/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.event.block.SculkBloomEvent;

public class SculkSpreader {
    public static final int a = 24;
    public static final int b = 1000;
    public static final float c = 0.5f;
    private static final int f = 32;
    public static final int d = 11;
    public static final int e = 1024;
    final boolean g;
    private final TagKey<Block> h;
    private final int i;
    private final int j;
    private final int k;
    private final int l;
    private List<a> m = new ArrayList<a>();
    public World level;

    public SculkSpreader(boolean isWorldGeneration, TagKey<Block> replaceableBlocks, int growthSpawnCost, int noGrowthRadius, int chargeDecayRate, int additionalDecayRate) {
        this.g = isWorldGeneration;
        this.h = replaceableBlocks;
        this.i = growthSpawnCost;
        this.j = noGrowthRadius;
        this.k = chargeDecayRate;
        this.l = additionalDecayRate;
    }

    public static SculkSpreader a() {
        return new SculkSpreader(false, TagsBlock.cg, 10, 4, 10, 5);
    }

    public static SculkSpreader b() {
        return new SculkSpreader(true, TagsBlock.ch, 50, 1, 5, 10);
    }

    public TagKey<Block> c() {
        return this.h;
    }

    public int d() {
        return this.i;
    }

    public int e() {
        return this.j;
    }

    public int f() {
        return this.k;
    }

    public int g() {
        return this.l;
    }

    public boolean h() {
        return this.g;
    }

    @VisibleForTesting
    public List<a> i() {
        return this.m;
    }

    public void j() {
        this.m.clear();
    }

    public void a(ValueInput input) {
        this.m.clear();
        input.a("cursors", net.minecraft.world.level.block.SculkSpreader$a.b.sizeLimitedListOf(32)).orElse(List.of()).forEach(cursor -> this.addCursor((a)cursor, false));
    }

    public void a(ValueOutput output) {
        output.a("cursors", net.minecraft.world.level.block.SculkSpreader$a.b.listOf(), this.m);
        if (SharedConstants.aj) {
            int i2 = this.i().stream().map(a::b).reduce(0, Integer::sum);
            int i1 = this.i().stream().map(chargeCursor -> 1).reduce(0, Integer::sum);
            int i22 = this.i().stream().map(a::b).reduce(0, Math::max);
            output.a("stats.total", i2);
            output.a("stats.count", i1);
            output.a("stats.max", i22);
            output.a("stats.avg", i2 / (i1 + 1));
        }
    }

    public void a(BlockPosition pos, int charge) {
        while (charge > 0) {
            int min = Math.min(charge, 1000);
            this.addCursor(new a(pos, min), true);
            charge -= min;
        }
    }

    private void addCursor(a cursor, boolean fireEvent) {
        if (this.m.size() < 32) {
            if (!this.h() && fireEvent) {
                CraftBlock bukkitBlock = CraftBlock.at(this.level, cursor.d);
                SculkBloomEvent event = new SculkBloomEvent((org.bukkit.block.Block)bukkitBlock, cursor.b());
                if (!event.callEvent()) {
                    return;
                }
                cursor.e = event.getCharge();
            }
            this.m.add(cursor);
        }
    }

    public void a(GeneratorAccess level, BlockPosition pos, RandomSource random, boolean shouldConvertBlocks) {
        if (!this.m.isEmpty()) {
            BlockPosition pos1;
            ArrayList<a> list = new ArrayList<a>();
            HashMap<BlockPosition, a> map = new HashMap<BlockPosition, a>();
            Object2IntOpenHashMap map1 = new Object2IntOpenHashMap();
            for (a chargeCursor : this.m) {
                if (chargeCursor.a(pos)) continue;
                chargeCursor.a(level, pos, random, this, shouldConvertBlocks);
                if (chargeCursor.e <= 0) {
                    level.c(3006, chargeCursor.a(), 0);
                    continue;
                }
                pos1 = chargeCursor.a();
                map1.computeInt((Object)pos1, (blockPos, integer) -> (integer == null ? 0 : integer) + chargeCursor.e);
                a chargeCursor1 = (a)map.get(pos1);
                if (chargeCursor1 == null) {
                    map.put(pos1, chargeCursor);
                    list.add(chargeCursor);
                    continue;
                }
                if (!this.h() && chargeCursor.e + chargeCursor1.e <= 1000) {
                    chargeCursor1.a(chargeCursor);
                    continue;
                }
                list.add(chargeCursor);
                if (chargeCursor.e >= chargeCursor1.e) continue;
                map.put(pos1, chargeCursor);
            }
            for (Object2IntMap.Entry entry : map1.object2IntEntrySet()) {
                Set<EnumDirection> collection;
                pos1 = (BlockPosition)entry.getKey();
                int intValue = entry.getIntValue();
                a chargeCursor2 = (a)map.get(pos1);
                Set<EnumDirection> set = collection = chargeCursor2 == null ? null : chargeCursor2.d();
                if (intValue <= 0 || collection == null) continue;
                int i2 = (int)(Math.log1p(intValue) / (double)2.3f) + 1;
                int i1 = (i2 << 6) + MultifaceBlock.a(collection);
                level.c(3006, pos1, i1);
            }
            this.m = list;
        }
    }

    public static class a {
        private static final ObjectArrayList<BaseBlockPosition> c = SystemUtils.a(new ObjectArrayList(18), list -> BlockPosition.d(new BlockPosition(-1, -1, -1), new BlockPosition(1, 1, 1)).filter(candidatePos -> (candidatePos.u() == 0 || candidatePos.v() == 0 || candidatePos.w() == 0) && !candidatePos.equals(BlockPosition.c)).map(BlockPosition::j).forEach(arg_0 -> ((ObjectArrayList)list).add(arg_0)));
        public static final int a = 1;
        private BlockPosition d;
        int e;
        private int f;
        private int g;
        @Nullable
        private Set<EnumDirection> h;
        private static final Codec<Set<EnumDirection>> i = EnumDirection.g.listOf().xmap(directions -> Sets.newEnumSet((Iterable)directions, EnumDirection.class), Lists::newArrayList);
        public static final Codec<a> b = RecordCodecBuilder.create(instance -> instance.group((App)BlockPosition.a.fieldOf("pos").forGetter(a::a), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(a::b), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(a::c), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(cursor -> cursor.f), (App)i.lenientOptionalFieldOf("facings").forGetter(cursor -> Optional.ofNullable(cursor.d()))).apply((Applicative)instance, a::new));

        private a(BlockPosition pos, int charge, int decayDelay, int updateDelay, Optional<Set<EnumDirection>> facings) {
            this.d = pos;
            this.e = charge;
            this.g = decayDelay;
            this.f = updateDelay;
            this.h = facings.orElse(null);
        }

        public a(BlockPosition pos, int charge) {
            this(pos, charge, 1, 0, Optional.empty());
        }

        public BlockPosition a() {
            return this.d;
        }

        boolean a(BlockPosition pos) {
            return this.d.l(pos) > 1024;
        }

        public int b() {
            return this.e;
        }

        public int c() {
            return this.g;
        }

        @Nullable
        public Set<EnumDirection> d() {
            return this.h;
        }

        private boolean a(GeneratorAccess level, BlockPosition pos, boolean isWorldGeneration) {
            WorldServer serverLevel;
            return this.e > 0 && (isWorldGeneration || level instanceof WorldServer && (serverLevel = (WorldServer)level).n(pos));
        }

        public void a(GeneratorAccess level, BlockPosition pos, RandomSource random, SculkSpreader spreader, boolean shouldConvertBlocks) {
            if (this.a(level, pos, spreader.g)) {
                if (this.f > 0) {
                    --this.f;
                } else {
                    IBlockData blockState = level.a_(this.d);
                    SculkBehaviour blockBehaviour = net.minecraft.world.level.block.SculkSpreader$a.a(blockState);
                    if (shouldConvertBlocks && blockBehaviour.a(level, this.d, blockState, this.h, spreader.h())) {
                        if (blockBehaviour.d()) {
                            blockState = level.a_(this.d);
                            blockBehaviour = net.minecraft.world.level.block.SculkSpreader$a.a(blockState);
                        }
                        level.a(null, this.d, SoundEffects.xM, SoundCategory.e, 1.0f, 1.0f);
                    }
                    this.e = blockBehaviour.a(this, level, pos, random, spreader, shouldConvertBlocks);
                    if (this.e <= 0) {
                        blockBehaviour.a(level, blockState, this.d, random);
                    } else {
                        BlockPosition validMovementPos = net.minecraft.world.level.block.SculkSpreader$a.a(level, this.d, random);
                        if (validMovementPos != null) {
                            blockBehaviour.a(level, blockState, this.d, random);
                            this.d = validMovementPos.j();
                            if (spreader.h() && !this.d.a(new BaseBlockPosition(pos.u(), this.d.v(), pos.w()), 15.0)) {
                                this.e = 0;
                                return;
                            }
                            blockState = level.a_(validMovementPos);
                        }
                        if (blockState.b() instanceof SculkBehaviour) {
                            this.h = MultifaceBlock.p(blockState);
                        }
                        this.g = blockBehaviour.j_(this.g);
                        this.f = blockBehaviour.b();
                    }
                }
            }
        }

        void a(a cursor) {
            this.e += cursor.e;
            cursor.e = 0;
            this.f = Math.min(this.f, cursor.f);
        }

        private static SculkBehaviour a(IBlockData state) {
            SculkBehaviour sculkBehaviour;
            Block block = state.b();
            return block instanceof SculkBehaviour ? (sculkBehaviour = (SculkBehaviour)((Object)block)) : SculkBehaviour.v_;
        }

        private static List<BaseBlockPosition> a(RandomSource random) {
            return SystemUtils.a(c, random);
        }

        @Nullable
        private static BlockPosition a(GeneratorAccess level, BlockPosition pos, RandomSource random) {
            BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
            BlockPosition.MutableBlockPosition mutableBlockPos1 = pos.k();
            for (BaseBlockPosition vec3i : net.minecraft.world.level.block.SculkSpreader$a.a(random)) {
                mutableBlockPos1.a((BaseBlockPosition)pos, vec3i);
                IBlockData blockState = level.a_(mutableBlockPos1);
                if (!(blockState.b() instanceof SculkBehaviour) || !net.minecraft.world.level.block.SculkSpreader$a.a(level, pos, mutableBlockPos1)) continue;
                mutableBlockPos.g(mutableBlockPos1);
                if (!SculkVeinBlock.a(level, blockState, mutableBlockPos1)) continue;
                break;
            }
            return mutableBlockPos.equals(pos) ? null : mutableBlockPos;
        }

        private static boolean a(GeneratorAccess level, BlockPosition fromPos, BlockPosition toPos) {
            if (fromPos.k(toPos) == 1) {
                return true;
            }
            BlockPosition blockPos = toPos.b(fromPos);
            EnumDirection direction = EnumDirection.a(EnumDirection.EnumAxis.a, blockPos.u() < 0 ? EnumDirection.EnumAxisDirection.b : EnumDirection.EnumAxisDirection.a);
            EnumDirection direction1 = EnumDirection.a(EnumDirection.EnumAxis.b, blockPos.v() < 0 ? EnumDirection.EnumAxisDirection.b : EnumDirection.EnumAxisDirection.a);
            EnumDirection direction2 = EnumDirection.a(EnumDirection.EnumAxis.c, blockPos.w() < 0 ? EnumDirection.EnumAxisDirection.b : EnumDirection.EnumAxisDirection.a);
            if (blockPos.u() == 0) {
                return net.minecraft.world.level.block.SculkSpreader$a.a(level, fromPos, direction1) || net.minecraft.world.level.block.SculkSpreader$a.a(level, fromPos, direction2);
            }
            return blockPos.v() == 0 ? net.minecraft.world.level.block.SculkSpreader$a.a(level, fromPos, direction) || net.minecraft.world.level.block.SculkSpreader$a.a(level, fromPos, direction2) : net.minecraft.world.level.block.SculkSpreader$a.a(level, fromPos, direction) || net.minecraft.world.level.block.SculkSpreader$a.a(level, fromPos, direction1);
        }

        private static boolean a(GeneratorAccess level, BlockPosition pos, EnumDirection direction) {
            BlockPosition blockPos = pos.a(direction);
            return !level.a_(blockPos).c((IBlockAccess)level, blockPos, direction.g());
        }
    }
}

