/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityExhaustionEvent;

public abstract class VegetationBlock
extends Block {
    protected VegetationBlock(BlockBase.Info properties) {
        super(properties);
    }

    protected abstract MapCodec<? extends VegetationBlock> a();

    protected boolean b(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return state.a(TagsBlock.ae) || state.a(Blocks.cZ);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        block2: {
            block3: {
                if (state.a(level, pos)) break block2;
                if (!(level instanceof WorldServer)) break block3;
                WorldServer serverLevel = (WorldServer)level;
                if (serverLevel.hasPhysicsEvent && CraftEventFactory.callBlockPhysicsEvent(serverLevel, pos).isCancelled()) break block2;
            }
            return Blocks.a.m();
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        return this.b(level.a_(blockPos), level, blockPos);
    }

    @Override
    protected boolean d_(IBlockData state) {
        return state.y().c();
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return pathComputationType == PathMode.c && !this.F || super.a(state, pathComputationType);
    }

    public void playerDestroyAndReplant(World world, EntityHuman player, BlockPosition pos, IBlockData state, @Nullable TileEntity blockEntity, ItemStack itemInHand, IMaterial itemToReplant) {
        player.b(StatisticList.a.b(this));
        player.causeFoodExhaustion(0.005f, EntityExhaustionEvent.ExhaustionReason.BLOCK_MINED);
        List<ItemStack> dropList = Block.a(state, (WorldServer)world, pos, blockEntity, (Entity)player, itemInHand);
        boolean planted = false;
        for (ItemStack itemToDrop : dropList) {
            if (!planted && itemToDrop.h() == itemToReplant) {
                world.a(pos, this.m(), 3);
                itemToDrop.e(itemToDrop.M() - 1);
                planted = true;
            }
            Block.a(world, pos, itemToDrop);
        }
        state.a((WorldServer)world, pos, itemInHand, true);
    }
}

