/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.coppergolem.CopperGolem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.CopperGolemStatueBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.CopperGolemStatueBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class WeatheringCopperGolemStatueBlock
extends CopperGolemStatueBlock
implements WeatheringCopper {
    public static final MapCodec<WeatheringCopperGolemStatueBlock> e = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WeatheringCopper.a.f.fieldOf("weathering_state").forGetter(ChangeOverTimeBlock::c), WeatheringCopperGolemStatueBlock.x()).apply((Applicative)instance, WeatheringCopperGolemStatueBlock::new));

    public MapCodec<WeatheringCopperGolemStatueBlock> a() {
        return e;
    }

    public WeatheringCopperGolemStatueBlock(WeatheringCopper.a weatheringState, BlockBase.Info properties) {
        super(weatheringState, properties);
    }

    @Override
    protected boolean f(IBlockData state) {
        return WeatheringCopper.c(state.b()).isPresent();
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        this.a_(state, level, pos, random);
    }

    public WeatheringCopper.a q() {
        return this.d();
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof CopperGolemStatueBlockEntity) {
            CopperGolem copperGolem;
            CopperGolemStatueBlockEntity copperGolemStatueBlockEntity = (CopperGolemStatueBlockEntity)tileEntity;
            if (!stack.a(TagsItem.bW)) {
                if (stack.a(Items.yO)) {
                    return EnumInteractionResult.e;
                }
                return this.updatePose(level, state, pos, player);
            }
            if (this.q().equals(WeatheringCopper.a.a) && (copperGolem = copperGolemStatueBlockEntity.a(state)) != null) {
                IBlockData newState = level.b_(pos).g();
                if (!CraftEventFactory.callEntityChangeBlockEvent(player, pos, newState)) {
                    return EnumInteractionResult.e;
                }
                stack.a(1, (EntityLiving)player, hand.a());
                level.addFreshEntity(copperGolem, CreatureSpawnEvent.SpawnReason.REANIMATE);
                level.a(pos, newState, 3);
                return EnumInteractionResult.a;
            }
        }
        return EnumInteractionResult.e;
    }
}

