/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.slf4j.Logger;

public class BrushableBlockEntity
extends TileEntity {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "LootTable";
    private static final String c = "LootTableSeed";
    private static final String d = "hit_direction";
    private static final String e = "item";
    private static final int f = 10;
    private static final int g = 40;
    private static final int h = 10;
    private int i;
    private long j;
    private long k;
    public ItemStack l = ItemStack.l;
    @Nullable
    private EnumDirection m;
    @Nullable
    public ResourceKey<LootTable> q;
    public long r;

    public BrushableBlockEntity(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.P, pos, blockState);
    }

    public boolean a(long startTick, WorldServer level, EntityLiving brusher, EnumDirection hitDirection, ItemStack stack) {
        if (this.m == null) {
            this.m = hitDirection;
        }
        this.j = startTick + 40L;
        if (startTick < this.k) {
            return false;
        }
        this.k = startTick + 10L;
        int currentCompletionStage = this.f();
        boolean enoughBrushesToBreak = ++this.i >= 10;
        int nextCompletionStage = this.f();
        boolean differentCompletionStages = currentCompletionStage != nextCompletionStage;
        IBlockData nextBrokenBlockState = (IBlockData)this.o().b(BlockProperties.bA, nextCompletionStage);
        if ((enoughBrushesToBreak || differentCompletionStages) && !CraftEventFactory.callEntityChangeBlockEvent(brusher, this.o, enoughBrushesToBreak ? this.computeTurnsTo().m() : nextBrokenBlockState)) {
            --this.i;
            return false;
        }
        this.a(level, brusher, stack);
        int completionState = currentCompletionStage;
        if (enoughBrushesToBreak) {
            this.b(level, brusher, stack);
            return true;
        }
        level.a(this.aD_(), this.o().b(), 2);
        int completionState1 = this.f();
        if (completionState != completionState1) {
            IBlockData blockState = this.o();
            IBlockData blockState1 = nextBrokenBlockState;
            level.a(this.aD_(), blockState1, 3);
        }
        return false;
    }

    private void a(WorldServer level, EntityLiving brusher, ItemStack stack) {
        if (this.q != null) {
            LootTable lootTable = level.q().bi().a(this.q);
            if (brusher instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)brusher;
                CriterionTriggers.Q.a(serverPlayer, this.q);
            }
            LootParams lootParams = new LootParams.a(level).a(LootContextParameters.h, Vec3D.b(this.o)).a(brusher.ew()).a(LootContextParameters.a, brusher).a(LootContextParameters.k, stack).a(LootContextParameterSets.i);
            ObjectArrayList<ItemStack> randomItems = lootTable.a(lootParams, this.r);
            this.l = switch (randomItems.size()) {
                case 0 -> ItemStack.l;
                case 1 -> (ItemStack)randomItems.getFirst();
                default -> {
                    a.warn("Expected max 1 loot from loot table {}, but got {}", (Object)this.q.a(), (Object)randomItems.size());
                    yield (ItemStack)randomItems.getFirst();
                }
            };
            this.q = null;
            this.e();
        }
    }

    private void b(WorldServer level, EntityLiving brusher, ItemStack stack) {
        this.c(level, brusher, stack);
        IBlockData blockState = this.o();
        level.c(3008, this.aD_(), Block.j(blockState));
        this.brushingCompleteUpdateBlock(this.computeTurnsTo());
    }

    private Block computeTurnsTo() {
        Block turnsInto;
        Block block = this.o().b();
        if (block instanceof BrushableBlock) {
            BrushableBlock brushableBlock = (BrushableBlock)block;
            turnsInto = brushableBlock.b();
        } else {
            turnsInto = Blocks.a;
        }
        return turnsInto;
    }

    public void brushingCompleteUpdateBlock(Block turnsInto) {
        this.n.a(this.o, turnsInto.m(), 3);
    }

    private void c(WorldServer level, EntityLiving brusher, ItemStack stack) {
        this.a(level, brusher, stack);
        if (!this.l.f()) {
            double d2 = EntityTypes.au.l();
            double d1 = 1.0 - d2;
            double d22 = d2 / 2.0;
            EnumDirection direction = Objects.requireNonNullElse(this.m, EnumDirection.b);
            BlockPosition blockPos = this.o.a(direction, 1);
            double d3 = (double)blockPos.u() + 0.5 * d1 + d22;
            double d4 = (double)blockPos.v() + 0.5 + (double)(EntityTypes.au.m() / 2.0f);
            double d5 = (double)blockPos.w() + 0.5 * d1 + d22;
            EntityItem itemEntity = new EntityItem(level, d3, d4, d5, this.l.a(level.z.a(21) + 10));
            itemEntity.k(Vec3D.c);
            if (brusher instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)brusher;
                CraftBlock bblock = CraftBlock.at(this.n, this.o);
                CraftEventFactory.handleBlockDropItemEvent(bblock, bblock.getState(), serverPlayer, List.of(itemEntity));
            }
            this.l = ItemStack.l;
        }
    }

    public void a(WorldServer level) {
        if (this.i != 0 && level.ag() >= this.j) {
            int completionState = this.f();
            this.i = Math.max(0, this.i - 2);
            int completionState1 = this.f();
            if (completionState != completionState1) {
                level.a(this.aD_(), (IBlockData)this.o().b(BlockProperties.bA, completionState1), 3);
            }
            int i2 = 4;
            this.j = level.ag() + 4L;
        }
        if (this.i == 0) {
            this.m = null;
            this.j = 0L;
            this.k = 0L;
        } else {
            level.a(this.aD_(), this.o().b(), 2);
        }
    }

    private boolean d(ValueInput input) {
        this.q = input.a(b, LootTable.a).orElse(null);
        this.r = input.a(c, 0L);
        return this.q != null;
    }

    private boolean g(ValueOutput output) {
        if (this.q == null) {
            return false;
        }
        output.a(b, LootTable.a, this.q);
        if (this.r != 0L) {
            output.a(c, this.r);
        }
        return true;
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        NBTTagCompound compoundTag = super.a(registries);
        compoundTag.b(d, EnumDirection.k, this.m);
        if (!this.l.f()) {
            RegistryOps<NBTBase> registryOps = registries.a(DynamicOpsNBT.a);
            compoundTag.a(e, ItemStack.b, registryOps, this.l);
        }
        return compoundTag;
    }

    public PacketPlayOutTileEntityData a() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.l = !this.d(input) ? input.a(e, ItemStack.b).orElse(ItemStack.l) : ItemStack.l;
        this.m = input.a(d, EnumDirection.k).orElse(null);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        if (!this.g(output) && !this.l.f()) {
            output.a(e, ItemStack.b, this.l);
        }
    }

    public void a(ResourceKey<LootTable> lootTable, long seed) {
        this.q = lootTable;
        this.r = seed;
    }

    private int f() {
        if (this.i == 0) {
            return 0;
        }
        if (this.i < 3) {
            return 1;
        }
        return this.i < 6 ? 2 : 3;
    }

    @Nullable
    public EnumDirection c() {
        return this.m;
    }

    public ItemStack d() {
        return this.l;
    }
}

