/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class SculkSensorBlockEntity
extends TileEntity
implements GameEventListener.b<VibrationSystem.b>,
VibrationSystem {
    private static final int a = 0;
    private VibrationSystem.a b;
    private final VibrationSystem.b c;
    private final VibrationSystem.d d = this.a();
    public int e = 0;
    @Nullable
    public Integer rangeOverride = null;
    protected static final String PAPER_LISTENER_RANGE_NBT_KEY = "Paper.ListenerRange";

    protected SculkSensorBlockEntity(TileEntityTypes<?> type, BlockPosition pos, IBlockData blockState) {
        super(type, pos, blockState);
        this.b = new VibrationSystem.a();
        this.c = new VibrationSystem.b(this);
    }

    public SculkSensorBlockEntity(BlockPosition pos, IBlockData blockState) {
        this(TileEntityTypes.J, pos, blockState);
    }

    public VibrationSystem.d a() {
        return new a(this.aD_());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.e = input.a("last_vibration_frequency", 0);
        this.b = input.a("listener", VibrationSystem.a.a).orElseGet(VibrationSystem.a::new);
        this.rangeOverride = input.e(PAPER_LISTENER_RANGE_NBT_KEY).orElse(null);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("last_vibration_frequency", this.e);
        output.a("listener", VibrationSystem.a.a, this.b);
        this.saveRangeOverride(output);
    }

    protected void saveRangeOverride(ValueOutput output) {
        if (this.rangeOverride != null && this.rangeOverride != 8) {
            output.a(PAPER_LISTENER_RANGE_NBT_KEY, this.rangeOverride);
        }
    }

    @Override
    public VibrationSystem.a gJ() {
        return this.b;
    }

    @Override
    public VibrationSystem.d gK() {
        return this.d;
    }

    public int d() {
        return this.e;
    }

    public void a(int lastVibrationFrequency) {
        this.e = lastVibrationFrequency;
    }

    public VibrationSystem.b f() {
        return this.c;
    }

    protected class a
    implements VibrationSystem.d {
        public static final int b = 8;
        protected final BlockPosition c;
        private final PositionSource a;

        public a(BlockPosition blockPos) {
            this.c = blockPos;
            this.a = new BlockPositionSource(blockPos);
        }

        @Override
        public int a() {
            if (SculkSensorBlockEntity.this.rangeOverride != null) {
                return SculkSensorBlockEntity.this.rangeOverride;
            }
            return 8;
        }

        @Override
        public PositionSource b() {
            return this.a;
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, @Nullable GameEvent.a context) {
            return (!pos.equals(this.c) || !gameEvent.a(GameEvent.f) && !gameEvent.a(GameEvent.i)) && VibrationSystem.a_(gameEvent) != 0 && SculkSensorBlock.r(SculkSensorBlockEntity.this.o());
        }

        @Override
        public void a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, @Nullable Entity entity, @Nullable Entity playerEntity, float distance) {
            IBlockData blockState = SculkSensorBlockEntity.this.o();
            if (SculkSensorBlock.r(blockState)) {
                int gameEventFrequency = VibrationSystem.a_(gameEvent);
                SculkSensorBlockEntity.this.a(gameEventFrequency);
                int redstoneStrengthForDistance = VibrationSystem.a_(distance, this.a());
                Block block = blockState.b();
                if (block instanceof SculkSensorBlock) {
                    SculkSensorBlock sculkSensorBlock = (SculkSensorBlock)block;
                    sculkSensorBlock.a(entity, (World)level, this.c, blockState, redstoneStrengthForDistance, gameEventFrequency);
                }
            }
        }

        @Override
        public void e() {
            SculkSensorBlockEntity.this.e();
        }

        @Override
        public boolean f() {
            return true;
        }
    }
}

