/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.EnumChatFormat;
import net.minecraft.FileUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.gametest.framework.FailedTestTracker;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestCommand;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BeaconBeamOwner;
import net.minecraft.world.level.block.entity.BoundingBoxRenderable;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.event.entity.EntityRemoveEvent;

public class TestInstanceBlockEntity
extends TileEntity
implements BeaconBeamOwner,
BoundingBoxRenderable {
    private static final IChatBaseComponent a = IChatBaseComponent.c("test_instance_block.invalid_test");
    private static final List<BeaconBeamOwner.a> b = List.of();
    private static final List<BeaconBeamOwner.a> c = List.of(new BeaconBeamOwner.a(ARGB.a(128, 128, 128)));
    private static final List<BeaconBeamOwner.a> d = List.of(new BeaconBeamOwner.a(ARGB.a(0, 255, 0)));
    private static final List<BeaconBeamOwner.a> e = List.of(new BeaconBeamOwner.a(ARGB.a(255, 0, 0)));
    private static final List<BeaconBeamOwner.a> f = List.of(new BeaconBeamOwner.a(ARGB.a(255, 128, 0)));
    private static final BaseBlockPosition g = new BaseBlockPosition(0, 1, 1);
    private a h;
    private final List<b> i = new ArrayList<b>();

    public TestInstanceBlockEntity(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.V, pos, blockState);
        this.h = new a(Optional.empty(), BaseBlockPosition.i, EnumBlockRotation.a, false, net.minecraft.world.level.block.entity.TestInstanceBlockEntity$c.a, Optional.empty());
    }

    public void a(a data) {
        this.h = data;
        this.e();
    }

    public static Optional<BaseBlockPosition> a(WorldServer level, ResourceKey<GameTestInstance> testKey) {
        return TestInstanceBlockEntity.b(level, testKey).map(DefinedStructure::a);
    }

    public StructureBoundingBox d() {
        BlockPosition structurePos = this.B();
        BlockPosition blockPos = structurePos.a(this.J()).b(-1, -1, -1);
        return StructureBoundingBox.a((BaseBlockPosition)structurePos, (BaseBlockPosition)blockPos);
    }

    public AxisAlignedBB f() {
        return AxisAlignedBB.a(this.d());
    }

    private static Optional<DefinedStructure> b(WorldServer level, ResourceKey<GameTestInstance> testKey) {
        return level.L_().c(testKey).map(reference -> ((GameTestInstance)reference.a()).e()).flatMap(resourceLocation -> level.s().b((MinecraftKey)resourceLocation));
    }

    public Optional<ResourceKey<GameTestInstance>> h() {
        return this.h.a();
    }

    public IChatBaseComponent k() {
        return this.h().map(resourceKey -> IChatBaseComponent.b(resourceKey.a().toString())).orElse(a);
    }

    private Optional<Holder.c<GameTestInstance>> I() {
        return this.h().flatMap(this.n.L_()::c);
    }

    public boolean l() {
        return this.h.d();
    }

    public BaseBlockPosition m() {
        return this.h.b();
    }

    public EnumBlockRotation w() {
        return this.I().map(Holder::a).map(GameTestInstance::m).orElse(EnumBlockRotation.a).a(this.h.c());
    }

    public Optional<IChatBaseComponent> x() {
        return this.h.f();
    }

    public void a(IChatBaseComponent errorMessage) {
        this.a(this.h.a(errorMessage));
    }

    public void y() {
        this.a(this.h.a(net.minecraft.world.level.block.entity.TestInstanceBlockEntity$c.c));
    }

    public void z() {
        this.a(this.h.a(net.minecraft.world.level.block.entity.TestInstanceBlockEntity$c.b));
    }

    @Override
    public void e() {
        super.e();
        if (this.n instanceof WorldServer) {
            this.n.a(this.aD_(), Blocks.a.m(), this.o(), 3);
        }
    }

    public PacketPlayOutTileEntityData A() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.d(registries);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        input.a("data", net.minecraft.world.level.block.entity.TestInstanceBlockEntity$a.a).ifPresent(this::a);
        this.i.clear();
        this.i.addAll(input.a("errors", net.minecraft.world.level.block.entity.TestInstanceBlockEntity$b.b).orElse(List.of()));
    }

    @Override
    protected void a(ValueOutput output) {
        output.a("data", net.minecraft.world.level.block.entity.TestInstanceBlockEntity$a.a, this.h);
        if (!this.i.isEmpty()) {
            output.a("errors", net.minecraft.world.level.block.entity.TestInstanceBlockEntity$b.b, this.i);
        }
    }

    @Override
    public BoundingBoxRenderable.a b() {
        return BoundingBoxRenderable.a.b;
    }

    public BlockPosition B() {
        return TestInstanceBlockEntity.a(this.aD_());
    }

    public static BlockPosition a(BlockPosition pos) {
        return pos.a(g);
    }

    @Override
    public BoundingBoxRenderable.b c() {
        return new BoundingBoxRenderable.b(new BlockPosition(g), this.J());
    }

    @Override
    public List<BeaconBeamOwner.a> a() {
        return switch (this.h.e().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> b;
            case 1 -> c;
            case 2 -> this.x().isEmpty() ? d : (this.I().map(Holder::a).map(GameTestInstance::h).orElse(true) != false ? e : f);
        };
    }

    private BaseBlockPosition J() {
        BaseBlockPosition size = this.m();
        EnumBlockRotation rotation = this.w();
        boolean flag = rotation == EnumBlockRotation.b || rotation == EnumBlockRotation.d;
        int i2 = flag ? size.w() : size.u();
        int i1 = flag ? size.u() : size.w();
        return new BaseBlockPosition(i2, size.v(), i1);
    }

    public void a(Consumer<IChatBaseComponent> messageSender) {
        this.F();
        this.G();
        boolean flag = this.C();
        if (flag) {
            messageSender.accept(IChatBaseComponent.a("test_instance_block.reset_success", this.k()).a(EnumChatFormat.k));
        }
        this.a(this.h.a(net.minecraft.world.level.block.entity.TestInstanceBlockEntity$c.a));
    }

    public Optional<MinecraftKey> b(Consumer<IChatBaseComponent> messageSender) {
        Optional<Holder.c<GameTestInstance>> testHolder = this.I();
        Optional<MinecraftKey> optional = testHolder.isPresent() ? Optional.of(testHolder.get().a().e()) : this.h().map(ResourceKey::a);
        if (optional.isEmpty()) {
            BlockPosition blockPos = this.aD_();
            messageSender.accept(IChatBaseComponent.a("test_instance_block.error.unable_to_save", blockPos.u(), blockPos.v(), blockPos.w()).a(EnumChatFormat.m));
            return optional;
        }
        World world = this.n;
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            TileEntityStructure.a(serverLevel, optional.get(), this.B(), this.m(), this.l(), "", true, List.of(Blocks.a));
        }
        return optional;
    }

    public boolean c(Consumer<IChatBaseComponent> messageSender) {
        WorldServer serverLevel;
        World world;
        Optional<MinecraftKey> optional = this.b(messageSender);
        return !optional.isEmpty() && (world = this.n) instanceof WorldServer && TestInstanceBlockEntity.a(serverLevel = (WorldServer)world, optional.get(), messageSender);
    }

    public static boolean a(WorldServer level, MinecraftKey test, Consumer<IChatBaseComponent> messageSender) {
        Path path = GameTestHarnessStructures.c;
        Path path1 = level.s().a(test, ".nbt");
        Path path2 = DebugReportNBT.a(CachedOutput.a, path1, test.a(), path.resolve(test.b()).resolve("structure"));
        if (path2 == null) {
            messageSender.accept(IChatBaseComponent.b("Failed to export " + String.valueOf(path1)).a(EnumChatFormat.m));
            return true;
        }
        try {
            FileUtils.c(path2.getParent());
        }
        catch (IOException var7) {
            messageSender.accept(IChatBaseComponent.b("Could not create folder " + String.valueOf(path2.getParent())).a(EnumChatFormat.m));
            return true;
        }
        messageSender.accept(IChatBaseComponent.b("Exported " + String.valueOf(test) + " to " + String.valueOf(path2.toAbsolutePath())));
        return false;
    }

    public void d(Consumer<IChatBaseComponent> messageSender) {
        World world = this.n;
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Optional<Holder.c<GameTestInstance>> var7 = this.I();
            BlockPosition blockPos = this.aD_();
            if (var7.isEmpty()) {
                messageSender.accept(IChatBaseComponent.a("test_instance_block.error.no_test", blockPos.u(), blockPos.v(), blockPos.w()).a(EnumChatFormat.m));
            } else if (!this.C()) {
                messageSender.accept(IChatBaseComponent.a("test_instance_block.error.no_test_structure", blockPos.u(), blockPos.v(), blockPos.w()).a(EnumChatFormat.m));
            } else {
                this.G();
                GameTestHarnessTicker.a.a();
                FailedTestTracker.b();
                messageSender.accept(IChatBaseComponent.a("test_instance_block.starting", new Object[]{var7.get().g()}));
                GameTestHarnessInfo gameTestInfo = new GameTestHarnessInfo(var7.get(), this.h.c(), serverLevel, RetryOptions.a());
                gameTestInfo.a(blockPos);
                GameTestHarnessRunner gameTestRunner = GameTestHarnessRunner.a.b(List.of(gameTestInfo), serverLevel).c();
                GameTestHarnessTestCommand.a(serverLevel.q().aK(), gameTestRunner);
            }
        }
    }

    public boolean C() {
        World world = this.n;
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Optional optional = this.h.a().flatMap(resourceKey -> TestInstanceBlockEntity.b(serverLevel, resourceKey));
            if (optional.isPresent()) {
                this.a(serverLevel, (DefinedStructure)optional.get());
                return true;
            }
        }
        return false;
    }

    private void a(WorldServer level, DefinedStructure structureTemplate) {
        DefinedStructureInfo structurePlaceSettings = new DefinedStructureInfo().a(this.w()).a(this.h.d()).b(true);
        BlockPosition startCorner = this.D();
        this.L();
        GameTestHarnessStructures.a(this.d(), level);
        this.K();
        structureTemplate.a(level, startCorner, startCorner, structurePlaceSettings, level.I_(), 818);
    }

    private void K() {
        this.n.a_(null, this.f()).stream().filter(entity -> !(entity instanceof EntityHuman)).forEach(entity -> entity.discard(EntityRemoveEvent.Cause.DISCARD));
    }

    private void L() {
        World world = this.n;
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.d().b().forEach(pos -> serverLevel.a(pos.h, pos.i, true));
        }
    }

    public BlockPosition D() {
        BaseBlockPosition size = this.m();
        EnumBlockRotation rotation = this.w();
        BlockPosition structurePos = this.B();
        return switch (rotation) {
            default -> throw new MatchException(null, null);
            case EnumBlockRotation.a -> structurePos;
            case EnumBlockRotation.b -> structurePos.b(size.w() - 1, 0, 0);
            case EnumBlockRotation.c -> structurePos.b(size.u() - 1, 0, size.w() - 1);
            case EnumBlockRotation.d -> structurePos.b(0, 0, size.u() - 1);
        };
    }

    public void E() {
        this.e((BlockPosition pos) -> {
            if (!this.n.a_((BlockPosition)pos).a(Blocks.qb)) {
                this.n.c((BlockPosition)pos, Blocks.iO.m());
            }
        });
    }

    public void F() {
        this.e((BlockPosition pos) -> {
            if (this.n.a_((BlockPosition)pos).a(Blocks.iO)) {
                this.n.c((BlockPosition)pos, Blocks.a.m());
            }
        });
    }

    public void e(Consumer<BlockPosition> processor) {
        AxisAlignedBB structureBounds = this.f();
        boolean flag = this.I().map(reference -> ((GameTestInstance)reference.a()).l()).orElse(false) == false;
        BlockPosition blockPos = BlockPosition.a(structureBounds.a, structureBounds.b, structureBounds.c).b(-1, -1, -1);
        BlockPosition blockPos1 = BlockPosition.a(structureBounds.d, structureBounds.e, structureBounds.f);
        BlockPosition.d(blockPos, blockPos1).forEach(blockPos2 -> {
            boolean flag2;
            boolean flag1 = blockPos2.u() == blockPos.u() || blockPos2.u() == blockPos1.u() || blockPos2.w() == blockPos.w() || blockPos2.w() == blockPos1.w() || blockPos2.v() == blockPos.v();
            boolean bl = flag2 = blockPos2.v() == blockPos1.v();
            if (flag1 || flag2 && flag) {
                processor.accept((BlockPosition)blockPos2);
            }
        });
    }

    public void a(BlockPosition pos, IChatBaseComponent text) {
        this.i.add(new b(pos, text));
        this.e();
    }

    public void G() {
        if (!this.i.isEmpty()) {
            this.i.clear();
            this.e();
        }
    }

    public List<b> H() {
        return this.i;
    }

    public static final class a
    extends Record {
        private final Optional<ResourceKey<GameTestInstance>> c;
        private final BaseBlockPosition d;
        private final EnumBlockRotation e;
        private final boolean f;
        private final c g;
        private final Optional<IChatBaseComponent> h;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.a(Registries.bp).optionalFieldOf("test").forGetter(a::a), (App)BaseBlockPosition.g.fieldOf("size").forGetter(a::b), (App)EnumBlockRotation.f.fieldOf("rotation").forGetter(a::c), (App)Codec.BOOL.fieldOf("ignore_entities").forGetter(a::d), (App)net.minecraft.world.level.block.entity.TestInstanceBlockEntity$c.d.fieldOf("status").forGetter(a::e), (App)ComponentSerialization.a.optionalFieldOf("error_message").forGetter(a::f)).apply((Applicative)instance, a::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, a> b = StreamCodec.a(ByteBufCodecs.a(ResourceKey.b(Registries.bp)), a::a, BaseBlockPosition.h, a::b, EnumBlockRotation.g, a::c, ByteBufCodecs.b, a::d, net.minecraft.world.level.block.entity.TestInstanceBlockEntity$c.e, a::e, ByteBufCodecs.a(ComponentSerialization.b), a::f, a::new);

        public a(Optional<ResourceKey<GameTestInstance>> test, BaseBlockPosition size, EnumBlockRotation rotation, boolean ignoreEntities, c status, Optional<IChatBaseComponent> errorMessage) {
            this.c = test;
            this.d = size;
            this.e = rotation;
            this.f = ignoreEntities;
            this.g = status;
            this.h = errorMessage;
        }

        public a a(BaseBlockPosition size) {
            return new a(this.c, size, this.e, this.f, this.g, this.h);
        }

        public a a(c status) {
            return new a(this.c, this.d, this.e, this.f, status, Optional.empty());
        }

        public a a(IChatBaseComponent error) {
            return new a(this.c, this.d, this.e, this.f, net.minecraft.world.level.block.entity.TestInstanceBlockEntity$c.c, Optional.of(error));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "test;size;rotation;ignoreEntities;status;errorMessage", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "test;size;rotation;ignoreEntities;status;errorMessage", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "test;size;rotation;ignoreEntities;status;errorMessage", "c", "d", "e", "f", "g", "h"}, this, o2);
        }

        public Optional<ResourceKey<GameTestInstance>> a() {
            return this.c;
        }

        public BaseBlockPosition b() {
            return this.d;
        }

        public EnumBlockRotation c() {
            return this.e;
        }

        public boolean d() {
            return this.f;
        }

        public c e() {
            return this.g;
        }

        public Optional<IChatBaseComponent> f() {
            return this.h;
        }
    }

    public static final class c
    extends Enum<c>
    implements INamable {
        public static final /* enum */ c a = new c("cleared", 0);
        public static final /* enum */ c b = new c("running", 1);
        public static final /* enum */ c c = new c("finished", 2);
        private static final IntFunction<c> f;
        public static final Codec<c> d;
        public static final StreamCodec<ByteBuf, c> e;
        private final String g;
        private final int h;
        private static final /* synthetic */ c[] i;

        public static c[] values() {
            return (c[])i.clone();
        }

        public static c valueOf(String name) {
            return Enum.valueOf(c.class, name);
        }

        private c(String id, int index) {
            this.g = id;
            this.h = index;
        }

        @Override
        public String c() {
            return this.g;
        }

        public static c a(int index) {
            return f.apply(index);
        }

        private static /* synthetic */ c[] a() {
            return new c[]{a, b, c};
        }

        static {
            i = net.minecraft.world.level.block.entity.TestInstanceBlockEntity$c.a();
            f = ByIdMap.a(status -> status.h, net.minecraft.world.level.block.entity.TestInstanceBlockEntity$c.values(), ByIdMap.a.a);
            d = INamable.a(c::values);
            e = ByteBufCodecs.a(c::a, (T status) -> status.h);
        }
    }

    public static final class b
    extends Record {
        private final BlockPosition c;
        private final IChatBaseComponent d;
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)BlockPosition.a.fieldOf("pos").forGetter(b::a), (App)ComponentSerialization.a.fieldOf("text").forGetter(b::b)).apply((Applicative)instance, b::new));
        public static final Codec<List<b>> b = a.listOf();

        public b(BlockPosition pos, IChatBaseComponent text) {
            this.c = pos;
            this.d = text;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "pos;text", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "pos;text", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "pos;text", "c", "d"}, this, o2);
        }

        public BlockPosition a() {
            return this.c;
        }

        public IChatBaseComponent b() {
            return this.d;
        }
    }
}

