/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.debug.DebugHiveInfo;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.component.Bees;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityEnterBlockEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.purpurmc.purpur.PurpurConfig;
import org.slf4j.Logger;

public class TileEntityBeehive
extends TileEntity {
    static final Logger c = LogUtils.getLogger();
    private static final String d = "flower_pos";
    private static final String e = "bees";
    static final List<String> f = Arrays.asList("Air", "drop_chances", "equipment", "Brain", "CanPickUpLoot", "DeathTime", "fall_distance", "FallFlying", "Fire", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "sleeping_pos", "CannotEnterHiveTicks", "TicksSincePollination", "CropsGrownSincePollination", "hive_pos", "Passengers", "leash", "UUID");
    public static final int a = PurpurConfig.beeInsideBeeHive;
    private static final int g = 400;
    private static final int h = 2400;
    public static final int b = 600;
    private List<HiveBee> i = Lists.newArrayList();
    @Nullable
    public BlockPosition j;
    public int maxBees = a;

    public TileEntityBeehive(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.I, pos, blockState);
    }

    @Override
    public void e() {
        if (this.a()) {
            this.a(null, this.n.a_(this.aD_()), ReleaseStatus.c);
        }
        super.e();
    }

    public boolean a() {
        if (this.n == null) {
            return false;
        }
        for (BlockPosition blockPos : BlockPosition.c(this.o.b(-1, -1, -1), this.o.b(1, 1, 1))) {
            if (!(this.n.a_(blockPos).b() instanceof BlockFire)) continue;
            return true;
        }
        return false;
    }

    public boolean c() {
        return this.i.isEmpty();
    }

    public boolean d() {
        return this.i.size() == this.maxBees;
    }

    public void a(@Nullable EntityHuman player, IBlockData state, ReleaseStatus releaseStatus) {
        List<net.minecraft.world.entity.Entity> list = this.a(state, releaseStatus);
        if (player != null) {
            for (net.minecraft.world.entity.Entity entity : list) {
                if (!(entity instanceof EntityBee)) continue;
                EntityBee bee = (EntityBee)entity;
                if (!(player.dD().g(entity.dD()) <= 16.0)) continue;
                if (!this.h()) {
                    bee.setTarget(player, EntityTargetEvent.TargetReason.CLOSEST_PLAYER);
                    continue;
                }
                bee.s(400);
            }
        }
    }

    private List<net.minecraft.world.entity.Entity> a(IBlockData state, ReleaseStatus releaseStatus) {
        return this.releaseBees(state, releaseStatus, false);
    }

    public List<net.minecraft.world.entity.Entity> releaseBees(IBlockData state, ReleaseStatus releaseStatus, boolean force) {
        ArrayList list = Lists.newArrayList();
        this.i.removeIf(data -> TileEntityBeehive.releaseOccupant(this.n, this.o, state, data.b(), list, releaseStatus, this.j, force));
        if (!list.isEmpty()) {
            super.e();
        }
        return list;
    }

    public List<net.minecraft.world.entity.Entity> releaseBee(IBlockData iblockdata, HiveBee data, ReleaseStatus tileentitybeehive_releasestatus, boolean force) {
        ArrayList list = Lists.newArrayList();
        TileEntityBeehive.releaseOccupant(this.n, this.o, iblockdata, data.a, list, tileentitybeehive_releasestatus, this.j, force);
        if (!list.isEmpty()) {
            this.i.remove(data);
            super.e();
        }
        return list;
    }

    @VisibleForDebug
    public int f() {
        return this.i.size();
    }

    public List<HiveBee> getStored() {
        return this.i;
    }

    public void clearBees() {
        this.i.clear();
    }

    public static int a(IBlockData state) {
        return state.c(BlockBeehive.c);
    }

    @VisibleForDebug
    public boolean h() {
        return BlockCampfire.a(this.n, this.aD_());
    }

    public void a(EntityBee bee) {
        if (this.i.size() < this.maxBees) {
            EntityEnterBlockEvent event;
            if (this.n != null && !(event = new EntityEnterBlockEvent((Entity)bee.getBukkitEntity(), (Block)CraftBlock.at(this.n, this.aD_()))).callEvent()) {
                bee.s(400);
                return;
            }
            bee.cb();
            bee.ca();
            bee.w();
            this.a(net.minecraft.world.level.block.entity.TileEntityBeehive$c.a(bee));
            if (this.n != null) {
                if (bee.n() && (!this.k() || this.n.z.h())) {
                    this.j = bee.m();
                }
                BlockPosition blockPos = this.aD_();
                this.n.a(null, (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w(), SoundEffects.bW, SoundCategory.e, 1.0f, 1.0f);
                this.n.a(GameEvent.c, blockPos, GameEvent.a.a(bee, this.o()));
            }
            bee.discard(EntityRemoveEvent.Cause.ENTER_BLOCK);
            super.e();
        }
    }

    public void a(c occupant) {
        this.i.add(new HiveBee(occupant));
    }

    private static boolean a(World level, BlockPosition pos, IBlockData state, c occupant, @Nullable List<net.minecraft.world.entity.Entity> storedInHives, ReleaseStatus releaseStatus, @Nullable BlockPosition storedFlowerPos) {
        return TileEntityBeehive.releaseOccupant(level, pos, state, occupant, storedInHives, releaseStatus, storedFlowerPos, false);
    }

    private static boolean releaseOccupant(World level, BlockPosition pos, IBlockData state, c occupant, @Nullable List<net.minecraft.world.entity.Entity> storedInHives, ReleaseStatus releaseStatus, @Nullable BlockPosition storedFlowerPos, boolean force) {
        boolean flag;
        if (!force && EntityBee.c(level) && releaseStatus != ReleaseStatus.c) {
            return false;
        }
        EnumDirection direction = state.c(BlockBeehive.b);
        BlockPosition blockPos = pos.a(direction);
        boolean bl = flag = !level.a_(blockPos).g(level, blockPos).c();
        if (flag && releaseStatus != ReleaseStatus.c) {
            return false;
        }
        net.minecraft.world.entity.Entity entity = occupant.a(level, pos);
        if (entity != null) {
            if (entity instanceof EntityBee) {
                float bbWidth = entity.dA();
                double d2 = flag ? 0.0 : 0.55 + (double)(bbWidth / 2.0f);
                double d1 = (double)pos.u() + 0.5 + d2 * (double)direction.j();
                double d22 = (double)pos.v() + 0.5 - (double)(entity.dB() / 2.0f);
                double d3 = (double)pos.w() + 0.5 + d2 * (double)direction.l();
                entity.b(d1, d22, d3, entity.dX(), entity.dZ());
            }
            if (!level.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.BEEHIVE)) {
                return false;
            }
            if (entity instanceof EntityBee) {
                EntityBee bee = (EntityBee)entity;
                if (storedFlowerPos != null && !bee.n() && level.z.i() < 0.9f) {
                    bee.h(storedFlowerPos);
                }
                if (releaseStatus == ReleaseStatus.a) {
                    int honeyLevel;
                    bee.gY();
                    if (state.a(TagsBlock.aU, (BlockBase.BlockData blockStateBase) -> blockStateBase.b(BlockBeehive.c)) && (honeyLevel = TileEntityBeehive.a(state)) < 5) {
                        IBlockData newBlockState;
                        int i2;
                        int n2 = i2 = level.z.a(100) == 0 ? 2 : 1;
                        if (honeyLevel + i2 > 5) {
                            --i2;
                        }
                        if (CraftEventFactory.callEntityChangeBlockEvent(entity, pos, newBlockState = (IBlockData)state.b(BlockBeehive.c, honeyLevel + i2))) {
                            level.c(pos, newBlockState);
                        }
                    }
                }
                if (storedInHives != null) {
                    storedInHives.add(bee);
                }
            }
            level.a(null, pos, SoundEffects.bX, SoundCategory.e, 1.0f, 1.0f);
            level.a(GameEvent.c, pos, GameEvent.a.a(entity, level.a_(pos)));
            return true;
        }
        return false;
    }

    private boolean k() {
        return this.j != null;
    }

    private static void a(World level, BlockPosition pos, IBlockData state, List<HiveBee> data, @Nullable BlockPosition savedFlowerPos) {
        boolean flag = false;
        Iterator<HiveBee> iterator = data.iterator();
        while (iterator.hasNext()) {
            ReleaseStatus beeReleaseStatus;
            HiveBee beeData = iterator.next();
            if (!beeData.a()) continue;
            ReleaseStatus releaseStatus = beeReleaseStatus = beeData.c() ? ReleaseStatus.a : ReleaseStatus.b;
            if (TileEntityBeehive.a(level, pos, state, beeData.b(), null, beeReleaseStatus, savedFlowerPos)) {
                flag = true;
                iterator.remove();
                continue;
            }
            if (!level.paperConfig().entities.behavior.cooldownFailedBeehiveReleases) continue;
            beeData.exitTickCounter = beeData.a.f / 2;
        }
        if (flag) {
            TileEntityBeehive.a(level, pos, state);
        }
    }

    public static void a(World level, BlockPosition pos, IBlockData state, TileEntityBeehive beehive) {
        TileEntityBeehive.a(level, pos, state, beehive.i, beehive.j);
        if (!beehive.i.isEmpty() && level.I_().j() < 0.005) {
            double d2 = (double)pos.u() + 0.5;
            double d1 = pos.v();
            double d22 = (double)pos.w() + 0.5;
            level.a(null, d2, d1, d22, SoundEffects.bZ, SoundCategory.e, 1.0f, 1.0f);
        }
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.i = Lists.newArrayList();
        input.a(e, net.minecraft.world.level.block.entity.TileEntityBeehive$c.b).orElse(List.of()).forEach(this::a);
        this.j = input.a(d, BlockPosition.a).orElse(null);
        this.maxBees = input.a("Bukkit.MaxEntities", a);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a(e, net.minecraft.world.level.block.entity.TileEntityBeehive$c.b, this.l());
        output.b(d, BlockPosition.a, this.j);
        output.a("Bukkit.MaxEntities", this.maxBees);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        super.a(componentGetter);
        this.i = Lists.newArrayList();
        List<c> list = componentGetter.a(DataComponents.ar, Bees.c).a();
        list.forEach(this::a);
    }

    @Override
    protected void a(DataComponentMap.a components) {
        super.a(components);
        components.a(DataComponents.ar, new Bees(this.l()));
    }

    @Override
    public void b(ValueOutput output) {
        super.b(output);
        output.c(e);
    }

    private List<c> l() {
        return this.i.stream().map(HiveBee::b).toList();
    }

    @Override
    public void a(WorldServer level, DebugValueSource.a registrar) {
        registrar.a(DebugSubscriptions.h, () -> DebugHiveInfo.a(this));
    }

    public static final class ReleaseStatus
    extends Enum<ReleaseStatus> {
        public static final /* enum */ ReleaseStatus a = new ReleaseStatus();
        public static final /* enum */ ReleaseStatus b = new ReleaseStatus();
        public static final /* enum */ ReleaseStatus c = new ReleaseStatus();
        private static final /* synthetic */ ReleaseStatus[] d;

        public static ReleaseStatus[] values() {
            return (ReleaseStatus[])d.clone();
        }

        public static ReleaseStatus valueOf(String name) {
            return Enum.valueOf(ReleaseStatus.class, name);
        }

        private static /* synthetic */ ReleaseStatus[] a() {
            return new ReleaseStatus[]{a, b, c};
        }

        static {
            d = ReleaseStatus.a();
        }
    }

    public static class HiveBee {
        public final c a;
        private int exitTickCounter;
        private int b;

        HiveBee(c occupant) {
            this.a = occupant;
            this.exitTickCounter = this.b = occupant.b();
        }

        public boolean a() {
            ++this.b;
            return this.exitTickCounter++ > this.a.f;
        }

        public c b() {
            return new c(this.a.d, this.b, this.a.f);
        }

        public boolean c() {
            return this.a.d.b().b("HasNectar", false);
        }
    }

    public static final class c
    extends Record {
        private final TypedEntityData<EntityTypes<?>> d;
        private final int e;
        private final int f;
        public static final Codec<c> a = RecordCodecBuilder.create(instance -> instance.group((App)TypedEntityData.a(EntityTypes.a).fieldOf("entity_data").forGetter(c::a), (App)Codec.INT.fieldOf("ticks_in_hive").forGetter(c::b), (App)Codec.INT.fieldOf("min_ticks_in_hive").forGetter(c::c)).apply((Applicative)instance, c::new));
        public static final Codec<List<c>> b = a.listOf();
        public static final StreamCodec<RegistryFriendlyByteBuf, c> c = StreamCodec.a(TypedEntityData.a(EntityTypes.b), c::a, ByteBufCodecs.h, c::b, ByteBufCodecs.h, c::c, c::new);

        public c(TypedEntityData<EntityTypes<?>> entityData, int ticksInHive, int minTicksInHive) {
            this.d = entityData;
            this.e = ticksInHive;
            this.f = minTicksInHive;
        }

        public static c a(net.minecraft.world.entity.Entity entity) {
            c var5;
            try (ProblemReporter.j scopedCollector = new ProblemReporter.j(entity.en(), c);){
                TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector, entity.ej());
                entity.c(tagValueOutput);
                f.forEach(tagValueOutput::c);
                NBTTagCompound compoundTag = tagValueOutput.b();
                boolean booleanOr = compoundTag.b("HasNectar", false);
                var5 = new c(TypedEntityData.a(entity.ax(), compoundTag), 0, booleanOr ? 2400 : 600);
            }
            return var5;
        }

        public static c a(int ticksInHive) {
            return new c(TypedEntityData.a(EntityTypes.n, new NBTTagCompound()), ticksInHive, 600);
        }

        @Nullable
        public net.minecraft.world.entity.Entity a(World level, BlockPosition pos) {
            NBTTagCompound compoundTag = this.d.c();
            f.forEach(compoundTag::r);
            net.minecraft.world.entity.Entity entity = EntityTypes.a(this.d.a(), compoundTag, level, EntitySpawnReason.r, entity1 -> entity1);
            if (entity != null && entity.ax().a(TagsEntity.e)) {
                entity.g(true);
                if (entity instanceof EntityBee) {
                    EntityBee bee = (EntityBee)entity;
                    bee.i(pos);
                    net.minecraft.world.level.block.entity.TileEntityBeehive$c.a(this.e, bee);
                }
                return entity;
            }
            return null;
        }

        private static void a(int ticksInHive, EntityBee bee) {
            if (!bee.ageLocked) {
                int age = bee.aa_();
                if (age < 0) {
                    bee.c_(Math.min(0, age + ticksInHive));
                } else if (age > 0) {
                    bee.c_(Math.max(0, age - ticksInHive));
                }
                bee.r(Math.max(0, bee.gQ() - ticksInHive));
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "entityData;ticksInHive;minTicksInHive", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "entityData;ticksInHive;minTicksInHive", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "entityData;ticksInHive;minTicksInHive", "d", "e", "f"}, this, o2);
        }

        public TypedEntityData<EntityTypes<?>> a() {
            return this.d;
        }

        public int b() {
            return this.e;
        }

        public int c() {
            return this.f;
        }
    }
}

