/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenEndGatewayConfiguration;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class TileEntityEndGateway
extends TileEntityEnderPortal {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 200;
    private static final int c = 40;
    private static final int d = 2400;
    private static final int e = 1;
    private static final int f = 10;
    private static final long g = 0L;
    private static final boolean h = false;
    public long i = 0L;
    private int j;
    @Nullable
    public BlockPosition k;
    public boolean l = false;

    public TileEntityEndGateway(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.w, pos, blockState);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Age", this.i);
        output.b("exit_portal", BlockPosition.a, this.k);
        if (this.l) {
            output.a("ExactTeleport", true);
        }
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.i = input.a("Age", 0L);
        this.k = input.a("exit_portal", BlockPosition.a).filter(World::l).orElse(null);
        this.l = input.a("ExactTeleport", false);
    }

    public static void a(World level, BlockPosition pos, IBlockData state, TileEntityEndGateway blockEntity) {
        ++blockEntity.i;
        if (blockEntity.c()) {
            --blockEntity.j;
        }
    }

    public static void b(World level, BlockPosition pos, IBlockData state, TileEntityEndGateway blockEntity) {
        boolean isSpawning = blockEntity.a();
        boolean isCoolingDown = blockEntity.c();
        ++blockEntity.i;
        if (isCoolingDown) {
            --blockEntity.j;
        } else if (blockEntity.i % 2400L == 0L) {
            TileEntityEndGateway.c(level, pos, state, blockEntity);
        }
        if (isSpawning != blockEntity.a() || isCoolingDown != blockEntity.c()) {
            TileEntityEndGateway.a(level, pos, state);
        }
    }

    public boolean a() {
        return this.i < 200L;
    }

    public boolean c() {
        return this.j > 0;
    }

    public float a(float partialTick) {
        return MathHelper.a(((float)this.i + partialTick) / 200.0f, 0.0f, 1.0f);
    }

    public float b(float partialTick) {
        return 1.0f - MathHelper.a(((float)this.j - partialTick) / 40.0f, 0.0f, 1.0f);
    }

    public PacketPlayOutTileEntityData d() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.d(registries);
    }

    public static void c(World level, BlockPosition pos, IBlockData state, TileEntityEndGateway blockEntity) {
        if (!level.D_()) {
            blockEntity.j = 40;
            level.a(pos, state.b(), 1, 0);
            TileEntityEndGateway.a(level, pos, state);
        }
    }

    @Override
    public boolean a_(int id, int type) {
        if (id == 1) {
            this.j = 40;
            return true;
        }
        return super.a_(id, type);
    }

    @Nullable
    public Vec3D a(WorldServer level, BlockPosition pos) {
        BlockPosition blockPos;
        if (this.k == null && level.getTypeKey() == WorldDimension.d) {
            blockPos = TileEntityEndGateway.b(level, pos);
            blockPos = blockPos.b(10);
            a.debug("Creating portal at {}", (Object)blockPos);
            TileEntityEndGateway.a(level, blockPos, WorldGenEndGatewayConfiguration.a(pos, false));
            this.a(blockPos, this.l);
        }
        if (this.k != null) {
            blockPos = this.l ? this.k : TileEntityEndGateway.a((World)level, this.k);
            return blockPos.c();
        }
        return null;
    }

    private static BlockPosition a(World level, BlockPosition pos) {
        BlockPosition blockPos = TileEntityEndGateway.a((IBlockAccess)level, pos.b(0, 2, 0), 5, false);
        a.debug("Best exit position for portal at {} is {}", (Object)pos, (Object)blockPos);
        return blockPos.d();
    }

    private static BlockPosition b(WorldServer level, BlockPosition pos) {
        Vec3D vec3 = TileEntityEndGateway.c(level, pos);
        Chunk chunk = TileEntityEndGateway.a((World)level, vec3);
        BlockPosition blockPos = TileEntityEndGateway.a(chunk);
        if (blockPos == null) {
            BlockPosition blockPos1 = BlockPosition.a(vec3.g + 0.5, 75.0, vec3.i + 0.5);
            a.debug("Failed to find a suitable block to teleport to, spawning an island on {}", (Object)blockPos1);
            level.L_().a(Registries.aS).flatMap(registry -> registry.a(EndFeatures.f)).ifPresent(reference -> ((WorldGenFeatureConfigured)reference.a()).a(level, level.n().g(), RandomSource.a(blockPos1.a()), blockPos1));
            blockPos = blockPos1;
        } else {
            a.debug("Found suitable block to teleport to: {}", (Object)blockPos);
        }
        return TileEntityEndGateway.a((IBlockAccess)level, blockPos, 16, true);
    }

    private static Vec3D c(WorldServer level, BlockPosition pos) {
        Vec3D vec3 = new Vec3D(pos.u(), 0.0, pos.w()).d();
        int i2 = 1024;
        Vec3D vec31 = vec3.c(1024.0);
        int i1 = 16;
        while (!TileEntityEndGateway.a(level, vec31) && i1-- > 0) {
            a.debug("Skipping backwards past nonempty chunk at {}", (Object)vec31);
            vec31 = vec31.e(vec3.c(-16.0));
        }
        int var6 = 16;
        while (TileEntityEndGateway.a(level, vec31) && var6-- > 0) {
            a.debug("Skipping forward past empty chunk at {}", (Object)vec31);
            vec31 = vec31.e(vec3.c(16.0));
        }
        a.debug("Found chunk at {}", (Object)vec31);
        return vec31;
    }

    private static boolean a(WorldServer level, Vec3D pos) {
        return TileEntityEndGateway.a((World)level, pos).a() == -1;
    }

    private static BlockPosition a(IBlockAccess level, BlockPosition pos, int radius, boolean allowBedrock) {
        BaseBlockPosition blockPos = null;
        for (int i2 = -radius; i2 <= radius; ++i2) {
            block1: for (int i1 = -radius; i1 <= radius; ++i1) {
                if (i2 == 0 && i1 == 0 && !allowBedrock) continue;
                for (int y2 = level.ar(); y2 > (blockPos == null ? level.M_() : blockPos.v()); --y2) {
                    BlockPosition blockPos1 = new BlockPosition(pos.u() + i2, y2, pos.w() + i1);
                    IBlockData blockState = level.a_(blockPos1);
                    if (!blockState.m(level, blockPos1) || !allowBedrock && blockState.a(Blocks.I)) continue;
                    blockPos = blockPos1;
                    continue block1;
                }
            }
        }
        return blockPos == null ? pos : blockPos;
    }

    private static Chunk a(World level, Vec3D pos) {
        return level.d(MathHelper.a(pos.g / 16.0), MathHelper.a(pos.i / 16.0));
    }

    @Nullable
    private static BlockPosition a(Chunk chunk) {
        ChunkCoordIntPair pos = chunk.f();
        BlockPosition blockPos = new BlockPosition(pos.d(), 30, pos.e());
        int i2 = chunk.b() + 16 - 1;
        BlockPosition blockPos1 = new BlockPosition(pos.f(), i2, pos.g());
        BlockPosition blockPos2 = null;
        double d2 = 0.0;
        for (BlockPosition blockPos3 : BlockPosition.c(blockPos, blockPos1)) {
            IBlockData blockState = chunk.a_(blockPos3);
            BlockPosition blockPos4 = blockPos3.d();
            BlockPosition blockPos5 = blockPos3.b(2);
            if (!blockState.a(Blocks.go) || chunk.a_(blockPos4).m(chunk, blockPos4) || chunk.a_(blockPos5).m(chunk, blockPos5)) continue;
            double d1 = blockPos3.c(0.0, 0.0, 0.0);
            if (blockPos2 != null && !(d1 < d2)) continue;
            blockPos2 = blockPos3;
            d2 = d1;
        }
        return blockPos2;
    }

    private static void a(WorldServer level, BlockPosition pos, WorldGenEndGatewayConfiguration config) {
        WorldGenerator.N.a(config, level, level.n().g(), RandomSource.a(), pos);
    }

    @Override
    public boolean a(EnumDirection face) {
        return Block.a(this.o(), this.n.a_(this.aD_().a(face)), face);
    }

    public int f() {
        int i2 = 0;
        for (EnumDirection direction : EnumDirection.values()) {
            i2 += this.a(direction) ? 1 : 0;
        }
        return i2;
    }

    public void a(BlockPosition exitPortal, boolean exactTeleport) {
        this.l = exactTeleport;
        this.k = exitPortal;
        this.e();
    }
}

