/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import io.papermc.paper.event.inventory.PaperInventoryMoveItemEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryHolder;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHopper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockHopper;
import net.minecraft.world.level.block.entity.IHopper;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.HopperInventorySearchEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.Inventory;

public class TileEntityHopper
extends TileEntityLootable
implements IHopper {
    public static final int d = 8;
    public static final int e = 5;
    private static final int[][] f = new int[54][];
    private static final int g = -1;
    private static final IChatBaseComponent h = IChatBaseComponent.c("container.hopper");
    private NonNullList<ItemStack> i = NonNullList.a(5, ItemStack.l);
    public int j = -1;
    private long k;
    private EnumDirection q;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;
    private static final int HOPPER_EMPTY = 0;
    private static final int HOPPER_HAS_ITEMS = 1;
    private static final int HOPPER_IS_FULL = 2;
    public static boolean skipHopperEvents;
    private static boolean skipPullModeEventFire;
    private static boolean skipPushModeEventFire;
    private static final BiPredicate<ItemStack, Integer> STACK_SIZE_TEST;
    private static final BiPredicate<ItemStack, Integer> IS_EMPTY_TEST;

    @Override
    public List<ItemStack> getContents() {
        return this.i;
    }

    @Override
    public void onOpen(CraftHumanEntity player) {
        this.transaction.add(player);
    }

    @Override
    public void onClose(CraftHumanEntity player) {
        this.transaction.remove(player);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int ap_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public TileEntityHopper(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.s, pos, blockState);
        this.q = blockState.c(BlockHopper.b);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.i = NonNullList.a(this.b(), ItemStack.l);
        if (!this.c_(input)) {
            ContainerUtil.a(input, this.i);
        }
        this.j = input.a("TransferCooldown", -1);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        if (!this.d_(output)) {
            ContainerUtil.a(output, this.i);
        }
        output.a("TransferCooldown", this.j);
    }

    @Override
    public int b() {
        return this.i.size();
    }

    @Override
    public ItemStack a(int index, int count) {
        this.e_(null);
        return ContainerUtil.a(this.g(), index, count);
    }

    @Override
    public void a(int index, ItemStack stack) {
        this.e_(null);
        this.g().set(index, stack);
        stack.f(this.f_(stack));
    }

    @Override
    public void c(IBlockData blockState) {
        super.c(blockState);
        this.q = blockState.c(BlockHopper.b);
    }

    @Override
    protected IChatBaseComponent k() {
        return h;
    }

    public static void a(World level, BlockPosition pos, IBlockData state, TileEntityHopper blockEntity) {
        --blockEntity.j;
        blockEntity.k = level.ag();
        if (!blockEntity.w()) {
            blockEntity.d(0);
            boolean result = TileEntityHopper.a(level, pos, state, blockEntity, () -> TileEntityHopper.a(level, (IHopper)blockEntity));
            if (!result && blockEntity.n.spigotConfig.hopperCheck > 1) {
                blockEntity.d(blockEntity.n.spigotConfig.hopperCheck);
            }
        }
    }

    private static int getFullState(TileEntityHopper hopper) {
        hopper.e_(null);
        NonNullList<ItemStack> hopperItems = hopper.i;
        boolean empty = true;
        boolean full = true;
        int len = hopperItems.size();
        for (int i2 = 0; i2 < len; ++i2) {
            ItemStack stack = (ItemStack)hopperItems.get(i2);
            if (stack.f()) {
                full = false;
                continue;
            }
            if (!full) {
                return 1;
            }
            empty = false;
            if (stack.M() == stack.k()) continue;
            return 1;
        }
        return empty ? 0 : (full ? 2 : 1);
    }

    private static boolean a(World level, BlockPosition pos, IBlockData state, TileEntityHopper blockEntity, BooleanSupplier validator) {
        if (level.D_()) {
            return false;
        }
        if (!blockEntity.w() && state.c(BlockHopper.c).booleanValue()) {
            boolean flag = false;
            int fullState = TileEntityHopper.getFullState(blockEntity);
            if (fullState != 0) {
                flag = TileEntityHopper.a(level, pos, blockEntity);
            }
            if (fullState != 2 || flag) {
                flag |= validator.getAsBoolean();
            }
            if (flag) {
                blockEntity.d(level.spigotConfig.hopperTransfer);
                TileEntityHopper.a(level, pos, state);
                return true;
            }
        }
        return false;
    }

    private boolean l() {
        for (ItemStack itemStack : this.i) {
            if (!itemStack.f() && itemStack.M() == itemStack.k()) continue;
            return false;
        }
        return true;
    }

    private static boolean hopperPush(World level, IInventory destination, EnumDirection direction, TileEntityHopper hopper) {
        skipPushModeEventFire = skipHopperEvents;
        boolean foundItem = false;
        for (int i2 = 0; i2 < hopper.b(); ++i2) {
            ItemStack origItemStack;
            ItemStack item = hopper.a(i2);
            if (item.f()) continue;
            foundItem = true;
            ItemStack movedItem = origItemStack = item;
            int originalItemCount = origItemStack.M();
            int movedItemCount = Math.min(level.spigotConfig.hopperAmount, originalItemCount);
            origItemStack.e(movedItemCount);
            if (!skipPushModeEventFire && (movedItem = TileEntityHopper.callPushMoveEvent(destination, movedItem, hopper)) == null) {
                origItemStack.e(originalItemCount);
                return false;
            }
            ItemStack remainingItem = TileEntityHopper.a((IInventory)hopper, destination, movedItem, direction);
            int remainingItemCount = remainingItem.M();
            if (remainingItemCount != movedItemCount) {
                origItemStack = origItemStack.copy(true);
                origItemStack.e(originalItemCount);
                if (!origItemStack.f()) {
                    origItemStack.e(originalItemCount - movedItemCount + remainingItemCount);
                }
                hopper.a(i2, origItemStack);
                destination.e();
                return true;
            }
            origItemStack.e(originalItemCount);
        }
        if (foundItem && level.paperConfig().hopper.cooldownWhenFull) {
            hopper.d(level.spigotConfig.hopperTransfer);
        }
        return false;
    }

    private static boolean hopperPull(World level, IHopper hopper, IInventory container, ItemStack origItemStack, int i2) {
        ItemStack movedItem = origItemStack;
        int originalItemCount = origItemStack.M();
        int movedItemCount = Math.min(level.spigotConfig.hopperAmount, originalItemCount);
        container.e();
        movedItem.e(movedItemCount);
        if (!skipPullModeEventFire && (movedItem = TileEntityHopper.callPullMoveEvent(hopper, container, movedItem)) == null) {
            origItemStack.e(originalItemCount);
            return true;
        }
        ItemStack remainingItem = TileEntityHopper.a(container, (IInventory)hopper, movedItem, null);
        int remainingItemCount = remainingItem.M();
        if (remainingItemCount != movedItemCount) {
            origItemStack = origItemStack.copy(true);
            origItemStack.e(originalItemCount);
            if (!origItemStack.f()) {
                origItemStack.e(originalItemCount - movedItemCount + remainingItemCount);
            }
            TileEntity.ignoreBlockEntityUpdates = true;
            container.a(i2, origItemStack);
            TileEntity.ignoreBlockEntityUpdates = false;
            container.e();
            return true;
        }
        origItemStack.e(originalItemCount);
        if (level.paperConfig().hopper.cooldownWhenFull) {
            TileEntityHopper.applyCooldown(hopper);
        }
        return false;
    }

    @Nullable
    private static ItemStack callPushMoveEvent(IInventory destination, ItemStack itemStack, TileEntityHopper hopper) {
        Inventory destinationInventory = TileEntityHopper.getInventory(destination);
        PaperInventoryMoveItemEvent event = new PaperInventoryMoveItemEvent(hopper.getOwner(false).getInventory(), CraftItemStack.asCraftMirror(itemStack), destinationInventory, true);
        boolean result = event.callEvent();
        if (!event.calledGetItem && !event.calledSetItem) {
            skipPushModeEventFire = true;
        }
        if (!result) {
            TileEntityHopper.applyCooldown(hopper);
            return null;
        }
        if (event.calledSetItem) {
            return CraftItemStack.asNMSCopy(event.getItem());
        }
        return itemStack;
    }

    @Nullable
    private static ItemStack callPullMoveEvent(IHopper hopper, IInventory container, ItemStack itemstack) {
        Inventory sourceInventory = TileEntityHopper.getInventory(container);
        Inventory destination = TileEntityHopper.getInventory(hopper);
        PaperInventoryMoveItemEvent event = new PaperInventoryMoveItemEvent(sourceInventory, CraftItemStack.asCraftMirror(itemstack), destination, false);
        boolean result = event.callEvent();
        if (!event.calledGetItem && !event.calledSetItem) {
            skipPullModeEventFire = true;
        }
        if (!result) {
            TileEntityHopper.applyCooldown(hopper);
            return null;
        }
        if (event.calledSetItem) {
            return CraftItemStack.asNMSCopy(event.getItem());
        }
        return itemstack;
    }

    private static Inventory getInventory(IInventory container) {
        CraftInventory sourceInventory;
        if (container instanceof InventoryLargeChest) {
            InventoryLargeChest compoundContainer = (InventoryLargeChest)container;
            sourceInventory = new CraftInventoryDoubleChest(compoundContainer);
        } else if (container instanceof TileEntity) {
            TileEntity blockEntity = (TileEntity)((Object)container);
            sourceInventory = blockEntity.getOwner(false).getInventory();
        } else {
            sourceInventory = container.getOwner() != null ? container.getOwner().getInventory() : new CraftInventory(container);
        }
        return sourceInventory;
    }

    private static void applyCooldown(IHopper hopper) {
        TileEntityHopper blockEntity;
        if (hopper instanceof TileEntityHopper && (blockEntity = (TileEntityHopper)hopper).j() != null) {
            blockEntity.d(blockEntity.j().spigotConfig.hopperTransfer);
        }
    }

    private static boolean allMatch(IInventory container, EnumDirection direction, BiPredicate<ItemStack, Integer> test) {
        if (container instanceof IWorldInventory) {
            for (int slot : ((IWorldInventory)container).a(direction)) {
                if (test.test(container.a(slot), slot)) continue;
                return false;
            }
        } else {
            int size = container.b();
            for (int slot = 0; slot < size; ++slot) {
                if (test.test(container.a(slot), slot)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean anyMatch(IInventory container, EnumDirection direction, BiPredicate<ItemStack, Integer> test) {
        if (container instanceof IWorldInventory) {
            for (int slot : ((IWorldInventory)container).a(direction)) {
                if (!test.test(container.a(slot), slot)) continue;
                return true;
            }
        } else {
            int size = container.b();
            for (int slot = 0; slot < size; ++slot) {
                if (!test.test(container.a(slot), slot)) continue;
                return true;
            }
        }
        return true;
    }

    private static boolean a(World level, BlockPosition pos, TileEntityHopper blockEntity) {
        IInventory attachedContainer = TileEntityHopper.b(level, pos, blockEntity);
        if (attachedContainer == null) {
            return false;
        }
        EnumDirection opposite = blockEntity.q.g();
        if (TileEntityHopper.b(attachedContainer, opposite)) {
            return false;
        }
        return TileEntityHopper.hopperPush(level, attachedContainer, opposite, blockEntity);
    }

    private static int[] a(IInventory container, EnumDirection direction) {
        if (container instanceof IWorldInventory) {
            IWorldInventory worldlyContainer = (IWorldInventory)container;
            return worldlyContainer.a(direction);
        }
        int containerSize = container.b();
        if (containerSize < f.length) {
            int[] ints = f[containerSize];
            if (ints != null) {
                return ints;
            }
            int[] ints1 = TileEntityHopper.c(containerSize);
            TileEntityHopper.f[containerSize] = ints1;
            return ints1;
        }
        return TileEntityHopper.c(containerSize);
    }

    private static int[] c(int size) {
        int[] ints = new int[size];
        int i2 = 0;
        while (i2 < ints.length) {
            ints[i2] = i2++;
        }
        return ints;
    }

    private static boolean b(IInventory container, EnumDirection direction) {
        int[] slots;
        for (int i2 : slots = TileEntityHopper.a(container, direction)) {
            ItemStack item = container.a(i2);
            if (item.M() >= item.k()) continue;
            return false;
        }
        return true;
    }

    public static boolean a(World level, IHopper hopper) {
        boolean flag;
        IBlockData blockState;
        BlockPosition blockPos = BlockPosition.a(hopper.B(), hopper.C() + 1.0, hopper.D());
        IInventory sourceContainer = TileEntityHopper.a(level, hopper, blockPos, blockState = level.a_(blockPos));
        if (sourceContainer != null) {
            EnumDirection direction = EnumDirection.a;
            skipPullModeEventFire = skipHopperEvents;
            for (int i2 : TileEntityHopper.a(sourceContainer, direction)) {
                if (!TileEntityHopper.tryTakeInItemFromSlot(hopper, sourceContainer, i2, direction, level)) continue;
                return true;
            }
            return false;
        }
        boolean bl = flag = hopper.E() && blockState.m(level, blockPos) && !blockState.a(TagsBlock.cQ);
        if (!flag) {
            for (EntityItem itemEntity : TileEntityHopper.b(level, hopper)) {
                if (!TileEntityHopper.a((IInventory)hopper, itemEntity)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(IHopper hopper, IInventory container, int slot, EnumDirection direction, World level) {
        ItemStack item = container.a(slot);
        if (!item.f() && TileEntityHopper.a(hopper, container, item, slot, direction)) {
            return TileEntityHopper.hopperPull(level, hopper, container, item, slot);
        }
        return false;
    }

    public static boolean a(IInventory container, EntityItem item) {
        InventoryPickupItemEvent event;
        boolean flag = false;
        if (InventoryPickupItemEvent.getHandlerList().getRegisteredListeners().length > 0 && !(event = new InventoryPickupItemEvent(TileEntityHopper.getInventory(container), (Item)item.getBukkitEntity())).callEvent()) {
            return false;
        }
        ItemStack itemStack = item.e().v();
        ItemStack itemStack1 = TileEntityHopper.a(null, container, itemStack, null);
        if (itemStack1.f()) {
            flag = true;
            item.a(ItemStack.l);
            item.discard(EntityRemoveEvent.Cause.PICKUP);
        } else {
            item.a(itemStack1);
        }
        return flag;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static ItemStack a(@Nullable IInventory source, IInventory destination, ItemStack stack, @Nullable EnumDirection direction) {
        if (destination instanceof IWorldInventory) {
            IWorldInventory worldlyContainer = (IWorldInventory)destination;
            if (direction != null) {
                int[] slotsForFace = worldlyContainer.a(direction);
                int i2 = 0;
                while (i2 < slotsForFace.length) {
                    if (stack.f()) return stack;
                    stack = TileEntityHopper.b(source, destination, stack, slotsForFace[i2], direction);
                    ++i2;
                }
                return stack;
            }
        }
        int containerSize = destination.b();
        int i3 = 0;
        while (i3 < containerSize) {
            if (stack.f()) return stack;
            stack = TileEntityHopper.b(source, destination, stack, i3, direction);
            ++i3;
        }
        return stack;
    }

    private static boolean a(IInventory container, ItemStack stack, int slot, @Nullable EnumDirection direction) {
        IWorldInventory worldlyContainer;
        return container.b(slot, stack) && (!(container instanceof IWorldInventory) || (worldlyContainer = (IWorldInventory)container).a(slot, stack, direction));
    }

    private static boolean a(IInventory source, IInventory destination, ItemStack stack, int slot, EnumDirection direction) {
        IWorldInventory worldlyContainer;
        return destination.a(source, slot, stack) && (!(destination instanceof IWorldInventory) || (worldlyContainer = (IWorldInventory)destination).b(slot, stack, direction));
    }

    private static ItemStack b(@Nullable IInventory source, IInventory destination, ItemStack stack, int slot, @Nullable EnumDirection direction) {
        ItemStack item = destination.a(slot);
        if (TileEntityHopper.a(destination, stack, slot, direction)) {
            int min;
            boolean flag = false;
            boolean isEmpty = destination.c();
            if (item.f()) {
                ItemStack leftover = ItemStack.l;
                if (!stack.f() && stack.M() > destination.ap_()) {
                    leftover = stack;
                    stack = stack.a(destination.ap_());
                }
                TileEntity.ignoreBlockEntityUpdates = true;
                destination.a(slot, stack);
                TileEntity.ignoreBlockEntityUpdates = false;
                stack = leftover;
                flag = true;
            } else if (TileEntityHopper.a(item, stack)) {
                int i2 = Math.min(stack.k(), destination.ap_()) - item.M();
                min = Math.min(stack.M(), i2);
                stack.h(min);
                item.g(min);
                boolean bl = flag = min > 0;
            }
            if (flag) {
                TileEntityHopper hopperBlockEntity;
                if (isEmpty && destination instanceof TileEntityHopper && !(hopperBlockEntity = (TileEntityHopper)destination).x()) {
                    min = 0;
                    if (source instanceof TileEntityHopper) {
                        TileEntityHopper hopperBlockEntity1 = (TileEntityHopper)source;
                        if (hopperBlockEntity.k >= hopperBlockEntity1.k) {
                            min = 1;
                        }
                    }
                    hopperBlockEntity.d(hopperBlockEntity.n.spigotConfig.hopperTransfer - min);
                }
                destination.e();
            }
        }
        return stack;
    }

    @Nullable
    private static IInventory runHopperInventorySearchEvent(IInventory container, CraftBlock hopper, CraftBlock searchLocation, HopperInventorySearchEvent.ContainerType containerType) {
        HopperInventorySearchEvent event = new HopperInventorySearchEvent((Inventory)(container != null ? new CraftInventory(container) : null), containerType, (org.bukkit.block.Block)hopper, (org.bukkit.block.Block)searchLocation);
        event.callEvent();
        return event.getInventory() != null ? ((CraftInventory)event.getInventory()).getInventory() : null;
    }

    @Nullable
    private static IInventory b(World level, BlockPosition pos, TileEntityHopper blockEntity) {
        BlockPosition searchPosition = pos.a(blockEntity.q);
        IInventory inventory = TileEntityHopper.a(level, searchPosition);
        if (HopperInventorySearchEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return inventory;
        }
        CraftBlock hopper = CraftBlock.at(level, pos);
        CraftBlock searchBlock = CraftBlock.at(level, searchPosition);
        return TileEntityHopper.runHopperInventorySearchEvent(inventory, hopper, searchBlock, HopperInventorySearchEvent.ContainerType.DESTINATION);
    }

    @Nullable
    private static IInventory a(World level, IHopper hopper, BlockPosition pos, IBlockData state) {
        IInventory inventory = TileEntityHopper.a(level, pos, state, hopper.B(), hopper.C() + 1.0, hopper.D());
        if (HopperInventorySearchEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return inventory;
        }
        BlockPosition hopperPos = BlockPosition.a(hopper.B(), hopper.C(), hopper.D());
        CraftBlock hopperBlock = CraftBlock.at(level, hopperPos);
        CraftBlock containerBlock = CraftBlock.at(level, hopperPos.d());
        return TileEntityHopper.runHopperInventorySearchEvent(inventory, hopperBlock, containerBlock, HopperInventorySearchEvent.ContainerType.SOURCE);
    }

    public static List<EntityItem> b(World level, IHopper hopper) {
        AxisAlignedBB aabb = hopper.an_().d(hopper.B() - 0.5, hopper.C() - 0.5, hopper.D() - 0.5);
        return level.a(EntityItem.class, aabb, IEntitySelector.a);
    }

    @Nullable
    public static IInventory a(World level, BlockPosition pos) {
        return TileEntityHopper.getContainerAt(level, pos, level.a_(pos), (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, true);
    }

    @Nullable
    private static IInventory a(World level, BlockPosition pos, IBlockData state, double x2, double y2, double z2) {
        return TileEntityHopper.getContainerAt(level, pos, state, x2, y2, z2, false);
    }

    @Nullable
    private static IInventory getContainerAt(World level, BlockPosition pos, IBlockData state, double x2, double y2, double z2, boolean optimizeEntities) {
        IInventory blockContainer = TileEntityHopper.b(level, pos, state);
        if (!(blockContainer != null || optimizeEntities && level.paperConfig().hopper.ignoreOccludingBlocks && state.getBukkitMaterial().isOccluding())) {
            blockContainer = TileEntityHopper.a(level, x2, y2, z2);
        }
        return blockContainer;
    }

    @Nullable
    private static IInventory b(World level, BlockPosition pos, IBlockData state) {
        TileEntity tileEntity;
        if (!level.spigotConfig.hopperCanLoadChunks && !level.D(pos)) {
            return null;
        }
        Block block = state.b();
        if (block instanceof IInventoryHolder) {
            return ((IInventoryHolder)((Object)block)).a(state, level, pos);
        }
        if (state.x() && (tileEntity = level.c_(pos)) instanceof IInventory) {
            IInventory container = (IInventory)((Object)tileEntity);
            if (container instanceof TileEntityChest && block instanceof BlockChest) {
                container = BlockChest.a((BlockChest)block, state, level, pos, true);
            }
            return container;
        }
        return null;
    }

    @Nullable
    private static IInventory a(World level, double x2, double y2, double z2) {
        List<Entity> entities = level.a(IInventory.class, new AxisAlignedBB(x2 - 0.5, y2 - 0.5, z2 - 0.5, x2 + 0.5, y2 + 0.5, z2 + 0.5), IEntitySelector.d);
        return !entities.isEmpty() ? (IInventory)((Object)entities.get(level.z.a(entities.size()))) : null;
    }

    private static boolean a(ItemStack stack1, ItemStack stack2) {
        return stack1.M() < stack1.k() && ItemStack.c(stack1, stack2);
    }

    @Override
    public double B() {
        return (double)this.o.u() + 0.5;
    }

    @Override
    public double C() {
        return (double)this.o.v() + 0.5;
    }

    @Override
    public double D() {
        return (double)this.o.w() + 0.5;
    }

    @Override
    public boolean E() {
        return true;
    }

    public void d(int cooldownTime) {
        this.j = cooldownTime;
    }

    private boolean w() {
        return this.j > 0;
    }

    private boolean x() {
        return this.j > 8;
    }

    @Override
    protected NonNullList<ItemStack> g() {
        return this.i;
    }

    @Override
    protected void a(NonNullList<ItemStack> items) {
        this.i = items;
    }

    public static void a(World level, BlockPosition pos, IBlockData state, Entity entity, TileEntityHopper blockEntity) {
        EntityItem itemEntity;
        if (entity instanceof EntityItem && !(itemEntity = (EntityItem)entity).e().f() && entity.de().d(-pos.u(), -pos.v(), -pos.w()).c(blockEntity.an_())) {
            TileEntityHopper.a(level, pos, state, blockEntity, () -> TileEntityHopper.a((IInventory)blockEntity, itemEntity));
        }
    }

    @Override
    protected Container a(int id, PlayerInventory player) {
        return new ContainerHopper(id, player, this);
    }

    static {
        STACK_SIZE_TEST = (itemStack, i2) -> itemStack.M() >= itemStack.k();
        IS_EMPTY_TEST = (itemStack, i2) -> itemStack.f();
    }
}

