/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.commands.DelegatingCommandSource;
import io.papermc.paper.event.player.PlayerSignCommandPreprocessEvent;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.UtilColor;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R6.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.util.LazyPlayerSet;
import org.bukkit.entity.Player;
import org.bukkit.event.block.SignChangeEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class TileEntitySign
extends TileEntity {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 90;
    private static final int c = 10;
    private static final boolean d = false;
    @Nullable
    public UUID e;
    private SignText f;
    private SignText g;
    private boolean h = false;
    private final ICommandListener commandSource = new ICommandListener(){

        @Override
        public void a(IChatBaseComponent message) {
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper commandSourceStack) {
            return commandSourceStack.f() != null ? commandSourceStack.f().getBukkitEntity() : new CraftBlockCommandSender(commandSourceStack, TileEntitySign.this);
        }

        @Override
        public boolean z_() {
            return false;
        }

        @Override
        public boolean A_() {
            return false;
        }

        @Override
        public boolean c() {
            return false;
        }
    };

    public TileEntitySign(BlockPosition pos, IBlockData blockState) {
        this((TileEntityTypes)TileEntityTypes.h, pos, blockState);
    }

    public TileEntitySign(TileEntityTypes type, BlockPosition pos, IBlockData blockState) {
        super(type, pos, blockState);
        this.f = this.f();
        this.g = this.f();
    }

    protected SignText f() {
        return new SignText();
    }

    public boolean a(EntityHuman player) {
        return this.isFacingFrontText(player.dK(), player.dQ());
    }

    public boolean isFacingFrontText(double x2, double z2) {
        Block block = this.o().b();
        if (block instanceof BlockSign) {
            float f2;
            BlockSign signBlock = (BlockSign)block;
            Vec3D signHitboxCenterPosition = signBlock.p(this.o());
            double d2 = x2 - ((double)this.aD_().u() + signHitboxCenterPosition.g);
            double d1 = z2 - ((double)this.aD_().w() + signHitboxCenterPosition.i);
            float yRotationDegrees = signBlock.h(this.o());
            return MathHelper.d(yRotationDegrees, f2 = (float)(MathHelper.d(d1, d2) * 180.0 / 3.1415927410125732) - 90.0f) <= 90.0f;
        }
        return false;
    }

    public SignText a(boolean isFrontText) {
        return isFrontText ? this.f : this.g;
    }

    public SignText h() {
        return this.f;
    }

    public SignText k() {
        return this.g;
    }

    public int a() {
        return 10;
    }

    public int c() {
        return 90;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("front_text", SignText.a, this.f);
        output.a("back_text", SignText.a, this.g);
        output.a("is_waxed", this.h);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.f = input.a("front_text", SignText.a).map(this::a).orElseGet(SignText::new);
        this.g = input.a("back_text", SignText.a).map(this::a).orElseGet(SignText::new);
        this.h = input.a("is_waxed", false);
    }

    private SignText a(SignText text) {
        for (int i2 = 0; i2 < 4; ++i2) {
            IChatBaseComponent component = this.a(text.a(i2, false));
            IChatBaseComponent component1 = this.a(text.a(i2, true));
            text = text.a(i2, component, component1);
        }
        return text;
    }

    private IChatBaseComponent a(IChatBaseComponent lineText) {
        World world = this.n;
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            try {
                return ChatComponentUtils.a(this.a(null, serverLevel, this.o), lineText, null, 0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return lineText;
    }

    public void a(EntityHuman player, boolean isFrontText, List<FilteredText> filteredText) {
        if (!this.w() && player.cT().equals(this.m()) && this.n != null) {
            this.a(signText -> this.setMessages(player, filteredText, (SignText)signText, isFrontText), isFrontText);
            this.a((UUID)null);
            this.n.a(this.aD_(), this.o(), this.o(), 3);
        } else {
            a.warn("Player {} just tried to change non-editable sign", (Object)player.ap());
            if (player.h(this.aD_().u(), this.aD_().v(), this.aD_().w()) < (double)MathHelper.i(32)) {
                ((EntityPlayer)player).g.b(this.l());
            }
        }
    }

    public boolean a(UnaryOperator<SignText> updater, boolean isFrontText) {
        SignText text = this.a(isFrontText);
        return this.a((SignText)updater.apply(text), isFrontText);
    }

    private IChatBaseComponent translateColors(Player player, String line, ChatModifier style) {
        if (this.n.purpurConfig.signAllowColors) {
            if (player.hasPermission("purpur.sign.color")) {
                line = line.replaceAll("(?i)&([0-9a-fr])", "\u00a7$1");
            }
            if (player.hasPermission("purpur.sign.style")) {
                line = line.replaceAll("(?i)&([l-or])", "\u00a7$1");
            }
            if (player.hasPermission("purpur.sign.magic")) {
                line = line.replaceAll("(?i)&([kr])", "\u00a7$1");
            }
            return PaperAdventure.asVanilla((Component)LegacyComponentSerializer.legacySection().deserialize(line));
        }
        return IChatBaseComponent.b(line).b(style);
    }

    private SignText setMessages(EntityHuman player, List<FilteredText> filteredText, SignText text, boolean front) {
        SignText originalText = text;
        for (int i2 = 0; i2 < filteredText.size(); ++i2) {
            FilteredText filteredText1 = filteredText.get(i2);
            ChatModifier style = text.a(i2, player.Z()).a();
            CraftPlayer craftPlayer = (CraftPlayer)player.getBukkitEntity();
            text = player.Z() ? text.a(i2, this.translateColors(craftPlayer, UtilColor.g(filteredText1.b()), style)) : text.a(i2, this.translateColors(craftPlayer, UtilColor.g(filteredText1.d()), style), this.translateColors(craftPlayer, UtilColor.g(filteredText1.b()), style));
        }
        CraftPlayer apiPlayer = ((EntityPlayer)player).getBukkitEntity();
        ArrayList<Component> lines = new ArrayList<Component>();
        for (int i3 = 0; i3 < filteredText.size(); ++i3) {
            lines.add(PaperAdventure.asAdventure(text.a(i3, player.Z())));
        }
        SignChangeEvent event = new SignChangeEvent((org.bukkit.block.Block)CraftBlock.at(this.n, this.o), (Player)apiPlayer, new ArrayList(lines), front ? Side.FRONT : Side.BACK);
        if (!event.callEvent()) {
            return originalText;
        }
        IChatBaseComponent[] components = CraftSign.sanitizeLines(event.lines());
        for (int i4 = 0; i4 < components.length; ++i4) {
            if (Objects.equals(lines.get(i4), event.line(i4))) continue;
            text = text.a(i4, components[i4]);
        }
        return text;
    }

    public boolean a(SignText text, boolean isFrontText) {
        return isFrontText ? this.c(text) : this.b(text);
    }

    private boolean b(SignText text) {
        if (text != this.g) {
            this.g = text;
            this.x();
            return true;
        }
        return false;
    }

    private boolean c(SignText text) {
        if (text != this.f) {
            this.f = text;
            this.x();
            return true;
        }
        return false;
    }

    public boolean a(boolean isFrontText, EntityHuman player) {
        return this.w() && this.a(isFrontText).b(player);
    }

    public boolean a(WorldServer level, EntityHuman player, BlockPosition pos, boolean isFrontText) {
        boolean flag = false;
        block5: for (IChatBaseComponent component : this.a(isFrontText).b(player.Z())) {
            ChatModifier style = component.a();
            ChatClickable chatClickable = style.i();
            int n2 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ChatClickable.RunCommand.class, ChatClickable.h.class, ChatClickable.d.class}, (Object)chatClickable, n2)) {
                case 0: {
                    PlayerSignCommandPreprocessEvent event;
                    Object command;
                    ChatClickable.RunCommand runCommand = (ChatClickable.RunCommand)chatClickable;
                    Object object = command = runCommand.b().startsWith("/") ? runCommand.b() : "/" + runCommand.b();
                    if (SpigotConfig.logCommands) {
                        a.info("{} issued server command: {}", (Object)player.cV(), command);
                    }
                    if (!(event = new PlayerSignCommandPreprocessEvent((Player)player.getBukkitEntity(), (String)command, (Set)new LazyPlayerSet(level.q()), (Sign)CraftBlock.at(this.n, this.o).getState(), isFrontText ? Side.FRONT : Side.BACK)).callEvent()) {
                        return false;
                    }
                    level.q().aJ().a(this.a((EntityHuman)((CraftPlayer)event.getPlayer()).getHandle(), level, pos), event.getMessage());
                    flag = true;
                    continue block5;
                }
                case 1: {
                    ChatClickable.h showDialog = (ChatClickable.h)chatClickable;
                    player.b(showDialog.b());
                    flag = true;
                    continue block5;
                }
                case 2: {
                    ChatClickable.d custom = (ChatClickable.d)chatClickable;
                    level.q().a(custom.b(), custom.c());
                    flag = true;
                    continue block5;
                }
            }
        }
        return flag;
    }

    private CommandListenerWrapper a(final @Nullable EntityHuman player, WorldServer level, BlockPosition pos) {
        String string = player == null ? "Sign" : player.ap();
        IChatBaseComponent component = player == null ? IChatBaseComponent.b("Sign") : player.S_();
        ICommandListener commandSource = level.paperConfig().misc.showSignClickCommandFailureMsgsToPlayer ? new DelegatingCommandSource(this, this.commandSource){

            @Override
            public void a(IChatBaseComponent message) {
                if (player instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)player;
                    serverPlayer.a(message);
                }
            }

            @Override
            public boolean A_() {
                return true;
            }
        } : this.commandSource;
        return new CommandListenerWrapper(commandSource, Vec3D.b(pos), Vec2F.a, level, 2, string, component, level.q(), player);
    }

    public PacketPlayOutTileEntityData getTranslatedUpdatePacket(boolean filtered, boolean front) {
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(this.v(), a);){
            TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector, this.j().L_());
            this.a(tagValueOutput);
            IChatBaseComponent[] lines = front ? this.f.b(filtered) : this.g.b(filtered);
            String side = front ? "front_text" : "back_text";
            ValueOutput sideNbt = tagValueOutput.a(side);
            ValueOutput.a<String> messagesNbt = sideNbt.a("messages", Codec.STRING);
            for (int i2 = 0; i2 < 4; ++i2) {
                Component component = PaperAdventure.asAdventure(lines[i2]);
                String line = LegacyComponentSerializer.legacyAmpersand().serialize(component);
                messagesNbt.a(line);
            }
            tagValueOutput.a("PurpurEditor", "true");
            PacketPlayOutTileEntityData packetPlayOutTileEntityData = PacketPlayOutTileEntityData.a(this, (TileEntity blockEntity, IRegistryCustom registryAccess) -> tagValueOutput.b());
            return packetPlayOutTileEntityData;
        }
    }

    public PacketPlayOutTileEntityData l() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.d(registries);
    }

    public void a(@Nullable UUID playWhoMayEdit) {
        this.e = playWhoMayEdit;
    }

    @Nullable
    public UUID m() {
        if (this.n != null && this.e != null) {
            this.a(this, this.n, this.e);
        }
        return this.e;
    }

    private void x() {
        this.e();
        if (this.n != null) {
            this.n.a(this.aD_(), this.o(), this.o(), 3);
        }
    }

    public boolean w() {
        return this.h;
    }

    public boolean b(boolean isWaxed) {
        if (this.h != isWaxed) {
            this.h = isWaxed;
            this.x();
            return true;
        }
        return false;
    }

    public boolean b(UUID uuid) {
        EntityHuman playerByUuid = this.n.c(uuid);
        return playerByUuid == null || !playerByUuid.a(this.aD_(), 4.0);
    }

    public static void a(World level, BlockPosition pos, IBlockData state, TileEntitySign sign) {
        UUID playerWhoMayEdit = sign.m();
        if (playerWhoMayEdit != null) {
            sign.a(sign, level, playerWhoMayEdit);
        }
    }

    private void a(TileEntitySign sign, World level, UUID uuid) {
        if (sign.b(uuid)) {
            sign.a((UUID)null);
        }
    }

    public SoundEffect d() {
        return SoundEffects.Eu;
    }
}

