/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;

public final class TrialSpawnerConfig
extends Record {
    private final int d;
    private final float e;
    private final float f;
    private final float g;
    private final float h;
    private final int i;
    private final WeightedList<MobSpawnerData> j;
    private final WeightedList<ResourceKey<LootTable>> k;
    private final ResourceKey<LootTable> l;
    public static final TrialSpawnerConfig a = TrialSpawnerConfig.b().a();
    public static final Codec<TrialSpawnerConfig> b = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)1, (int)128).optionalFieldOf("spawn_range", (Object)TrialSpawnerConfig.a.d).forGetter(TrialSpawnerConfig::c), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("total_mobs", (Object)Float.valueOf(TrialSpawnerConfig.a.e)).forGetter(TrialSpawnerConfig::d), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("simultaneous_mobs", (Object)Float.valueOf(TrialSpawnerConfig.a.f)).forGetter(TrialSpawnerConfig::e), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("total_mobs_added_per_player", (Object)Float.valueOf(TrialSpawnerConfig.a.g)).forGetter(TrialSpawnerConfig::f), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("simultaneous_mobs_added_per_player", (Object)Float.valueOf(TrialSpawnerConfig.a.h)).forGetter(TrialSpawnerConfig::g), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("ticks_between_spawn", (Object)TrialSpawnerConfig.a.i).forGetter(TrialSpawnerConfig::h), (App)MobSpawnerData.c.optionalFieldOf("spawn_potentials", WeightedList.a()).forGetter(TrialSpawnerConfig::i), (App)WeightedList.a(LootTable.a).optionalFieldOf("loot_tables_to_eject", TrialSpawnerConfig.a.k).forGetter(TrialSpawnerConfig::j), (App)LootTable.a.optionalFieldOf("items_to_drop_when_ominous", TrialSpawnerConfig.a.l).forGetter(TrialSpawnerConfig::k)).apply((Applicative)instance, TrialSpawnerConfig::new));
    public static final Codec<Holder<TrialSpawnerConfig>> c = RegistryFileCodec.a(Registries.bq, b);

    public TrialSpawnerConfig(int spawnRange, float totalMobs, float simultaneousMobs, float totalMobsAddedPerPlayer, float simultaneousMobsAddedPerPlayer, int ticksBetweenSpawn, WeightedList<MobSpawnerData> spawnPotentialsDefinition, WeightedList<ResourceKey<LootTable>> lootTablesToEject, ResourceKey<LootTable> itemsToDropWhenOminous) {
        this.d = spawnRange;
        this.e = totalMobs;
        this.f = simultaneousMobs;
        this.g = totalMobsAddedPerPlayer;
        this.h = simultaneousMobsAddedPerPlayer;
        this.i = ticksBetweenSpawn;
        this.j = spawnPotentialsDefinition;
        this.k = lootTablesToEject;
        this.l = itemsToDropWhenOminous;
    }

    public int a(int players) {
        return (int)Math.floor(this.e + this.g * (float)players);
    }

    public int b(int players) {
        return (int)Math.floor(this.f + this.h * (float)players);
    }

    public long a() {
        return 160L;
    }

    public static a b() {
        return new a();
    }

    public TrialSpawnerConfig a(EntityTypes<?> entityType) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("id", BuiltInRegistries.g.b(entityType).toString());
        MobSpawnerData spawnData = new MobSpawnerData(compoundTag, Optional.empty(), Optional.empty());
        return new TrialSpawnerConfig(this.d, this.e, this.f, this.g, this.h, this.i, WeightedList.a(spawnData), this.k, this.l);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{TrialSpawnerConfig.class, "spawnRange;totalMobs;simultaneousMobs;totalMobsAddedPerPlayer;simultaneousMobsAddedPerPlayer;ticksBetweenSpawn;spawnPotentialsDefinition;lootTablesToEject;itemsToDropWhenOminous", "d", "e", "f", "g", "h", "i", "j", "k", "l"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TrialSpawnerConfig.class, "spawnRange;totalMobs;simultaneousMobs;totalMobsAddedPerPlayer;simultaneousMobsAddedPerPlayer;ticksBetweenSpawn;spawnPotentialsDefinition;lootTablesToEject;itemsToDropWhenOminous", "d", "e", "f", "g", "h", "i", "j", "k", "l"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TrialSpawnerConfig.class, "spawnRange;totalMobs;simultaneousMobs;totalMobsAddedPerPlayer;simultaneousMobsAddedPerPlayer;ticksBetweenSpawn;spawnPotentialsDefinition;lootTablesToEject;itemsToDropWhenOminous", "d", "e", "f", "g", "h", "i", "j", "k", "l"}, this, o2);
    }

    public int c() {
        return this.d;
    }

    public float d() {
        return this.e;
    }

    public float e() {
        return this.f;
    }

    public float f() {
        return this.g;
    }

    public float g() {
        return this.h;
    }

    public int h() {
        return this.i;
    }

    public WeightedList<MobSpawnerData> i() {
        return this.j;
    }

    public WeightedList<ResourceKey<LootTable>> j() {
        return this.k;
    }

    public ResourceKey<LootTable> k() {
        return this.l;
    }

    public static class a {
        private int a = 4;
        private float b = 6.0f;
        private float c = 2.0f;
        private float d = 2.0f;
        private float e = 1.0f;
        private int f = 40;
        private WeightedList<MobSpawnerData> g = WeightedList.a();
        private WeightedList<ResourceKey<LootTable>> h = WeightedList.b().a(LootTables.aR).a(LootTables.aQ).a();
        private ResourceKey<LootTable> i = LootTables.aU;

        public a a(int spawnRange) {
            this.a = spawnRange;
            return this;
        }

        public a a(float totalMobs) {
            this.b = totalMobs;
            return this;
        }

        public a b(float simultaneousMobs) {
            this.c = simultaneousMobs;
            return this;
        }

        public a c(float totalMobsAddedPerPlayer) {
            this.d = totalMobsAddedPerPlayer;
            return this;
        }

        public a d(float simultaneousMobsAddedPerPlayer) {
            this.e = simultaneousMobsAddedPerPlayer;
            return this;
        }

        public a b(int ticksBetweenSpawn) {
            this.f = ticksBetweenSpawn;
            return this;
        }

        public a a(WeightedList<MobSpawnerData> spawnPotentialsDefinition) {
            this.g = spawnPotentialsDefinition;
            return this;
        }

        public a b(WeightedList<ResourceKey<LootTable>> lootTablesToEject) {
            this.h = lootTablesToEject;
            return this;
        }

        public a a(ResourceKey<LootTable> itemsToDropWhenOminous) {
            this.i = itemsToDropWhenOminous;
            return this;
        }

        public TrialSpawnerConfig a() {
            return new TrialSpawnerConfig(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i);
        }
    }
}

