/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.bukkit.event.entity.EntityRemoveEvent;

public class TrialSpawnerData {
    private static final String j = "spawn_data";
    private static final String k = "next_mob_spawns_at";
    private static final int l = 20;
    private static final int m = 18000;
    public final Set<UUID> a = new HashSet<UUID>();
    public final Set<UUID> b = new HashSet<UUID>();
    public long c;
    public long d;
    int e;
    public Optional<MobSpawnerData> f = Optional.empty();
    Optional<ResourceKey<LootTable>> g = Optional.empty();
    @Nullable
    private Entity n;
    @Nullable
    private WeightedList<ItemStack> o;
    double h;
    double i;

    public a a() {
        return new a(Set.copyOf(this.a), Set.copyOf(this.b), this.c, this.d, this.e, this.f, this.g);
    }

    public void a(a data) {
        this.a.clear();
        this.a.addAll(data.b);
        this.b.clear();
        this.b.addAll(data.c);
        this.c = data.d;
        this.d = data.e;
        this.e = data.f;
        this.f = data.g;
        this.g = data.h;
    }

    public void b() {
        this.b.clear();
        this.f = Optional.empty();
        this.c();
    }

    public void c() {
        this.a.clear();
        this.e = 0;
        this.d = 0L;
        this.c = 0L;
    }

    public boolean a(TrialSpawner spawner, RandomSource random) {
        boolean isPresent = this.b(spawner, random).a().i("id").isPresent();
        return isPresent || !spawner.a().i().c();
    }

    public boolean a(TrialSpawnerConfig config, int players) {
        return this.e >= config.a(players);
    }

    public boolean d() {
        return this.b.isEmpty();
    }

    public boolean a(WorldServer level, TrialSpawnerConfig config, int players) {
        return level.ag() >= this.d && this.b.size() < config.b(players);
    }

    public int a(BlockPosition pos) {
        if (this.a.isEmpty()) {
            SystemUtils.b("Trial Spawner at " + String.valueOf(pos) + " has no detected players");
        }
        return Math.max(0, this.a.size() - 1);
    }

    public void a(WorldServer level, BlockPosition pos, TrialSpawner spawner) {
        boolean flag;
        boolean bl = flag = (pos.a() + level.ag()) % 20L != 0L;
        if (!(flag || spawner.g().equals(TrialSpawnerState.f) && spawner.d())) {
            boolean flag1;
            List<UUID> list = spawner.j().detect(level, spawner.k(), pos, spawner.f(), true);
            if (!spawner.d() && !list.isEmpty()) {
                Optional<Pair<EntityHuman, Holder<MobEffectList>>> optional = TrialSpawnerData.a(level, list);
                optional.ifPresent(pair -> {
                    EntityHuman player = (EntityHuman)pair.getFirst();
                    if (pair.getSecond() == MobEffects.E) {
                        TrialSpawnerData.a(player);
                    }
                    level.c(3020, BlockPosition.a(player.bR()), 0);
                    spawner.a(level, pos);
                });
                flag1 = optional.isPresent();
            } else {
                flag1 = false;
            }
            if (!spawner.g().equals(TrialSpawnerState.f) || flag1) {
                List<UUID> list1;
                boolean isEmpty = spawner.h().a.isEmpty();
                List<UUID> list2 = list1 = isEmpty ? list : spawner.j().detect(level, spawner.k(), pos, spawner.f(), false);
                if (this.a.addAll(list1)) {
                    this.d = Math.max(level.ag() + 40L, this.d);
                    if (!flag1) {
                        int i2 = spawner.d() ? 3019 : 3013;
                        level.c(i2, pos, this.a.size());
                    }
                }
            }
        }
    }

    private static Optional<Pair<EntityHuman, Holder<MobEffectList>>> a(WorldServer level, List<UUID> players) {
        EntityHuman player = null;
        for (UUID uuid : players) {
            EntityHuman playerByUuid = level.c(uuid);
            if (playerByUuid == null) continue;
            Holder<MobEffectList> holder = MobEffects.H;
            if (playerByUuid.d(holder)) {
                return Optional.of(Pair.of((Object)playerByUuid, holder));
            }
            if (!playerByUuid.d(MobEffects.E)) continue;
            player = playerByUuid;
        }
        return Optional.ofNullable(player).map(player1 -> Pair.of((Object)player1, MobEffects.E));
    }

    public void a(TrialSpawner spawner, WorldServer level) {
        this.b.stream().map(level::d).forEach(entity -> {
            if (entity != null) {
                level.c(3012, entity.dF(), TrialSpawner.a.a.a());
                if (entity instanceof EntityInsentient) {
                    EntityInsentient mob = (EntityInsentient)entity;
                    mob.b(level);
                }
                entity.remove(Entity.RemovalReason.b, EntityRemoveEvent.Cause.DESPAWN);
            }
        });
        if (!spawner.c().i().c()) {
            this.f = Optional.empty();
        }
        this.e = 0;
        this.b.clear();
        this.d = level.ag() + (long)spawner.c().h();
        spawner.i();
        this.c = level.ag() + spawner.c().a();
    }

    private static void a(EntityHuman player) {
        MobEffect effect = player.e(MobEffects.E);
        if (effect != null) {
            int i2 = effect.e() + 1;
            int i1 = 18000 * i2;
            player.g(MobEffects.E);
            player.a(new MobEffect(MobEffects.H, i1, 0));
        }
    }

    public boolean a(WorldServer level, float delay, int targetCooldownLength) {
        long l2 = this.c - (long)targetCooldownLength;
        return (float)level.ag() >= (float)l2 + delay;
    }

    public boolean b(WorldServer level, float delay, int targetCooldownLength) {
        long l2 = this.c - (long)targetCooldownLength;
        return (float)(level.ag() - l2) % delay == 0.0f;
    }

    public boolean a(WorldServer level) {
        return level.ag() >= this.c;
    }

    protected MobSpawnerData b(TrialSpawner spawner, RandomSource random) {
        if (this.f.isPresent()) {
            return this.f.get();
        }
        WeightedList<MobSpawnerData> weightedList = spawner.a().i();
        Optional<MobSpawnerData> optional = weightedList.c() ? this.f : weightedList.a(random);
        this.f = Optional.of(optional.orElseGet(MobSpawnerData::new));
        spawner.i();
        return this.f.get();
    }

    @Nullable
    public Entity a(TrialSpawner spawner, World level, TrialSpawnerState spawnerState) {
        NBTTagCompound entityToSpawn;
        if (!spawnerState.d()) {
            return null;
        }
        if (this.n == null && (entityToSpawn = this.b(spawner, level.I_()).a()).i("id").isPresent()) {
            this.n = EntityTypes.a(entityToSpawn, level, EntitySpawnReason.q, Function.identity());
        }
        return this.n;
    }

    public NBTTagCompound a(TrialSpawnerState spawnerState) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        if (spawnerState == TrialSpawnerState.c) {
            compoundTag.a(k, this.d);
        }
        this.f.ifPresent(data -> compoundTag.a(j, MobSpawnerData.b, data));
        return compoundTag;
    }

    public double e() {
        return this.h;
    }

    public double f() {
        return this.i;
    }

    WeightedList<ItemStack> a(WorldServer level, TrialSpawnerConfig config, BlockPosition pos) {
        long l2;
        LootParams lootParams;
        if (this.o != null) {
            return this.o;
        }
        LootTable lootTable = level.q().bi().a(config.k());
        ObjectArrayList<ItemStack> randomItems = lootTable.a(lootParams = new LootParams.a(level).a(LootContextParameterSets.b), l2 = TrialSpawnerData.a(level, pos));
        if (randomItems.isEmpty()) {
            return WeightedList.a();
        }
        WeightedList.a<ItemStack> builder = WeightedList.b();
        for (ItemStack itemStack : randomItems) {
            builder.a(itemStack.c(1), itemStack.M());
        }
        this.o = builder.a();
        return this.o;
    }

    private static long a(WorldServer level, BlockPosition pos) {
        BlockPosition blockPos = new BlockPosition(MathHelper.d((float)pos.u() / 30.0f), MathHelper.d((float)pos.v() / 20.0f), MathHelper.d((float)pos.w() / 30.0f));
        return level.H() + blockPos.a();
    }

    public static final class a
    extends Record {
        private final Set<UUID> b;
        private final Set<UUID> c;
        private final long d;
        private final long e;
        private final int f;
        private final Optional<MobSpawnerData> g;
        private final Optional<ResourceKey<LootTable>> h;
        public static final MapCodec<a> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UUIDUtil.b.lenientOptionalFieldOf("registered_players", Set.of()).forGetter(a::a), (App)UUIDUtil.b.lenientOptionalFieldOf("current_mobs", Set.of()).forGetter(a::b), (App)Codec.LONG.lenientOptionalFieldOf("cooldown_ends_at", (Object)0L).forGetter(a::c), (App)Codec.LONG.lenientOptionalFieldOf(TrialSpawnerData.k, (Object)0L).forGetter(a::d), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).lenientOptionalFieldOf("total_mobs_spawned", (Object)0).forGetter(a::e), (App)MobSpawnerData.b.lenientOptionalFieldOf(TrialSpawnerData.j).forGetter(a::f), (App)LootTable.a.lenientOptionalFieldOf("ejecting_loot_table").forGetter(a::g)).apply((Applicative)instance, a::new));

        public a(Set<UUID> detectedPlayers, Set<UUID> currentMobs, long cooldownEndsAt, long nextMobSpawnsAt, int totalMobsSpawned, Optional<MobSpawnerData> nextSpawnData, Optional<ResourceKey<LootTable>> ejectingLootTable) {
            this.b = detectedPlayers;
            this.c = currentMobs;
            this.d = cooldownEndsAt;
            this.e = nextMobSpawnsAt;
            this.f = totalMobsSpawned;
            this.g = nextSpawnData;
            this.h = ejectingLootTable;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "detectedPlayers;currentMobs;cooldownEndsAt;nextMobSpawnsAt;totalMobsSpawned;nextSpawnData;ejectingLootTable", "b", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "detectedPlayers;currentMobs;cooldownEndsAt;nextMobSpawnsAt;totalMobsSpawned;nextSpawnData;ejectingLootTable", "b", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "detectedPlayers;currentMobs;cooldownEndsAt;nextMobSpawnsAt;totalMobsSpawned;nextSpawnData;ejectingLootTable", "b", "c", "d", "e", "f", "g", "h"}, this, o2);
        }

        public Set<UUID> a() {
            return this.b;
        }

        public Set<UUID> b() {
            return this.c;
        }

        public long c() {
            return this.d;
        }

        public long d() {
            return this.e;
        }

        public int e() {
            return this.f;
        }

        public Optional<MobSpawnerData> f() {
            return this.g;
        }

        public Optional<ResourceKey<LootTable>> g() {
            return this.h;
        }
    }
}

