/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public final class TrialSpawnerState
extends Enum<TrialSpawnerState>
implements INamable {
    public static final /* enum */ TrialSpawnerState a = new TrialSpawnerState("inactive", 0, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a, -1.0, false);
    public static final /* enum */ TrialSpawnerState b = new TrialSpawnerState("waiting_for_players", 4, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.b, 200.0, true);
    public static final /* enum */ TrialSpawnerState c = new TrialSpawnerState("active", 8, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.c, 1000.0, true);
    public static final /* enum */ TrialSpawnerState d = new TrialSpawnerState("waiting_for_reward_ejection", 8, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.b, -1.0, false);
    public static final /* enum */ TrialSpawnerState e = new TrialSpawnerState("ejecting_reward", 8, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.b, -1.0, false);
    public static final /* enum */ TrialSpawnerState f = new TrialSpawnerState("cooldown", 0, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.d, -1.0, false);
    private static final float g = 40.0f;
    private static final int h;
    private final String i;
    private final int j;
    private final double k;
    private final b l;
    private final boolean m;
    private static final /* synthetic */ TrialSpawnerState[] n;

    public static TrialSpawnerState[] values() {
        return (TrialSpawnerState[])n.clone();
    }

    public static TrialSpawnerState valueOf(String name) {
        return Enum.valueOf(TrialSpawnerState.class, name);
    }

    private TrialSpawnerState(String name, int lightLevel, b particleEmission, double spinningMobSpeed, boolean isCapableOfSpawning) {
        this.i = name;
        this.j = lightLevel;
        this.l = particleEmission;
        this.k = spinningMobSpeed;
        this.m = isCapableOfSpawning;
    }

    TrialSpawnerState a(BlockPosition pos, TrialSpawner spawner, WorldServer level) {
        TrialSpawnerData stateData = spawner.h();
        TrialSpawnerConfig trialSpawnerConfig = spawner.a();
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (stateData.a(spawner, level, b) == null) {
                    yield this;
                }
                yield b;
            }
            case 1 -> {
                if (!spawner.a(level)) {
                    stateData.c();
                    yield this;
                }
                if (!stateData.a(spawner, level.z)) {
                    yield a;
                }
                stateData.a(level, pos, spawner);
                if (stateData.a.isEmpty()) {
                    yield this;
                }
                yield c;
            }
            case 2 -> {
                if (!spawner.a(level)) {
                    stateData.c();
                    yield b;
                }
                if (!stateData.a(spawner, level.z)) {
                    yield a;
                }
                int i = stateData.a(pos);
                stateData.a(level, pos, spawner);
                if (spawner.d()) {
                    this.a(level, pos, spawner);
                }
                if (stateData.a(trialSpawnerConfig, i)) {
                    if (stateData.d()) {
                        stateData.c = level.ag() + (long)spawner.e();
                        stateData.e = 0;
                        stateData.d = 0L;
                        yield d;
                    }
                } else if (stateData.a(level, trialSpawnerConfig, i)) {
                    spawner.c(level, pos).ifPresent(uuid -> {
                        stateData.b.add((UUID)uuid);
                        ++stateData.e;
                        stateData.d = level.ag() + (long)trialSpawnerConfig.h();
                        trialSpawnerConfig.i().a(level.I_()).ifPresent(spawnData -> {
                            stateData.f = Optional.of(spawnData);
                            spawner.i();
                        });
                    });
                }
                yield this;
            }
            case 3 -> {
                if (stateData.a(level, 40.0f, spawner.e())) {
                    level.a(null, pos, SoundEffects.nI, SoundCategory.e);
                    yield e;
                }
                yield this;
            }
            case 4 -> {
                if (!stateData.b(level, h, spawner.e())) {
                    yield this;
                }
                if (stateData.a.isEmpty()) {
                    level.a(null, pos, SoundEffects.nJ, SoundCategory.e);
                    stateData.g = Optional.empty();
                    yield f;
                }
                if (stateData.g.isEmpty()) {
                    stateData.g = trialSpawnerConfig.j().a(level.I_());
                }
                stateData.g.ifPresent(resourceKey -> spawner.a(level, pos, (ResourceKey<LootTable>)resourceKey));
                stateData.a.remove(stateData.a.iterator().next());
                yield this;
            }
            case 5 -> {
                stateData.a(level, pos, spawner);
                if (!stateData.a.isEmpty()) {
                    stateData.e = 0;
                    stateData.d = 0L;
                    yield c;
                }
                if (stateData.a(level)) {
                    spawner.b(level, pos);
                    stateData.b();
                    yield b;
                }
                yield this;
            }
        };
    }

    private void a(WorldServer level, BlockPosition pos, TrialSpawner spawner) {
        TrialSpawnerConfig trialSpawnerConfig;
        TrialSpawnerData stateData = spawner.h();
        ItemStack itemStack = stateData.a(level, trialSpawnerConfig = spawner.a(), pos).a(level.z).orElse(ItemStack.l);
        if (!itemStack.f() && this.a(level, stateData)) {
            TrialSpawnerState.a(level, pos, spawner, stateData).ifPresent(vec3 -> {
                OminousItemSpawner ominousItemSpawner = OminousItemSpawner.a((World)level, itemStack);
                ominousItemSpawner.f((Vec3D)vec3);
                level.b(ominousItemSpawner);
                float f2 = (level.I_().i() - level.I_().i()) * 0.2f + 1.0f;
                level.a(null, BlockPosition.a(vec3), SoundEffects.nD, SoundCategory.e, 1.0f, f2);
                stateData.c = level.ag() + spawner.c().a();
            });
        }
    }

    private static Optional<Vec3D> a(WorldServer level, BlockPosition pos, TrialSpawner spawner, TrialSpawnerData data) {
        List<EntityHuman> list = data.a.stream().map(level::c).filter(Objects::nonNull).filter(player -> !player.gQ() && !player.at() && player.bX() && player.g(pos.b()) <= (double)MathHelper.i(spawner.f())).toList();
        if (list.isEmpty()) {
            return Optional.empty();
        }
        Entity entity = TrialSpawnerState.a(list, data.b, spawner, pos, level);
        return entity == null ? Optional.empty() : TrialSpawnerState.a(entity, level);
    }

    private static Optional<Vec3D> a(Entity entity, WorldServer level) {
        Vec3D vec31;
        Vec3D vec3 = entity.dD();
        MovingObjectPositionBlock blockHitResult = level.a(new RayTrace(vec3, vec31 = vec3.a(EnumDirection.b, (double)(entity.dB() + 2.0f + (float)level.z.a(4))), RayTrace.BlockCollisionOption.c, RayTrace.FluidCollisionOption.a, VoxelShapeCollision.a()));
        Vec3D vec32 = blockHitResult.b().b().a(EnumDirection.a, 1.0);
        BlockPosition blockPos = BlockPosition.a(vec32);
        return !level.a_(blockPos).g(level, blockPos).c() ? Optional.empty() : Optional.of(vec32);
    }

    @Nullable
    private static Entity a(List<EntityHuman> player, Set<UUID> currentMobs, TrialSpawner spawner, BlockPosition pos, WorldServer level) {
        List<Entity> list;
        Stream<Entity> stream = currentMobs.stream().map(level::d).filter(Objects::nonNull).filter(entity -> entity.bX() && entity.g(pos.b()) <= (double)MathHelper.i(spawner.f()));
        List<Entity> list2 = list = level.z.h() ? stream.toList() : player;
        if (list.isEmpty()) {
            return null;
        }
        return list.size() == 1 ? list.getFirst() : SystemUtils.a(list, level.z);
    }

    private boolean a(WorldServer level, TrialSpawnerData data) {
        return level.ag() >= data.c;
    }

    public int a() {
        return this.j;
    }

    public double b() {
        return this.k;
    }

    public boolean d() {
        return this.k >= 0.0;
    }

    public boolean e() {
        return this.m;
    }

    public void a(World level, BlockPosition pos, boolean isOminous) {
        this.l.emit(level, level.I_(), pos, isOminous);
    }

    @Override
    public String c() {
        return this.i;
    }

    private static /* synthetic */ TrialSpawnerState[] f() {
        return new TrialSpawnerState[]{a, b, c, d, e, f};
    }

    static {
        n = TrialSpawnerState.f();
        h = MathHelper.d(30.0f);
    }

    static interface b {
        public static final b a = (level, random, pos, isOminous) -> {};
        public static final b b = (level, random, pos, isOminous) -> {
            if (random.a(2) == 0) {
                Vec3D vec3 = pos.b().a(random, 0.9f);
                net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a(isOminous ? Particles.O : Particles.aN, vec3, level);
            }
        };
        public static final b c = (level, random, pos, isOminous) -> {
            Vec3D vec3 = pos.b().a(random, 1.0f);
            net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a(Particles.ai, vec3, level);
            net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a(isOminous ? Particles.O : Particles.G, vec3, level);
        };
        public static final b d = (level, random, pos, isOminous) -> {
            Vec3D vec3 = pos.b().a(random, 0.9f);
            if (random.a(3) == 0) {
                net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a(Particles.ai, vec3, level);
            }
            if (level.ag() % 20L == 0L) {
                Vec3D vec31 = pos.b().b(0.0, 0.5, 0.0);
                int i2 = level.I_().a(4) + 20;
                for (int i1 = 0; i1 < i2; ++i1) {
                    net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a(Particles.ai, vec31, level);
                }
            }
        };

        private static void a(ParticleType particleType, Vec3D pos, World level) {
            level.a(particleType, pos.a(), pos.b(), pos.c(), 0.0, 0.0, 0.0);
        }

        public void emit(World var1, RandomSource var2, BlockPosition var3, boolean var4);
    }

    static class c {
        private static final double a = -1.0;
        private static final double b = 200.0;
        private static final double c = 1000.0;

        private c() {
        }
    }

    static class a {
        private static final int a = 0;
        private static final int b = 4;
        private static final int c = 8;

        private a() {
        }
    }
}

