/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import ca.spottedleaf.moonrise.patches.collisions.block.CollisionBlockState;
import ca.spottedleaf.moonrise.patches.starlight.blockstate.StarlightAbstractBlockState;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.DependantName;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.spigotmc.AsyncCatcher;

public abstract class BlockBase
implements FeatureElement {
    protected static final EnumDirection[] E = new EnumDirection[]{EnumDirection.e, EnumDirection.f, EnumDirection.c, EnumDirection.d, EnumDirection.a, EnumDirection.b};
    public final boolean F;
    public float G;
    protected final boolean H;
    protected final SoundEffectType I;
    protected final float J;
    protected final float K;
    protected final float L;
    protected final boolean M;
    protected final FeatureFlagSet N;
    protected final Info O;
    protected final Optional<ResourceKey<LootTable>> P;
    protected final String Q;

    public BlockBase(Info properties) {
        this.F = properties.c;
        this.P = properties.h();
        this.Q = properties.q();
        this.G = properties.f;
        this.H = properties.i;
        this.I = properties.d;
        this.J = properties.j;
        this.K = properties.k;
        this.L = properties.l;
        this.M = properties.F;
        this.N = properties.G;
        this.O = properties;
    }

    public Info w() {
        return this.O;
    }

    protected abstract MapCodec<? extends Block> a();

    protected static <B extends Block> RecordCodecBuilder<B, Info> x() {
        return Info.a.fieldOf("properties").forGetter(BlockBase::w);
    }

    public static <B extends Block> MapCodec<B> b(Function<Info, B> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group(BlockBase.x()).apply((Applicative)instance, factory));
    }

    protected void a(IBlockData state, GeneratorAccess level, BlockPosition pos, int flags, int recursionLeft) {
    }

    protected boolean a(IBlockData state, PathMode pathComputationType) {
        switch (pathComputationType) {
            case a: {
                return !state.m(BlockAccessAir.a, BlockPosition.c);
            }
            case b: {
                return state.y().a(TagsFluid.a);
            }
            case c: {
                return !state.m(BlockAccessAir.a, BlockPosition.c);
            }
        }
        return false;
    }

    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        return state;
    }

    protected boolean b(IBlockData state, IBlockData adjacentState, EnumDirection direction) {
        return false;
    }

    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
    }

    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston) {
        AsyncCatcher.catchOp("block onPlace");
    }

    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
    }

    protected void onPlace(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston, @Nullable ItemActionContext context) {
        this.a(state, level, pos, oldState, movedByPiston);
    }

    protected void a(IBlockData state, WorldServer level, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> dropConsumer) {
        if (!state.l() && explosion.b() != Explosion.Effect.d && state.isDestroyable()) {
            Block block = state.b();
            boolean flag = explosion.c() instanceof EntityHuman;
            if (block.a(explosion)) {
                TileEntity blockEntity = state.x() ? level.c_(pos) : null;
                LootParams.a builder = new LootParams.a(level).a(LootContextParameters.h, Vec3D.b(pos)).a(LootContextParameters.k, ItemStack.l).b(LootContextParameters.j, blockEntity).b(LootContextParameters.a, explosion.d());
                if (explosion instanceof ServerExplosion) {
                    ServerExplosion serverExplosion = (ServerExplosion)explosion;
                    if (serverExplosion.yield < 1.0f) {
                        builder.a(LootContextParameters.l, Float.valueOf(1.0f / serverExplosion.yield));
                    }
                }
                state.a(level, pos, ItemStack.l, flag);
                state.a(builder).forEach(stack -> dropConsumer.accept((ItemStack)stack, pos));
            }
            level.a(pos, Blocks.a.m(), 3);
            block.a(level, pos, explosion);
        }
    }

    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        return EnumInteractionResult.e;
    }

    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        return EnumInteractionResult.f;
    }

    protected boolean a(IBlockData state, World level, BlockPosition pos, int id, int param) {
        return false;
    }

    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.b;
    }

    protected boolean g_(IBlockData state) {
        return false;
    }

    protected boolean e_(IBlockData state) {
        return false;
    }

    protected Fluid b_(IBlockData state) {
        return FluidTypes.a.g();
    }

    protected boolean c_(IBlockData state) {
        return false;
    }

    protected float at_() {
        return 0.25f;
    }

    protected float av_() {
        return 0.2f;
    }

    @Override
    public FeatureFlagSet k() {
        return this.N;
    }

    protected boolean o(IBlockData state) {
        return false;
    }

    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return state;
    }

    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state;
    }

    protected boolean a(IBlockData state, BlockActionContext useContext) {
        return state.v() && (useContext.n().f() || !useContext.n().a(this.h())) && (state.isDestroyable() || useContext.o() != null && useContext.o().gC().d);
    }

    protected boolean a(IBlockData state, FluidType fluid) {
        return state.v() || !state.e();
    }

    protected List<ItemStack> a(IBlockData state, LootParams.a params) {
        if (this.P.isEmpty()) {
            return Collections.emptyList();
        }
        LootParams lootParams = params.a(LootContextParameters.i, state).a(LootContextParameterSets.r);
        WorldServer level = lootParams.a();
        LootTable lootTable = level.q().bi().a(this.P.get());
        return lootTable.a(lootParams);
    }

    protected long a(IBlockData state, BlockPosition pos) {
        return MathHelper.a(pos);
    }

    protected VoxelShape f_(IBlockData state) {
        return state.f(BlockAccessAir.a, BlockPosition.c);
    }

    protected VoxelShape b_(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return this.b(state, level, pos, VoxelShapeCollision.a());
    }

    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return VoxelShapes.a();
    }

    protected int i_(IBlockData state) {
        if (state.s()) {
            return 15;
        }
        return state.f() ? 0 : 1;
    }

    @Nullable
    public ITileInventory a(IBlockData state, World level, BlockPosition pos) {
        return null;
    }

    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        return true;
    }

    protected float c(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return state.m(level, pos) ? 0.2f : 1.0f;
    }

    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        return 0;
    }

    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return VoxelShapes.b();
    }

    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.F ? state.f(level, pos) : VoxelShapes.a();
    }

    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, Entity entity) {
        return VoxelShapes.b();
    }

    protected boolean a_(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return Block.a(state.g(level, pos));
    }

    protected VoxelShape c(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.b(state, level, pos, context);
    }

    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
    }

    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
    }

    protected float a(IBlockData state, EntityHuman player, IBlockAccess level, BlockPosition pos) {
        float destroySpeed = state.e(level, pos);
        if (destroySpeed == -1.0f) {
            return 0.0f;
        }
        int i2 = player.d(state) ? 30 : 100;
        return player.c(state) / destroySpeed / (float)i2;
    }

    protected void a(IBlockData state, WorldServer level, BlockPosition pos, ItemStack stack, boolean dropExperience) {
    }

    protected void a_(IBlockData state, World level, BlockPosition pos, EntityHuman player) {
    }

    protected int a(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection direction) {
        return 0;
    }

    protected void a(IBlockData state, World level, BlockPosition pos, Entity entity, InsideBlockEffectApplier effectApplier, boolean pastEdges) {
    }

    protected int b(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection direction) {
        return 0;
    }

    public final Optional<ResourceKey<LootTable>> y() {
        return this.P;
    }

    public final String z() {
        return this.Q;
    }

    protected void a(World level, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
    }

    protected boolean d_(IBlockData state) {
        return !Block.a(state.f(BlockAccessAir.a, BlockPosition.c)) && state.y().c();
    }

    protected boolean f(IBlockData state) {
        return this.H;
    }

    protected SoundEffectType h_(IBlockData state) {
        return this.I;
    }

    protected ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        return new ItemStack(this.h());
    }

    public abstract Item h();

    protected abstract Block o();

    public MaterialMapColor A() {
        return this.O.b.apply(this.o().m());
    }

    public float B() {
        return this.O.g;
    }

    public static class Info {
        public static final Codec<Info> a = Codec.unit(() -> Info.a());
        Function<IBlockData, MaterialMapColor> b = state -> MaterialMapColor.a;
        boolean c = true;
        SoundEffectType d = SoundEffectType.f;
        ToIntFunction<IBlockData> e = state -> 0;
        float f;
        float g;
        boolean h;
        boolean i;
        float j = 0.6f;
        float k = 1.0f;
        float l = 1.0f;
        @Nullable
        private ResourceKey<Block> m;
        private DependantName<Block, Optional<ResourceKey<LootTable>>> n = key -> Optional.of(ResourceKey.a(Registries.bz, key.a().f("blocks/")));
        private DependantName<Block, String> o = key -> SystemUtils.a("block", key.a());
        boolean p = true;
        boolean q;
        boolean r;
        @Deprecated
        boolean s;
        @Deprecated
        boolean t;
        boolean u;
        EnumPistonReaction v = EnumPistonReaction.a;
        boolean w = true;
        BlockPropertyInstrument x = BlockPropertyInstrument.a;
        boolean y;
        e<EntityTypes<?>> z = (state, level, pos, random) -> state.c(level, pos, EnumDirection.b) && state.k() < 14;
        f A = (state, level, pos) -> state.m(level, pos);
        f B;
        f C = this.B = (state, level, pos) -> state.d() && state.m(level, pos);
        f D = (state, level, pos) -> false;
        f E = (state, level, pos) -> false;
        boolean F;
        FeatureFlagSet G = FeatureFlags.g;
        @Nullable
        b H;

        private Info() {
        }

        public static Info a() {
            return new Info();
        }

        public static Info a(BlockBase blockBehaviour) {
            Info properties = Info.b(blockBehaviour);
            Info properties1 = blockBehaviour.O;
            properties.l = properties1.l;
            properties.A = properties1.A;
            properties.z = properties1.z;
            properties.D = properties1.D;
            properties.B = properties1.B;
            properties.C = properties1.C;
            properties.n = properties1.n;
            properties.o = properties1.o;
            return properties;
        }

        @Deprecated
        public static Info b(BlockBase blockBehaviour) {
            Info properties = new Info();
            Info properties1 = blockBehaviour.O;
            properties.g = properties1.g;
            properties.f = properties1.f;
            properties.c = properties1.c;
            properties.i = properties1.i;
            properties.e = properties1.e;
            properties.b = properties1.b;
            properties.d = properties1.d;
            properties.j = properties1.j;
            properties.k = properties1.k;
            properties.F = properties1.F;
            properties.p = properties1.p;
            properties.q = properties1.q;
            properties.r = properties1.r;
            properties.s = properties1.s;
            properties.t = properties1.t;
            properties.u = properties1.u;
            properties.v = properties1.v;
            properties.h = properties1.h;
            properties.H = properties1.H;
            properties.w = properties1.w;
            properties.G = properties1.G;
            properties.E = properties1.E;
            properties.x = properties1.x;
            properties.y = properties1.y;
            return properties;
        }

        public Info a(EnumColor mapColor) {
            this.b = state -> mapColor.e();
            return this;
        }

        public Info a(MaterialMapColor mapColor) {
            this.b = state -> mapColor;
            return this;
        }

        public Info a(Function<IBlockData, MaterialMapColor> mapColor) {
            this.b = mapColor;
            return this;
        }

        public Info b() {
            this.c = false;
            this.p = false;
            return this;
        }

        public Info c() {
            this.p = false;
            return this;
        }

        public Info a(float friction) {
            this.j = friction;
            return this;
        }

        public Info b(float speedFactor) {
            this.k = speedFactor;
            return this;
        }

        public Info c(float jumpFactor) {
            this.l = jumpFactor;
            return this;
        }

        public Info a(SoundEffectType soundType) {
            this.d = soundType;
            return this;
        }

        public Info a(ToIntFunction<IBlockData> lightEmission) {
            this.e = lightEmission;
            return this;
        }

        public Info a(float destroyTime, float explosionResistance) {
            return this.e(destroyTime).f(explosionResistance);
        }

        public Info d() {
            return this.d(0.0f);
        }

        public Info d(float strength) {
            this.a(strength, strength);
            return this;
        }

        public Info e() {
            this.i = true;
            return this;
        }

        public Info f() {
            this.F = true;
            return this;
        }

        public Info g() {
            this.n = DependantName.fixed(Optional.empty());
            return this;
        }

        public Info a(Optional<ResourceKey<LootTable>> lootTable) {
            this.n = DependantName.fixed(lootTable);
            return this;
        }

        protected Optional<ResourceKey<LootTable>> h() {
            return this.n.get(Objects.requireNonNull(this.m, "Block id not set"));
        }

        public Info i() {
            this.r = true;
            return this;
        }

        public Info j() {
            this.s = true;
            return this;
        }

        public Info k() {
            this.u = true;
            return this;
        }

        @Deprecated
        public Info l() {
            this.t = true;
            return this;
        }

        public Info a(EnumPistonReaction pushReaction) {
            this.v = pushReaction;
            return this;
        }

        public Info m() {
            this.q = true;
            return this;
        }

        public Info a(e<EntityTypes<?>> isValidSpawn) {
            this.z = isValidSpawn;
            return this;
        }

        public Info a(f isRedstoneConductor) {
            this.A = isRedstoneConductor;
            return this;
        }

        public Info b(f isSuffocating) {
            this.B = isSuffocating;
            return this;
        }

        public Info c(f isViewBlocking) {
            this.C = isViewBlocking;
            return this;
        }

        public Info d(f hasPostProcess) {
            this.D = hasPostProcess;
            return this;
        }

        public Info e(f emissiveRendering) {
            this.E = emissiveRendering;
            return this;
        }

        public Info n() {
            this.h = true;
            return this;
        }

        public Info e(float destroyTime) {
            this.g = destroyTime;
            return this;
        }

        public Info f(float explosionResistance) {
            this.f = Math.max(0.0f, explosionResistance);
            return this;
        }

        public Info a(EnumRandomOffset offsetType) {
            this.H = switch (offsetType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> null;
                case 1 -> (state, pos) -> {
                    Block block = state.b();
                    long seed = MathHelper.b(pos.u(), 0, pos.w());
                    float maxHorizontalOffset = block.at_();
                    double d2 = MathHelper.a(((double)((float)(seed & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-maxHorizontalOffset), (double)maxHorizontalOffset);
                    double d1 = MathHelper.a(((double)((float)(seed >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-maxHorizontalOffset), (double)maxHorizontalOffset);
                    return new Vec3D(d2, 0.0, d1);
                };
                case 2 -> (state, pos) -> {
                    Block block = state.b();
                    long seed = MathHelper.b(pos.u(), 0, pos.w());
                    double d2 = ((double)((float)(seed >> 4 & 0xFL) / 15.0f) - 1.0) * (double)block.av_();
                    float maxHorizontalOffset = block.at_();
                    double d1 = MathHelper.a(((double)((float)(seed & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-maxHorizontalOffset), (double)maxHorizontalOffset);
                    double d22 = MathHelper.a(((double)((float)(seed >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-maxHorizontalOffset), (double)maxHorizontalOffset);
                    return new Vec3D(d1, d2, d22);
                };
            };
            return this;
        }

        public Info o() {
            this.w = false;
            return this;
        }

        public Info a(FeatureFlag ... requiredFeatures) {
            this.G = FeatureFlags.e.a(requiredFeatures);
            return this;
        }

        public Info a(BlockPropertyInstrument instrument) {
            this.x = instrument;
            return this;
        }

        public Info p() {
            this.y = true;
            return this;
        }

        public Info a(ResourceKey<Block> id) {
            this.m = id;
            return this;
        }

        public Info a(String description) {
            this.o = DependantName.fixed(description);
            return this;
        }

        protected String q() {
            return this.o.get(Objects.requireNonNull(this.m, "Block id not set"));
        }
    }

    @FunctionalInterface
    public static interface f {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3);
    }

    @FunctionalInterface
    public static interface e<A> {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3, A var4);
    }

    public static final class EnumRandomOffset
    extends Enum<EnumRandomOffset> {
        public static final /* enum */ EnumRandomOffset a = new EnumRandomOffset();
        public static final /* enum */ EnumRandomOffset b = new EnumRandomOffset();
        public static final /* enum */ EnumRandomOffset c = new EnumRandomOffset();
        private static final /* synthetic */ EnumRandomOffset[] d;

        public static EnumRandomOffset[] values() {
            return (EnumRandomOffset[])d.clone();
        }

        public static EnumRandomOffset valueOf(String name) {
            return Enum.valueOf(EnumRandomOffset.class, name);
        }

        private static /* synthetic */ EnumRandomOffset[] a() {
            return new EnumRandomOffset[]{a, b, c};
        }

        static {
            d = EnumRandomOffset.a();
        }
    }

    @FunctionalInterface
    public static interface b {
        public Vec3D evaluate(IBlockData var1, BlockPosition var2);
    }

    public static abstract class BlockData
    extends IBlockDataHolder<Block, IBlockData>
    implements StarlightAbstractBlockState,
    CollisionBlockState {
        private static final EnumDirection[] a = EnumDirection.values();
        private static final VoxelShape[] f = SystemUtils.a(new VoxelShape[a.length], (? super T shape) -> Arrays.fill(shape, VoxelShapes.a()));
        private static final VoxelShape[] g = SystemUtils.a(new VoxelShape[a.length], (? super T shape) -> Arrays.fill(shape, VoxelShapes.b()));
        private final int h;
        private final boolean i;
        private final boolean j;
        private final boolean k;
        @Deprecated
        private final boolean l;
        @Deprecated
        private boolean m;
        private final EnumPistonReaction n;
        private final MaterialMapColor o;
        public final float p;
        private final boolean q;
        private final boolean r;
        private final f s;
        private final f t;
        private final f u;
        private final f v;
        private final f w;
        @Nullable
        private final b x;
        private final boolean y;
        private final BlockPropertyInstrument z;
        private final boolean A;
        @Nullable
        private Cache B;
        private Fluid C = FluidTypes.a.g();
        private boolean D;
        private boolean E;
        private VoxelShape F;
        private VoxelShape[] G;
        private boolean H;
        private int I;
        private boolean isConditionallyFullOpaque;
        private static final int RANDOM_OFFSET = 704237939;
        private static final EnumDirection[] DIRECTIONS_CACHED = EnumDirection.values();
        private static final AtomicInteger ID_GENERATOR = new AtomicInteger();
        private final int id1 = HashCommon.murmurHash3((int)(HashCommon.murmurHash3((int)(ID_GENERATOR.getAndIncrement() + 704237939)) + 704237939));
        private final int id2 = HashCommon.murmurHash3((int)(HashCommon.murmurHash3((int)(ID_GENERATOR.getAndIncrement() + 704237939)) + 704237939));
        private boolean occludesFullBlock;
        private boolean emptyCollisionShape;
        private boolean emptyConstantCollisionShape;
        private VoxelShape constantCollisionShape;
        @Nullable
        private CraftBlockData cachedCraftBlockData;
        protected boolean shapeExceedsCube = true;

        @Override
        public final boolean starlight$isConditionallyFullOpaque() {
            return this.isConditionallyFullOpaque;
        }

        private static void initCaches(VoxelShape shape, boolean neighbours) {
            shape.moonrise$isFullBlock();
            shape.moonrise$occludesFullBlock();
            shape.e();
            if (!shape.c()) {
                shape.a();
            }
            if (neighbours) {
                for (EnumDirection direction : DIRECTIONS_CACHED) {
                    BlockData.initCaches(shape.moonrise$getFaceShapeClamped(direction), false);
                    BlockData.initCaches(shape.a(direction), false);
                }
            }
        }

        @Override
        public final boolean moonrise$hasCache() {
            return this.B != null;
        }

        @Override
        public final boolean moonrise$occludesFullBlock() {
            return this.occludesFullBlock;
        }

        @Override
        public final boolean moonrise$emptyCollisionShape() {
            return this.emptyCollisionShape;
        }

        @Override
        public final boolean moonrise$emptyContextCollisionShape() {
            return this.emptyConstantCollisionShape;
        }

        @Override
        public final int moonrise$uniqueId1() {
            return this.id1;
        }

        @Override
        public final int moonrise$uniqueId2() {
            return this.id2;
        }

        @Override
        public final VoxelShape moonrise$getConstantContextCollisionShape() {
            return this.constantCollisionShape;
        }

        protected BlockData(Block owner, Reference2ObjectArrayMap<IBlockState<?>, Comparable<?>> values, MapCodec<IBlockData> propertiesCodec) {
            super(owner, values, propertiesCodec);
            Info properties = owner.O;
            this.h = properties.e.applyAsInt(this.B());
            this.i = owner.g_(this.B());
            this.j = properties.q;
            this.k = properties.r;
            this.l = properties.s;
            this.n = properties.v;
            this.o = properties.b.apply(this.B());
            this.p = properties.g;
            this.q = properties.h;
            this.r = properties.p;
            this.s = properties.A;
            this.t = properties.B;
            this.u = properties.C;
            this.v = properties.D;
            this.w = properties.E;
            this.x = properties.H;
            this.y = properties.w;
            this.z = properties.x;
            this.A = properties.y;
        }

        public CraftBlockData createCraftBlockData() {
            if (this.cachedCraftBlockData == null) {
                this.cachedCraftBlockData = CraftBlockData.createData(this.B());
            }
            return (CraftBlockData)this.cachedCraftBlockData.clone();
        }

        private boolean H() {
            if (((Block)this.d).O.u) {
                return true;
            }
            if (((Block)this.d).O.t) {
                return false;
            }
            if (this.B == null) {
                return false;
            }
            VoxelShape voxelShape = this.B.a;
            if (voxelShape.c()) {
                return false;
            }
            AxisAlignedBB aabb = voxelShape.a();
            return aabb.a() >= 0.7291666666666666 || aabb.c() >= 1.0;
        }

        public void a() {
            this.C = ((Block)this.d).b_(this.B());
            this.D = ((Block)this.d).f(this.B());
            if (!this.b().n()) {
                this.B = new Cache(this.B());
            }
            this.shapeExceedsCube = this.B == null || this.B.b;
            this.m = this.H();
            this.F = this.r ? ((Block)this.d).f_(this.B()) : VoxelShapes.a();
            this.E = Block.a(this.F);
            if (this.F.c()) {
                this.G = f;
            } else if (this.E) {
                this.G = g;
            } else {
                this.G = new VoxelShape[a.length];
                for (EnumDirection direction : a) {
                    this.G[direction.ordinal()] = this.F.a(direction);
                }
            }
            this.H = ((Block)this.d).d_(this.B());
            this.I = ((Block)this.d).i_(this.B());
            this.isConditionallyFullOpaque = this.r & this.i;
            if (this.B != null) {
                VoxelShape collisionShape = this.B.a;
                this.constantCollisionShape = this.l() ? VoxelShapes.a() : null;
                this.occludesFullBlock = collisionShape.moonrise$occludesFullBlock();
                this.emptyCollisionShape = collisionShape.c();
                this.emptyConstantCollisionShape = this.constantCollisionShape != null && this.constantCollisionShape.c();
                BlockData.initCaches(collisionShape, true);
                if (this.constantCollisionShape != null) {
                    BlockData.initCaches(this.constantCollisionShape, true);
                }
            } else {
                this.occludesFullBlock = false;
                this.emptyCollisionShape = false;
                this.emptyConstantCollisionShape = false;
                this.constantCollisionShape = null;
            }
            if (this.F != null) {
                BlockData.initCaches(this.F, true);
            }
            if (this.G != null) {
                for (VoxelShape shape : this.G) {
                    BlockData.initCaches(shape, true);
                }
            }
        }

        public Block b() {
            return (Block)this.d;
        }

        public Holder<Block> c() {
            return ((Block)this.d).p();
        }

        @Deprecated
        public boolean d() {
            Block block = this.b();
            return block != Blocks.bz && block != Blocks.nV && this.e();
        }

        @Deprecated
        public boolean e() {
            return this.m;
        }

        public final boolean isDestroyable() {
            return this.b().isDestroyable();
        }

        public boolean a(IBlockAccess level, BlockPosition pos, EntityTypes<?> entityType) {
            return this.b().O.z.test(this.B(), level, pos, entityType);
        }

        public boolean f() {
            return this.H;
        }

        public int g() {
            return this.I;
        }

        public VoxelShape a(EnumDirection face) {
            return this.G[face.ordinal()];
        }

        public VoxelShape h() {
            return this.F;
        }

        public final boolean i() {
            return this.shapeExceedsCube;
        }

        public final boolean j() {
            return this.i;
        }

        public final int k() {
            return this.h;
        }

        public final boolean l() {
            return this.j;
        }

        public boolean m() {
            return this.k;
        }

        @Deprecated
        public boolean n() {
            return this.l;
        }

        public MaterialMapColor a(IBlockAccess level, BlockPosition pos) {
            return this.o;
        }

        public IBlockData a(EnumBlockRotation rotation) {
            return this.b().a(this.B(), rotation);
        }

        public IBlockData a(EnumBlockMirror mirror) {
            return this.b().a(this.B(), mirror);
        }

        public EnumRenderType o() {
            return this.b().a_(this.B());
        }

        public boolean b(IBlockAccess level, BlockPosition pos) {
            return this.w.test(this.B(), level, pos);
        }

        public float c(IBlockAccess level, BlockPosition pos) {
            return this.b().c(this.B(), level, pos);
        }

        public boolean d(IBlockAccess level, BlockPosition pos) {
            return this.s.test(this.B(), level, pos);
        }

        public boolean p() {
            return this.b().e_(this.B());
        }

        public int a(IBlockAccess level, BlockPosition pos, EnumDirection direction) {
            return this.b().a(this.B(), level, pos, direction);
        }

        public boolean q() {
            return this.b().c_(this.B());
        }

        public int a(World level, BlockPosition pos, EnumDirection direction) {
            return this.b().a(this.B(), level, pos, direction);
        }

        public float e(IBlockAccess level, BlockPosition pos) {
            return this.p;
        }

        public float a(EntityHuman player, IBlockAccess level, BlockPosition pos) {
            return this.b().a(this.B(), player, level, pos);
        }

        public int b(IBlockAccess level, BlockPosition pos, EnumDirection direction) {
            return this.b().b(this.B(), level, pos, direction);
        }

        public EnumPistonReaction r() {
            return !this.isDestroyable() ? EnumPistonReaction.c : this.n;
        }

        public boolean s() {
            return this.E;
        }

        public final boolean t() {
            return this.r;
        }

        public boolean a(IBlockData state, EnumDirection face) {
            return this.b().b(this.B(), state, face);
        }

        public VoxelShape f(IBlockAccess level, BlockPosition pos) {
            return this.a(level, pos, VoxelShapeCollision.a());
        }

        public VoxelShape a(IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
            return this.b().a(this.B(), level, pos, context);
        }

        public VoxelShape g(IBlockAccess level, BlockPosition pos) {
            return this.B != null ? this.B.a : this.b(level, pos, VoxelShapeCollision.a());
        }

        public VoxelShape b(IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
            return this.b().b(this.B(), level, pos, context);
        }

        public VoxelShape a(IBlockAccess level, BlockPosition pos, Entity entity) {
            return this.b().a(this.B(), level, pos, entity);
        }

        public VoxelShape h(IBlockAccess level, BlockPosition pos) {
            return this.b().b_(this.B(), level, pos);
        }

        public VoxelShape c(IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
            return this.b().c(this.B(), level, pos, context);
        }

        public VoxelShape i(IBlockAccess level, BlockPosition pos) {
            return this.b().a(this.B(), level, pos);
        }

        public final boolean b(IBlockAccess level, BlockPosition pos, Entity entity) {
            return this.a(level, pos, entity, EnumDirection.b);
        }

        public final boolean a(IBlockAccess level, BlockPosition pos, Entity entity, EnumDirection face) {
            return Block.a(this.b(level, pos, VoxelShapeCollision.a(entity)), face);
        }

        public Vec3D a(BlockPosition pos) {
            b offsetFunction = this.x;
            return offsetFunction != null ? offsetFunction.evaluate(this.B(), pos) : Vec3D.c;
        }

        public boolean u() {
            return this.x != null;
        }

        public boolean a(World level, BlockPosition pos, int id, int param) {
            return this.b().a(this.B(), level, pos, id, param);
        }

        public void a(World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
            this.b().a(this.B(), level, pos, neighborBlock, orientation, movedByPiston);
        }

        public final void a(GeneratorAccess level, BlockPosition pos, int flags) {
            this.a(level, pos, flags, 512);
        }

        public final void a(GeneratorAccess level, BlockPosition pos, int flags, int recursionLeft) {
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (EnumDirection direction : E) {
                mutableBlockPos.a((BaseBlockPosition)pos, direction);
                level.a(direction.g(), (BlockPosition)mutableBlockPos, pos, this.B(), flags, recursionLeft);
            }
        }

        public final void b(GeneratorAccess level, BlockPosition pos, int flags) {
            this.b(level, pos, flags, 512);
        }

        public void b(GeneratorAccess level, BlockPosition pos, int flags, int recursionLeft) {
            this.b().a(this.B(), level, pos, flags, recursionLeft);
        }

        public void a(World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston) {
            this.onPlace(level, pos, oldState, movedByPiston, null);
        }

        public void onPlace(World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston, @Nullable ItemActionContext context) {
            this.b().onPlace(this.B(), level, pos, oldState, movedByPiston, context);
        }

        public void a(WorldServer level, BlockPosition pos, boolean movedByPiston) {
            this.b().a(this.B(), level, pos, movedByPiston);
        }

        public void a(WorldServer level, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> dropConsumer) {
            this.b().a(this.B(), level, pos, explosion, dropConsumer);
        }

        public void a(WorldServer level, BlockPosition pos, RandomSource random) {
            this.b().a(this.B(), level, pos, random);
        }

        public void b(WorldServer level, BlockPosition pos, RandomSource random) {
            this.b().b(this.B(), level, pos, random);
        }

        public void a(World level, BlockPosition pos, Entity entity, InsideBlockEffectApplier effectApplier, boolean pastEdges) {
            this.b().a(this.B(), level, pos, entity, effectApplier, pastEdges);
        }

        public void a(WorldServer level, BlockPosition pos, ItemStack stack, boolean dropExperience) {
            this.b().a(this.B(), level, pos, stack, dropExperience);
            if (dropExperience) {
                this.b().a(level, pos, this.b().getExpDrop(this.B(), level, pos, stack, true));
            }
        }

        public List<ItemStack> a(LootParams.a lootParams) {
            return this.b().a(this.B(), lootParams);
        }

        public EnumInteractionResult a(ItemStack stack, World level, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
            return this.b().a(stack, this.B(), level, hitResult.b(), player, hand, hitResult);
        }

        public EnumInteractionResult a(World level, EntityHuman player, MovingObjectPositionBlock hitResult) {
            return this.b().a(this.B(), level, hitResult.b(), player, hitResult);
        }

        public void a(World level, BlockPosition pos, EntityHuman player) {
            this.b().a_(this.B(), level, pos, player);
        }

        public boolean j(IBlockAccess level, BlockPosition pos) {
            return this.t.test(this.B(), level, pos);
        }

        public boolean k(IBlockAccess level, BlockPosition pos) {
            return this.u.test(this.B(), level, pos);
        }

        public IBlockData a(IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
            return this.b().a(this.B(), level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
        }

        public boolean a(PathMode type) {
            return this.b().a(this.B(), type);
        }

        public boolean a(BlockActionContext useContext) {
            return this.b().a(this.B(), useContext);
        }

        public boolean a(FluidType fluid) {
            return this.b().a(this.B(), fluid);
        }

        public boolean v() {
            return this.A;
        }

        public boolean a(IWorldReader level, BlockPosition pos) {
            return this.b().a(this.B(), level, pos);
        }

        public boolean l(IBlockAccess level, BlockPosition pos) {
            return this.v.test(this.B(), level, pos);
        }

        @Nullable
        public ITileInventory a(World level, BlockPosition pos) {
            return this.b().a(this.B(), level, pos);
        }

        @Override
        public boolean a(TagKey<Block> tag) {
            return this.b().p().a(tag);
        }

        @Override
        public boolean a(TagKey<Block> tag, Predicate<BlockData> predicate) {
            return this.a(tag) && predicate.test(this);
        }

        @Override
        public boolean a(HolderSet<Block> holder) {
            return holder.a(this.b().p());
        }

        @Override
        public boolean a(Holder<Block> block) {
            return this.a(block.a());
        }

        public Stream<TagKey<Block>> w() {
            return this.b().p().c();
        }

        public boolean x() {
            return this.b() instanceof ITileEntity;
        }

        public boolean a(IBlockData state) {
            return this.b().o(state);
        }

        @Nullable
        public <T extends TileEntity> BlockEntityTicker<T> a(World level, TileEntityTypes<T> blockEntityType) {
            return this.b() instanceof ITileEntity ? ((ITileEntity)((Object)this.b())).a(level, this.B(), blockEntityType) : null;
        }

        public boolean a(Block block) {
            return this.b() == block;
        }

        @Override
        public boolean a(ResourceKey<Block> block) {
            return this.b().p().a(block);
        }

        public final Fluid y() {
            return this.C;
        }

        public final boolean z() {
            return this.D;
        }

        public long b(BlockPosition pos) {
            return this.b().a(this.B(), pos);
        }

        public SoundEffectType A() {
            return this.b().h_(this.B());
        }

        public void a(World level, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
            this.b().a(level, state, hit, projectile);
        }

        public boolean c(IBlockAccess level, BlockPosition pos, EnumDirection direction) {
            return this.a(level, pos, direction, EnumBlockSupport.a);
        }

        public boolean a(IBlockAccess level, BlockPosition pos, EnumDirection face, EnumBlockSupport supportType) {
            return this.B != null ? this.B.a(face, supportType) : supportType.a(this.B(), level, pos, face);
        }

        public boolean m(IBlockAccess level, BlockPosition pos) {
            return this.B != null ? this.B.c : this.b().a_(this.B(), level, pos);
        }

        public ItemStack a(IWorldReader level, BlockPosition pos, boolean includeData) {
            return this.b().a(level, pos, this.B(), includeData);
        }

        protected abstract IBlockData B();

        public boolean C() {
            return this.q;
        }

        public boolean D() {
            return this.y;
        }

        public BlockPropertyInstrument E() {
            return this.z;
        }

        static final class Cache {
            private static final EnumDirection[] d = EnumDirection.values();
            private static final int e = EnumBlockSupport.values().length;
            protected final VoxelShape a;
            protected final boolean b;
            private final boolean[] f;
            protected final boolean c;

            Cache(IBlockData state) {
                Block block = state.b();
                this.a = block.b(state, (IBlockAccess)BlockAccessAir.a, BlockPosition.c, VoxelShapeCollision.a());
                if (!this.a.c() && state.u()) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "%s has a collision shape and an offset type, but is not marked as dynamicShape in its properties.", BuiltInRegistries.e.b(block)));
                }
                this.b = Arrays.stream(EnumDirection.EnumAxis.values()).anyMatch(dir -> this.a.b((EnumDirection.EnumAxis)dir) < 0.0 || this.a.c((EnumDirection.EnumAxis)dir) > 1.0);
                this.f = new boolean[d.length * e];
                for (EnumDirection direction : d) {
                    for (EnumBlockSupport supportType : EnumBlockSupport.values()) {
                        this.f[Cache.b((EnumDirection)direction, (EnumBlockSupport)supportType)] = supportType.a(state, BlockAccessAir.a, BlockPosition.c, direction);
                    }
                }
                this.c = Block.a(state.g(BlockAccessAir.a, BlockPosition.c));
            }

            public boolean a(EnumDirection direction, EnumBlockSupport supportType) {
                return this.f[Cache.b(direction, supportType)];
            }

            private static int b(EnumDirection direction, EnumBlockSupport supportType) {
                return direction.ordinal() * e + supportType.ordinal();
            }
        }
    }
}

