/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.border;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeEvent;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeFinishEvent;
import io.papermc.paper.event.world.border.WorldBorderCenterChangeEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Objects;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.border.BorderStatus;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Location;
import org.bukkit.World;

public class WorldBorder
extends PersistentBase {
    public static final double a = 5.9999968E7;
    public static final double b = 2.9999984E7;
    public static final Codec<WorldBorder> c = net.minecraft.world.level.border.WorldBorder$c.b.xmap(c::a, c::new);
    public static final SavedDataType<WorldBorder> d = new SavedDataType<WorldBorder>("world_border", context -> net.minecraft.world.level.border.WorldBorder$c.a.a(), context -> c, DataFixTypes.q);
    private final List<IWorldBorderListener> e = Lists.newArrayList();
    double f = 0.2;
    double g = 5.0;
    int h = 15;
    int i = 5;
    double j;
    double k;
    int l = 29999984;
    a m = new d(5.9999968E7);
    public WorldServer world;
    private final BlockPosition.MutableBlockPosition mutPos = new BlockPosition.MutableBlockPosition();

    public boolean a(BlockPosition pos) {
        return this.a(pos.u(), pos.w());
    }

    public boolean a(Vec3D pos) {
        return this.a(pos.g, pos.i);
    }

    public boolean a(ChunkCoordIntPair chunkPos) {
        return this.a(chunkPos.d(), chunkPos.e()) && this.a(chunkPos.f(), chunkPos.g());
    }

    public boolean isBlockInBounds(int x2, int z2) {
        this.mutPos.d(x2, 64, z2);
        return this.a(this.mutPos);
    }

    public boolean isChunkInBounds(int chunkX, int chunkZ) {
        this.mutPos.d((chunkX << 4) + 15, 64, (chunkZ << 4) + 15);
        return this.a(this.mutPos);
    }

    public boolean a(AxisAlignedBB box) {
        return this.a(box.a, box.c, box.d - (double)1.0E-5f, box.f - (double)1.0E-5f);
    }

    private boolean a(double x1, double z1, double x2, double z2) {
        return this.a(x1, z1) && this.a(x2, z2);
    }

    public boolean a(double x2, double z2) {
        return this.a(x2, z2, 0.0);
    }

    public boolean a(double x2, double z2, double offset) {
        return x2 >= this.c() - offset && x2 < this.e() + offset && z2 >= this.d() - offset && z2 < this.f() + offset;
    }

    public BlockPosition b(BlockPosition pos) {
        return this.b(pos.u(), pos.v(), pos.w());
    }

    public BlockPosition b(Vec3D pos) {
        return this.b(pos.a(), pos.b(), pos.c());
    }

    public BlockPosition b(double x2, double y2, double z2) {
        return BlockPosition.a(this.c(x2, y2, z2));
    }

    public Vec3D c(Vec3D vec3) {
        return this.c(vec3.g, vec3.h, vec3.i);
    }

    public Vec3D c(double x2, double y2, double z2) {
        return new Vec3D(MathHelper.a(x2, this.c(), this.e() - (double)1.0E-5f), y2, MathHelper.a(z2, this.d(), this.f() - (double)1.0E-5f));
    }

    public double a(Entity entity) {
        return this.b(entity.dK(), entity.dQ());
    }

    public VoxelShape a() {
        return this.m.m();
    }

    public double b(double x2, double z2) {
        double d2 = z2 - this.d();
        double d1 = this.f() - z2;
        double d22 = x2 - this.c();
        double d3 = this.e() - x2;
        double min = Math.min(d22, d3);
        min = Math.min(min, d2);
        return Math.min(min, d1);
    }

    public boolean a(Entity entity, AxisAlignedBB bounds) {
        double max = Math.max(MathHelper.a(bounds.b(), bounds.d()), 1.0);
        return this.a(entity) < max * 2.0 && this.a(entity.dK(), entity.dQ(), max);
    }

    public BorderStatus b() {
        return this.m.i();
    }

    public double c() {
        return this.m.a();
    }

    public double d() {
        return this.m.c();
    }

    public double e() {
        return this.m.b();
    }

    public double f() {
        return this.m.d();
    }

    public double g() {
        return this.j;
    }

    public double h() {
        return this.k;
    }

    public void c(double x2, double z2) {
        if (this.world != null) {
            WorldBorderCenterChangeEvent event = new WorldBorderCenterChangeEvent((World)this.world.getWorld(), this.world.getWorld().getWorldBorder(), new Location((World)this.world.getWorld(), this.g(), 0.0, this.h()), new Location((World)this.world.getWorld(), x2, 0.0, z2));
            if (!event.callEvent()) {
                return;
            }
            x2 = event.getNewCenter().getX();
            z2 = event.getNewCenter().getZ();
        }
        this.j = x2;
        this.k = z2;
        this.m.k();
        this.t();
        for (IWorldBorderListener borderChangeListener : this.l()) {
            borderChangeListener.a(this, x2, z2);
        }
    }

    public double i() {
        return this.m.e();
    }

    public long j() {
        return this.m.g();
    }

    public double k() {
        return this.m.h();
    }

    public void a(double size) {
        if (this.world != null) {
            WorldBorderBoundsChangeEvent event = new WorldBorderBoundsChangeEvent((World)this.world.getWorld(), this.world.getWorld().getWorldBorder(), WorldBorderBoundsChangeEvent.Type.INSTANT_MOVE, this.i(), size, 0L);
            if (!event.callEvent()) {
                return;
            }
            if (event.getType() == WorldBorderBoundsChangeEvent.Type.STARTED_MOVE && event.getDuration() > 0L) {
                this.a(event.getOldSize(), event.getNewSize(), event.getDuration());
                return;
            }
            size = event.getNewSize();
        }
        this.m = new d(size);
        this.t();
        for (IWorldBorderListener borderChangeListener : this.l()) {
            borderChangeListener.a(this, size);
        }
    }

    public void a(double oldSize, double newSize, long time) {
        if (this.world != null) {
            WorldBorderBoundsChangeEvent.Type type = oldSize == newSize ? WorldBorderBoundsChangeEvent.Type.INSTANT_MOVE : WorldBorderBoundsChangeEvent.Type.STARTED_MOVE;
            WorldBorderBoundsChangeEvent event = new WorldBorderBoundsChangeEvent((World)this.world.getWorld(), this.world.getWorld().getWorldBorder(), type, oldSize, newSize, time);
            if (!event.callEvent()) {
                return;
            }
            newSize = event.getNewSize();
            time = event.getDuration();
        }
        this.m = oldSize == newSize ? new d(newSize) : new b(oldSize, newSize, time);
        this.t();
        for (IWorldBorderListener borderChangeListener : this.l()) {
            borderChangeListener.a(this, oldSize, newSize, time);
        }
    }

    protected List<IWorldBorderListener> l() {
        return Lists.newArrayList(this.e);
    }

    public void a(IWorldBorderListener listener) {
        if (this.e.contains(listener)) {
            return;
        }
        this.e.add(listener);
    }

    public void b(IWorldBorderListener listener) {
        this.e.remove(listener);
    }

    public void a(int size) {
        this.l = size;
        this.m.j();
    }

    public int m() {
        return this.l;
    }

    public double n() {
        return this.g;
    }

    public void b(double safeZone) {
        this.g = safeZone;
        this.t();
        for (IWorldBorderListener borderChangeListener : this.l()) {
            borderChangeListener.c(this, safeZone);
        }
    }

    public double o() {
        return this.f;
    }

    public void c(double damagePerBlock) {
        this.f = damagePerBlock;
        this.t();
        for (IWorldBorderListener borderChangeListener : this.l()) {
            borderChangeListener.b(this, damagePerBlock);
        }
    }

    public double p() {
        return this.m.f();
    }

    public int q() {
        return this.h;
    }

    public void b(int warningTime) {
        this.h = warningTime;
        this.t();
        for (IWorldBorderListener borderChangeListener : this.l()) {
            borderChangeListener.a(this, warningTime);
        }
    }

    public int r() {
        return this.i;
    }

    public void c(int warningBlocks) {
        this.i = warningBlocks;
        this.t();
        for (IWorldBorderListener borderChangeListener : this.l()) {
            borderChangeListener.b(this, warningBlocks);
        }
    }

    public void s() {
        this.m = this.m.l();
    }

    public void a(c settings) {
        this.c(settings.b(), settings.c());
        this.c(settings.d());
        this.b(settings.e());
        this.c(settings.f());
        this.b(settings.g());
        if (settings.i() > 0L) {
            this.a(settings.h(), settings.j(), settings.i());
        } else {
            this.a(settings.h());
        }
    }

    class d
    implements a {
        private final double b;
        private double c;
        private double d;
        private double e;
        private double f;
        private VoxelShape g;

        public d(double size) {
            this.b = size;
            this.n();
        }

        @Override
        public double a() {
            return this.c;
        }

        @Override
        public double b() {
            return this.e;
        }

        @Override
        public double c() {
            return this.d;
        }

        @Override
        public double d() {
            return this.f;
        }

        @Override
        public double e() {
            return this.b;
        }

        @Override
        public BorderStatus i() {
            return BorderStatus.c;
        }

        @Override
        public double f() {
            return 0.0;
        }

        @Override
        public long g() {
            return 0L;
        }

        @Override
        public double h() {
            return this.b;
        }

        private void n() {
            this.c = MathHelper.a(WorldBorder.this.g() - this.b / 2.0, (double)(-WorldBorder.this.l), (double)WorldBorder.this.l);
            this.d = MathHelper.a(WorldBorder.this.h() - this.b / 2.0, (double)(-WorldBorder.this.l), (double)WorldBorder.this.l);
            this.e = MathHelper.a(WorldBorder.this.g() + this.b / 2.0, (double)(-WorldBorder.this.l), (double)WorldBorder.this.l);
            this.f = MathHelper.a(WorldBorder.this.h() + this.b / 2.0, (double)(-WorldBorder.this.l), (double)WorldBorder.this.l);
            this.g = VoxelShapes.a(VoxelShapes.c, VoxelShapes.a(Math.floor(this.a()), Double.NEGATIVE_INFINITY, Math.floor(this.c()), Math.ceil(this.b()), Double.POSITIVE_INFINITY, Math.ceil(this.d())), OperatorBoolean.e);
        }

        @Override
        public void j() {
            this.n();
        }

        @Override
        public void k() {
            this.n();
        }

        @Override
        public a l() {
            return this;
        }

        @Override
        public VoxelShape m() {
            return this.g;
        }
    }

    static interface a {
        public double a();

        public double b();

        public double c();

        public double d();

        public double e();

        public double f();

        public long g();

        public double h();

        public BorderStatus i();

        public void j();

        public void k();

        public a l();

        public VoxelShape m();
    }

    class b
    implements a {
        private final double b;
        private final double c;
        private final long d;
        private final long e;
        private final double f;

        b(double from, double to, long lerpDuration) {
            this.b = from;
            this.c = to;
            this.f = lerpDuration;
            this.e = SystemUtils.c();
            this.d = this.e + lerpDuration;
        }

        @Override
        public double a() {
            return MathHelper.a(WorldBorder.this.g() - this.e() / 2.0, (double)(-WorldBorder.this.l), (double)WorldBorder.this.l);
        }

        @Override
        public double c() {
            return MathHelper.a(WorldBorder.this.h() - this.e() / 2.0, (double)(-WorldBorder.this.l), (double)WorldBorder.this.l);
        }

        @Override
        public double b() {
            return MathHelper.a(WorldBorder.this.g() + this.e() / 2.0, (double)(-WorldBorder.this.l), (double)WorldBorder.this.l);
        }

        @Override
        public double d() {
            return MathHelper.a(WorldBorder.this.h() + this.e() / 2.0, (double)(-WorldBorder.this.l), (double)WorldBorder.this.l);
        }

        @Override
        public double e() {
            double d2 = (double)(SystemUtils.c() - this.e) / this.f;
            return d2 < 1.0 ? MathHelper.d(d2, this.b, this.c) : this.c;
        }

        @Override
        public double f() {
            return Math.abs(this.b - this.c) / (double)(this.d - this.e);
        }

        @Override
        public long g() {
            return this.d - SystemUtils.c();
        }

        @Override
        public double h() {
            return this.c;
        }

        @Override
        public BorderStatus i() {
            return this.c < this.b ? BorderStatus.b : BorderStatus.a;
        }

        @Override
        public void k() {
        }

        @Override
        public void j() {
        }

        @Override
        public a l() {
            if (this.g() <= 0L) {
                if (WorldBorder.this.world != null) {
                    new WorldBorderBoundsChangeFinishEvent((World)WorldBorder.this.world.getWorld(), WorldBorder.this.world.getWorld().getWorldBorder(), this.b, this.c, this.f).callEvent();
                }
                WorldBorder.this.t();
                WorldBorder worldBorder = WorldBorder.this;
                Objects.requireNonNull(worldBorder);
                return worldBorder.new d(this.c);
            }
            return this;
        }

        @Override
        public VoxelShape m() {
            return VoxelShapes.a(VoxelShapes.c, VoxelShapes.a(Math.floor(this.a()), Double.NEGATIVE_INFINITY, Math.floor(this.c()), Math.ceil(this.b()), Double.POSITIVE_INFINITY, Math.ceil(this.d())), OperatorBoolean.e);
        }
    }

    public static final class c
    extends Record {
        private final double c;
        private final double d;
        private final double e;
        private final double f;
        private final int g;
        private final int h;
        private final double i;
        private final long j;
        private final double k;
        public static final c a = new c(0.0, 0.0, 0.2, 5.0, 5, 15, 5.9999968E7, 0L, 0.0);
        public static final Codec<c> b = RecordCodecBuilder.create(instance -> instance.group((App)Codec.doubleRange((double)-2.9999984E7, (double)2.9999984E7).fieldOf("center_x").forGetter(c::b), (App)Codec.doubleRange((double)-2.9999984E7, (double)2.9999984E7).fieldOf("center_z").forGetter(c::c), (App)Codec.DOUBLE.fieldOf("damage_per_block").forGetter(c::d), (App)Codec.DOUBLE.fieldOf("safe_zone").forGetter(c::e), (App)Codec.INT.fieldOf("warning_blocks").forGetter(c::f), (App)Codec.INT.fieldOf("warning_time").forGetter(c::g), (App)Codec.DOUBLE.fieldOf("size").forGetter(c::h), (App)Codec.LONG.fieldOf("lerp_time").forGetter(c::i), (App)Codec.DOUBLE.fieldOf("lerp_target").forGetter(c::j)).apply((Applicative)instance, c::new));

        public c(WorldBorder border) {
            this(border.j, border.k, border.f, border.g, border.i, border.h, border.m.e(), border.m.g(), border.m.h());
        }

        public c(double centerX, double centerZ, double damagePerBlock, double safeZone, int warningBlocks, int warningTime, double size, long lerpTime, double lerpTarget) {
            this.c = centerX;
            this.d = centerZ;
            this.e = damagePerBlock;
            this.f = safeZone;
            this.g = warningBlocks;
            this.h = warningTime;
            this.i = size;
            this.j = lerpTime;
            this.k = lerpTarget;
        }

        public WorldBorder a() {
            WorldBorder worldBorder = new WorldBorder();
            worldBorder.a(this);
            return worldBorder;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "centerX;centerZ;damagePerBlock;safeZone;warningBlocks;warningTime;size;lerpTime;lerpTarget", "c", "d", "e", "f", "g", "h", "i", "j", "k"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "centerX;centerZ;damagePerBlock;safeZone;warningBlocks;warningTime;size;lerpTime;lerpTarget", "c", "d", "e", "f", "g", "h", "i", "j", "k"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "centerX;centerZ;damagePerBlock;safeZone;warningBlocks;warningTime;size;lerpTime;lerpTarget", "c", "d", "e", "f", "g", "h", "i", "j", "k"}, this, o2);
        }

        public double b() {
            return this.c;
        }

        public double c() {
            return this.d;
        }

        public double d() {
            return this.e;
        }

        public double e() {
            return this.f;
        }

        public int f() {
            return this.g;
        }

        public int g() {
            return this.h;
        }

        public double h() {
            return this.i;
        }

        public long i() {
            return this.j;
        }

        public double j() {
            return this.k;
        }
    }
}

