/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemLevelChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.getblock.GetBlockChunk;
import ca.spottedleaf.moonrise.patches.starlight.chunk.StarlightChunk;
import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerException;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.debug.DebugStructureInfo;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkEmpty;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.EuclideanGameEventListenerRegistry;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.TickContainerAccess;
import org.bukkit.craftbukkit.v1_21_R6.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkPopulateEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.generator.BlockPopulator;
import org.slf4j.Logger;

public class Chunk
extends IChunkAccess
implements DebugValueSource,
ChunkSystemLevelChunk,
StarlightChunk,
GetBlockChunk {
    static final Logger m = LogUtils.getLogger();
    private static final TickingBlockEntity n = new TickingBlockEntity(){

        @Override
        public void a() {
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public BlockPosition c() {
            return BlockPosition.c;
        }

        @Override
        public String d() {
            return "<null>";
        }
    };
    private final Map<BlockPosition, d> o = Maps.newHashMap();
    public boolean p;
    public final WorldServer q;
    @Nullable
    private Supplier<FullChunkStatus> r;
    @Nullable
    private c s;
    private final Int2ObjectMap<GameEventListenerRegistry> t;
    private final LevelChunkTicks<Block> u;
    private final LevelChunkTicks<FluidType> v;
    private e w = chunkPos -> {};
    public boolean mustNotSave;
    public boolean needsDecoration;
    boolean loadedTicketLevel;
    private boolean postProcessingDone;
    private NewChunkHolder chunkAndHolder;
    private static final IBlockData AIR_BLOCKSTATE = Blocks.a.m();
    private static final Fluid AIR_FLUIDSTATE = FluidTypes.a.g();
    private static final IBlockData VOID_AIR_BLOCKSTATE = Blocks.nY.m();
    private final int minSection;
    private final int maxSection;
    private final boolean debug;
    private final IBlockData defaultBlockState;

    @Override
    public final boolean moonrise$isPostProcessingDone() {
        return this.postProcessingDone;
    }

    @Override
    public final NewChunkHolder moonrise$getChunkHolder() {
        return this.chunkAndHolder;
    }

    @Override
    public final void moonrise$setChunkHolder(NewChunkHolder holder) {
        this.chunkAndHolder = holder;
    }

    @Override
    public final IBlockData moonrise$getBlock(int x2, int y2, int z2) {
        return this.getBlockStateFinal(x2, y2, z2);
    }

    public Chunk(World level, ChunkCoordIntPair pos) {
        this(level, pos, ChunkConverter.a, new LevelChunkTicks<Block>(), new LevelChunkTicks<FluidType>(), 0L, null, null, null);
    }

    public Chunk(World level, ChunkCoordIntPair pos, ChunkConverter data, LevelChunkTicks<Block> blockTicks, LevelChunkTicks<FluidType> fluidTicks, long inhabitedTime, @Nullable ChunkSection[] sections, @Nullable c postLoad, @Nullable BlendingData blendingData) {
        super(pos, data, level, PalettedContainerFactory.a(MinecraftServer.getServer().bg()), inhabitedTime, sections, blendingData);
        this.q = (WorldServer)level;
        this.t = new Int2ObjectOpenHashMap();
        for (HeightMap.Type types : HeightMap.Type.values()) {
            if (!ChunkStatus.n.e().contains(types)) continue;
            this.g.put(types, new HeightMap(this, types));
        }
        this.s = postLoad;
        this.u = blockTicks;
        this.v = fluidTicks;
        this.minSection = WorldUtil.getMinSection(level);
        this.maxSection = WorldUtil.getMaxSection(level);
        boolean empty = this instanceof ChunkEmpty;
        this.debug = !empty && this.q.am();
        this.defaultBlockState = empty ? VOID_AIR_BLOCKSTATE : AIR_BLOCKSTATE;
    }

    public Chunk(WorldServer level, ProtoChunk chunk, @Nullable c postLoad) {
        this(level, chunk.f(), chunk.t(), chunk.L(), chunk.M(), chunk.w(), chunk.d(), postLoad, chunk.v());
        if (!Collections.disjoint(chunk.i.keySet(), chunk.j.keySet())) {
            m.error("Chunk at {} contains duplicated block entities", (Object)chunk.f());
        }
        for (TileEntity blockEntity : chunk.I().values()) {
            this.a(blockEntity);
        }
        this.i.putAll(chunk.K());
        for (int i2 = 0; i2 < chunk.p().length; ++i2) {
            this.b[i2] = chunk.p()[i2];
        }
        this.a(chunk.g());
        this.b(chunk.h());
        for (Map.Entry<HeightMap.Type, HeightMap> entry : chunk.e()) {
            if (!ChunkStatus.n.e().contains(entry.getKey())) continue;
            this.a(entry.getKey(), entry.getValue().a());
        }
        this.a(chunk.x());
        this.i();
        this.needsDecoration = true;
        this.persistentDataContainer = chunk.persistentDataContainer;
        this.starlight$setBlockNibbles(chunk.starlight$getBlockNibbles());
        this.starlight$setSkyNibbles(chunk.starlight$getSkyNibbles());
        this.starlight$setSkyEmptinessMap(chunk.starlight$getSkyEmptinessMap());
        this.starlight$setBlockEmptinessMap(chunk.starlight$getBlockEmptinessMap());
    }

    public void a(e unsavedListener) {
        this.w = unsavedListener;
        if (this.m()) {
            unsavedListener.setUnsaved(this.c);
        }
    }

    @Override
    public long w() {
        return this.q.paperConfig().chunks.fixedChunkInhabitedTime < 0 ? super.w() : (long)this.q.paperConfig().chunks.fixedChunkInhabitedTime;
    }

    @Override
    public void i() {
        boolean isUnsaved = this.m();
        super.i();
        if (!isUnsaved) {
            this.w.setUnsaved(this.c);
        }
    }

    @Override
    public TickContainerAccess<Block> q() {
        return this.u;
    }

    @Override
    public TickContainerAccess<FluidType> r() {
        return this.v;
    }

    @Override
    public IChunkAccess.b a(long gameTime) {
        return new IChunkAccess.b(this.u.a(gameTime), this.v.a(gameTime));
    }

    @Override
    public GameEventListenerRegistry a(int sectionY) {
        GameEventListenerRegistry gameEventListenerRegistry;
        WorldServer worldServer = this.q;
        if (worldServer instanceof WorldServer) {
            WorldServer serverLevel = worldServer;
            gameEventListenerRegistry = (GameEventListenerRegistry)this.t.computeIfAbsent(sectionY, i2 -> new EuclideanGameEventListenerRegistry(serverLevel, sectionY, this::c));
        } else {
            gameEventListenerRegistry = super.a(sectionY);
        }
        return gameEventListenerRegistry;
    }

    @Override
    public IBlockData getBlockState(int x2, int y2, int z2) {
        return this.getBlockStateFinal(x2, y2, z2);
    }

    public IBlockData getBlockStateFinal(int x2, int y2, int z2) {
        int sectionIndex = this.f(y2);
        if (sectionIndex < 0 || sectionIndex >= this.l.length || this.l[sectionIndex].e == 0) {
            return Blocks.a.m();
        }
        return this.l[sectionIndex].h.a((y2 & 0xF) << 8 | (z2 & 0xF) << 4 | x2 & 0xF);
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        return this.getBlockStateFinal(pos.u(), pos.v(), pos.w());
    }

    @Override
    public final Fluid getFluidIfLoaded(BlockPosition pos) {
        return this.b_(pos);
    }

    @Override
    public final IBlockData getBlockStateIfLoaded(BlockPosition pos) {
        return this.a_(pos);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        return this.a(pos.u(), pos.v(), pos.w());
    }

    public Fluid a(int x2, int y2, int z2) {
        ChunkSection levelChunkSection;
        int sectionIndex = this.f(y2);
        if (sectionIndex >= 0 && sectionIndex < this.l.length && !(levelChunkSection = this.l[sectionIndex]).c()) {
            return levelChunkSection.h.a((y2 & 0xF) << 8 | (z2 & 0xF) << 4 | x2 & 0xF).y();
        }
        return FluidTypes.a.g();
    }

    @Override
    @Nullable
    public IBlockData a(BlockPosition pos, IBlockData state, int flags) {
        WorldServer worldServer;
        TileEntity blockEntity;
        boolean flag2;
        int i2;
        int i1;
        int y2 = pos.v();
        ChunkSection section = this.b(this.f(y2));
        boolean hasOnlyAir = section.c();
        if (hasOnlyAir && state.l()) {
            return null;
        }
        int i3 = pos.u() & 0xF;
        IBlockData blockState = section.a(i3, i1 = y2 & 0xF, i2 = pos.w() & 0xF, state);
        if (blockState == state) {
            return null;
        }
        Block block = state.b();
        this.g.get(HeightMap.Type.e).a(i3, y2, i2, state);
        this.g.get(HeightMap.Type.f).a(i3, y2, i2, state);
        this.g.get(HeightMap.Type.d).a(i3, y2, i2, state);
        this.g.get(HeightMap.Type.b).a(i3, y2, i2, state);
        boolean hasOnlyAir1 = section.c();
        if (hasOnlyAir != hasOnlyAir1) {
            this.q.n().a().a(pos, hasOnlyAir1);
            this.q.n().a(this.c.h, SectionPosition.a(y2), this.c.i, hasOnlyAir1);
        }
        if (LightEngine.a(blockState, state)) {
            GameProfilerFiller profilerFiller = Profiler.a();
            profilerFiller.a("updateSkyLightSources");
            profilerFiller.b("queueCheckLight");
            this.q.n().a().a(pos);
            profilerFiller.c();
        }
        boolean flag = !blockState.a(block);
        boolean flag1 = (flags & 0x40) != 0;
        boolean bl = flag2 = (flags & 0x100) == 0;
        if (flag && blockState.x() && !state.a(blockState)) {
            if (!this.q.D_() && flag2 && (blockEntity = this.q.c_(pos)) != null) {
                blockEntity.a(pos, blockState);
            }
            this.d(pos);
        }
        if ((flag || block instanceof BlockMinecartTrackAbstract) && (worldServer = this.q) instanceof WorldServer) {
            WorldServer serverLevel = worldServer;
            if ((flags & 1) != 0 || flag1) {
                blockState.a(serverLevel, pos, flag1);
            }
        }
        if (!section.a(i3, i1, i2).a(block)) {
            return null;
        }
        if (!(this.q.D_() || (flags & 0x200) != 0 || this.q.captureBlockStates && !(block instanceof BlockTileEntity))) {
            state.a((World)this.q, pos, blockState, flag1);
        }
        if (state.x()) {
            blockEntity = this.a(pos, EnumTileEntityState.c);
            if (blockEntity != null && !blockEntity.b(state)) {
                m.warn("Found mismatched block entity @ {}: type = {}, state = {}", new Object[]{pos, blockEntity.s().a().h().a(), state});
                this.d(pos);
                blockEntity = null;
            }
            if (blockEntity == null) {
                blockEntity = ((ITileEntity)((Object)block)).a(pos, state);
                if (blockEntity != null) {
                    this.b(blockEntity);
                }
            } else {
                blockEntity.c(state);
                this.c(blockEntity);
            }
        }
        this.i();
        return blockState;
    }

    @Override
    @Deprecated
    public void a(Entity entity) {
    }

    @Nullable
    private TileEntity g(BlockPosition pos) {
        IBlockData blockState = this.a_(pos);
        return !blockState.x() ? null : ((ITileEntity)((Object)blockState.b())).a(pos, blockState);
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition pos) {
        return this.a(pos, EnumTileEntityState.c);
    }

    @Nullable
    public TileEntity a(BlockPosition pos, EnumTileEntityState creationType) {
        TileEntity blockEntity1;
        NBTTagCompound compoundTag;
        TileEntity blockEntity = this.q.capturedTileEntities.get(pos);
        if (blockEntity == null) {
            blockEntity = this.j.get(pos);
        }
        if (blockEntity == null && (compoundTag = this.i.remove(pos)) != null && (blockEntity1 = this.a(pos, compoundTag)) != null) {
            return blockEntity1;
        }
        if (blockEntity == null) {
            if (creationType == EnumTileEntityState.a && (blockEntity = this.g(pos)) != null) {
                this.b(blockEntity);
            }
        } else if (blockEntity.p()) {
            this.j.remove(pos);
            return null;
        }
        return blockEntity;
    }

    public void b(TileEntity blockEntity) {
        this.a(blockEntity);
        if (this.M()) {
            WorldServer worldServer = this.q;
            if (worldServer instanceof WorldServer) {
                WorldServer serverLevel = worldServer;
                this.b(blockEntity, serverLevel);
            }
            this.q.a(blockEntity);
            this.c(blockEntity);
        }
    }

    private boolean M() {
        return this.p || this.q.D_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean h(BlockPosition pos) {
        if (!this.q.u().a(pos)) return false;
        WorldServer worldServer = this.q;
        if (!(worldServer instanceof WorldServer)) return true;
        WorldServer serverLevel = worldServer;
        if (!this.G().a(FullChunkStatus.c)) return false;
        if (!serverLevel.c(ChunkCoordIntPair.a(pos))) return false;
        return true;
    }

    @Override
    public void a(TileEntity blockEntity) {
        BlockPosition blockPos = blockEntity.aD_();
        IBlockData blockState = this.a_(blockPos);
        if (!blockState.x()) {
            ServerInternalException e2 = new ServerInternalException("Trying to set block entity %s at position %s, but state %s does not allow it".formatted(blockEntity, blockPos, blockState));
            e2.printStackTrace();
            ServerInternalException.reportInternalException((Throwable)e2);
        } else {
            IBlockData blockState1 = blockEntity.o();
            if (blockState != blockState1) {
                if (!blockEntity.s().a(blockState)) {
                    m.warn("Trying to set block entity {} at position {}, but state {} does not allow it", new Object[]{blockEntity, blockPos, blockState});
                    return;
                }
                if (blockState.b() != blockState1.b()) {
                    m.warn("Block state mismatch on block entity {} in position {}, {} != {}, updating", new Object[]{blockEntity, blockPos, blockState, blockState1});
                }
                blockEntity.c(blockState);
            }
            blockEntity.a(this.q);
            blockEntity.q();
            TileEntity blockEntity1 = this.j.put(blockPos.j(), blockEntity);
            if (blockEntity1 != null && blockEntity1 != blockEntity) {
                blockEntity1.ay_();
            }
        }
    }

    @Override
    @Nullable
    public NBTTagCompound a(BlockPosition pos, HolderLookup.a registries) {
        TileEntity blockEntity = this.c_(pos);
        if (blockEntity != null && !blockEntity.p()) {
            NBTTagCompound compoundTag = blockEntity.b(this.q.L_());
            compoundTag.a("keepPacked", false);
            return compoundTag;
        }
        NBTTagCompound compoundTag = this.i.get(pos);
        if (compoundTag != null) {
            compoundTag = compoundTag.l();
            compoundTag.a("keepPacked", true);
        }
        return compoundTag;
    }

    @Override
    public void d(BlockPosition pos) {
        if (this.M()) {
            TileEntity blockEntity = this.j.remove(pos);
            if (!this.i.isEmpty()) {
                this.i.remove(pos);
            }
            if (blockEntity != null) {
                WorldServer worldServer = this.q;
                if (worldServer instanceof WorldServer) {
                    WorldServer serverLevel = worldServer;
                    this.a(blockEntity, serverLevel);
                    serverLevel.U().a(pos);
                }
                blockEntity.ay_();
            }
        }
        this.k(pos);
    }

    private <T extends TileEntity> void a(T blockEntity, WorldServer level) {
        GameEventListener listener;
        Block block = blockEntity.o().b();
        if (block instanceof ITileEntity && (listener = ((ITileEntity)((Object)block)).a(level, blockEntity)) != null) {
            int sectionPosY = SectionPosition.a(blockEntity.aD_().v());
            GameEventListenerRegistry listenerRegistry = this.a(sectionPosY);
            listenerRegistry.b(listener);
        }
    }

    private void c(int sectionY) {
        this.t.remove(sectionY);
    }

    private void k(BlockPosition pos) {
        d rebindableTickingBlockEntityWrapper = this.o.remove(pos);
        if (rebindableTickingBlockEntityWrapper != null) {
            rebindableTickingBlockEntityWrapper.a(n);
        }
    }

    public void H() {
        if (this.s != null) {
            this.s.run(this);
            this.s = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCallback() {
        if (this.loadedTicketLevel) {
            m.error("Double calling chunk load!", new Throwable());
        }
        this.loadedTicketLevel = true;
        CraftServer server = this.q.getCraftServer();
        if (server != null) {
            CraftChunk bukkitChunk = new CraftChunk(this);
            server.getPluginManager().callEvent((Event)new ChunkLoadEvent((org.bukkit.Chunk)bukkitChunk, this.needsDecoration));
            CraftEventFactory.callEntitiesLoadEvent(this.q, this.c, this.q.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(this.locX, this.locZ).getEntityChunk().getAllEntities());
            if (this.needsDecoration) {
                this.needsDecoration = false;
                Random random = new Random();
                random.setSeed(this.q.H());
                long xRand = random.nextLong() / 2L * 2L + 1L;
                long zRand = random.nextLong() / 2L * 2L + 1L;
                random.setSeed((long)this.c.h * xRand + (long)this.c.i * zRand ^ this.q.H());
                CraftWorld world = this.q.getWorld();
                if (world != null) {
                    this.q.populating = true;
                    try {
                        for (BlockPopulator populator : world.getPopulators()) {
                            populator.populate((org.bukkit.World)world, random, (org.bukkit.Chunk)bukkitChunk);
                        }
                    }
                    finally {
                        this.q.populating = false;
                    }
                }
                server.getPluginManager().callEvent((Event)new ChunkPopulateEvent((org.bukkit.Chunk)bukkitChunk));
            }
        }
    }

    public void unloadCallback() {
        if (!this.loadedTicketLevel) {
            m.error("Double calling chunk unload!", new Throwable());
        }
        CraftServer server = this.q.getCraftServer();
        CraftEventFactory.callEntitiesUnloadEvent(this.q, this.c, this.q.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(this.locX, this.locZ).getEntityChunk().getAllEntities());
        CraftChunk bukkitChunk = new CraftChunk(this);
        ChunkUnloadEvent unloadEvent = new ChunkUnloadEvent((org.bukkit.Chunk)bukkitChunk, true);
        server.getPluginManager().callEvent((Event)unloadEvent);
        this.mustNotSave = !unloadEvent.isSaveChunk();
        this.loadedTicketLevel = false;
    }

    @Override
    public boolean m() {
        long gameTime = this.q.ag();
        if (this.u.moonrise$isDirty(gameTime) || this.v.moonrise$isDirty(gameTime)) {
            return true;
        }
        return super.m();
    }

    @Override
    public boolean j() {
        if (!this.m()) {
            return false;
        }
        this.u.moonrise$clearDirty();
        this.v.moonrise$clearDirty();
        super.j();
        return true;
    }

    public boolean F() {
        return false;
    }

    public void a(PacketDataSerializer buffer, Map<HeightMap.Type, long[]> heightmaps, Consumer<ClientboundLevelChunkPacketData.b> outputTagConsumer) {
        this.K();
        for (ChunkSection levelChunkSection : this.l) {
            levelChunkSection.a(buffer);
        }
        heightmaps.forEach(this::a);
        this.C();
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(this.E(), m);){
            outputTagConsumer.accept((pos, type, tag) -> {
                TileEntity blockEntity = this.a(pos, EnumTileEntityState.a);
                if (blockEntity != null && tag != null && blockEntity.s() == type) {
                    blockEntity.b(TagValueInput.a(scopedCollector.a(blockEntity.v()), (HolderLookup.a)this.q.L_(), tag));
                }
            });
        }
    }

    public void a(PacketDataSerializer buffer) {
        for (ChunkSection levelChunkSection : this.l) {
            levelChunkSection.b(buffer);
        }
    }

    public void b(boolean loaded) {
        this.p = loaded;
    }

    public World I() {
        return this.q;
    }

    public Map<BlockPosition, TileEntity> J() {
        return this.j;
    }

    public void a(WorldServer level) {
        ChunkCoordIntPair pos = this.f();
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            if (this.b[i2] == null) continue;
            for (Short _short : this.b[i2]) {
                IBlockData blockState1;
                BlockPosition blockPos = ProtoChunk.a(_short, this.h(i2), pos);
                IBlockData blockState = this.a_(blockPos);
                Fluid fluidState = blockState.y();
                if (!fluidState.c()) {
                    fluidState.a(level, blockPos, blockState);
                }
                if (blockState.b() instanceof BlockFluids || (blockState1 = Block.b(blockState, (GeneratorAccess)level, blockPos)) == blockState) continue;
                level.a(blockPos, blockState1, 276);
            }
            this.b[i2].clear();
        }
        for (BlockPosition blockPos1 : ImmutableList.copyOf(this.i.keySet())) {
            this.c_(blockPos1);
        }
        this.i.clear();
        this.e.a(this);
        this.postProcessingDone = true;
    }

    @Nullable
    private TileEntity a(BlockPosition pos, NBTTagCompound tag) {
        TileEntity blockEntity;
        IBlockData blockState = this.a_(pos);
        if ("DUMMY".equals(tag.b("id", ""))) {
            if (blockState.x()) {
                blockEntity = ((ITileEntity)((Object)blockState.b())).a(pos, blockState);
            } else {
                blockEntity = null;
                m.warn("Tried to load a DUMMY block entity @ {} but found not block entity block {} at location", (Object)pos, (Object)blockState);
            }
        } else {
            blockEntity = TileEntity.a(pos, blockState, tag, this.q.L_());
        }
        if (blockEntity != null) {
            blockEntity.a(this.q);
            this.b(blockEntity);
        } else {
            m.warn("Tried to load a block entity for block {} but failed at location {}", (Object)blockState, (Object)pos);
        }
        return blockEntity;
    }

    public void d(long pos) {
        this.u.b(pos);
        this.v.b(pos);
    }

    public void b(WorldServer level) {
        level.o().a(this.c, this.u);
        level.p().a(this.c, this.v);
    }

    public void c(WorldServer level) {
        level.o().a(this.c);
        level.p().a(this.c);
    }

    @Override
    public void a(WorldServer level, DebugValueSource.a registrar) {
        if (!this.g().isEmpty()) {
            registrar.a(DebugSubscriptions.m, () -> {
                ArrayList<DebugStructureInfo> list = new ArrayList<DebugStructureInfo>();
                for (StructureStart structureStart : this.g().values()) {
                    StructureBoundingBox boundingBox = structureStart.a();
                    List<StructurePiece> pieces = structureStart.i();
                    ArrayList<DebugStructureInfo.a> list1 = new ArrayList<DebugStructureInfo.a>(pieces.size());
                    for (int i2 = 0; i2 < pieces.size(); ++i2) {
                        boolean flag = i2 == 0;
                        list1.add(new DebugStructureInfo.a(pieces.get(i2).f(), flag));
                    }
                    list.add(new DebugStructureInfo(boundingBox, list1));
                }
                return list;
            });
        }
        registrar.a(DebugSubscriptions.l, () -> level.E().a(this.c));
    }

    @Override
    public ChunkStatus n() {
        return ChunkStatus.n;
    }

    public FullChunkStatus G() {
        return this.r == null ? FullChunkStatus.b : this.r.get();
    }

    public void b(Supplier<FullChunkStatus> fullStatus) {
        this.r = fullStatus;
    }

    public void K() {
        this.j.values().forEach(TileEntity::ay_);
        this.j.clear();
        this.o.values().forEach(ticker -> ticker.a(n));
        this.o.clear();
    }

    public void L() {
        this.j.values().forEach(blockEntity -> {
            WorldServer patt0$temp = this.q;
            if (patt0$temp instanceof WorldServer) {
                WorldServer serverLevel = patt0$temp;
                this.b(blockEntity, serverLevel);
            }
            this.q.a((TileEntity)blockEntity);
            this.c(blockEntity);
        });
    }

    private <T extends TileEntity> void b(T blockEntity, WorldServer level) {
        GameEventListener listener;
        Block block = blockEntity.o().b();
        if (block instanceof ITileEntity && (listener = ((ITileEntity)((Object)block)).a(level, blockEntity)) != null) {
            this.a(SectionPosition.a(blockEntity.aD_().v())).a(listener);
        }
    }

    private <T extends TileEntity> void c(T blockEntity) {
        IBlockData blockState = blockEntity.o();
        BlockEntityTicker<?> ticker = blockState.a((World)this.q, blockEntity.s());
        if (ticker == null) {
            this.k(blockEntity.aD_());
        } else {
            this.o.compute(blockEntity.aD_(), (pos, ticker1) -> {
                TickingBlockEntity tickingBlockEntity = this.a(blockEntity, ticker);
                if (ticker1 != null) {
                    ticker1.a(tickingBlockEntity);
                    return ticker1;
                }
                if (this.M()) {
                    d rebindableTickingBlockEntityWrapper = new d(tickingBlockEntity);
                    this.q.a(rebindableTickingBlockEntityWrapper);
                    return rebindableTickingBlockEntityWrapper;
                }
                return null;
            });
        }
    }

    private <T extends TileEntity> TickingBlockEntity a(T blockEntity, BlockEntityTicker<T> ticker) {
        return new a(this, blockEntity, ticker);
    }

    private /* synthetic */ String c(int x2, int y2, int z2) throws Exception {
        return CrashReportSystemDetails.a((LevelHeightAccessor)this, x2, y2, z2);
    }

    @FunctionalInterface
    public static interface c {
        public void run(Chunk var1);
    }

    @FunctionalInterface
    public static interface e {
        public void setUnsaved(ChunkCoordIntPair var1);
    }

    public static final class EnumTileEntityState
    extends Enum<EnumTileEntityState> {
        public static final /* enum */ EnumTileEntityState a = new EnumTileEntityState();
        public static final /* enum */ EnumTileEntityState b = new EnumTileEntityState();
        public static final /* enum */ EnumTileEntityState c = new EnumTileEntityState();
        private static final /* synthetic */ EnumTileEntityState[] d;

        public static EnumTileEntityState[] values() {
            return (EnumTileEntityState[])d.clone();
        }

        public static EnumTileEntityState valueOf(String name) {
            return Enum.valueOf(EnumTileEntityState.class, name);
        }

        private static /* synthetic */ EnumTileEntityState[] a() {
            return new EnumTileEntityState[]{a, b, c};
        }

        static {
            d = EnumTileEntityState.a();
        }
    }

    static class d
    implements TickingBlockEntity {
        private TickingBlockEntity a;

        d(TickingBlockEntity ticker) {
            this.a = ticker;
        }

        void a(TickingBlockEntity ticker) {
            this.a = ticker;
        }

        @Override
        public void a() {
            this.a.a();
        }

        @Override
        public boolean b() {
            return this.a.b();
        }

        @Override
        public BlockPosition c() {
            return this.a.c();
        }

        @Override
        public String d() {
            return this.a.d();
        }

        public String toString() {
            return String.valueOf(this.a) + " <wrapped>";
        }
    }

    static class a<T extends TileEntity>
    implements TickingBlockEntity {
        private final T b;
        private final BlockEntityTicker<T> c;
        private boolean d;
        final /* synthetic */ Chunk a;

        a(T blockEntity, BlockEntityTicker<T> ticker) {
            this.a = this$0;
            this.b = blockEntity;
            this.c = ticker;
        }

        @Override
        public void a() {
            BlockPosition blockPos;
            if (!((TileEntity)this.b).p() && ((TileEntity)this.b).n() && this.a.h(blockPos = ((TileEntity)this.b).aD_())) {
                try {
                    GameProfilerFiller profilerFiller = Profiler.a();
                    profilerFiller.a(this::d);
                    IBlockData blockState = this.a.a_(blockPos);
                    if (((TileEntity)this.b).s().a(blockState)) {
                        this.c.tick(this.a.q, ((TileEntity)this.b).aD_(), blockState, this.b);
                        this.d = false;
                    } else {
                        this.a.d(this.c());
                        if (!this.d) {
                            this.d = true;
                            m.warn("Block entity {} @ {} state {} invalid for ticking:", new Object[]{LogUtils.defer(this::d), LogUtils.defer(this::c), blockState});
                        }
                    }
                    profilerFiller.c();
                }
                catch (Throwable var5) {
                    String msg = String.format("BlockEntity threw exception at %s:%s,%s,%s", this.a.I().getWorld().getName(), this.c().u(), this.c().v(), this.c().w());
                    MinecraftServer.m.error(msg, var5);
                    this.a.q.getCraftServer().getPluginManager().callEvent((Event)new ServerExceptionEvent((ServerException)new ServerInternalException(msg, var5)));
                    this.a.d(this.c());
                }
            }
        }

        @Override
        public boolean b() {
            return ((TileEntity)this.b).p();
        }

        @Override
        public BlockPosition c() {
            return ((TileEntity)this.b).aD_();
        }

        @Override
        public String d() {
            return TileEntityTypes.a(((TileEntity)this.b).s()).toString();
        }

        public String toString() {
            return "Level ticker for " + this.d() + "@" + String.valueOf(this.c());
        }
    }
}

