/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.ticks.TickListChunk;
import org.slf4j.Logger;

public class ChunkConverter {
    private static final Logger b = LogUtils.getLogger();
    public static final ChunkConverter a = new ChunkConverter(BlockAccessAir.a);
    private static final String c = "Indices";
    private static final EnumDirection8[] d = EnumDirection8.values();
    private static final Codec<List<TickListChunk<Block>>> e = TickListChunk.a(BuiltInRegistries.e.q().orElse((Object)Blocks.a)).listOf();
    private static final Codec<List<TickListChunk<FluidType>>> f = TickListChunk.a(BuiltInRegistries.c.q().orElse((Object)FluidTypes.a)).listOf();
    private final EnumSet<EnumDirection8> g = EnumSet.noneOf(EnumDirection8.class);
    private final List<TickListChunk<Block>> h = Lists.newArrayList();
    private final List<TickListChunk<FluidType>> i = Lists.newArrayList();
    private final int[][] j;
    static final Map<Block, a> k = new IdentityHashMap<Block, a>();
    static final Set<a> l = Sets.newHashSet();

    private ChunkConverter(LevelHeightAccessor level) {
        this.j = new int[level.as()][];
    }

    public ChunkConverter(NBTTagCompound tag, LevelHeightAccessor level) {
        this(level);
        tag.m(c).ifPresent(compoundTag -> {
            for (int i2 = 0; i2 < this.j.length; ++i2) {
                this.j[i2] = compoundTag.k(String.valueOf(i2)).orElse(null);
            }
        });
        int intOr = tag.b("Sides", 0);
        for (EnumDirection8 direction8 : EnumDirection8.values()) {
            if ((intOr & 1 << direction8.ordinal()) == 0) continue;
            this.g.add(direction8);
        }
        tag.a("neighbor_block_ticks", e).ifPresent(this.h::addAll);
        tag.a("neighbor_fluid_ticks", f).ifPresent(this.i::addAll);
    }

    private ChunkConverter(ChunkConverter other) {
        this.g.addAll(other.g);
        this.h.addAll(other.h);
        this.i.addAll(other.i);
        this.j = new int[other.j.length][];
        for (int i2 = 0; i2 < other.j.length; ++i2) {
            int[] ints = other.j[i2];
            this.j[i2] = ints != null ? IntArrays.copy((int[])ints) : null;
        }
    }

    private static <T> void filterTickList(int chunkX, int chunkZ, List<TickListChunk<T>> ticks) {
        Iterator<TickListChunk<T>> iterator = ticks.iterator();
        while (iterator.hasNext()) {
            TickListChunk<T> tick = iterator.next();
            BlockPosition tickPos = tick.b();
            int tickCX = tickPos.u() >> 4;
            int tickCZ = tickPos.w() >> 4;
            int dist = Math.max(Math.abs(chunkX - tickCX), Math.abs(chunkZ - tickCZ));
            if (dist == 1) continue;
            b.warn("Neighbour tick '" + String.valueOf(tick) + "' serialized in chunk (" + chunkX + "," + chunkZ + ") is too far (" + tickCX + "," + tickCZ + ")");
            iterator.remove();
        }
    }

    public void a(Chunk chunk) {
        this.b(chunk);
        for (EnumDirection8 direction8 : d) {
            ChunkConverter.a(chunk, direction8);
        }
        ChunkConverter.filterTickList(chunk.locX, chunk.locZ, this.h);
        ChunkConverter.filterTickList(chunk.locX, chunk.locZ, this.i);
        World level = chunk.I();
        this.h.forEach(savedTick -> {
            Block block = savedTick.a() == Blocks.a ? level.a_(savedTick.b()).b() : (Block)savedTick.a();
            level.a(savedTick.b(), block, savedTick.c(), savedTick.d());
        });
        this.i.forEach(savedTick -> {
            FluidType fluid = savedTick.a() == FluidTypes.a ? level.b_(savedTick.b()).a() : (FluidType)savedTick.a();
            level.a(savedTick.b(), fluid, savedTick.c(), savedTick.d());
        });
        Type.values();
        l.forEach(blockFixer -> blockFixer.a(level));
    }

    private static void a(Chunk chunk, EnumDirection8 side) {
        World level = chunk.I();
        if (chunk.t().g.remove((Object)side)) {
            Set<EnumDirection> directions = side.a();
            boolean i2 = false;
            int i1 = 15;
            boolean flag = directions.contains(EnumDirection.f);
            boolean flag1 = directions.contains(EnumDirection.e);
            boolean flag2 = directions.contains(EnumDirection.d);
            boolean flag3 = directions.contains(EnumDirection.c);
            boolean flag4 = directions.size() == 1;
            ChunkCoordIntPair pos = chunk.f();
            int i22 = pos.d() + (!flag4 || !flag3 && !flag2 ? (flag1 ? 0 : 15) : 1);
            int i3 = pos.d() + (!flag4 || !flag3 && !flag2 ? (flag1 ? 0 : 15) : 14);
            int i4 = pos.e() + (!flag4 || !flag && !flag1 ? (flag3 ? 0 : 15) : 1);
            int i5 = pos.e() + (!flag4 || !flag && !flag1 ? (flag3 ? 0 : 15) : 14);
            EnumDirection[] directions1 = EnumDirection.values();
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (BlockPosition blockPos : BlockPosition.b(i22, level.M_(), i4, i3, level.ar(), i5)) {
                IBlockData blockState;
                IBlockData blockState1 = blockState = level.a_(blockPos);
                for (EnumDirection direction : directions1) {
                    mutableBlockPos.a((BaseBlockPosition)blockPos, direction);
                    blockState1 = ChunkConverter.a(blockState1, direction, level, blockPos, mutableBlockPos);
                }
                Block.a(blockState, blockState1, level, blockPos, 18);
            }
        }
    }

    private static IBlockData a(IBlockData state, EnumDirection direction, GeneratorAccess level, BlockPosition pos, BlockPosition offsetPos) {
        return k.getOrDefault(state.b(), Type.b).a(state, direction, level.a_(offsetPos), level, pos, offsetPos);
    }

    private void b(Chunk chunk) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition mutableBlockPos1 = new BlockPosition.MutableBlockPosition();
        ChunkCoordIntPair pos = chunk.f();
        World level = chunk.I();
        for (int i2 = 0; i2 < this.j.length; ++i2) {
            ChunkSection section = chunk.b(i2);
            int[] ints = this.j[i2];
            this.j[i2] = null;
            if (ints == null || ints.length <= 0) continue;
            EnumDirection[] directions = EnumDirection.values();
            DataPaletteBlock<IBlockData> states = section.h();
            int sectionYFromSectionIndex = chunk.h(i2);
            int blockPosCoord = SectionPosition.c(sectionYFromSectionIndex);
            for (int i1 : ints) {
                IBlockData blockState;
                int i22 = i1 & 0xF;
                int i3 = i1 >> 8 & 0xF;
                int i4 = i1 >> 4 & 0xF;
                mutableBlockPos.d(pos.d() + i22, blockPosCoord + i3, pos.e() + i4);
                IBlockData blockState1 = blockState = states.a(i1);
                for (EnumDirection direction : directions) {
                    mutableBlockPos1.a((BaseBlockPosition)mutableBlockPos, direction);
                    if (SectionPosition.a(mutableBlockPos.u()) != pos.h || SectionPosition.a(mutableBlockPos.w()) != pos.i) continue;
                    blockState1 = ChunkConverter.a(blockState1, direction, level, mutableBlockPos, mutableBlockPos1);
                }
                Block.a(blockState, blockState1, level, mutableBlockPos, 18);
            }
        }
        for (int ix = 0; ix < this.j.length; ++ix) {
            if (this.j[ix] != null) {
                b.warn("Discarding update data for section {} for chunk ({} {})", new Object[]{level.h(ix), pos.h, pos.i});
            }
            this.j[ix] = null;
        }
    }

    public boolean a() {
        for (int[] ints : this.j) {
            if (ints == null) continue;
            return false;
        }
        return this.g.isEmpty();
    }

    public NBTTagCompound b() {
        NBTTagCompound compoundTag = new NBTTagCompound();
        NBTTagCompound compoundTag1 = new NBTTagCompound();
        for (int i2 = 0; i2 < this.j.length; ++i2) {
            String string = String.valueOf(i2);
            if (this.j[i2] == null || this.j[i2].length == 0) continue;
            compoundTag1.a(string, this.j[i2]);
        }
        if (!compoundTag1.j()) {
            compoundTag.a(c, compoundTag1);
        }
        int ix = 0;
        for (EnumDirection8 direction8 : this.g) {
            ix |= 1 << direction8.ordinal();
        }
        compoundTag.a("Sides", (byte)ix);
        if (!this.h.isEmpty()) {
            compoundTag.a("neighbor_block_ticks", e, this.h);
        }
        if (!this.i.isEmpty()) {
            compoundTag.a("neighbor_fluid_ticks", f, this.i);
        }
        return compoundTag;
    }

    public ChunkConverter c() {
        return this == a ? a : new ChunkConverter(this);
    }

    static abstract sealed class Type
    extends Enum<Type>
    implements a {
        public static final /* enum */ Type a = new Type(new Block[]{Blocks.lK, Blocks.eI, Blocks.mI, Blocks.mJ, Blocks.mK, Blocks.mL, Blocks.mM, Blocks.mN, Blocks.mO, Blocks.mP, Blocks.mQ, Blocks.mR, Blocks.mS, Blocks.mT, Blocks.mU, Blocks.mV, Blocks.mW, Blocks.mX, Blocks.hJ, Blocks.hK, Blocks.hL, Blocks.gp, Blocks.O, Blocks.L, Blocks.N, Blocks.db, Blocks.dc, Blocks.dd, Blocks.de, Blocks.df, Blocks.dg, Blocks.dh, Blocks.di, Blocks.dp, Blocks.dq, Blocks.dr, Blocks.ds, Blocks.du, Blocks.dv, Blocks.dw, Blocks.dz, Blocks.dA, Blocks.dB, Blocks.dC, Blocks.dE, Blocks.dF, Blocks.dG, Blocks.dL, Blocks.dM, Blocks.dN, Blocks.dO, Blocks.dQ, Blocks.dR, Blocks.dS}){

            @Override
            public IBlockData a(IBlockData state, EnumDirection direction, IBlockData offsetState, GeneratorAccess level, BlockPosition pos, BlockPosition offsetPos) {
                return state;
            }
        };
        public static final /* enum */ Type b = new Type(new Block[0]){

            @Override
            public IBlockData a(IBlockData state, EnumDirection direction, IBlockData offsetState, GeneratorAccess level, BlockPosition pos, BlockPosition offsetPos) {
                return state.a(level, level, pos, direction, offsetPos, level.a_(offsetPos), level.I_());
            }
        };
        public static final /* enum */ Type c = new Type(new Block[]{Blocks.cS, Blocks.hM}){

            @Override
            public IBlockData a(IBlockData state, EnumDirection direction, IBlockData offsetState, GeneratorAccess level, BlockPosition pos, BlockPosition offsetPos) {
                if (offsetState.a(state.b()) && direction.o().d() && state.c(BlockChest.d) == BlockPropertyChestType.a && offsetState.c(BlockChest.d) == BlockPropertyChestType.a) {
                    EnumDirection direction1 = state.c(BlockChest.c);
                    if (direction.o() != direction1.o() && direction1 == offsetState.c(BlockChest.c)) {
                        BlockPropertyChestType chestType = direction == direction1.h() ? BlockPropertyChestType.b : BlockPropertyChestType.c;
                        level.a(offsetPos, (IBlockData)offsetState.b(BlockChest.d, chestType.a()), 18);
                        if (direction1 == EnumDirection.c || direction1 == EnumDirection.f) {
                            TileEntity blockEntity = level.c_(pos);
                            TileEntity blockEntity1 = level.c_(offsetPos);
                            if (blockEntity instanceof TileEntityChest && blockEntity1 instanceof TileEntityChest) {
                                TileEntityChest.a((TileEntityChest)blockEntity, (TileEntityChest)blockEntity1);
                            }
                        }
                        return (IBlockData)state.b(BlockChest.d, chestType);
                    }
                }
                return state;
            }
        };
        public static final /* enum */ Type d = new Type(true, new Block[]{Blocks.aO, Blocks.aP, Blocks.aM, Blocks.aR, Blocks.aQ, Blocks.aN, Blocks.aK, Blocks.aL}){
            private final ThreadLocal<List<ObjectSet<BlockPosition>>> g = ThreadLocal.withInitial(() -> Lists.newArrayListWithCapacity((int)7));

            @Override
            public IBlockData a(IBlockData state, EnumDirection direction, IBlockData offsetState, GeneratorAccess level, BlockPosition pos, BlockPosition offsetPos) {
                IBlockData blockState = state.a(level, level, pos, direction, offsetPos, level.a_(offsetPos), level.I_());
                if (state != blockState) {
                    int distanceValue = blockState.c(BlockProperties.aG);
                    List<ObjectSet<BlockPosition>> list = this.g.get();
                    if (list.isEmpty()) {
                        for (int i2 = 0; i2 < 7; ++i2) {
                            list.add((ObjectSet<BlockPosition>)new ObjectOpenHashSet());
                        }
                    }
                    list.get(distanceValue).add((Object)pos.j());
                }
                return state;
            }

            @Override
            public void a(GeneratorAccess level) {
                BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
                List<ObjectSet<BlockPosition>> list = this.g.get();
                for (int i2 = 2; i2 < list.size(); ++i2) {
                    int i1 = i2 - 1;
                    ObjectSet<BlockPosition> set = list.get(i1);
                    ObjectSet<BlockPosition> set1 = list.get(i2);
                    for (BlockPosition blockPos : set) {
                        IBlockData blockState = level.a_(blockPos);
                        if (blockState.c(BlockProperties.aG) < i1) continue;
                        level.a(blockPos, (IBlockData)blockState.b(BlockProperties.aG, i1), 18);
                        if (i2 == 7) continue;
                        for (EnumDirection direction : f) {
                            mutableBlockPos.a((BaseBlockPosition)blockPos, direction);
                            IBlockData blockState1 = level.a_(mutableBlockPos);
                            if (!blockState1.b(BlockProperties.aG) || blockState.c(BlockProperties.aG) <= i2) continue;
                            set1.add((Object)mutableBlockPos.j());
                        }
                    }
                }
                list.clear();
            }
        };
        public static final /* enum */ Type e = new Type(new Block[]{Blocks.fM, Blocks.fL}){

            @Override
            public IBlockData a(IBlockData state, EnumDirection direction, IBlockData offsetState, GeneratorAccess level, BlockPosition pos, BlockPosition offsetPos) {
                if (state.c(BlockStem.c) == 7) {
                    Block block;
                    Block block2 = block = state.a(Blocks.fL) ? Blocks.fH : Blocks.fI;
                    if (offsetState.a(block)) {
                        return (IBlockData)(state.a(Blocks.fL) ? Blocks.fJ : Blocks.fK).m().b(BlockFacingHorizontal.f, direction);
                    }
                }
                return state;
            }
        };
        public static final EnumDirection[] f;
        private static final /* synthetic */ Type[] g;

        public static Type[] values() {
            return (Type[])g.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(Block ... blocks) {
            this(false, blocks);
        }

        private Type(boolean chunkyFixer, Block ... blocks) {
            for (Block block : blocks) {
                k.put(block, this);
            }
            if (chunkyFixer) {
                l.add(this);
            }
        }

        private static /* synthetic */ Type[] a() {
            return new Type[]{a, b, c, d, e};
        }

        static {
            g = Type.a();
            f = EnumDirection.values();
        }
    }

    public static interface a {
        public IBlockData a(IBlockData var1, EnumDirection var2, IBlockData var3, GeneratorAccess var4, BlockPosition var5, BlockPosition var6);

        default public void a(GeneratorAccess level) {
        }
    }
}

