/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.util.VisibleForDebug;

public class NibbleArray {
    public static final int a = 16;
    public static final int b = 128;
    public static final int c = 2048;
    private static final int e = 4;
    @Nullable
    protected byte[] d;
    private int f;

    public NibbleArray() {
        this(0);
    }

    public NibbleArray(int defaultValue) {
        this.f = defaultValue;
    }

    public NibbleArray(byte[] data) {
        this.d = data;
        this.f = 0;
        if (data.length != 2048) {
            throw SystemUtils.b(new IllegalArgumentException("DataLayer should be 2048 bytes not: " + data.length));
        }
    }

    public int a(int x2, int y2, int z2) {
        return this.d(NibbleArray.b(x2, y2, z2));
    }

    public void a(int x2, int y2, int z2, int value) {
        this.a(NibbleArray.b(x2, y2, z2), value);
    }

    private static int b(int x2, int y2, int z2) {
        return y2 << 8 | z2 << 4 | x2;
    }

    private int d(int index) {
        if (this.d == null) {
            return this.f;
        }
        int byteIndex = NibbleArray.f(index);
        int nibbleIndex = NibbleArray.e(index);
        return this.d[byteIndex] >> 4 * nibbleIndex & 0xF;
    }

    private void a(int index, int value) {
        byte[] data = this.a();
        int byteIndex = NibbleArray.f(index);
        int nibbleIndex = NibbleArray.e(index);
        int i2 = ~(15 << 4 * nibbleIndex);
        int i1 = (value & 0xF) << 4 * nibbleIndex;
        data[byteIndex] = (byte)(data[byteIndex] & i2 | i1);
    }

    private static int e(int index) {
        return index & 1;
    }

    private static int f(int index) {
        return index >> 1;
    }

    public void a(int defaultValue) {
        this.f = defaultValue;
        this.d = null;
    }

    private static byte g(int value) {
        byte b2 = (byte)value;
        for (int i2 = 4; i2 < 8; i2 += 4) {
            b2 = (byte)(b2 | value << i2);
        }
        return b2;
    }

    public byte[] a() {
        if (this.d == null) {
            this.d = new byte[2048];
            if (this.f != 0) {
                Arrays.fill(this.d, NibbleArray.g(this.f));
            }
        }
        return this.d;
    }

    public NibbleArray b() {
        return this.d == null ? new NibbleArray(this.f) : new NibbleArray((byte[])this.d.clone());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < 4096; ++i2) {
            stringBuilder.append(Integer.toHexString(this.d(i2)));
            if ((i2 & 0xF) == 15) {
                stringBuilder.append("\n");
            }
            if ((i2 & 0xFF) != 255) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @VisibleForDebug
    public String b(int layer) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < 256; ++i2) {
            stringBuilder.append(Integer.toHexString(this.d(i2)));
            if ((i2 & 0xF) != 15) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public boolean c() {
        return this.d == null;
    }

    public boolean c(int value) {
        return this.d == null && this.f == value;
    }

    public boolean d() {
        return this.d == null && this.f == 0;
    }
}

