/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.util.Version;
import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemChunkStorage;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.structure.PersistentStructureLegacy;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class IChunkLoader
implements AutoCloseable,
ChunkSystemChunkStorage {
    public static final int d = 1493;
    protected final DataFixer e;
    @Nullable
    private volatile PersistentStructureLegacy b;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RegionFileCache storage;

    @Override
    public final RegionFileCache moonrise$getRegionStorage() {
        return this.storage;
    }

    public IChunkLoader(RegionStorageInfo info, Path folder, DataFixer fixerUpper, boolean sync) {
        this.e = fixerUpper;
        this.storage = new IOWorker((RegionStorageInfo)info, (Path)folder, (boolean)sync).d;
    }

    public boolean b(ChunkCoordIntPair pos, int radius) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTTagCompound upgradeChunkTag(ResourceKey<WorldDimension> levelKey, Supplier<WorldPersistentData> storage, NBTTagCompound chunkData, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> chunkGeneratorKey, ChunkCoordIntPair pos, @Nullable GeneratorAccess levelAccessor) {
        int version = IChunkLoader.a(chunkData);
        if (version == SharedConstants.b().a().b()) {
            return chunkData;
        }
        try {
            boolean belowZeroGenerationInExistingChunks;
            if (version < 1493 && (chunkData = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, chunkData, version, 1493)).m("Level").flatMap(compoundTag -> compoundTag.q("hasLegacyStructureData")).orElse(false).booleanValue()) {
                PersistentStructureLegacy legacyStructureHandler;
                PersistentStructureLegacy persistentStructureLegacy = legacyStructureHandler = this.a(levelKey, storage);
                synchronized (persistentStructureLegacy) {
                    chunkData = legacyStructureHandler.a(chunkData);
                }
            }
            boolean stopBelowZero = false;
            boolean bl = belowZeroGenerationInExistingChunks = levelAccessor != null ? ((WorldServer)levelAccessor).spigotConfig.belowZeroGenerationInExistingChunks : SpigotConfig.belowZeroGenerationInExistingChunks;
            if (version <= 2730 && !belowZeroGenerationInExistingChunks) {
                stopBelowZero = "full".equals(chunkData.m("Level").flatMap(l2 -> l2.i("Status")).orElse(null));
            }
            IChunkLoader.a(chunkData, levelKey, chunkGeneratorKey);
            chunkData = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, chunkData, Math.max(1493, version), Version.getCurrentVersion());
            if (stopBelowZero) {
                chunkData.a("Status", BuiltInRegistries.m.b(ChunkStatus.m).toString());
            }
            IChunkLoader.b(chunkData);
            GameProfileSerializer.e(chunkData);
            return chunkData;
        }
        catch (Exception var9) {
            CrashReport crashReport = CrashReport.a(var9, "Updated chunk");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Updated chunk details");
            crashReportCategory.a("Data version", version);
            throw new ReportedException(crashReport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistentStructureLegacy a(ResourceKey<WorldDimension> level, Supplier<WorldPersistentData> storage) {
        PersistentStructureLegacy legacyStructureDataHandler = this.b;
        if (legacyStructureDataHandler == null) {
            IChunkLoader iChunkLoader = this;
            synchronized (iChunkLoader) {
                legacyStructureDataHandler = this.b;
                if (legacyStructureDataHandler == null) {
                    this.b = legacyStructureDataHandler = PersistentStructureLegacy.a(level, storage.get());
                }
            }
        }
        return legacyStructureDataHandler;
    }

    public static void a(NBTTagCompound chunkData, ResourceKey<WorldDimension> levelKey, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> chunkGeneratorKey) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("dimension", levelKey.a().toString());
        chunkGeneratorKey.ifPresent(resourceKey -> compoundTag.a("generator", resourceKey.a().toString()));
        chunkData.a("__context", compoundTag);
    }

    private static void b(NBTTagCompound tag) {
        tag.r("__context");
    }

    public static int a(NBTTagCompound chunkData) {
        return GameProfileSerializer.b(chunkData, -1);
    }

    public CompletableFuture<Optional<NBTTagCompound>> d(ChunkCoordIntPair chunkPos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.storage.a(chunkPos)));
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    public CompletableFuture<Void> a(ChunkCoordIntPair pos, Supplier<NBTTagCompound> tagSupplier) {
        Supplier<NBTTagCompound> guardedPosCheck = () -> {
            NBTTagCompound nbt = (NBTTagCompound)tagSupplier.get();
            if (nbt != null && !pos.equals(SerializableChunkData.getChunkCoordinate(nbt))) {
                String world = this instanceof PlayerChunkMap ? ((PlayerChunkMap)this).t.getWorld().getName() : null;
                throw new IllegalArgumentException("Chunk coordinate and serialized data do not have matching coordinates, trying to serialize coordinate " + String.valueOf(pos) + " but compound says coordinate is " + String.valueOf(SerializableChunkData.getChunkCoordinate(nbt)) + (String)(world == null ? " for an unknown world" : " for world: " + world));
            }
            return nbt;
        };
        this.e(pos);
        try {
            this.storage.a(pos, guardedPosCheck.get());
            return CompletableFuture.completedFuture(null);
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void e(ChunkCoordIntPair chunkPos) {
        if (this.b != null) {
            PersistentStructureLegacy persistentStructureLegacy = this.b;
            synchronized (persistentStructureLegacy) {
                this.b.a(chunkPos.a());
            }
        }
    }

    public void m() {
        try {
            this.storage.a();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to flush chunk storage", (Throwable)ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.storage.close();
    }

    public ChunkScanAccess n() {
        return (chunkPos, streamTagVisitor) -> {
            try {
                this.storage.a(chunkPos, streamTagVisitor);
                return CompletableFuture.completedFuture(null);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        };
    }

    public RegionStorageInfo o() {
        return this.storage.b();
    }
}

