/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.moonrise.patches.chunk_system.level.storage.ChunkSystemSectionStorage;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTBase;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.slf4j.Logger;

public class RegionFileSection<R, P>
implements AutoCloseable,
ChunkSystemSectionStorage {
    static final Logger a = LogUtils.getLogger();
    private static final String b = "Sections";
    private final Long2ObjectMap<Optional<R>> e = new Long2ObjectOpenHashMap();
    private final LongLinkedOpenHashSet f = new LongLinkedOpenHashSet();
    private final Codec<P> g;
    private final Function<R, P> h;
    private final BiFunction<P, Runnable, R> i;
    private final Function<Runnable, R> j;
    private final IRegistryCustom k;
    private final ChunkIOErrorReporter l;
    protected final LevelHeightAccessor c;
    private final LongSet m = new LongOpenHashSet();
    private final Long2ObjectMap<CompletableFuture<Optional<a<P>>>> n = new Long2ObjectOpenHashMap();
    private final Object o = new Object();
    private final RegionFileCache regionStorage;

    @Override
    public final RegionFileCache moonrise$getRegionStorage() {
        return this.regionStorage;
    }

    @Override
    public void moonrise$close() throws IOException {
    }

    public RegionFileSection(SimpleRegionStorage simpleRegionStorage, Codec<P> codec, Function<R, P> packer, BiFunction<P, Runnable, R> unpacker, Function<Runnable, R> factory, IRegistryCustom registryAccess, ChunkIOErrorReporter errorReporter, LevelHeightAccessor levelHeightAccessor) {
        this.g = codec;
        this.h = packer;
        this.i = unpacker;
        this.j = factory;
        this.k = registryAccess;
        this.l = errorReporter;
        this.c = levelHeightAccessor;
        this.regionStorage = simpleRegionStorage.a.d;
    }

    protected void a(BooleanSupplier aheadOfTime) {
        LongListIterator longIterator = this.f.iterator();
        while (longIterator.hasNext() && aheadOfTime.getAsBoolean()) {
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(longIterator.nextLong());
            longIterator.remove();
            this.e(chunkPos);
        }
        this.c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c() {
        Object object = this.o;
        synchronized (object) {
            ObjectIterator iterator = Long2ObjectMaps.fastIterator(this.n);
            while (iterator.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
                Optional optional = ((CompletableFuture)entry.getValue()).getNow(null);
                if (optional == null) continue;
                long longKey = entry.getLongKey();
                this.a(new ChunkCoordIntPair(longKey), (a<P>)optional.orElse(null));
                iterator.remove();
                this.m.add(longKey);
            }
        }
    }

    public void a() {
        if (!this.f.isEmpty()) {
            this.f.forEach(l2 -> this.e(new ChunkCoordIntPair(l2)));
            this.f.clear();
        }
    }

    public boolean b() {
        return !this.f.isEmpty();
    }

    @Nullable
    public Optional<R> c(long sectionKey) {
        return (Optional)this.e.get(sectionKey);
    }

    public Optional<R> d(long sectionKey) {
        if (this.e(sectionKey)) {
            return Optional.empty();
        }
        Optional<R> optional = this.c(sectionKey);
        if (optional != null) {
            return optional;
        }
        this.c(SectionPosition.a(sectionKey).r());
        optional = this.c(sectionKey);
        if (optional == null) {
            throw SystemUtils.b(new IllegalStateException());
        }
        return optional;
    }

    protected boolean e(long sectionKey) {
        int blockPosY = SectionPosition.c(SectionPosition.c(sectionKey));
        return this.c.e(blockPosY);
    }

    protected R f(long sectionKey) {
        if (this.e(sectionKey)) {
            throw SystemUtils.b(new IllegalArgumentException("sectionPos out of bounds"));
        }
        Optional<R> orLoad = this.d(sectionKey);
        if (orLoad.isPresent()) {
            return orLoad.get();
        }
        R object = this.j.apply(() -> this.a(sectionKey));
        this.e.put(sectionKey, Optional.of(object));
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> a(ChunkCoordIntPair pos) {
        Object object = this.o;
        synchronized (object) {
            long packedChunkPos = pos.a();
            return this.m.contains(packedChunkPos) ? CompletableFuture.completedFuture(null) : (CompletableFuture)this.n.computeIfAbsent(packedChunkPos, l2 -> this.d(pos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c(ChunkCoordIntPair pos) {
        CompletableFuture completableFuture;
        long packedChunkPos = pos.a();
        Object object = this.o;
        synchronized (object) {
            if (!this.m.add(packedChunkPos)) {
                return;
            }
            completableFuture = (CompletableFuture)this.n.computeIfAbsent(packedChunkPos, l2 -> this.d(pos));
        }
        this.a(pos, (a<P>)((Optional)completableFuture.join()).orElse(null));
        object = this.o;
        synchronized (object) {
            this.n.remove(packedChunkPos);
        }
    }

    private CompletableFuture<Optional<a<P>>> d(ChunkCoordIntPair chunkPos) {
        throw new IllegalStateException("Only chunk system can write state, offending class:" + this.getClass().getName());
    }

    private void a(ChunkCoordIntPair pos, @Nullable a<P> packedChunk) {
        throw new IllegalStateException("Only chunk system can load in state, offending class:" + this.getClass().getName());
    }

    private void e(ChunkCoordIntPair pos) {
        throw new IllegalStateException("Only chunk system can write state, offending class:" + this.getClass().getName());
    }

    private <T> Dynamic<T> a(ChunkCoordIntPair pos, DynamicOps<T> ops) {
        HashMap map = Maps.newHashMap();
        for (int sectionY = this.c.at(); sectionY <= this.c.au(); ++sectionY) {
            long key = RegionFileSection.a(pos, sectionY);
            Optional optional = (Optional)this.e.get(key);
            if (optional == null || optional.isEmpty()) continue;
            DataResult dataResult = this.g.encodeStart(ops, this.h.apply(optional.get()));
            String string = Integer.toString(sectionY);
            dataResult.resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(object -> map.put(ops.createString(string), object));
        }
        return new Dynamic<Object>(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString(b), (Object)ops.createMap((Map)map), (Object)ops.createString("DataVersion"), (Object)ops.createInt(SharedConstants.b().a().b()))));
    }

    private static long a(ChunkCoordIntPair chunkPos, int sectionY) {
        return SectionPosition.b(chunkPos.h, sectionY, chunkPos.i);
    }

    protected void b(long sectionKey) {
    }

    public void a(long sectionPos) {
        Optional optional = (Optional)this.e.get(sectionPos);
        if (optional != null && !optional.isEmpty()) {
            this.f.add(ChunkCoordIntPair.c(SectionPosition.b(sectionPos), SectionPosition.d(sectionPos)));
        } else {
            a.warn("No data for position: {}", (Object)SectionPosition.a(sectionPos));
        }
    }

    public void b(ChunkCoordIntPair chunkPos) {
        if (this.f.remove(chunkPos.a())) {
            this.e(chunkPos);
        }
    }

    @Override
    public void close() throws IOException {
        this.moonrise$close();
    }

    record a<T>(Int2ObjectMap<T> a, boolean b) {
        public static <T> a<T> a(Codec<T> codec, DynamicOps<NBTBase> ops, NBTBase value, SimpleRegionStorage simpleRegionStorage, LevelHeightAccessor level) {
            Dynamic<NBTBase> dynamic = new Dynamic<NBTBase>(ops, value);
            Dynamic<NBTBase> dynamic1 = simpleRegionStorage.a(dynamic, 1945);
            boolean flag = dynamic != dynamic1;
            OptionalDynamic<NBTBase> optionalDynamic = dynamic1.get(RegionFileSection.b);
            Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
            for (int sectionY = level.at(); sectionY <= level.au(); ++sectionY) {
                Optional optional = optionalDynamic.get(Integer.toString(sectionY)).result().flatMap(dynamic2 -> codec.parse(dynamic2).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)));
                if (!optional.isPresent()) continue;
                map.put(sectionY, optional.get());
            }
            return new a<T>(map, flag);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "sectionsByY;versionChanged", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "sectionsByY;versionChanged", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "sectionsByY;versionChanged", "a", "b"}, this, o2);
        }
    }
}

