/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.slf4j.Logger;

public class EntityLookup<T extends EntityAccess> {
    private static final Logger a = LogUtils.getLogger();
    private final Int2ObjectMap<T> b = new Int2ObjectLinkedOpenHashMap();
    private final Map<UUID, T> c = Maps.newHashMap();

    public <U extends T> void a(EntityTypeTest<T, U> test, AbortableIterationConsumer<U> consumer) {
        for (EntityAccess entityAccess : this.b.values()) {
            EntityAccess entityAccess1 = (EntityAccess)test.a(entityAccess);
            if (entityAccess1 == null || !consumer.accept(entityAccess1).a()) continue;
            return;
        }
    }

    public Iterable<T> a() {
        return Iterables.unmodifiableIterable((Iterable)this.b.values());
    }

    public void a(T entity) {
        UUID uuid = entity.cT();
        if (this.c.containsKey(uuid)) {
            Entity oldCast;
            EntityAccess old;
            a.warn("Duplicate entity UUID {}: {}", (Object)uuid, entity);
            if (entity instanceof Entity && (old = (EntityAccess)this.c.get(entity.cT())) instanceof Entity && (oldCast = (Entity)old).az() != entity.az() && oldCast.valid) {
                a.error("Overwrote an existing entity {} with {}", (Object)oldCast, entity);
            }
        } else {
            this.c.put(uuid, entity);
            this.b.put(entity.az(), entity);
        }
    }

    public void b(T entity) {
        this.c.remove(entity.cT());
        this.b.remove(entity.az());
    }

    @Nullable
    public T a(int id) {
        return (T)((EntityAccess)this.b.get(id));
    }

    @Nullable
    public T a(UUID uuid) {
        return (T)((EntityAccess)this.c.get(uuid));
    }

    public int b() {
        return this.c.size();
    }
}

