/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.ArrayList;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.phys.AxisAlignedBB;

public class EntitySectionStorage<T extends EntityAccess> {
    public static final int a = 2;
    public static final int b = 4;
    private final Class<T> c;
    private final Long2ObjectFunction<Visibility> d;
    private final Long2ObjectMap<EntitySection<T>> e = new Long2ObjectOpenHashMap();
    private final LongSortedSet f = new LongAVLTreeSet();

    public EntitySectionStorage(Class<T> entityClass, Long2ObjectFunction<Visibility> initialSectionVisibility) {
        this.c = entityClass;
        this.d = initialSectionVisibility;
    }

    public Iterable<T> getAllEntities() {
        ArrayList ret = new ArrayList();
        for (EntitySection section : this.e.values()) {
            section.getEntities(ret);
        }
        return ret;
    }

    public void a(AxisAlignedBB boundingBox, AbortableIterationConsumer<EntitySection<T>> consumer) {
        int sectionPosCoord = SectionPosition.a(boundingBox.a - 2.0);
        int sectionPosCoord1 = SectionPosition.a(boundingBox.b - 4.0);
        int sectionPosCoord2 = SectionPosition.a(boundingBox.c - 2.0);
        int sectionPosCoord3 = SectionPosition.a(boundingBox.d + 2.0);
        int sectionPosCoord4 = SectionPosition.a(boundingBox.e + 0.0);
        int sectionPosCoord5 = SectionPosition.a(boundingBox.f + 2.0);
        for (int i2 = sectionPosCoord; i2 <= sectionPosCoord3; ++i2) {
            long packedSectionPos = SectionPosition.b(i2, 0, 0);
            long packedSectionPos1 = SectionPosition.b(i2, -1, -1);
            LongBidirectionalIterator longIterator = this.f.subSet(packedSectionPos, packedSectionPos1 + 1L).iterator();
            while (longIterator.hasNext()) {
                EntitySection entitySection;
                long l2 = longIterator.nextLong();
                int sectionY = SectionPosition.c(l2);
                int sectionZ = SectionPosition.d(l2);
                if (sectionY < sectionPosCoord1 || sectionY > sectionPosCoord4 || sectionZ < sectionPosCoord2 || sectionZ > sectionPosCoord5 || (entitySection = (EntitySection)this.e.get(l2)) == null || entitySection.a() || !entitySection.c().b() || !consumer.accept(entitySection).a()) continue;
                return;
            }
        }
    }

    public LongStream a(long pos) {
        int z2;
        int x2 = ChunkCoordIntPair.a(pos);
        LongSortedSet chunkSections = this.a(x2, z2 = ChunkCoordIntPair.b(pos));
        if (chunkSections.isEmpty()) {
            return LongStream.empty();
        }
        LongBidirectionalIterator ofLong = chunkSections.iterator();
        return StreamSupport.longStream(Spliterators.spliteratorUnknownSize((PrimitiveIterator.OfLong)ofLong, 1301), false);
    }

    private LongSortedSet a(int x2, int z2) {
        long packedSectionPos = SectionPosition.b(x2, 0, z2);
        long packedSectionPos1 = SectionPosition.b(x2, -1, z2);
        return this.f.subSet(packedSectionPos, packedSectionPos1 + 1L);
    }

    public Stream<EntitySection<T>> b(long pos) {
        return this.a(pos).mapToObj(arg_0 -> this.e.get(arg_0)).filter(Objects::nonNull);
    }

    private static long f(long pos) {
        return ChunkCoordIntPair.c(SectionPosition.b(pos), SectionPosition.d(pos));
    }

    public EntitySection<T> c(long sectionPos) {
        return (EntitySection)this.e.computeIfAbsent(sectionPos, this::g);
    }

    @Nullable
    public EntitySection<T> d(long sectionPos) {
        return (EntitySection)this.e.get(sectionPos);
    }

    private EntitySection<T> g(long sectionPos) {
        long chunkKeyFromSectionKey = EntitySectionStorage.f(sectionPos);
        Visibility visibility = (Visibility)((Object)this.d.get(chunkKeyFromSectionKey));
        this.f.add(sectionPos);
        return new EntitySection<T>(this.c, visibility);
    }

    public LongSet a() {
        LongOpenHashSet set = new LongOpenHashSet();
        this.e.keySet().forEach(arg_0 -> EntitySectionStorage.a((LongSet)set, arg_0));
        return set;
    }

    public void b(AxisAlignedBB bounds, AbortableIterationConsumer<T> consumer) {
        this.a(bounds, section -> section.a(bounds, consumer));
    }

    public <U extends T> void a(EntityTypeTest<T, U> test, AxisAlignedBB bounds, AbortableIterationConsumer<U> consumer) {
        this.a(bounds, section -> section.a(test, bounds, consumer));
    }

    public void e(long sectionId) {
        this.e.remove(sectionId);
        this.f.remove(sectionId);
    }

    @VisibleForDebug
    public int b() {
        return this.f.size();
    }

    private static /* synthetic */ void a(LongSet set, long sectionId) {
        set.add(EntitySectionStorage.f(sectionId));
    }
}

