/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerHell;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.spigotmc.SpigotWorldConfig;

public class ChunkProviderFlat
extends ChunkGenerator {
    public static final MapCodec<ChunkProviderFlat> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GeneratorSettingsFlat.a.fieldOf("settings").forGetter(ChunkProviderFlat::h)).apply((Applicative)instance, instance.stable(ChunkProviderFlat::new)));
    private final GeneratorSettingsFlat d;

    public ChunkProviderFlat(GeneratorSettingsFlat settings) {
        this(settings, new WorldChunkManagerHell(settings.d()));
    }

    public ChunkProviderFlat(GeneratorSettingsFlat settings, WorldChunkManager biomeSource) {
        super(biomeSource, SystemUtils.b(settings::a));
        this.d = settings;
    }

    @Override
    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> structureSetLookup, RandomState randomState, long seed, SpigotWorldConfig conf) {
        Stream stream = this.d.c().map(HolderSet::a).orElseGet(() -> structureSetLookup.c().map(reference -> reference));
        return ChunkGeneratorStructureState.createForFlat(randomState, seed, this.b, stream, conf);
    }

    @Override
    protected MapCodec<? extends ChunkGenerator> b() {
        return c;
    }

    public GeneratorSettingsFlat h() {
        return this.d;
    }

    @Override
    public void a(RegionLimitedWorldAccess region, StructureManager structureManager, RandomState random, IChunkAccess chunk) {
    }

    @Override
    public int a(LevelHeightAccessor level) {
        return level.M_() + Math.min(level.N_(), this.d.f().size());
    }

    @Override
    public CompletableFuture<IChunkAccess> a(Blender blender, RandomState randomState, StructureManager structureManager, IChunkAccess chunk) {
        List<IBlockData> layers = this.d.f();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        HeightMap heightmapUnprimed = chunk.a(HeightMap.Type.c);
        HeightMap heightmapUnprimed1 = chunk.a(HeightMap.Type.a);
        for (int i2 = 0; i2 < Math.min(chunk.N_(), layers.size()); ++i2) {
            IBlockData blockState = layers.get(i2);
            if (blockState == null) continue;
            int i1 = chunk.M_() + i2;
            for (int i22 = 0; i22 < 16; ++i22) {
                for (int i3 = 0; i3 < 16; ++i3) {
                    chunk.a((BlockPosition)mutableBlockPos.d(i22, i1, i3), blockState);
                    heightmapUnprimed.a(i22, i1, i3, blockState);
                    heightmapUnprimed1.a(i22, i1, i3, blockState);
                }
            }
        }
        return CompletableFuture.completedFuture(chunk);
    }

    @Override
    public int a(int x2, int z2, HeightMap.Type type, LevelHeightAccessor level, RandomState random) {
        List<IBlockData> layers = this.d.f();
        for (int min = Math.min(layers.size() - 1, level.ar()); min >= 0; --min) {
            IBlockData blockState = layers.get(min);
            if (blockState == null || !type.e().test(blockState)) continue;
            return level.M_() + min + 1;
        }
        return level.M_();
    }

    @Override
    public BlockColumn a(int x2, int z2, LevelHeightAccessor height, RandomState random) {
        return new BlockColumn(height.M_(), (IBlockData[])this.d.f().stream().limit(height.N_()).map(state -> state == null ? Blocks.a.m() : state).toArray(IBlockData[]::new));
    }

    @Override
    public void a(List<String> info, RandomState random, BlockPosition pos) {
    }

    @Override
    public void a(RegionLimitedWorldAccess region, long seed, RandomState random, BiomeManager biomeManager, StructureManager structureManager, IChunkAccess chunk) {
    }

    @Override
    public void a(RegionLimitedWorldAccess region) {
    }

    @Override
    public int g() {
        return 0;
    }

    @Override
    public int e() {
        return 384;
    }

    @Override
    public int f() {
        return -63;
    }
}

