/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.state.IBlockData;

public abstract class Column {
    public static b a(int floor, int ceiling) {
        return new b(floor - 1, ceiling + 1);
    }

    public static b b(int floor, int ceiling) {
        return new b(floor, ceiling);
    }

    public static Column a(int ceiling) {
        return new c(ceiling, false);
    }

    public static Column b(int ceiling) {
        return new c(ceiling + 1, false);
    }

    public static Column c(int floor) {
        return new c(floor, true);
    }

    public static Column d(int floor) {
        return new c(floor - 1, true);
    }

    public static Column a() {
        return a.a;
    }

    public static Column a(OptionalInt floor, OptionalInt ceiling) {
        if (floor.isPresent() && ceiling.isPresent()) {
            return Column.b(floor.getAsInt(), ceiling.getAsInt());
        }
        if (floor.isPresent()) {
            return Column.c(floor.getAsInt());
        }
        return ceiling.isPresent() ? Column.a(ceiling.getAsInt()) : Column.a();
    }

    public abstract OptionalInt b();

    public abstract OptionalInt c();

    public abstract OptionalInt d();

    public Column a(OptionalInt floor) {
        return Column.a(floor, this.b());
    }

    public Column b(OptionalInt ceiling) {
        return Column.a(this.c(), ceiling);
    }

    public static Optional<Column> a(VirtualLevelReadable level, BlockPosition pos, int maxDistance, Predicate<IBlockData> columnPredicate, Predicate<IBlockData> tipPredicate) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        if (!level.a(pos, columnPredicate)) {
            return Optional.empty();
        }
        int y2 = pos.v();
        OptionalInt optionalInt = Column.a(level, maxDistance, columnPredicate, tipPredicate, mutableBlockPos, y2, EnumDirection.b);
        OptionalInt optionalInt1 = Column.a(level, maxDistance, columnPredicate, tipPredicate, mutableBlockPos, y2, EnumDirection.a);
        return Optional.of(Column.a(optionalInt1, optionalInt));
    }

    private static OptionalInt a(VirtualLevelReadable level, int maxDistance, Predicate<IBlockData> columnPredicate, Predicate<IBlockData> tipPredicate, BlockPosition.MutableBlockPosition mutablePos, int startY, EnumDirection direction) {
        mutablePos.q(startY);
        for (int i2 = 1; i2 < maxDistance && level.a((BlockPosition)mutablePos, columnPredicate); ++i2) {
            mutablePos.c(direction);
        }
        return level.a((BlockPosition)mutablePos, tipPredicate) ? OptionalInt.of(mutablePos.v()) : OptionalInt.empty();
    }

    public static final class b
    extends Column {
        private final int a;
        private final int b;

        protected b(int floor, int ceiling) {
            this.a = floor;
            this.b = ceiling;
            if (this.g() < 0) {
                throw new IllegalArgumentException("Column of negative height: " + String.valueOf(this));
            }
        }

        @Override
        public OptionalInt b() {
            return OptionalInt.of(this.b);
        }

        @Override
        public OptionalInt c() {
            return OptionalInt.of(this.a);
        }

        @Override
        public OptionalInt d() {
            return OptionalInt.of(this.g());
        }

        public int e() {
            return this.b;
        }

        public int f() {
            return this.a;
        }

        public int g() {
            return this.b - this.a - 1;
        }

        public String toString() {
            return "C(" + this.b + "-" + this.a + ")";
        }
    }

    public static final class c
    extends Column {
        private final int a;
        private final boolean b;

        public c(int edge, boolean pointingUp) {
            this.a = edge;
            this.b = pointingUp;
        }

        @Override
        public OptionalInt b() {
            return this.b ? OptionalInt.empty() : OptionalInt.of(this.a);
        }

        @Override
        public OptionalInt c() {
            return this.b ? OptionalInt.of(this.a) : OptionalInt.empty();
        }

        @Override
        public OptionalInt d() {
            return OptionalInt.empty();
        }

        public String toString() {
            return this.b ? "C(" + this.a + "-)" : "C(-" + this.a + ")";
        }
    }

    public static final class a
    extends Column {
        static final a a = new a();

        private a() {
        }

        @Override
        public OptionalInt b() {
            return OptionalInt.empty();
        }

        @Override
        public OptionalInt c() {
            return OptionalInt.empty();
        }

        @Override
        public OptionalInt d() {
            return OptionalInt.empty();
        }

        public String toString() {
            return "C(-)";
        }
    }
}

