/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.BoundedFloatFunction;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3Handler;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.purpurmc.purpur.PurpurConfig;
import org.slf4j.Logger;

public final class DensityFunctions {
    private static final Codec<DensityFunction> c = BuiltInRegistries.ae.q().dispatch(densityFunction -> densityFunction.c().a(), Function.identity());
    protected static final double a = 1000000.0;
    static final Codec<Double> d = Codec.doubleRange((double)-1000000.0, (double)1000000.0);
    public static final Codec<DensityFunction> b = Codec.either(d, c).xmap(either -> either.map(DensityFunctions::a, Function.identity()), densityFunction -> {
        Either<Object, DensityFunction> either;
        if (densityFunction instanceof h) {
            h constant = (h)densityFunction;
            either = Either.left(constant.k());
        } else {
            either = Either.right(densityFunction);
        }
        return either;
    });

    public static MapCodec<? extends DensityFunction> a(IRegistry<MapCodec<? extends DensityFunction>> registry) {
        DensityFunctions.a(registry, "blend_alpha", net.minecraft.world.level.levelgen.DensityFunctions$d.b);
        DensityFunctions.a(registry, "blend_offset", f.b);
        DensityFunctions.a(registry, "beardifier", net.minecraft.world.level.levelgen.DensityFunctions$b.f);
        DensityFunctions.a(registry, "old_blended_noise", BlendedNoise.a);
        for (m.a a2 : m.a.values()) {
            DensityFunctions.a(registry, a2.c(), a2.g);
        }
        DensityFunctions.a(registry, "noise", p.b);
        DensityFunctions.a(registry, "end_islands", i.a);
        DensityFunctions.a(registry, "weird_scaled_sampler", aa.a);
        DensityFunctions.a(registry, "shifted_noise", w.a);
        DensityFunctions.a(registry, "range_choice", r.b);
        DensityFunctions.a(registry, "shift_a", t.b);
        DensityFunctions.a(registry, "shift_b", u.b);
        DensityFunctions.a(registry, "shift", s.b);
        DensityFunctions.a(registry, "blend_density", e.b);
        DensityFunctions.a(registry, "clamp", g.a);
        for (Enum enum_ : l.a.values()) {
            DensityFunctions.a(registry, ((l.a)enum_).c(), ((l.a)enum_).i);
        }
        for (Enum enum_ : z.a.values()) {
            DensityFunctions.a(registry, ((z.a)enum_).c(), ((z.a)enum_).e);
        }
        DensityFunctions.a(registry, "spline", x.a);
        DensityFunctions.a(registry, "constant", h.b);
        DensityFunctions.a(registry, "y_clamped_gradient", ab.a);
        return DensityFunctions.a(registry, "find_top_surface", j.a);
    }

    private static MapCodec<? extends DensityFunction> a(IRegistry<MapCodec<? extends DensityFunction>> registry, String name, KeyDispatchDataCodec<? extends DensityFunction> codec) {
        return IRegistry.a(registry, name, codec.a());
    }

    static <A, O> KeyDispatchDataCodec<O> a(Codec<A> codec, Function<A, O> fromFunction, Function<O, A> toFunction) {
        return KeyDispatchDataCodec.a(codec.fieldOf("argument").xmap(fromFunction, toFunction));
    }

    static <O> KeyDispatchDataCodec<O> a(Function<DensityFunction, O> fromFunction, Function<O, DensityFunction> toFunction) {
        return DensityFunctions.a(DensityFunction.e, fromFunction, toFunction);
    }

    static <O> KeyDispatchDataCodec<O> a(BiFunction<DensityFunction, DensityFunction, O> fromFunction, Function<O, DensityFunction> primary, Function<O, DensityFunction> secondary) {
        return KeyDispatchDataCodec.a(RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.e.fieldOf("argument1").forGetter(primary), (App)DensityFunction.e.fieldOf("argument2").forGetter(secondary)).apply((Applicative)instance, fromFunction)));
    }

    static <O> KeyDispatchDataCodec<O> a(MapCodec<O> mapCodec) {
        return KeyDispatchDataCodec.a(mapCodec);
    }

    private DensityFunctions() {
    }

    public static DensityFunction a(DensityFunction wrapped) {
        return new m(m.a.a, wrapped);
    }

    public static DensityFunction b(DensityFunction wrapped) {
        return new m(m.a.b, wrapped);
    }

    public static DensityFunction c(DensityFunction wrapped) {
        return new m(m.a.c, wrapped);
    }

    public static DensityFunction d(DensityFunction wrapped) {
        return new m(m.a.d, wrapped);
    }

    public static DensityFunction e(DensityFunction wrapped) {
        return new m(m.a.e, wrapped);
    }

    public static DensityFunction a(Holder<NoiseGeneratorNormal.a> noiseData, @Deprecated double xzScale, double yScale, double fromY, double toY) {
        return DensityFunctions.a((DensityFunction)new p(new DensityFunction.c(noiseData), xzScale, yScale), fromY, toY);
    }

    public static DensityFunction a(Holder<NoiseGeneratorNormal.a> noiseData, double yScale, double fromY, double toY) {
        return DensityFunctions.a(noiseData, 1.0, yScale, fromY, toY);
    }

    public static DensityFunction a(Holder<NoiseGeneratorNormal.a> noiseData, double fromY, double toY) {
        return DensityFunctions.a(noiseData, 1.0, 1.0, fromY, toY);
    }

    public static DensityFunction a(DensityFunction shiftX, DensityFunction shiftZ, double xzScale, Holder<NoiseGeneratorNormal.a> noiseData) {
        return new w(shiftX, DensityFunctions.a(), shiftZ, xzScale, 0.0, new DensityFunction.c(noiseData));
    }

    public static DensityFunction a(Holder<NoiseGeneratorNormal.a> noiseData) {
        return DensityFunctions.b(noiseData, 1.0, 1.0);
    }

    public static DensityFunction b(Holder<NoiseGeneratorNormal.a> noiseData, double xzScale, double yScale) {
        return new p(new DensityFunction.c(noiseData), xzScale, yScale);
    }

    public static DensityFunction a(Holder<NoiseGeneratorNormal.a> noiseData, double yScale) {
        return DensityFunctions.b(noiseData, 1.0, yScale);
    }

    public static DensityFunction a(DensityFunction input, double minInclusive, double maxExclusive, DensityFunction whenInRange, DensityFunction whenOutOfRange) {
        return new r(input, minInclusive, maxExclusive, whenInRange, whenOutOfRange);
    }

    public static DensityFunction b(Holder<NoiseGeneratorNormal.a> noiseData) {
        return new t(new DensityFunction.c(noiseData));
    }

    public static DensityFunction c(Holder<NoiseGeneratorNormal.a> noiseData) {
        return new u(new DensityFunction.c(noiseData));
    }

    public static DensityFunction d(Holder<NoiseGeneratorNormal.a> noiseData) {
        return new s(new DensityFunction.c(noiseData));
    }

    public static DensityFunction f(DensityFunction input) {
        return new e(input);
    }

    public static DensityFunction a(long seed) {
        return new i(seed);
    }

    public static DensityFunction a(DensityFunction input, Holder<NoiseGeneratorNormal.a> noiseData, aa.a rarityValueMapper) {
        return new aa(input, new DensityFunction.c(noiseData), rarityValueMapper);
    }

    public static DensityFunction a(DensityFunction argument1, DensityFunction argument2) {
        return z.a(z.a.a, argument1, argument2);
    }

    public static DensityFunction b(DensityFunction argument1, DensityFunction argument2) {
        return z.a(z.a.b, argument1, argument2);
    }

    public static DensityFunction c(DensityFunction argument1, DensityFunction argument2) {
        return z.a(z.a.c, argument1, argument2);
    }

    public static DensityFunction d(DensityFunction argument1, DensityFunction argument2) {
        return z.a(z.a.d, argument1, argument2);
    }

    public static DensityFunction a(CubicSpline<x.b, x.a> spline) {
        return new x(spline);
    }

    public static DensityFunction a() {
        return h.f;
    }

    public static DensityFunction a(double value) {
        return new h(value);
    }

    public static DensityFunction a(int fromY, int toY, double fromValue, double toValue) {
        return new ab(fromY, toY, fromValue, toValue);
    }

    public static DensityFunction a(DensityFunction input, l.a type) {
        return l.a(type, input);
    }

    private static DensityFunction a(DensityFunction densityFunction, double fromY, double toY) {
        double d2 = (fromY + toY) * 0.5;
        double d1 = (toY - fromY) * 0.5;
        return DensityFunctions.a(DensityFunctions.a(d2), DensityFunctions.b(DensityFunctions.a(d1), densityFunction));
    }

    public static DensityFunction b() {
        return net.minecraft.world.level.levelgen.DensityFunctions$d.a;
    }

    public static DensityFunction c() {
        return f.a;
    }

    public static DensityFunction a(DensityFunction deltaFunction, DensityFunction minFunction, DensityFunction maxFunction) {
        if (minFunction instanceof h) {
            h constant = (h)minFunction;
            return DensityFunctions.a(deltaFunction, constant.a, maxFunction);
        }
        DensityFunction densityFunction = DensityFunctions.d(deltaFunction);
        DensityFunction densityFunction1 = DensityFunctions.a(DensityFunctions.b(densityFunction, DensityFunctions.a(-1.0)), DensityFunctions.a(1.0));
        return DensityFunctions.a(DensityFunctions.b(minFunction, densityFunction1), DensityFunctions.b(maxFunction, densityFunction));
    }

    public static DensityFunction a(DensityFunction deltaFunction, double min, DensityFunction maxFunction) {
        return DensityFunctions.a(DensityFunctions.b(deltaFunction, DensityFunctions.a(maxFunction, DensityFunctions.a(-min))), DensityFunctions.a(min));
    }

    public static DensityFunction a(DensityFunction density, DensityFunction upperBound, int lowerBound, int cellHeight) {
        return new j(density, upperBound, lowerBound, cellHeight);
    }

    protected static final class d
    extends Enum<d>
    implements DensityFunction.d {
        public static final /* enum */ d a = new d();
        public static final KeyDispatchDataCodec<DensityFunction> b;
        private static final /* synthetic */ d[] f;

        public static d[] values() {
            return (d[])f.clone();
        }

        public static d valueOf(String name) {
            return Enum.valueOf(d.class, name);
        }

        @Override
        public double a(DensityFunction.b context) {
            return 1.0;
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            Arrays.fill(array, 1.0);
        }

        @Override
        public double a() {
            return 1.0;
        }

        @Override
        public double b() {
            return 1.0;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return b;
        }

        private static /* synthetic */ d[] k() {
            return new d[]{a};
        }

        static {
            f = net.minecraft.world.level.levelgen.DensityFunctions$d.k();
            b = KeyDispatchDataCodec.a(MapCodec.unit((Object)a));
        }
    }

    protected static final class f
    extends Enum<f>
    implements DensityFunction.d {
        public static final /* enum */ f a = new f();
        public static final KeyDispatchDataCodec<DensityFunction> b;
        private static final /* synthetic */ f[] f;

        public static f[] values() {
            return (f[])f.clone();
        }

        public static f valueOf(String name) {
            return Enum.valueOf(f.class, name);
        }

        @Override
        public double a(DensityFunction.b context) {
            return 0.0;
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            Arrays.fill(array, 0.0);
        }

        @Override
        public double a() {
            return 0.0;
        }

        @Override
        public double b() {
            return 0.0;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return b;
        }

        private static /* synthetic */ f[] k() {
            return new f[]{a};
        }

        static {
            f = net.minecraft.world.level.levelgen.DensityFunctions$f.k();
            b = KeyDispatchDataCodec.a(MapCodec.unit((Object)a));
        }
    }

    protected static final class b
    extends Enum<b>
    implements c {
        public static final /* enum */ b a = new b();
        private static final /* synthetic */ b[] b;

        public static b[] values() {
            return (b[])b.clone();
        }

        public static b valueOf(String name) {
            return Enum.valueOf(b.class, name);
        }

        @Override
        public double a(DensityFunction.b context) {
            return 0.0;
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            Arrays.fill(array, 0.0);
        }

        @Override
        public double a() {
            return 0.0;
        }

        @Override
        public double b() {
            return 0.0;
        }

        private static /* synthetic */ b[] k() {
            return new b[]{a};
        }

        static {
            b = net.minecraft.world.level.levelgen.DensityFunctions$b.k();
        }
    }

    protected record m(a a, DensityFunction b) implements n
    {
        private final a a;
        private final DensityFunction b;

        @Override
        public double a(DensityFunction.b context) {
            return this.b.a(context);
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            this.b.a(array, contextProvider);
        }

        @Override
        public double a() {
            return this.b.a();
        }

        @Override
        public double b() {
            return this.b.b();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{m.class, "type;wrapped", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{m.class, "type;wrapped", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{m.class, "type;wrapped", "a", "b"}, this, o2);
        }

        @Override
        public a k() {
            return this.a;
        }

        @Override
        public DensityFunction l() {
            return this.b;
        }

        static final class a
        extends Enum<a>
        implements INamable {
            public static final /* enum */ a a = new a("interpolated");
            public static final /* enum */ a b = new a("flat_cache");
            public static final /* enum */ a c = new a("cache_2d");
            public static final /* enum */ a d = new a("cache_once");
            public static final /* enum */ a e = new a("cache_all_in_cell");
            private final String f;
            final KeyDispatchDataCodec<n> g = DensityFunctions.a((DensityFunction function) -> new m(this, (DensityFunction)function), n::l);
            private static final /* synthetic */ a[] h;

            public static a[] values() {
                return (a[])h.clone();
            }

            public static a valueOf(String name) {
                return Enum.valueOf(a.class, name);
            }

            private a(String name) {
                this.f = name;
            }

            @Override
            public String c() {
                return this.f;
            }

            private static /* synthetic */ a[] a() {
                return new a[]{a, b, c, d, e};
            }

            static {
                h = net.minecraft.world.level.levelgen.DensityFunctions$m$a.a();
            }
        }
    }

    protected static final class p
    extends Record
    implements DensityFunction {
        private final DensityFunction.c f;
        @Deprecated
        private final double g;
        private final double h;
        public static final MapCodec<p> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.c.a.fieldOf("noise").forGetter(p::k), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(p::l), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(p::m)).apply((Applicative)instance, p::new));
        public static final KeyDispatchDataCodec<p> b = KeyDispatchDataCodec.a(a);

        protected p(DensityFunction.c noise, @Deprecated double xzScale, double yScale) {
            this.f = noise;
            this.g = xzScale;
            this.h = yScale;
        }

        @Override
        public double a(DensityFunction.b context) {
            return this.f.a((double)context.a() * this.g, (double)context.b() * this.h, (double)context.c() * this.g);
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            contextProvider.a(array, this);
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new p(visitor.a(this.f), this.g, this.h));
        }

        @Override
        public double a() {
            return -this.b();
        }

        @Override
        public double b() {
            return this.f.a();
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return b;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{p.class, "noise;xzScale;yScale", "f", "g", "h"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{p.class, "noise;xzScale;yScale", "f", "g", "h"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{p.class, "noise;xzScale;yScale", "f", "g", "h"}, this, o2);
        }

        public DensityFunction.c k() {
            return this.f;
        }

        @Deprecated
        public double l() {
            return this.g;
        }

        public double m() {
            return this.h;
        }
    }

    protected static final class i
    implements DensityFunction.d {
        public static final KeyDispatchDataCodec<i> a = KeyDispatchDataCodec.a(MapCodec.unit((Object)new i(0L)));
        private static final float b = -0.9f;
        private final NoiseGenerator3Handler f;
        private static final ThreadLocal<Map<NoiseGenerator3Handler, NoiseCache>> noiseCache = ThreadLocal.withInitial(WeakHashMap::new);

        public i(long seed) {
            LegacyRandomSource randomSource = new LegacyRandomSource(seed);
            randomSource.b(17292);
            this.f = new NoiseGenerator3Handler(randomSource);
        }

        private static float a(NoiseGenerator3Handler noise, int x2, int z2) {
            int i2 = x2 / 2;
            int i1 = z2 / 2;
            int i22 = x2 % 2;
            int i3 = z2 % 2;
            float f2 = 100.0f - MathHelper.c(PurpurConfig.generateEndVoidRings ? (float)(x2 * x2 + z2 * z2) : (float)((long)x2 * (long)x2 + (long)z2 * (long)z2)) * 8.0f;
            f2 = MathHelper.a(f2, -100.0f, 80.0f);
            NoiseCache cache = noiseCache.get().computeIfAbsent(noise, noiseKey -> new NoiseCache());
            for (int i4 = -12; i4 <= 12; ++i4) {
                for (int i5 = -12; i5 <= 12; ++i5) {
                    long l2 = i2 + i4;
                    int chunkX = (int)l2;
                    long l1 = i1 + i5;
                    int chunkZ = (int)l1;
                    long chunkKey = ChunkCoordIntPair.c(chunkX, chunkZ);
                    int cacheIndex = (int)HashCommon.mix((long)chunkKey) & 0x1FFF;
                    float f1 = Float.MIN_VALUE;
                    if (cache.keys[cacheIndex] == chunkKey) {
                        f1 = cache.values[cacheIndex];
                    } else {
                        if (l2 * l2 + l1 * l1 > 4096L && noise.a(l2, l1) < (double)-0.9f) {
                            f1 = (MathHelper.e(l2) * 3439.0f + MathHelper.e(l1) * 147.0f) % 13.0f + 9.0f;
                        }
                        cache.keys[cacheIndex] = chunkKey;
                        cache.values[cacheIndex] = f1;
                    }
                    if (f1 == Float.MIN_VALUE) continue;
                    float f22 = i22 - i4 * 2;
                    float f3 = i3 - i5 * 2;
                    float f4 = 100.0f - MathHelper.c(f22 * f22 + f3 * f3) * f1;
                    f4 = MathHelper.a(f4, -100.0f, 80.0f);
                    f2 = Math.max(f2, f4);
                }
            }
            return f2;
        }

        @Override
        public double a(DensityFunction.b context) {
            return ((double)i.a(this.f, context.a() / 8, context.c() / 8) - 8.0) / 128.0;
        }

        @Override
        public double a() {
            return -0.84375;
        }

        @Override
        public double b() {
            return 0.5625;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return a;
        }

        private static final class NoiseCache {
            public long[] keys = new long[8192];
            public float[] values = new float[8192];

            public NoiseCache() {
                Arrays.fill(this.keys, Long.MIN_VALUE);
            }
        }
    }

    protected static final class aa
    extends Record
    implements y {
        private final DensityFunction b;
        private final DensityFunction.c f;
        private final a g;
        private static final MapCodec<aa> h = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.e.fieldOf("input").forGetter(aa::k), (App)DensityFunction.c.a.fieldOf("noise").forGetter(aa::l), (App)a.c.fieldOf("rarity_value_mapper").forGetter(aa::m)).apply((Applicative)instance, aa::new));
        public static final KeyDispatchDataCodec<aa> a = KeyDispatchDataCodec.a(h);

        protected aa(DensityFunction input, DensityFunction.c noise, a rarityValueMapper) {
            this.b = input;
            this.f = noise;
            this.g = rarityValueMapper;
        }

        @Override
        public double a(DensityFunction.b context, double value) {
            double d2 = this.g.e.get(value);
            return d2 * Math.abs(this.f.a((double)context.a() / d2, (double)context.b() / d2, (double)context.c() / d2));
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new aa(this.b.a(visitor), visitor.a(this.f), this.g));
        }

        @Override
        public double a() {
            return 0.0;
        }

        @Override
        public double b() {
            return this.g.f * this.f.a();
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return a;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{aa.class, "input;noise;rarityValueMapper", "b", "f", "g"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{aa.class, "input;noise;rarityValueMapper", "b", "f", "g"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{aa.class, "input;noise;rarityValueMapper", "b", "f", "g"}, this, o2);
        }

        @Override
        public DensityFunction k() {
            return this.b;
        }

        public DensityFunction.c l() {
            return this.f;
        }

        public a m() {
            return this.g;
        }

        public static final class a
        extends Enum<a>
        implements INamable {
            public static final /* enum */ a a = new a("type_1", NoiseRouterData.a::b, 2.0);
            public static final /* enum */ a b = new a("type_2", NoiseRouterData.a::a, 3.0);
            public static final Codec<a> c;
            private final String d;
            final Double2DoubleFunction e;
            final double f;
            private static final /* synthetic */ a[] g;

            public static a[] values() {
                return (a[])g.clone();
            }

            public static a valueOf(String name) {
                return Enum.valueOf(a.class, name);
            }

            private a(String name, Double2DoubleFunction mapper, double maxRarity) {
                this.d = name;
                this.e = mapper;
                this.f = maxRarity;
            }

            @Override
            public String c() {
                return this.d;
            }

            private static /* synthetic */ a[] a() {
                return new a[]{a, b};
            }

            static {
                g = net.minecraft.world.level.levelgen.DensityFunctions$aa$a.a();
                c = INamable.a(a::values);
            }
        }
    }

    protected static final class w
    extends Record
    implements DensityFunction {
        private final DensityFunction b;
        private final DensityFunction f;
        private final DensityFunction g;
        private final double h;
        private final double i;
        private final DensityFunction.c j;
        private static final MapCodec<w> k = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.e.fieldOf("shift_x").forGetter(w::k), (App)DensityFunction.e.fieldOf("shift_y").forGetter(w::l), (App)DensityFunction.e.fieldOf("shift_z").forGetter(w::m), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(w::n), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(w::o), (App)DensityFunction.c.a.fieldOf("noise").forGetter(w::p)).apply((Applicative)instance, w::new));
        public static final KeyDispatchDataCodec<w> a = KeyDispatchDataCodec.a(k);

        protected w(DensityFunction shiftX, DensityFunction shiftY, DensityFunction shiftZ, double xzScale, double yScale, DensityFunction.c noise) {
            this.b = shiftX;
            this.f = shiftY;
            this.g = shiftZ;
            this.h = xzScale;
            this.i = yScale;
            this.j = noise;
        }

        @Override
        public double a(DensityFunction.b context) {
            double d2 = (double)context.a() * this.h + this.b.a(context);
            double d1 = (double)context.b() * this.i + this.f.a(context);
            double d22 = (double)context.c() * this.h + this.g.a(context);
            return this.j.a(d2, d1, d22);
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            contextProvider.a(array, this);
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new w(this.b.a(visitor), this.f.a(visitor), this.g.a(visitor), this.h, this.i, visitor.a(this.j)));
        }

        @Override
        public double a() {
            return -this.b();
        }

        @Override
        public double b() {
            return this.j.a();
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return a;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{w.class, "shiftX;shiftY;shiftZ;xzScale;yScale;noise", "b", "f", "g", "h", "i", "j"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{w.class, "shiftX;shiftY;shiftZ;xzScale;yScale;noise", "b", "f", "g", "h", "i", "j"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{w.class, "shiftX;shiftY;shiftZ;xzScale;yScale;noise", "b", "f", "g", "h", "i", "j"}, this, o2);
        }

        public DensityFunction k() {
            return this.b;
        }

        public DensityFunction l() {
            return this.f;
        }

        public DensityFunction m() {
            return this.g;
        }

        public double n() {
            return this.h;
        }

        public double o() {
            return this.i;
        }

        public DensityFunction.c p() {
            return this.j;
        }
    }

    static final class r
    extends Record
    implements DensityFunction {
        private final DensityFunction f;
        private final double g;
        private final double h;
        private final DensityFunction i;
        private final DensityFunction j;
        public static final MapCodec<r> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.e.fieldOf("input").forGetter(r::k), (App)d.fieldOf("min_inclusive").forGetter(r::l), (App)d.fieldOf("max_exclusive").forGetter(r::m), (App)DensityFunction.e.fieldOf("when_in_range").forGetter(r::n), (App)DensityFunction.e.fieldOf("when_out_of_range").forGetter(r::o)).apply((Applicative)instance, r::new));
        public static final KeyDispatchDataCodec<r> b = KeyDispatchDataCodec.a(a);

        r(DensityFunction input, double minInclusive, double maxExclusive, DensityFunction whenInRange, DensityFunction whenOutOfRange) {
            this.f = input;
            this.g = minInclusive;
            this.h = maxExclusive;
            this.i = whenInRange;
            this.j = whenOutOfRange;
        }

        @Override
        public double a(DensityFunction.b context) {
            double d2 = this.f.a(context);
            return d2 >= this.g && d2 < this.h ? this.i.a(context) : this.j.a(context);
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            this.f.a(array, contextProvider);
            for (int i2 = 0; i2 < array.length; ++i2) {
                double d2 = array[i2];
                array[i2] = d2 >= this.g && d2 < this.h ? this.i.a(contextProvider.a(i2)) : this.j.a(contextProvider.a(i2));
            }
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new r(this.f.a(visitor), this.g, this.h, this.i.a(visitor), this.j.a(visitor)));
        }

        @Override
        public double a() {
            return Math.min(this.i.a(), this.j.a());
        }

        @Override
        public double b() {
            return Math.max(this.i.b(), this.j.b());
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return b;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{r.class, "input;minInclusive;maxExclusive;whenInRange;whenOutOfRange", "f", "g", "h", "i", "j"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{r.class, "input;minInclusive;maxExclusive;whenInRange;whenOutOfRange", "f", "g", "h", "i", "j"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{r.class, "input;minInclusive;maxExclusive;whenInRange;whenOutOfRange", "f", "g", "h", "i", "j"}, this, o2);
        }

        public DensityFunction k() {
            return this.f;
        }

        public double l() {
            return this.g;
        }

        public double m() {
            return this.h;
        }

        public DensityFunction n() {
            return this.i;
        }

        public DensityFunction o() {
            return this.j;
        }
    }

    protected static final class t
    extends Record
    implements v {
        private final DensityFunction.c a;
        static final KeyDispatchDataCodec<t> b = DensityFunctions.a(DensityFunction.c.a, t::new, t::k);

        protected t(DensityFunction.c offsetNoise) {
            this.a = offsetNoise;
        }

        @Override
        public double a(DensityFunction.b context) {
            return this.a(context.a(), 0.0, context.c());
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new t(visitor.a(this.a)));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return b;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{t.class, "offsetNoise", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{t.class, "offsetNoise", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{t.class, "offsetNoise", "a"}, this, o2);
        }

        @Override
        public DensityFunction.c k() {
            return this.a;
        }
    }

    protected static final class u
    extends Record
    implements v {
        private final DensityFunction.c a;
        static final KeyDispatchDataCodec<u> b = DensityFunctions.a(DensityFunction.c.a, u::new, u::k);

        protected u(DensityFunction.c offsetNoise) {
            this.a = offsetNoise;
        }

        @Override
        public double a(DensityFunction.b context) {
            return this.a(context.c(), context.a(), 0.0);
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new u(visitor.a(this.a)));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return b;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{u.class, "offsetNoise", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{u.class, "offsetNoise", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{u.class, "offsetNoise", "a"}, this, o2);
        }

        @Override
        public DensityFunction.c k() {
            return this.a;
        }
    }

    protected static final class s
    extends Record
    implements v {
        private final DensityFunction.c a;
        static final KeyDispatchDataCodec<s> b = DensityFunctions.a(DensityFunction.c.a, s::new, s::k);

        protected s(DensityFunction.c offsetNoise) {
            this.a = offsetNoise;
        }

        @Override
        public double a(DensityFunction.b context) {
            return this.a(context.a(), context.b(), context.c());
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new s(visitor.a(this.a)));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return b;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{s.class, "offsetNoise", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{s.class, "offsetNoise", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{s.class, "offsetNoise", "a"}, this, o2);
        }

        @Override
        public DensityFunction.c k() {
            return this.a;
        }
    }

    record e(DensityFunction a) implements y
    {
        private final DensityFunction a;
        static final KeyDispatchDataCodec<e> b = DensityFunctions.a(e::new, e::k);

        @Override
        public double a(DensityFunction.b context, double value) {
            return context.d().a(context, value);
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new e(this.a.a(visitor)));
        }

        @Override
        public double a() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public double b() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return b;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "input", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "input", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "input", "a"}, this, o2);
        }

        @Override
        public DensityFunction k() {
            return this.a;
        }
    }

    protected static final class g
    extends Record
    implements q {
        private final DensityFunction b;
        private final double f;
        private final double g;
        private static final MapCodec<g> h = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.c.fieldOf("input").forGetter(g::aG_), (App)d.fieldOf("min").forGetter(g::a), (App)d.fieldOf("max").forGetter(g::b)).apply((Applicative)instance, g::new));
        public static final KeyDispatchDataCodec<g> a = KeyDispatchDataCodec.a(h);

        protected g(DensityFunction input, double minValue, double maxValue) {
            this.b = input;
            this.f = minValue;
            this.g = maxValue;
        }

        @Override
        public double a(double value) {
            return MathHelper.a(value, this.f, this.g);
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return new g(this.b.a(visitor), this.f, this.g);
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return a;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{g.class, "input;minValue;maxValue", "b", "f", "g"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{g.class, "input;minValue;maxValue", "b", "f", "g"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{g.class, "input;minValue;maxValue", "b", "f", "g"}, this, o2);
        }

        @Override
        public DensityFunction aG_() {
            return this.b;
        }

        @Override
        public double a() {
            return this.f;
        }

        @Override
        public double b() {
            return this.g;
        }
    }

    protected static final class l
    extends Record
    implements q {
        private final a a;
        private final DensityFunction b;
        private final double f;
        private final double g;

        protected l(a type, DensityFunction input, double minValue, double maxValue) {
            this.a = type;
            this.b = input;
            this.f = minValue;
            this.g = maxValue;
        }

        public static l a(a type, DensityFunction input) {
            double d2 = input.a();
            double d1 = input.b();
            double d22 = l.a(type, d2);
            double d3 = l.a(type, d1);
            if (type == a.f) {
                return d2 < 0.0 && d1 > 0.0 ? new l(type, input, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY) : new l(type, input, d3, d22);
            }
            return type != a.a && type != a.b ? new l(type, input, d22, d3) : new l(type, input, Math.max(0.0, d2), Math.max(d22, d3));
        }

        private static double a(a type, double value) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Math.abs(value);
                case 1 -> value * value;
                case 2 -> value * value * value;
                case 3 -> {
                    if (value > 0.0) {
                        yield value;
                    }
                    yield value * 0.5;
                }
                case 4 -> {
                    if (value > 0.0) {
                        yield value;
                    }
                    yield value * 0.25;
                }
                case 5 -> 1.0 / value;
                case 6 -> {
                    double d = MathHelper.a(value, -1.0, 1.0);
                    yield d / 2.0 - d * d * d / 24.0;
                }
            };
        }

        @Override
        public double a(double value) {
            return l.a(this.a, value);
        }

        public l b(DensityFunction.f visitor) {
            return l.a(this.a, this.b.a(visitor));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return this.a.i;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{l.class, "type;input;minValue;maxValue", "a", "b", "f", "g"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{l.class, "type;input;minValue;maxValue", "a", "b", "f", "g"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{l.class, "type;input;minValue;maxValue", "a", "b", "f", "g"}, this, o2);
        }

        public a l() {
            return this.a;
        }

        @Override
        public DensityFunction aG_() {
            return this.b;
        }

        @Override
        public double a() {
            return this.f;
        }

        @Override
        public double b() {
            return this.g;
        }

        static final class a
        extends Enum<a>
        implements INamable {
            public static final /* enum */ a a = new a("abs");
            public static final /* enum */ a b = new a("square");
            public static final /* enum */ a c = new a("cube");
            public static final /* enum */ a d = new a("half_negative");
            public static final /* enum */ a e = new a("quarter_negative");
            public static final /* enum */ a f = new a("invert");
            public static final /* enum */ a g = new a("squeeze");
            private final String h;
            final KeyDispatchDataCodec<l> i = DensityFunctions.a((DensityFunction input) -> l.a(this, input), l::aG_);
            private static final /* synthetic */ a[] j;

            public static a[] values() {
                return (a[])j.clone();
            }

            public static a valueOf(String name) {
                return Enum.valueOf(a.class, name);
            }

            private a(String name) {
                this.h = name;
            }

            @Override
            public String c() {
                return this.h;
            }

            private static /* synthetic */ a[] a() {
                return new a[]{a, b, c, d, e, f, g};
            }

            static {
                j = net.minecraft.world.level.levelgen.DensityFunctions$l$a.a();
            }
        }
    }

    static interface z
    extends DensityFunction {
        public static final Logger a = LogUtils.getLogger();

        public static z a(a type, DensityFunction argument1, DensityFunction argument2) {
            double d5;
            double d2 = argument1.a();
            double d1 = argument2.a();
            double d22 = argument1.b();
            double d3 = argument2.b();
            if (type == a.c || type == a.d) {
                boolean flag1;
                boolean flag = d2 >= d3;
                boolean bl = flag1 = d1 >= d22;
                if (flag || flag1) {
                    a.warn("Creating a {} function between two non-overlapping inputs: {} and {}", new Object[]{type, argument1, argument2});
                }
            }
            double d4 = switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> d2 + d1;
                case 1 -> {
                    if (d2 > 0.0 && d1 > 0.0) {
                        yield d2 * d1;
                    }
                    if (d22 < 0.0 && d3 < 0.0) {
                        yield d22 * d3;
                    }
                    yield Math.min(d2 * d3, d22 * d1);
                }
                case 2 -> Math.min(d2, d1);
                case 3 -> Math.max(d2, d1);
            };
            switch (type.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    double d6 = d22 + d3;
                    break;
                }
                case 1: {
                    double d6;
                    if (d2 > 0.0 && d1 > 0.0) {
                        d6 = d22 * d3;
                        break;
                    }
                    if (d22 < 0.0 && d3 < 0.0) {
                        d6 = d2 * d1;
                        break;
                    }
                    d6 = Math.max(d2 * d1, d22 * d3);
                    break;
                }
                case 2: {
                    double d6 = Math.min(d22, d3);
                    break;
                }
                case 3: {
                    double d6 = d5 = Math.max(d22, d3);
                }
            }
            if (type == a.b || type == a.a) {
                if (argument1 instanceof h) {
                    h constant = (h)argument1;
                    return new o(type == a.a ? o.a.b : o.a.a, argument2, d4, d5, constant.a);
                }
                if (argument2 instanceof h) {
                    h constant = (h)argument2;
                    return new o(type == a.a ? o.a.b : o.a.a, argument1, d4, d5, constant.a);
                }
            }
            return new net.minecraft.world.level.levelgen.DensityFunctions$a(type, argument1, argument2, d4, d5);
        }

        public a k();

        public DensityFunction l();

        public DensityFunction m();

        @Override
        default public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return this.k().e;
        }

        public static final class a
        extends Enum<a>
        implements INamable {
            public static final /* enum */ a a = new a("add");
            public static final /* enum */ a b = new a("mul");
            public static final /* enum */ a c = new a("min");
            public static final /* enum */ a d = new a("max");
            final KeyDispatchDataCodec<z> e = DensityFunctions.a((from, to) -> z.a(this, from, to), z::l, z::m);
            private final String f;
            private static final /* synthetic */ a[] g;

            public static a[] values() {
                return (a[])g.clone();
            }

            public static a valueOf(String name) {
                return Enum.valueOf(a.class, name);
            }

            private a(String name) {
                this.f = name;
            }

            @Override
            public String c() {
                return this.f;
            }

            private static /* synthetic */ a[] a() {
                return new a[]{a, b, c, d};
            }

            static {
                g = net.minecraft.world.level.levelgen.DensityFunctions$z$a.a();
            }
        }
    }

    public record x(CubicSpline<b, a> b) implements DensityFunction
    {
        private final CubicSpline<b, a> b;
        private static final Codec<CubicSpline<b, a>> f = CubicSpline.a(a.b);
        private static final MapCodec<x> g = f.fieldOf("spline").xmap(x::new, x::k);
        public static final KeyDispatchDataCodec<x> a = KeyDispatchDataCodec.a(g);

        @Override
        public double a(DensityFunction.b context) {
            return this.b.a(new b(context));
        }

        @Override
        public double a() {
            return this.b.a();
        }

        @Override
        public double b() {
            return this.b.b();
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            contextProvider.a(array, this);
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new x(this.b.a((I coordinate) -> coordinate.a(visitor))));
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return a;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{x.class, "spline", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{x.class, "spline", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{x.class, "spline", "b"}, this, o2);
        }

        public CubicSpline<b, a> k() {
            return this.b;
        }

        public record b(DensityFunction.b a) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "context", "a"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "context", "a"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "context", "a"}, this, o2);
            }
        }

        public record a(Holder<DensityFunction> c) implements BoundedFloatFunction<b>
        {
            public static final Codec<a> b = DensityFunction.d.xmap(a::new, a::c);

            @Override
            public String toString() {
                Optional<ResourceKey<DensityFunction>> optional = this.c.e();
                if (optional.isPresent()) {
                    ResourceKey<DensityFunction> resourceKey = optional.get();
                    if (resourceKey == NoiseRouterData.e) {
                        return "continents";
                    }
                    if (resourceKey == NoiseRouterData.f) {
                        return "erosion";
                    }
                    if (resourceKey == NoiseRouterData.g) {
                        return "weirdness";
                    }
                    if (resourceKey == NoiseRouterData.h) {
                        return "ridges";
                    }
                }
                return "Coordinate[" + String.valueOf(this.c) + "]";
            }

            @Override
            public float a(b value) {
                return (float)this.c.a().a(value.a());
            }

            @Override
            public float a() {
                return this.c.b() ? (float)this.c.a().a() : Float.NEGATIVE_INFINITY;
            }

            @Override
            public float b() {
                return this.c.b() ? (float)this.c.a().b() : Float.POSITIVE_INFINITY;
            }

            public a a(DensityFunction.f visitor) {
                return new a(new Holder.a<DensityFunction>(this.c.a().a(visitor)));
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "function", "c"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "function", "c"}, this, o2);
            }
        }
    }

    record h(double a) implements DensityFunction.d
    {
        static final KeyDispatchDataCodec<h> b = DensityFunctions.a(d, h::new, h::k);
        static final h f = new h(0.0);

        @Override
        public double a(DensityFunction.b context) {
            return this.a;
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            Arrays.fill(array, this.a);
        }

        @Override
        public double b() {
            return this.a;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return b;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "value", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "value", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "value", "a"}, this, o2);
        }

        public double k() {
            return this.a;
        }
    }

    static final class ab
    extends Record
    implements DensityFunction.d {
        private final int b;
        private final int f;
        private final double g;
        private final double h;
        private static final MapCodec<ab> i = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)-4064, (int)4062).fieldOf("from_y").forGetter(ab::k), (App)Codec.intRange((int)-4064, (int)4062).fieldOf("to_y").forGetter(ab::l), (App)d.fieldOf("from_value").forGetter(ab::m), (App)d.fieldOf("to_value").forGetter(ab::n)).apply((Applicative)instance, ab::new));
        public static final KeyDispatchDataCodec<ab> a = KeyDispatchDataCodec.a(i);

        ab(int fromY, int toY, double fromValue, double toValue) {
            this.b = fromY;
            this.f = toY;
            this.g = fromValue;
            this.h = toValue;
        }

        @Override
        public double a(DensityFunction.b context) {
            return MathHelper.a((double)context.b(), (double)this.b, (double)this.f, this.g, this.h);
        }

        @Override
        public double a() {
            return Math.min(this.g, this.h);
        }

        @Override
        public double b() {
            return Math.max(this.g, this.h);
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return a;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ab.class, "fromY;toY;fromValue;toValue", "b", "f", "g", "h"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ab.class, "fromY;toY;fromValue;toValue", "b", "f", "g", "h"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ab.class, "fromY;toY;fromValue;toValue", "b", "f", "g", "h"}, this, o2);
        }

        public int k() {
            return this.b;
        }

        public int l() {
            return this.f;
        }

        public double m() {
            return this.g;
        }

        public double n() {
            return this.h;
        }
    }

    static final class j
    extends Record
    implements DensityFunction {
        private final DensityFunction b;
        private final DensityFunction f;
        private final int g;
        private final int h;
        private static final MapCodec<j> i = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.e.fieldOf("density").forGetter(j::k), (App)DensityFunction.e.fieldOf("upper_bound").forGetter(j::l), (App)Codec.intRange((int)-4064, (int)4062).fieldOf("lower_bound").forGetter(j::m), (App)ExtraCodecs.p.fieldOf("cell_height").forGetter(j::n)).apply((Applicative)instance, j::new));
        public static final KeyDispatchDataCodec<j> a = KeyDispatchDataCodec.a(i);

        j(DensityFunction density, DensityFunction upperBound, int lowerBound, int cellHeight) {
            this.b = density;
            this.f = upperBound;
            this.g = lowerBound;
            this.h = cellHeight;
        }

        @Override
        public double a(DensityFunction.b context) {
            int i2 = MathHelper.a(this.f.a(context) / (double)this.h) * this.h;
            if (i2 <= this.g) {
                return this.g;
            }
            for (int i1 = i2; i1 >= this.g; i1 -= this.h) {
                DensityFunction.e e2 = new DensityFunction.e(context.a(), i1, context.c());
                if (!(this.b.a(e2) > 0.0)) continue;
                return i1;
            }
            return this.g;
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            contextProvider.a(array, this);
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new j(this.b.a(visitor), this.f.a(visitor), this.g, this.h));
        }

        @Override
        public double a() {
            return this.g;
        }

        @Override
        public double b() {
            return Math.max((double)this.g, this.f.b());
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return a;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{j.class, "density;upperBound;lowerBound;cellHeight", "b", "f", "g", "h"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{j.class, "density;upperBound;lowerBound;cellHeight", "b", "f", "g", "h"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{j.class, "density;upperBound;lowerBound;cellHeight", "b", "f", "g", "h"}, this, o2);
        }

        public DensityFunction k() {
            return this.b;
        }

        public DensityFunction l() {
            return this.f;
        }

        public int m() {
            return this.g;
        }

        public int n() {
            return this.h;
        }
    }

    static interface y
    extends DensityFunction {
        public DensityFunction k();

        @Override
        default public double a(DensityFunction.b context) {
            return this.a(context, this.k().a(context));
        }

        @Override
        default public void a(double[] array, DensityFunction.a contextProvider) {
            this.k().a(array, contextProvider);
            for (int i2 = 0; i2 < array.length; ++i2) {
                array[i2] = this.a(contextProvider.a(i2), array[i2]);
            }
        }

        public double a(DensityFunction.b var1, double var2);
    }

    static interface v
    extends DensityFunction {
        public DensityFunction.c k();

        @Override
        default public double a() {
            return -this.b();
        }

        @Override
        default public double b() {
            return this.k().a() * 4.0;
        }

        default public double a(double x2, double y2, double z2) {
            return this.k().a(x2 * 0.25, y2 * 0.25, z2 * 0.25) * 4.0;
        }

        @Override
        default public void a(double[] array, DensityFunction.a contextProvider) {
            contextProvider.a(array, this);
        }
    }

    static interface q
    extends DensityFunction {
        public DensityFunction aG_();

        @Override
        default public double a(DensityFunction.b context) {
            return this.a(this.aG_().a(context));
        }

        @Override
        default public void a(double[] array, DensityFunction.a contextProvider) {
            this.aG_().a(array, contextProvider);
            for (int i2 = 0; i2 < array.length; ++i2) {
                array[i2] = this.a(array[i2]);
            }
        }

        public double a(double var1);
    }

    static final class o
    extends Record
    implements q,
    z {
        private final a b;
        private final DensityFunction f;
        private final double g;
        private final double h;
        private final double i;

        o(a specificType, DensityFunction input, double minValue, double maxValue, double argument) {
            this.b = specificType;
            this.f = input;
            this.g = minValue;
            this.h = maxValue;
            this.i = argument;
        }

        @Override
        public z.a k() {
            return this.b == a.a ? z.a.b : z.a.a;
        }

        @Override
        public DensityFunction l() {
            return DensityFunctions.a(this.i);
        }

        @Override
        public DensityFunction m() {
            return this.f;
        }

        @Override
        public double a(double value) {
            return switch (this.b.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> value * this.i;
                case 1 -> value + this.i;
            };
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            double d3;
            double d2;
            DensityFunction densityFunction = this.f.a(visitor);
            double d4 = densityFunction.a();
            double d1 = densityFunction.b();
            if (this.b == a.b) {
                d2 = d4 + this.i;
                d3 = d1 + this.i;
            } else if (this.i >= 0.0) {
                d2 = d4 * this.i;
                d3 = d1 * this.i;
            } else {
                d2 = d1 * this.i;
                d3 = d4 * this.i;
            }
            return new o(this.b, densityFunction, d2, d3, this.i);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{o.class, "specificType;input;minValue;maxValue;argument", "b", "f", "g", "h", "i"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{o.class, "specificType;input;minValue;maxValue;argument", "b", "f", "g", "h", "i"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{o.class, "specificType;input;minValue;maxValue;argument", "b", "f", "g", "h", "i"}, this, o2);
        }

        public a n() {
            return this.b;
        }

        @Override
        public DensityFunction aG_() {
            return this.f;
        }

        @Override
        public double a() {
            return this.g;
        }

        @Override
        public double b() {
            return this.h;
        }

        public double o() {
            return this.i;
        }

        static final class a
        extends Enum<a> {
            public static final /* enum */ a a = new a();
            public static final /* enum */ a b = new a();
            private static final /* synthetic */ a[] c;

            public static a[] values() {
                return (a[])c.clone();
            }

            public static a valueOf(String name) {
                return Enum.valueOf(a.class, name);
            }

            private static /* synthetic */ a[] a() {
                return new a[]{a, b};
            }

            static {
                c = net.minecraft.world.level.levelgen.DensityFunctions$o$a.a();
            }
        }
    }

    public static interface n
    extends DensityFunction {
        public m.a k();

        public DensityFunction l();

        @Override
        default public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return this.k().g;
        }

        @Override
        default public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new m(this.k(), this.l().a(visitor)));
        }
    }

    @VisibleForDebug
    public record k(Holder<DensityFunction> a) implements DensityFunction
    {
        private final Holder<DensityFunction> a;

        @Override
        public double a(DensityFunction.b context) {
            return this.a.a().a(context);
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            this.a.a().a(array, contextProvider);
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(new k(new Holder.a<DensityFunction>(this.a.a().a(visitor))));
        }

        @Override
        public double a() {
            return this.a.b() ? this.a.a().a() : Double.NEGATIVE_INFINITY;
        }

        @Override
        public double b() {
            return this.a.b() ? this.a.a().b() : Double.POSITIVE_INFINITY;
        }

        @Override
        public KeyDispatchDataCodec<? extends DensityFunction> c() {
            throw new UnsupportedOperationException("Calling .codec() on HolderHolder");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{k.class, "function", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{k.class, "function", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{k.class, "function", "a"}, this, o2);
        }

        public Holder<DensityFunction> k() {
            return this.a;
        }
    }

    public static interface c
    extends DensityFunction.d {
        public static final KeyDispatchDataCodec<DensityFunction> f = KeyDispatchDataCodec.a(MapCodec.unit((Object)net.minecraft.world.level.levelgen.DensityFunctions$b.a));

        @Override
        default public KeyDispatchDataCodec<? extends DensityFunction> c() {
            return f;
        }
    }

    static final class a
    extends Record
    implements z {
        private final z.a b;
        private final DensityFunction f;
        private final DensityFunction g;
        private final double h;
        private final double i;

        a(z.a type, DensityFunction argument1, DensityFunction argument2, double minValue, double maxValue) {
            this.b = type;
            this.f = argument1;
            this.g = argument2;
            this.h = minValue;
            this.i = maxValue;
        }

        @Override
        public double a(DensityFunction.b context) {
            double d2 = this.f.a(context);
            return switch (this.b.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> d2 + this.g.a(context);
                case 1 -> {
                    if (d2 == 0.0) {
                        yield 0.0;
                    }
                    yield d2 * this.g.a(context);
                }
                case 2 -> {
                    if (d2 < this.g.a()) {
                        yield d2;
                    }
                    yield Math.min(d2, this.g.a(context));
                }
                case 3 -> d2 > this.g.b() ? d2 : Math.max(d2, this.g.a(context));
            };
        }

        @Override
        public void a(double[] array, DensityFunction.a contextProvider) {
            this.f.a(array, contextProvider);
            switch (this.b.ordinal()) {
                case 0: {
                    double[] doubles = new double[array.length];
                    this.g.a(doubles, contextProvider);
                    for (int i2 = 0; i2 < array.length; ++i2) {
                        int n2 = i2;
                        array[n2] = array[n2] + doubles[i2];
                    }
                    break;
                }
                case 1: {
                    for (int i1 = 0; i1 < array.length; ++i1) {
                        double d2 = array[i1];
                        array[i1] = d2 == 0.0 ? 0.0 : d2 * this.g.a(contextProvider.a(i1));
                    }
                    break;
                }
                case 2: {
                    double d1 = this.g.a();
                    for (int i2 = 0; i2 < array.length; ++i2) {
                        double d2 = array[i2];
                        array[i2] = d2 < d1 ? d2 : Math.min(d2, this.g.a(contextProvider.a(i2)));
                    }
                    break;
                }
                case 3: {
                    double d1 = this.g.b();
                    for (int i2 = 0; i2 < array.length; ++i2) {
                        double d2 = array[i2];
                        array[i2] = d2 > d1 ? d2 : Math.max(d2, this.g.a(contextProvider.a(i2)));
                    }
                    break;
                }
            }
        }

        @Override
        public DensityFunction a(DensityFunction.f visitor) {
            return visitor.apply(z.a(this.b, this.f.a(visitor), this.g.a(visitor)));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "type;argument1;argument2;minValue;maxValue", "b", "f", "g", "h", "i"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "type;argument1;argument2;minValue;maxValue", "b", "f", "g", "h", "i"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "type;argument1;argument2;minValue;maxValue", "b", "f", "g", "h", "i"}, this, o2);
        }

        @Override
        public z.a k() {
            return this.b;
        }

        @Override
        public DensityFunction l() {
            return this.f;
        }

        @Override
        public DensityFunction m() {
            return this.g;
        }

        @Override
        public double a() {
            return this.h;
        }

        @Override
        public double b() {
            return this.i;
        }
    }
}

