/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.BlockColumn;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public class SurfaceSystem {
    private static final IBlockData a = Blocks.ia.m();
    private static final IBlockData b = Blocks.ib.m();
    private static final IBlockData c = Blocks.js.m();
    private static final IBlockData d = Blocks.ie.m();
    private static final IBlockData e = Blocks.im.m();
    private static final IBlockData f = Blocks.io.m();
    private static final IBlockData g = Blocks.ii.m();
    private static final IBlockData h = Blocks.ju.m();
    private static final IBlockData i = Blocks.er.m();
    private final IBlockData j;
    private final int k;
    private final IBlockData[] l;
    private final NoiseGeneratorNormal m;
    private final NoiseGeneratorNormal n;
    private final NoiseGeneratorNormal o;
    private final NoiseGeneratorNormal p;
    private final NoiseGeneratorNormal q;
    private final NoiseGeneratorNormal r;
    private final NoiseGeneratorNormal s;
    private final PositionalRandomFactory t;
    private final NoiseGeneratorNormal u;
    private final NoiseGeneratorNormal v;

    public SurfaceSystem(RandomState randomState, IBlockData defaultBlock, int seaLevel, PositionalRandomFactory noiseRandom) {
        this.j = defaultBlock;
        this.k = seaLevel;
        this.t = noiseRandom;
        this.m = randomState.a(Noises.P);
        this.l = SurfaceSystem.a(noiseRandom.a(MinecraftKey.b("clay_bands")));
        this.u = randomState.a(Noises.N);
        this.v = randomState.a(Noises.O);
        this.n = randomState.a(Noises.Q);
        this.o = randomState.a(Noises.R);
        this.p = randomState.a(Noises.S);
        this.q = randomState.a(Noises.T);
        this.r = randomState.a(Noises.U);
        this.s = randomState.a(Noises.V);
    }

    public void a(RandomState randomState, BiomeManager biomeManager, IRegistry<BiomeBase> biomes, boolean useLegacyRandomSource, WorldGenerationContext context, final IChunkAccess chunk, NoiseChunk noiseChunk, SurfaceRules.o ruleSource) {
        final BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        final ChunkCoordIntPair pos = chunk.f();
        int minBlockX = pos.d();
        int minBlockZ = pos.e();
        BlockColumn blockColumn = new BlockColumn(){

            @Override
            public IBlockData a(int pos1) {
                return chunk.a_(mutableBlockPos.q(pos1));
            }

            @Override
            public void a(int pos1, IBlockData state) {
                LevelHeightAccessor heightAccessorForGeneration = chunk.B();
                if (heightAccessorForGeneration.d(pos1)) {
                    chunk.a((BlockPosition)mutableBlockPos.q(pos1), state);
                    if (!state.y().c()) {
                        chunk.e(mutableBlockPos);
                    }
                }
            }

            public String toString() {
                return "ChunkBlockColumn " + String.valueOf(pos);
            }
        };
        SurfaceRules.g context1 = new SurfaceRules.g(this, randomState, chunk, noiseChunk, biomeManager::a, biomes, context);
        SurfaceRules.u surfaceRule = (SurfaceRules.u)ruleSource.apply(context1);
        BlockPosition.MutableBlockPosition mutableBlockPos1 = new BlockPosition.MutableBlockPosition();
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int i1 = 0; i1 < 16; ++i1) {
                int i22 = minBlockX + i2;
                int i3 = minBlockZ + i1;
                int i4 = chunk.a(HeightMap.Type.a, i2, i1) + 1;
                mutableBlockPos.p(i22).r(i3);
                Holder<BiomeBase> biome = biomeManager.a(mutableBlockPos1.d(i22, useLegacyRandomSource ? 0 : i4, i3));
                if (biome.a(Biomes.C)) {
                    this.a(blockColumn, i22, i3, i4, chunk);
                }
                int i5 = chunk.a(HeightMap.Type.a, i2, i1) + 1;
                context1.a(i22, i3);
                int i6 = 0;
                int i7 = Integer.MIN_VALUE;
                int i8 = Integer.MAX_VALUE;
                int minY = chunk.M_();
                for (int i9 = i5; i9 >= minY; --i9) {
                    IBlockData block1;
                    IBlockData block = blockColumn.a(i9);
                    if (block.l()) {
                        i6 = 0;
                        i7 = Integer.MIN_VALUE;
                        continue;
                    }
                    if (!block.y().c()) {
                        if (i7 != Integer.MIN_VALUE) continue;
                        i7 = i9 + 1;
                        continue;
                    }
                    if (i8 >= i9) {
                        i8 = -32512;
                        for (int i10 = i9 - 1; i10 >= minY - 1; --i10) {
                            block1 = blockColumn.a(i10);
                            if (this.a(block1)) continue;
                            i8 = i10 + 1;
                            break;
                        }
                    }
                    int i10x = i9 - i8 + 1;
                    context1.a(++i6, i10x, i7, i22, i9, i3);
                    if (block != this.j || (block1 = surfaceRule.tryApply(i22, i9, i3)) == null) continue;
                    blockColumn.a(i9, block1);
                }
                if (!biome.a(Biomes.X) && !biome.a(Biomes.Y)) continue;
                this.a(context1.c(), biome.a(), blockColumn, mutableBlockPos1, i22, i3, i4);
            }
        }
    }

    protected int a(int x2, int z2) {
        double value = this.u.a(x2, 0.0, z2);
        return (int)(value * 2.75 + 3.0 + this.t.a(x2, 0, z2).j() * 0.25);
    }

    protected double b(int x2, int z2) {
        return this.v.a(x2, 0.0, z2);
    }

    private boolean a(IBlockData state) {
        return !state.l() && state.y().c();
    }

    public int a() {
        return this.k;
    }

    @Deprecated
    public Optional<IBlockData> a(SurfaceRules.o rule, CarvingContext context, Function<BlockPosition, Holder<BiomeBase>> biomeGetter, IChunkAccess chunk, NoiseChunk noiseChunk, BlockPosition pos, boolean hasFluid) {
        SurfaceRules.g context1 = new SurfaceRules.g(this, context.d(), chunk, noiseChunk, biomeGetter, context.c().f(Registries.aN), context);
        SurfaceRules.u surfaceRule = (SurfaceRules.u)rule.apply(context1);
        int x2 = pos.u();
        int y2 = pos.v();
        int z2 = pos.w();
        context1.a(x2, z2);
        context1.a(1, 1, hasFluid ? y2 + 1 : Integer.MIN_VALUE, x2, y2, z2);
        IBlockData blockState = surfaceRule.tryApply(x2, y2, z2);
        return Optional.ofNullable(blockState);
    }

    private void a(BlockColumn blockColumn, int x2, int z2, int height, LevelHeightAccessor level) {
        double d2 = 0.2;
        double min = Math.min(Math.abs(this.p.a(x2, 0.0, z2) * 8.25), this.n.a((double)x2 * 0.2, 0.0, (double)z2 * 0.2) * 15.0);
        if (!(min <= 0.0)) {
            double d1 = 0.75;
            double d22 = 1.5;
            double abs = Math.abs(this.o.a((double)x2 * 0.75, 0.0, (double)z2 * 0.75) * 1.5);
            double d3 = 64.0 + Math.min(min * min * 2.5, Math.ceil(abs * 50.0) + 24.0);
            int floor = MathHelper.a(d3);
            if (height <= floor) {
                IBlockData block;
                int i2;
                for (i2 = floor; i2 >= level.M_() && !(block = blockColumn.a(i2)).a(this.j.b()); --i2) {
                    if (!block.a(Blocks.J)) continue;
                    return;
                }
                for (i2 = floor; i2 >= level.M_() && blockColumn.a(i2).l(); --i2) {
                    blockColumn.a(i2, this.j);
                }
            }
        }
    }

    private void a(int minSurfaceLevel, BiomeBase biome, BlockColumn blockColumn, BlockPosition.MutableBlockPosition topWaterPos, int x2, int z2, int height) {
        double d2 = 1.28;
        double min = Math.min(Math.abs(this.s.a(x2, 0.0, z2) * 8.25), this.q.a((double)x2 * 1.28, 0.0, (double)z2 * 1.28) * 15.0);
        if (!(min <= 1.8)) {
            double d3;
            double d1 = 1.17;
            double d22 = 1.5;
            double abs = Math.abs(this.r.a((double)x2 * 1.17, 0.0, (double)z2 * 1.17) * 1.5);
            double min1 = Math.min(min * min * 1.2, Math.ceil(abs * 40.0) + 14.0);
            if (biome.d(topWaterPos.d(x2, this.k, z2), this.k)) {
                min1 -= 2.0;
            }
            if (min1 > 2.0) {
                d3 = (double)this.k - min1 - 7.0;
                min1 += (double)this.k;
            } else {
                min1 = 0.0;
                d3 = 0.0;
            }
            double d4 = min1;
            RandomSource randomSource = this.t.a(x2, 0, z2);
            int i2 = 2 + randomSource.a(4);
            int i1 = this.k + 18 + randomSource.a(10);
            int i22 = 0;
            for (int max = Math.max(height, (int)min1 + 1); max >= minSurfaceLevel; --max) {
                if (!(blockColumn.a(max).l() && max < (int)d4 && randomSource.j() > 0.01) && (!blockColumn.a(max).a(Blocks.J) || max <= (int)d3 || max >= this.k || d3 == 0.0 || !(randomSource.j() > 0.15))) continue;
                if (i22 <= i2 && max > i1) {
                    blockColumn.a(max, i);
                    ++i22;
                    continue;
                }
                blockColumn.a(max, h);
            }
        }
    }

    private static IBlockData[] a(RandomSource random) {
        Object[] blockStates = new IBlockData[192];
        Arrays.fill(blockStates, c);
        for (int i2 = 0; i2 < blockStates.length; ++i2) {
            if ((i2 += random.a(5) + 1) >= blockStates.length) continue;
            blockStates[i2] = b;
        }
        SurfaceSystem.a(random, (IBlockData[])blockStates, 1, d);
        SurfaceSystem.a(random, (IBlockData[])blockStates, 2, e);
        SurfaceSystem.a(random, (IBlockData[])blockStates, 1, f);
        int ix = random.a(9, 15);
        int i1 = 0;
        for (int i2 = 0; i1 < ix && i2 < blockStates.length; ++i1, i2 += random.a(16) + 4) {
            blockStates[i2] = a;
            if (i2 - 1 > 0 && random.h()) {
                blockStates[i2 - 1] = g;
            }
            if (i2 + 1 >= blockStates.length || !random.h()) continue;
            blockStates[i2 + 1] = g;
        }
        return blockStates;
    }

    private static void a(RandomSource random, IBlockData[] output, int minSize, IBlockData state) {
        int randomInt = random.a(6, 15);
        for (int i2 = 0; i2 < randomInt; ++i2) {
            int i1 = minSize + random.a(3);
            int randomInt1 = random.a(output.length);
            for (int i22 = 0; randomInt1 + i22 < output.length && i22 < i1; ++i22) {
                output[randomInt1 + i22] = state;
            }
        }
    }

    protected IBlockData a(int x2, int y2, int z2) {
        int i2 = (int)Math.round(this.m.a(x2, 0.0, z2) * 4.0);
        return this.l[(y2 + i2 + this.l.length) % this.l.length];
    }
}

