/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;

public class WorldGenCanyon
extends WorldGenCarverAbstract<CanyonCarverConfiguration> {
    public WorldGenCanyon(Codec<CanyonCarverConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean a(CanyonCarverConfiguration config, RandomSource random) {
        return random.i() <= config.l;
    }

    @Override
    public boolean a(CarvingContext context, CanyonCarverConfiguration config, IChunkAccess chunk, Function<BlockPosition, Holder<BiomeBase>> biomeAccessor, RandomSource random, Aquifer aquifer, ChunkCoordIntPair chunkPos, CarvingMask carvingMask) {
        int i2 = (this.d() * 2 - 1) * 16;
        double d2 = chunkPos.a(random.a(16));
        int i1 = config.e.a(random, context);
        double d1 = chunkPos.b(random.a(16));
        float f2 = random.i() * ((float)Math.PI * 2);
        float f1 = config.b.a(random);
        double d22 = config.f.a(random);
        float f22 = config.c.c.a(random);
        int i22 = (int)((float)i2 * config.c.b.a(random));
        boolean i3 = false;
        this.a(context, config, chunk, biomeAccessor, random.g(), aquifer, d2, i1, d1, f22, f2, f1, 0, i22, d22, carvingMask);
        return true;
    }

    private void a(CarvingContext context, CanyonCarverConfiguration config, IChunkAccess chunk, Function<BlockPosition, Holder<BiomeBase>> biomeAccessor, long seed, Aquifer aquifer, double x2, double y2, double z2, float thickness, float yaw, float pitch, int branchIndex, int branchCount, double horizontalVerticalRatio, CarvingMask carvingMask) {
        RandomSource randomSource = RandomSource.a(seed);
        float[] floats = this.a(context, config, randomSource);
        float f2 = 0.0f;
        float f1 = 0.0f;
        for (int i2 = branchIndex; i2 < branchCount; ++i2) {
            double d2 = 1.5 + (double)(MathHelper.a((float)i2 * (float)Math.PI / (float)branchCount) * thickness);
            double d1 = d2 * horizontalVerticalRatio;
            d2 *= (double)config.c.e.a(randomSource);
            d1 = this.a(config, randomSource, d1, branchCount, i2);
            float cos = MathHelper.b(pitch);
            float sin = MathHelper.a(pitch);
            x2 += (double)(MathHelper.b(yaw) * cos);
            y2 += (double)sin;
            z2 += (double)(MathHelper.a(yaw) * cos);
            pitch *= 0.7f;
            pitch += f1 * 0.05f;
            yaw += f2 * 0.05f;
            f1 *= 0.8f;
            f2 *= 0.5f;
            f1 += (randomSource.i() - randomSource.i()) * randomSource.i() * 2.0f;
            f2 += (randomSource.i() - randomSource.i()) * randomSource.i() * 4.0f;
            if (randomSource.a(4) == 0) continue;
            if (!WorldGenCanyon.a(chunk.f(), x2, z2, i2, branchCount, thickness)) {
                return;
            }
            this.a(context, config, chunk, biomeAccessor, aquifer, x2, y2, z2, d2, d1, carvingMask, (skipContext, relativeX, relativeY, relativeZ, skipY) -> this.a(skipContext, floats, relativeX, relativeY, relativeZ, skipY));
        }
    }

    private float[] a(CarvingContext context, CanyonCarverConfiguration config, RandomSource random) {
        int genDepth = context.b();
        float[] floats = new float[genDepth];
        float f2 = 1.0f;
        for (int i2 = 0; i2 < genDepth; ++i2) {
            if (i2 == 0 || random.a(config.c.d) == 0) {
                f2 = 1.0f + random.i() * random.i();
            }
            floats[i2] = f2 * f2;
        }
        return floats;
    }

    private double a(CanyonCarverConfiguration config, RandomSource random, double verticalRadius, float branchCount, float currentBranch) {
        float f2 = 1.0f - MathHelper.e(0.5f - currentBranch / branchCount) * 2.0f;
        float f1 = config.c.f + config.c.g * f2;
        return (double)f1 * verticalRadius * (double)MathHelper.b(random, 0.75f, 1.0f);
    }

    private boolean a(CarvingContext context, float[] widthFactors, double relativeX, double relativeY, double relativeZ, int y2) {
        int i2 = y2 - context.a();
        return (relativeX * relativeX + relativeZ * relativeZ) * (double)widthFactors[i2 - 1] + relativeY * relativeY / 6.0 >= 1.0;
    }
}

