/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration;

public class DripstoneClusterFeature
extends WorldGenerator<DripstoneClusterConfiguration> {
    public DripstoneClusterFeature(Codec<DripstoneClusterConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean a(FeaturePlaceContext<DripstoneClusterConfiguration> context) {
        GeneratorAccessSeed worldGenLevel = context.b();
        BlockPosition blockPos = context.e();
        DripstoneClusterConfiguration dripstoneClusterConfiguration = context.f();
        RandomSource randomSource = context.d();
        if (!DripstoneUtils.a(worldGenLevel, blockPos)) {
            return false;
        }
        int i2 = dripstoneClusterConfiguration.c.a(randomSource);
        float f2 = dripstoneClusterConfiguration.i.a(randomSource);
        float f1 = dripstoneClusterConfiguration.h.a(randomSource);
        int i1 = dripstoneClusterConfiguration.d.a(randomSource);
        int i22 = dripstoneClusterConfiguration.d.a(randomSource);
        for (int i3 = -i1; i3 <= i1; ++i3) {
            for (int i4 = -i22; i4 <= i22; ++i4) {
                double chanceOfStalagmiteOrStalactite = this.a(i1, i22, i3, i4, dripstoneClusterConfiguration);
                BlockPosition blockPos1 = blockPos.b(i3, 0, i4);
                this.a(worldGenLevel, randomSource, blockPos1, i3, i4, f2, chanceOfStalagmiteOrStalactite, i2, f1, dripstoneClusterConfiguration);
            }
        }
        return true;
    }

    private void a(GeneratorAccessSeed level, RandomSource random, BlockPosition pos, int x2, int z2, float wetness, double chance, int height, float density, DripstoneClusterConfiguration config) {
        Optional<Column> optional = Column.a(level, pos, config.b, DripstoneUtils::c, DripstoneUtils::d);
        if (!optional.isEmpty()) {
            OptionalInt ceiling = optional.get().b();
            OptionalInt floor = optional.get().c();
            if (!ceiling.isEmpty() || !floor.isEmpty()) {
                boolean flag3;
                int i4;
                int i1;
                int i2;
                boolean flag2;
                int dripstoneHeight;
                boolean flag1;
                Column column;
                boolean flag;
                boolean bl = flag = random.i() < wetness;
                if (flag && floor.isPresent() && this.b(level, pos.h(floor.getAsInt()))) {
                    int asInt = floor.getAsInt();
                    column = optional.get().a(OptionalInt.of(asInt - 1));
                    level.a(pos.h(asInt), Blocks.J.m(), 2);
                } else {
                    column = optional.get();
                }
                OptionalInt floor1 = column.c();
                boolean bl2 = flag1 = random.j() < chance;
                if (ceiling.isPresent() && flag1 && !this.a((IWorldReader)level, pos.h(ceiling.getAsInt()))) {
                    int i3 = config.g.a(random);
                    this.a(level, pos.h(ceiling.getAsInt()), i3, EnumDirection.b);
                    int min = floor1.isPresent() ? Math.min(height, ceiling.getAsInt() - floor1.getAsInt()) : height;
                    dripstoneHeight = this.a(random, x2, z2, density, min, config);
                } else {
                    dripstoneHeight = 0;
                }
                boolean bl3 = flag2 = random.j() < chance;
                if (floor1.isPresent() && flag2 && !this.a((IWorldReader)level, pos.h(floor1.getAsInt()))) {
                    int i12 = config.g.a(random);
                    this.a(level, pos.h(floor1.getAsInt()), i12, EnumDirection.a);
                    i2 = ceiling.isPresent() ? Math.max(0, dripstoneHeight + MathHelper.b(random, -config.e, config.e)) : this.a(random, x2, z2, density, height, config);
                } else {
                    i2 = 0;
                }
                if (ceiling.isPresent() && floor1.isPresent() && ceiling.getAsInt() - dripstoneHeight <= floor1.getAsInt() + i2) {
                    int asInt1 = floor1.getAsInt();
                    int asInt2 = ceiling.getAsInt();
                    int max = Math.max(asInt2 - dripstoneHeight, asInt1 + 1);
                    int min1 = Math.min(asInt1 + i2, asInt2 - 1);
                    int i22 = MathHelper.b(random, max, min1 + 1);
                    int i3 = i22 - 1;
                    i1 = asInt2 - i22;
                    i4 = i3 - asInt1;
                } else {
                    i1 = dripstoneHeight;
                    i4 = i2;
                }
                boolean bl4 = flag3 = random.h() && i1 > 0 && i4 > 0 && column.d().isPresent() && i1 + i4 == column.d().getAsInt();
                if (ceiling.isPresent()) {
                    DripstoneUtils.a(level, pos.h(ceiling.getAsInt() - 1), EnumDirection.a, i1, flag3);
                }
                if (floor1.isPresent()) {
                    DripstoneUtils.a(level, pos.h(floor1.getAsInt() + 1), EnumDirection.b, i4, flag3);
                }
            }
        }
    }

    private boolean a(IWorldReader level, BlockPosition pos) {
        return level.a_(pos).a(Blocks.K);
    }

    private int a(RandomSource random, int x2, int z2, float chance, int height, DripstoneClusterConfiguration config) {
        if (random.i() > chance) {
            return 0;
        }
        int i2 = Math.abs(x2) + Math.abs(z2);
        float f2 = (float)MathHelper.a((double)i2, 0.0, (double)config.l, (double)height / 2.0, 0.0);
        return (int)DripstoneClusterFeature.a(random, 0.0f, height, f2, config.f);
    }

    private boolean b(GeneratorAccessSeed level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos);
        if (!(blockState.a(Blocks.J) || blockState.a(Blocks.tR) || blockState.a(Blocks.tQ))) {
            if (level.a_(pos.d()).y().a(TagsFluid.a)) {
                return false;
            }
            for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
                if (this.a((GeneratorAccess)level, pos.a(direction))) continue;
                return false;
            }
            return this.a((GeneratorAccess)level, pos.e());
        }
        return false;
    }

    private boolean a(GeneratorAccess level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos);
        return blockState.a(TagsBlock.bq) || blockState.y().a(TagsFluid.a);
    }

    private void a(GeneratorAccessSeed level, BlockPosition pos, int thickness, EnumDirection direction) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        for (int i2 = 0; i2 < thickness; ++i2) {
            if (!DripstoneUtils.c(level, mutableBlockPos)) {
                return;
            }
            mutableBlockPos.c(direction);
        }
    }

    private double a(int xRadius, int zRadius, int x2, int z2, DripstoneClusterConfiguration config) {
        int i2 = xRadius - Math.abs(x2);
        int i1 = zRadius - Math.abs(z2);
        int min = Math.min(i2, i1);
        return MathHelper.b(min, 0.0f, config.k, config.j, 1.0f);
    }

    private static float a(RandomSource random, float min, float max, float mean, float deviation) {
        return ClampedNormalFloat.a(random, mean, deviation, min, max);
    }
}

