/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;

public class DripstoneUtils {
    protected static double a(double radius, double maxRadius, double scale, double minRadius) {
        if (radius < minRadius) {
            radius = minRadius;
        }
        double d2 = 0.384;
        double d1 = radius / maxRadius * 0.384;
        double d22 = 0.75 * Math.pow(d1, 1.3333333333333333);
        double d3 = Math.pow(d1, 0.6666666666666666);
        double d4 = 0.3333333333333333 * Math.log(d1);
        double d5 = scale * (d22 - d3 - d4);
        d5 = Math.max(d5, 0.0);
        return d5 / 0.384 * maxRadius;
    }

    protected static boolean a(GeneratorAccessSeed level, BlockPosition pos, int radius) {
        if (DripstoneUtils.b(level, pos)) {
            return false;
        }
        float f2 = 6.0f;
        float f1 = 6.0f / (float)radius;
        for (float f22 = 0.0f; f22 < (float)Math.PI * 2; f22 += f1) {
            int i1;
            int i2 = (int)(MathHelper.b(f22) * (float)radius);
            if (!DripstoneUtils.b(level, pos.b(i2, 0, i1 = (int)(MathHelper.a(f22) * (float)radius)))) continue;
            return false;
        }
        return true;
    }

    protected static boolean a(GeneratorAccess level, BlockPosition pos) {
        return level.a(pos, DripstoneUtils::c);
    }

    protected static boolean b(GeneratorAccess level, BlockPosition pos) {
        return level.a(pos, DripstoneUtils::e);
    }

    protected static void a(EnumDirection direction, int height, boolean mergeTip, Consumer<IBlockData> blockSetter) {
        if (height >= 3) {
            blockSetter.accept(DripstoneUtils.a(direction, DripstoneThickness.e));
            for (int i2 = 0; i2 < height - 3; ++i2) {
                blockSetter.accept(DripstoneUtils.a(direction, DripstoneThickness.d));
            }
        }
        if (height >= 2) {
            blockSetter.accept(DripstoneUtils.a(direction, DripstoneThickness.c));
        }
        if (height >= 1) {
            blockSetter.accept(DripstoneUtils.a(direction, mergeTip ? DripstoneThickness.a : DripstoneThickness.b));
        }
    }

    protected static void a(GeneratorAccess level, BlockPosition pos, EnumDirection direction, int height, boolean mergeTip) {
        if (DripstoneUtils.b(level.a_(pos.a(direction.g())))) {
            BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
            DripstoneUtils.a(direction, height, mergeTip, (IBlockData blockState) -> {
                if (blockState.a(Blocks.tQ)) {
                    blockState = (IBlockData)blockState.b(PointedDripstoneBlock.d, level.B(mutableBlockPos));
                }
                level.a((BlockPosition)mutableBlockPos, (IBlockData)blockState, 2);
                mutableBlockPos.c(direction);
            });
        }
    }

    protected static boolean c(GeneratorAccess level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos);
        if (blockState.a(TagsBlock.bE)) {
            level.a(pos, Blocks.tR.m(), 2);
            return true;
        }
        return false;
    }

    private static IBlockData a(EnumDirection direction, DripstoneThickness dripstoneThickness) {
        return (IBlockData)((IBlockData)Blocks.tQ.m().b(PointedDripstoneBlock.b, direction)).b(PointedDripstoneBlock.c, dripstoneThickness);
    }

    public static boolean a(IBlockData state) {
        return DripstoneUtils.b(state) || state.a(Blocks.K);
    }

    public static boolean b(IBlockData state) {
        return state.a(Blocks.tR) || state.a(TagsBlock.bE);
    }

    public static boolean c(IBlockData state) {
        return state.l() || state.a(Blocks.J);
    }

    public static boolean d(IBlockData state) {
        return !state.l() && !state.a(Blocks.J);
    }

    public static boolean e(IBlockData state) {
        return state.l() || state.a(Blocks.J) || state.a(Blocks.K);
    }
}

