/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

public class FeatureCountTracker {
    private static final Logger a = LogUtils.getLogger();
    private static final LoadingCache<WorldServer, b> b = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<WorldServer, b>(){

        public b a(WorldServer level) {
            return new b((Object2IntMap<a>)Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap()), new MutableInt(0));
        }
    });

    public static void a(WorldServer level) {
        try {
            ((b)b.get((Object)level)).b().increment();
        }
        catch (Exception var2) {
            a.error("Failed to increment chunk count", (Throwable)var2);
        }
    }

    public static void a(WorldServer level, WorldGenFeatureConfigured<?, ?> feature, Optional<PlacedFeature> topFeature) {
        try {
            ((b)b.get((Object)level)).a().computeInt((Object)new a(feature, topFeature), (featureData, integer) -> integer == null ? 1 : integer + 1);
        }
        catch (Exception var4) {
            a.error("Failed to increment feature count", (Throwable)var4);
        }
    }

    public static void a() {
        b.invalidateAll();
        a.debug("Cleared feature counts");
    }

    public static void b() {
        a.debug("Logging feature counts:");
        b.asMap().forEach((serverLevel, levelData) -> {
            String string = serverLevel.al().a().toString();
            boolean isRunning = serverLevel.q().B();
            IRegistry<PlacedFeature> registry = serverLevel.L_().f(Registries.bj);
            String string1 = (isRunning ? "running" : "dead") + " " + string;
            Integer value = levelData.b().getValue();
            a.debug("{} total_chunks: {}", (Object)string1, (Object)value);
            levelData.a().forEach((featureData, integer) -> {
                Object[] objectArray = new Object[6];
                objectArray[0] = string1;
                objectArray[1] = String.format(Locale.ROOT, "%10d", integer);
                objectArray[2] = String.format(Locale.ROOT, "%10f", (double)integer.intValue() / (double)value.intValue());
                objectArray[3] = featureData.b().flatMap(registry::d).map(ResourceKey::a);
                objectArray[4] = featureData.a().b();
                objectArray[5] = featureData.a();
                a.debug("{} {} {} {} {} {}", objectArray);
            });
        });
    }

    record b(Object2IntMap<a> a, MutableInt b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "featureData;chunksWithFeatures", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "featureData;chunksWithFeatures", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "featureData;chunksWithFeatures", "a", "b"}, this, o2);
        }
    }

    record a(WorldGenFeatureConfigured<?, ?> a, Optional<PlacedFeature> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "feature;topFeature", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "feature;topFeature", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "feature;topFeature", "a", "b"}, this, o2);
        }
    }
}

