/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.RootSystemConfiguration;

public class RootSystemFeature
extends WorldGenerator<RootSystemConfiguration> {
    public RootSystemFeature(Codec<RootSystemConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean a(FeaturePlaceContext<RootSystemConfiguration> context) {
        BlockPosition blockPos;
        GeneratorAccessSeed worldGenLevel = context.b();
        if (!worldGenLevel.a_(blockPos = context.e()).l()) {
            return false;
        }
        RandomSource randomSource = context.d();
        BlockPosition blockPos1 = context.e();
        RootSystemConfiguration rootSystemConfiguration = context.f();
        BlockPosition.MutableBlockPosition mutableBlockPos = blockPos1.k();
        if (RootSystemFeature.a(worldGenLevel, context.c(), rootSystemConfiguration, randomSource, mutableBlockPos, blockPos1)) {
            RootSystemFeature.a(worldGenLevel, rootSystemConfiguration, randomSource, blockPos1, mutableBlockPos);
        }
        return true;
    }

    private static boolean a(GeneratorAccessSeed level, RootSystemConfiguration config, BlockPosition pos) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        for (int i2 = 1; i2 <= config.c; ++i2) {
            mutableBlockPos.c(EnumDirection.b);
            IBlockData blockState = level.a_(mutableBlockPos);
            if (RootSystemFeature.a(blockState, i2, config.n)) continue;
            return false;
        }
        return true;
    }

    private static boolean a(IBlockData state, int y2, int allowedVerticalWater) {
        if (state.l()) {
            return true;
        }
        int i2 = y2 + 1;
        return i2 <= allowedVerticalWater && state.y().a(TagsFluid.a);
    }

    private static boolean a(GeneratorAccessSeed level, ChunkGenerator chunkGenerator, RootSystemConfiguration config, RandomSource random, BlockPosition.MutableBlockPosition mutablePos, BlockPosition basePos) {
        for (int i2 = 0; i2 < config.h; ++i2) {
            mutablePos.c(EnumDirection.b);
            if (!config.o.test(level, mutablePos) || !RootSystemFeature.a(level, config, mutablePos)) continue;
            BlockPosition blockPos = mutablePos.e();
            if (level.b_(blockPos).a(TagsFluid.b) || !level.a_(blockPos).e()) {
                return false;
            }
            if (!config.b.a().a(level, chunkGenerator, random, mutablePos)) continue;
            RootSystemFeature.a(basePos, basePos.v() + i2, level, config, random);
            return true;
        }
        return false;
    }

    private static void a(BlockPosition pos, int maxY, GeneratorAccessSeed level, RootSystemConfiguration config, RandomSource random) {
        int x2 = pos.u();
        int z2 = pos.w();
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        for (int y2 = pos.v(); y2 < maxY; ++y2) {
            RootSystemFeature.a(level, config, random, x2, z2, mutableBlockPos.d(x2, y2, z2));
        }
    }

    private static void a(GeneratorAccessSeed level, RootSystemConfiguration config, RandomSource random, int x2, int z2, BlockPosition.MutableBlockPosition pos) {
        int i2 = config.d;
        Predicate<IBlockData> predicate = blockState -> blockState.a(config.e);
        for (int i1 = 0; i1 < config.g; ++i1) {
            pos.a(pos, random.a(i2) - random.a(i2), 0, random.a(i2) - random.a(i2));
            if (predicate.test(level.a_(pos))) {
                level.a((BlockPosition)pos, config.f.a(random, pos), 2);
            }
            pos.p(x2);
            pos.r(z2);
        }
    }

    private static void a(GeneratorAccessSeed level, RootSystemConfiguration config, RandomSource random, BlockPosition basePos, BlockPosition.MutableBlockPosition mutablePos) {
        int i2 = config.i;
        int i1 = config.j;
        for (int i22 = 0; i22 < config.l; ++i22) {
            IBlockData state;
            mutablePos.a(basePos, random.a(i2) - random.a(i2), random.a(i1) - random.a(i1), random.a(i2) - random.a(i2));
            if (!level.w(mutablePos) || !(state = config.k.a(random, mutablePos)).a(level, (BlockPosition)mutablePos) || !level.a_(mutablePos.d()).c((IBlockAccess)level, (BlockPosition)mutablePos, EnumDirection.a)) continue;
            level.a((BlockPosition)mutablePos, state, 2);
        }
    }
}

