/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.rootplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.rootplacers.AboveRootPlacement;
import net.minecraft.world.level.levelgen.feature.rootplacers.MangroveRootPlacement;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;

public class MangroveRootPlacer
extends RootPlacer {
    public static final int a = 8;
    public static final int b = 15;
    public static final MapCodec<MangroveRootPlacer> c = RecordCodecBuilder.mapCodec(instance -> MangroveRootPlacer.a(instance).and((App)MangroveRootPlacement.a.fieldOf("mangrove_root_placement").forGetter(placement -> placement.h)).apply((Applicative)instance, MangroveRootPlacer::new));
    private final MangroveRootPlacement h;

    public MangroveRootPlacer(IntProvider trunkOffset, WorldGenFeatureStateProvider rootProvider, Optional<AboveRootPlacement> aboveRootPlacement, MangroveRootPlacement mangroveRootPlacement) {
        super(trunkOffset, rootProvider, aboveRootPlacement);
        this.h = mangroveRootPlacement;
    }

    @Override
    public boolean a(VirtualLevelReadable level, BiConsumer<BlockPosition, IBlockData> blockSetter, RandomSource random, BlockPosition pos, BlockPosition trunkOrigin, WorldGenFeatureTreeConfiguration treeConfig) {
        ArrayList list = Lists.newArrayList();
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        while (mutableBlockPos.v() < trunkOrigin.v()) {
            if (!this.a(level, mutableBlockPos)) {
                return false;
            }
            mutableBlockPos.c(EnumDirection.b);
        }
        list.add(trunkOrigin.e());
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            ArrayList list1;
            BlockPosition blockPos = trunkOrigin.a(direction);
            if (!this.a(level, random, blockPos, direction, trunkOrigin, list1 = Lists.newArrayList(), 0)) {
                return false;
            }
            list.addAll(list1);
            list.add(trunkOrigin.a(direction));
        }
        for (BlockPosition blockPos1 : list) {
            this.a(level, blockSetter, random, blockPos1, treeConfig);
        }
        return true;
    }

    private boolean a(VirtualLevelReadable level, RandomSource random, BlockPosition pos, EnumDirection direction, BlockPosition trunkOrigin, List<BlockPosition> roots, int length) {
        int maxRootLength = this.h.e();
        if (length != maxRootLength && roots.size() <= maxRootLength) {
            for (BlockPosition blockPos : this.a(pos, direction, random, trunkOrigin)) {
                if (!this.a(level, blockPos)) continue;
                roots.add(blockPos);
                if (this.a(level, random, blockPos, direction, trunkOrigin, roots, length + 1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<BlockPosition> a(BlockPosition pos, EnumDirection direction, RandomSource random, BlockPosition trunkOrigin) {
        BlockPosition blockPos = pos.e();
        BlockPosition blockPos1 = pos.a(direction);
        int i2 = pos.k(trunkOrigin);
        int maxRootWidth = this.h.d();
        float randomSkewChance = this.h.f();
        if (i2 > maxRootWidth - 3 && i2 <= maxRootWidth) {
            return random.i() < randomSkewChance ? List.of(blockPos, blockPos1.e()) : List.of(blockPos);
        }
        if (i2 > maxRootWidth) {
            return List.of(blockPos);
        }
        if (random.i() < randomSkewChance) {
            return List.of(blockPos);
        }
        return random.h() ? List.of(blockPos1) : List.of(blockPos);
    }

    @Override
    protected boolean a(VirtualLevelReadable level, BlockPosition pos) {
        return super.a(level, pos) || level.a(pos, (IBlockData blockState) -> blockState.a(this.h.a()));
    }

    @Override
    protected void a(VirtualLevelReadable level, BiConsumer<BlockPosition, IBlockData> blockSetter, RandomSource random, BlockPosition pos, WorldGenFeatureTreeConfiguration treeConfig) {
        if (level.a(pos, (IBlockData blockState) -> blockState.a(this.h.b()))) {
            IBlockData state = this.h.c().a(random, pos);
            blockSetter.accept(pos, this.a(level, pos, state));
        } else {
            super.a(level, blockSetter, random, pos, treeConfig);
        }
    }

    @Override
    protected RootPlacerType<?> a() {
        return RootPlacerType.a;
    }
}

