/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.heightproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import org.slf4j.Logger;

public class VeryBiasedToBottomHeight
extends HeightProvider {
    public static final MapCodec<VeryBiasedToBottomHeight> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)VerticalAnchor.a.fieldOf("min_inclusive").forGetter(provider -> provider.d), (App)VerticalAnchor.a.fieldOf("max_inclusive").forGetter(provider -> provider.e), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("inner", (Object)1).forGetter(provider -> provider.f)).apply((Applicative)instance, VeryBiasedToBottomHeight::new));
    private static final Logger b = LogUtils.getLogger();
    private final VerticalAnchor d;
    private final VerticalAnchor e;
    private final int f;

    private VeryBiasedToBottomHeight(VerticalAnchor minInclusive, VerticalAnchor maxInclusive, int inner) {
        this.d = minInclusive;
        this.e = maxInclusive;
        this.f = inner;
    }

    public static VeryBiasedToBottomHeight a(VerticalAnchor minInclusive, VerticalAnchor maxInclusive, int inner) {
        return new VeryBiasedToBottomHeight(minInclusive, maxInclusive, inner);
    }

    @Override
    public int a(RandomSource random, WorldGenerationContext context) {
        int i2 = this.d.a(context);
        int i1 = this.e.a(context);
        if (i1 - i2 - this.f + 1 <= 0) {
            b.warn("Empty height range: {}", (Object)this);
            return i2;
        }
        int randomInt = MathHelper.a(random, i2 + this.f, i1);
        int randomInt1 = MathHelper.a(random, i2, randomInt - 1);
        return MathHelper.a(random, i2, randomInt1 - 1 + this.f);
    }

    @Override
    public HeightProviderType<?> a() {
        return HeightProviderType.d;
    }

    public String toString() {
        return "biased[" + String.valueOf(this.d) + "-" + String.valueOf(this.e) + " inner: " + this.f + "]";
    }
}

