/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.base.MoreObjects;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.slf4j.Logger;

public class StructureBoundingBox {
    private static final Logger c = LogUtils.getLogger();
    public static final Codec<StructureBoundingBox> a = Codec.INT_STREAM.comapFlatMap(stream -> SystemUtils.a(stream, 6).map(ints -> new StructureBoundingBox(ints[0], ints[1], ints[2], ints[3], ints[4], ints[5])), boundingBox -> IntStream.of(boundingBox.d, boundingBox.e, boundingBox.f, boundingBox.g, boundingBox.h, boundingBox.i)).stable();
    public static final StreamCodec<ByteBuf, StructureBoundingBox> b = StreamCodec.a(BlockPosition.b, boundingBox -> new BlockPosition(boundingBox.d, boundingBox.e, boundingBox.f), BlockPosition.b, boundingBox -> new BlockPosition(boundingBox.g, boundingBox.h, boundingBox.i), (blockPos, blockPos1) -> new StructureBoundingBox(blockPos.u(), blockPos.v(), blockPos.w(), blockPos1.u(), blockPos1.v(), blockPos1.w()));
    private int d;
    private int e;
    private int f;
    private int g;
    private int h;
    private int i;

    public StructureBoundingBox(BlockPosition pos) {
        this(pos.u(), pos.v(), pos.w(), pos.u(), pos.v(), pos.w());
    }

    public StructureBoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.d = minX;
        this.e = minY;
        this.f = minZ;
        this.g = maxX;
        this.h = maxY;
        this.i = maxZ;
        if (maxX < minX || maxY < minY || maxZ < minZ) {
            SystemUtils.b("Invalid bounding box data, inverted bounds for: " + String.valueOf(this));
            this.d = Math.min(minX, maxX);
            this.e = Math.min(minY, maxY);
            this.f = Math.min(minZ, maxZ);
            this.g = Math.max(minX, maxX);
            this.h = Math.max(minY, maxY);
            this.i = Math.max(minZ, maxZ);
        }
    }

    public static StructureBoundingBox a(BaseBlockPosition first, BaseBlockPosition second) {
        return new StructureBoundingBox(Math.min(first.u(), second.u()), Math.min(first.v(), second.v()), Math.min(first.w(), second.w()), Math.max(first.u(), second.u()), Math.max(first.v(), second.v()), Math.max(first.w(), second.w()));
    }

    public static StructureBoundingBox a() {
        return new StructureBoundingBox(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static StructureBoundingBox a(int structureMinX, int structureMinY, int structureMinZ, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, EnumDirection facing) {
        switch (facing) {
            default: {
                return new StructureBoundingBox(structureMinX + xMin, structureMinY + yMin, structureMinZ + zMin, structureMinX + xMax - 1 + xMin, structureMinY + yMax - 1 + yMin, structureMinZ + zMax - 1 + zMin);
            }
            case c: {
                return new StructureBoundingBox(structureMinX + xMin, structureMinY + yMin, structureMinZ - zMax + 1 + zMin, structureMinX + xMax - 1 + xMin, structureMinY + yMax - 1 + yMin, structureMinZ + zMin);
            }
            case e: {
                return new StructureBoundingBox(structureMinX - zMax + 1 + zMin, structureMinY + yMin, structureMinZ + xMin, structureMinX + zMin, structureMinY + yMax - 1 + yMin, structureMinZ + xMax - 1 + xMin);
            }
            case f: 
        }
        return new StructureBoundingBox(structureMinX + zMin, structureMinY + yMin, structureMinZ + xMin, structureMinX + zMax - 1 + zMin, structureMinY + yMax - 1 + yMin, structureMinZ + xMax - 1 + xMin);
    }

    public Stream<ChunkCoordIntPair> b() {
        int sectionPosMinX = SectionPosition.a(this.h());
        int sectionPosMinZ = SectionPosition.a(this.j());
        int sectionPosMaxX = SectionPosition.a(this.k());
        int sectionPosMaxZ = SectionPosition.a(this.m());
        return ChunkCoordIntPair.a(new ChunkCoordIntPair(sectionPosMinX, sectionPosMinZ), new ChunkCoordIntPair(sectionPosMaxX, sectionPosMaxZ));
    }

    public boolean a(StructureBoundingBox box) {
        return this.g >= box.d && this.d <= box.g && this.i >= box.f && this.f <= box.i && this.h >= box.e && this.e <= box.h;
    }

    public boolean a(int minX, int minZ, int maxX, int maxZ) {
        return this.g >= minX && this.d <= maxX && this.i >= minZ && this.f <= maxZ;
    }

    public static Optional<StructureBoundingBox> a(Iterable<BlockPosition> positions) {
        Iterator<BlockPosition> iterator = positions.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        StructureBoundingBox boundingBox = new StructureBoundingBox(iterator.next());
        iterator.forEachRemaining(boundingBox::a);
        return Optional.of(boundingBox);
    }

    public static Optional<StructureBoundingBox> b(Iterable<StructureBoundingBox> boxes) {
        Iterator<StructureBoundingBox> iterator = boxes.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        StructureBoundingBox boundingBox = iterator.next();
        StructureBoundingBox boundingBox1 = new StructureBoundingBox(boundingBox.d, boundingBox.e, boundingBox.f, boundingBox.g, boundingBox.h, boundingBox.i);
        iterator.forEachRemaining(boundingBox1::b);
        return Optional.of(boundingBox1);
    }

    @Deprecated
    public StructureBoundingBox b(StructureBoundingBox box) {
        this.d = Math.min(this.d, box.d);
        this.e = Math.min(this.e, box.e);
        this.f = Math.min(this.f, box.f);
        this.g = Math.max(this.g, box.g);
        this.h = Math.max(this.h, box.h);
        this.i = Math.max(this.i, box.i);
        return this;
    }

    public static StructureBoundingBox a(StructureBoundingBox box1, StructureBoundingBox box2) {
        return new StructureBoundingBox(Math.min(box1.d, box2.d), Math.min(box1.e, box2.e), Math.min(box1.f, box2.f), Math.max(box1.g, box2.g), Math.max(box1.h, box2.h), Math.max(box1.i, box2.i));
    }

    @Deprecated
    public StructureBoundingBox a(BlockPosition pos) {
        this.d = Math.min(this.d, pos.u());
        this.e = Math.min(this.e, pos.v());
        this.f = Math.min(this.f, pos.w());
        this.g = Math.max(this.g, pos.u());
        this.h = Math.max(this.h, pos.v());
        this.i = Math.max(this.i, pos.w());
        return this;
    }

    @Deprecated
    public StructureBoundingBox a(int x2, int y2, int z2) {
        this.d += x2;
        this.e += y2;
        this.f += z2;
        this.g += x2;
        this.h += y2;
        this.i += z2;
        return this;
    }

    @Deprecated
    public StructureBoundingBox a(BaseBlockPosition vector) {
        return this.a(vector.u(), vector.v(), vector.w());
    }

    public StructureBoundingBox b(int x2, int y2, int z2) {
        return new StructureBoundingBox(this.d + x2, this.e + y2, this.f + z2, this.g + x2, this.h + y2, this.i + z2);
    }

    public StructureBoundingBox a(int value) {
        return this.c(value, value, value);
    }

    public StructureBoundingBox c(int x2, int y2, int z2) {
        return new StructureBoundingBox(this.h() - x2, this.i() - y2, this.j() - z2, this.k() + x2, this.l() + y2, this.m() + z2);
    }

    public boolean b(BaseBlockPosition vector) {
        return this.d(vector.u(), vector.v(), vector.w());
    }

    public boolean d(int x2, int y2, int z2) {
        return x2 >= this.d && x2 <= this.g && z2 >= this.f && z2 <= this.i && y2 >= this.e && y2 <= this.h;
    }

    public BaseBlockPosition c() {
        return new BaseBlockPosition(this.g - this.d, this.h - this.e, this.i - this.f);
    }

    public int d() {
        return this.g - this.d + 1;
    }

    public int e() {
        return this.h - this.e + 1;
    }

    public int f() {
        return this.i - this.f + 1;
    }

    public BlockPosition g() {
        return new BlockPosition(this.d + (this.g - this.d + 1) / 2, this.e + (this.h - this.e + 1) / 2, this.f + (this.i - this.f + 1) / 2);
    }

    public void a(Consumer<BlockPosition> pos) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        pos.accept(mutableBlockPos.d(this.g, this.h, this.i));
        pos.accept(mutableBlockPos.d(this.d, this.h, this.i));
        pos.accept(mutableBlockPos.d(this.g, this.e, this.i));
        pos.accept(mutableBlockPos.d(this.d, this.e, this.i));
        pos.accept(mutableBlockPos.d(this.g, this.h, this.f));
        pos.accept(mutableBlockPos.d(this.d, this.h, this.f));
        pos.accept(mutableBlockPos.d(this.g, this.e, this.f));
        pos.accept(mutableBlockPos.d(this.d, this.e, this.f));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("minX", this.d).add("minY", this.e).add("minZ", this.f).add("maxX", this.g).add("maxY", this.h).add("maxZ", this.i).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof StructureBoundingBox)) return false;
        StructureBoundingBox boundingBox = (StructureBoundingBox)other;
        if (this.d != boundingBox.d) return false;
        if (this.e != boundingBox.e) return false;
        if (this.f != boundingBox.f) return false;
        if (this.g != boundingBox.g) return false;
        if (this.h != boundingBox.h) return false;
        if (this.i != boundingBox.i) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.d, this.e, this.f, this.g, this.h, this.i);
    }

    public int h() {
        return this.d;
    }

    public int i() {
        return this.e;
    }

    public int j() {
        return this.f;
    }

    public int k() {
        return this.g;
    }

    public int l() {
        return this.h;
    }

    public int m() {
        return this.i;
    }
}

