/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.loot.LootTable;
import org.bukkit.craftbukkit.v1_21_R6.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftChest;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_21_R6.util.TransformerGeneratorAccess;
import org.bukkit.entity.EntityType;
import org.slf4j.Logger;

public abstract class StructurePiece {
    protected static final IBlockData e = Blocks.nZ.m();
    protected StructureBoundingBox f;
    @Nullable
    private EnumDirection a;
    private EnumBlockMirror b;
    private EnumBlockRotation c;
    protected int g;
    private final WorldGenFeatureStructurePieceType d;
    public static final Set<Block> h = ImmutableSet.builder().add((Object)Blocks.gd).add((Object)Blocks.cL).add((Object)Blocks.cM).add((Object)Blocks.ex).add((Object)Blocks.kX).add((Object)Blocks.lc).add((Object)Blocks.ld).add((Object)Blocks.la).add((Object)Blocks.kY).add((Object)Blocks.kZ).add((Object)Blocks.dm).add((Object)Blocks.fC).build();
    private static final Logger LOGGER = LogUtils.getLogger();

    protected StructurePiece(WorldGenFeatureStructurePieceType type, int genDepth, StructureBoundingBox boundingBox) {
        this.d = type;
        this.g = genDepth;
        this.f = boundingBox;
    }

    public StructurePiece(WorldGenFeatureStructurePieceType type, NBTTagCompound tag) {
        this(type, tag.b("GD", 0), tag.a("BB", StructureBoundingBox.a).orElseThrow());
        int intOr = tag.b("O", 0);
        this.a(intOr == -1 ? null : EnumDirection.b(intOr));
    }

    protected static StructureBoundingBox a(int x2, int y2, int z2, EnumDirection direction, int offsetX, int offsetY, int offsetZ) {
        return direction.o() == EnumDirection.EnumAxis.c ? new StructureBoundingBox(x2, y2, z2, x2 + offsetX - 1, y2 + offsetY - 1, z2 + offsetZ - 1) : new StructureBoundingBox(x2, y2, z2, x2 + offsetZ - 1, y2 + offsetY - 1, z2 + offsetX - 1);
    }

    protected static EnumDirection a(RandomSource random) {
        return EnumDirection.EnumDirectionLimit.a.a(random);
    }

    public final NBTTagCompound a(StructurePieceSerializationContext context) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("id", BuiltInRegistries.R.b(this.k()).toString());
        compoundTag.a("BB", StructureBoundingBox.a, this.f);
        EnumDirection orientation = this.i();
        compoundTag.a("O", orientation == null ? -1 : orientation.e());
        compoundTag.a("GD", this.g);
        this.a(context, compoundTag);
        return compoundTag;
    }

    protected abstract void a(StructurePieceSerializationContext var1, NBTTagCompound var2);

    public void a(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
    }

    public abstract void a(GeneratorAccessSeed var1, StructureManager var2, ChunkGenerator var3, RandomSource var4, StructureBoundingBox var5, ChunkCoordIntPair var6, BlockPosition var7);

    public StructureBoundingBox f() {
        return this.f;
    }

    public int g() {
        return this.g;
    }

    public void a(int genDepth) {
        this.g = genDepth;
    }

    public boolean a(ChunkCoordIntPair chunkPos, int distance) {
        int minBlockX = chunkPos.d();
        int minBlockZ = chunkPos.e();
        return this.f.a(minBlockX - distance, minBlockZ - distance, minBlockX + 15 + distance, minBlockZ + 15 + distance);
    }

    public BlockPosition h() {
        return new BlockPosition(this.f.g());
    }

    protected BlockPosition.MutableBlockPosition b(int x2, int y2, int z2) {
        return new BlockPosition.MutableBlockPosition(this.a(x2, z2), this.b(y2), this.b(x2, z2));
    }

    protected int a(int x2, int z2) {
        EnumDirection orientation = this.i();
        if (orientation == null) {
            return x2;
        }
        switch (orientation) {
            case c: 
            case d: {
                return this.f.h() + x2;
            }
            case e: {
                return this.f.k() - z2;
            }
            case f: {
                return this.f.h() + z2;
            }
        }
        return x2;
    }

    protected int b(int y2) {
        return this.i() == null ? y2 : y2 + this.f.i();
    }

    protected int b(int x2, int z2) {
        EnumDirection orientation = this.i();
        if (orientation == null) {
            return z2;
        }
        switch (orientation) {
            case c: {
                return this.f.m() - z2;
            }
            case d: {
                return this.f.j() + z2;
            }
            case e: 
            case f: {
                return this.f.j() + x2;
            }
        }
        return z2;
    }

    protected void a(GeneratorAccessSeed level, IBlockData state, int x2, int y2, int z2, StructureBoundingBox boundingBox) {
        BlockPosition.MutableBlockPosition worldPos = this.b(x2, y2, z2);
        if (boundingBox.b(worldPos) && this.a(level, x2, y2, z2, boundingBox)) {
            TransformerGeneratorAccess transformerAccess;
            if (this.b != EnumBlockMirror.a) {
                state = state.a(this.b);
            }
            if (this.c != EnumBlockRotation.a) {
                state = state.a(this.c);
            }
            level.a((BlockPosition)worldPos, state, 2);
            if (level instanceof TransformerGeneratorAccess && (transformerAccess = (TransformerGeneratorAccess)level).canTransformBlocks()) {
                return;
            }
            Fluid fluidState = level.b_(worldPos);
            if (!fluidState.c()) {
                level.a((BlockPosition)worldPos, fluidState.a(), 0);
            }
            if (h.contains(state.b())) {
                level.A(worldPos).e(worldPos);
            }
        }
    }

    protected boolean placeCraftBlockEntity(WorldAccess levelAccessor, BlockPosition pos, CraftBlockEntityState<?> craftBlockEntityState, int flags) {
        TransformerGeneratorAccess transformerAccess;
        if (levelAccessor instanceof TransformerGeneratorAccess && (transformerAccess = (TransformerGeneratorAccess)levelAccessor).canTransformBlocks()) {
            return transformerAccess.setCraftBlock(pos, craftBlockEntityState, flags);
        }
        boolean result = levelAccessor.a(pos, craftBlockEntityState.getHandle(), flags);
        TileEntity blockEntity = levelAccessor.c_(pos);
        if (blockEntity != null) {
            try (ProblemReporter.j problemReporter = new ProblemReporter.j(() -> "StructurePieceTranformers@" + pos.x(), LOGGER);){
                blockEntity.b(TagValueInput.a((ProblemReporter)problemReporter, (HolderLookup.a)levelAccessor.L_(), craftBlockEntityState.getSnapshotNBT()));
            }
        }
        return result;
    }

    protected void placeCraftSpawner(WorldAccess levelAccessor, BlockPosition pos, EntityType entityType, int flags) {
        CraftCreatureSpawner spawner = (CraftCreatureSpawner)CraftBlockStates.getBlockState((IWorldReader)levelAccessor, pos, Blocks.cP.m(), null);
        spawner.setSpawnedType(entityType);
        this.placeCraftBlockEntity(levelAccessor, pos, spawner, flags);
    }

    protected void setCraftLootTable(WorldAccess levelAccessor, BlockPosition pos, RandomSource randomSource, ResourceKey<LootTable> lootTable) {
        TileEntity blockEntity = levelAccessor.c_(pos);
        if (blockEntity instanceof TileEntityLootable) {
            TransformerGeneratorAccess transformerAccess;
            TileEntityLootable lootContainerBlockEntity = (TileEntityLootable)blockEntity;
            lootContainerBlockEntity.a(lootTable, randomSource.g());
            if (levelAccessor instanceof TransformerGeneratorAccess && (transformerAccess = (TransformerGeneratorAccess)levelAccessor).canTransformBlocks()) {
                transformerAccess.setCraftBlock(pos, (CraftBlockState)CraftBlockStates.getBlockState((IWorldReader)levelAccessor, pos, blockEntity.o(), lootContainerBlockEntity.b(levelAccessor.L_())), 3);
            }
        }
    }

    protected boolean a(IWorldReader level, int x2, int y2, int z2, StructureBoundingBox box) {
        return true;
    }

    protected IBlockData a(IBlockAccess level, int x2, int y2, int z2, StructureBoundingBox box) {
        BlockPosition.MutableBlockPosition worldPos = this.b(x2, y2, z2);
        return !box.b(worldPos) ? Blocks.a.m() : level.a_(worldPos);
    }

    protected boolean b(IWorldReader level, int x2, int y2, int z2, StructureBoundingBox box) {
        BlockPosition.MutableBlockPosition worldPos = this.b(x2, y2 + 1, z2);
        return box.b(worldPos) && worldPos.v() < level.a(HeightMap.Type.c, worldPos.u(), worldPos.w());
    }

    protected void a(GeneratorAccessSeed level, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int i2 = minY; i2 <= maxY; ++i2) {
            for (int i1 = minX; i1 <= maxX; ++i1) {
                for (int i22 = minZ; i22 <= maxZ; ++i22) {
                    this.a(level, Blocks.a.m(), i1, i2, i22, box);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed level, StructureBoundingBox box, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, IBlockData boundaryBlockState, IBlockData insideBlockState, boolean existingOnly) {
        for (int i2 = yMin; i2 <= yMax; ++i2) {
            for (int i1 = xMin; i1 <= xMax; ++i1) {
                for (int i22 = zMin; i22 <= zMax; ++i22) {
                    if (existingOnly && this.a((IBlockAccess)level, i1, i2, i22, box).l()) continue;
                    if (i2 != yMin && i2 != yMax && i1 != xMin && i1 != xMax && i22 != zMin && i22 != zMax) {
                        this.a(level, insideBlockState, i1, i2, i22, box);
                        continue;
                    }
                    this.a(level, boundaryBlockState, i1, i2, i22, box);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed level, StructureBoundingBox boundingBox, StructureBoundingBox box, IBlockData boundaryBlockState, IBlockData insideBlockState, boolean existingOnly) {
        this.a(level, boundingBox, box.h(), box.i(), box.j(), box.k(), box.l(), box.m(), boundaryBlockState, insideBlockState, existingOnly);
    }

    protected void a(GeneratorAccessSeed level, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean alwaysReplace, RandomSource random, StructurePieceBlockSelector blockSelector) {
        for (int i2 = minY; i2 <= maxY; ++i2) {
            for (int i1 = minX; i1 <= maxX; ++i1) {
                for (int i22 = minZ; i22 <= maxZ; ++i22) {
                    if (alwaysReplace && this.a((IBlockAccess)level, i1, i2, i22, box).l()) continue;
                    blockSelector.a(random, i1, i2, i22, i2 == minY || i2 == maxY || i1 == minX || i1 == maxX || i22 == minZ || i22 == maxZ);
                    this.a(level, blockSelector.a(), i1, i2, i22, box);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed level, StructureBoundingBox boundingBox, StructureBoundingBox box, boolean alwaysReplace, RandomSource random, StructurePieceBlockSelector blockSelector) {
        this.a(level, boundingBox, box.h(), box.i(), box.j(), box.k(), box.l(), box.m(), alwaysReplace, random, blockSelector);
    }

    protected void a(GeneratorAccessSeed level, StructureBoundingBox box, RandomSource random, float chance, int x1, int y1, int z1, int x2, int y2, int z2, IBlockData edgeState, IBlockData state, boolean requireNonAir, boolean requireSkylight) {
        for (int i2 = y1; i2 <= y2; ++i2) {
            for (int i1 = x1; i1 <= x2; ++i1) {
                for (int i22 = z1; i22 <= z2; ++i22) {
                    if (random.i() > chance || requireNonAir && this.a((IBlockAccess)level, i1, i2, i22, box).l() || requireSkylight && !this.b(level, i1, i2, i22, box)) continue;
                    if (i2 != y1 && i2 != y2 && i1 != x1 && i1 != x2 && i22 != z1 && i22 != z2) {
                        this.a(level, state, i1, i2, i22, box);
                        continue;
                    }
                    this.a(level, edgeState, i1, i2, i22, box);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed level, StructureBoundingBox box, RandomSource random, float chance, int x2, int y2, int z2, IBlockData state) {
        if (random.i() < chance) {
            this.a(level, state, x2, y2, z2, box);
        }
    }

    protected void a(GeneratorAccessSeed level, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockData state, boolean excludeAir) {
        float f2 = maxX - minX + 1;
        float f1 = maxY - minY + 1;
        float f22 = maxZ - minZ + 1;
        float f3 = (float)minX + f2 / 2.0f;
        float f4 = (float)minZ + f22 / 2.0f;
        for (int i2 = minY; i2 <= maxY; ++i2) {
            float f5 = (float)(i2 - minY) / f1;
            for (int i1 = minX; i1 <= maxX; ++i1) {
                float f6 = ((float)i1 - f3) / (f2 * 0.5f);
                for (int i22 = minZ; i22 <= maxZ; ++i22) {
                    float f8;
                    float f7 = ((float)i22 - f4) / (f22 * 0.5f);
                    if (excludeAir && this.a((IBlockAccess)level, i1, i2, i22, box).l() || !((f8 = f6 * f6 + f5 * f5 + f7 * f7) <= 1.05f)) continue;
                    this.a(level, state, i1, i2, i22, box);
                }
            }
        }
    }

    protected void b(GeneratorAccessSeed level, IBlockData state, int x2, int y2, int z2, StructureBoundingBox box) {
        BlockPosition.MutableBlockPosition worldPos = this.b(x2, y2, z2);
        if (box.b(worldPos)) {
            while (this.a(level.a_(worldPos)) && worldPos.v() > level.M_() + 1) {
                level.a((BlockPosition)worldPos, state, 2);
                worldPos.c(EnumDirection.a);
            }
        }
    }

    protected boolean a(IBlockData state) {
        return state.l() || state.n() || state.a(Blocks.fO) || state.a(Blocks.bG) || state.a(Blocks.bH);
    }

    protected boolean a(GeneratorAccessSeed level, StructureBoundingBox box, RandomSource random, int x2, int y2, int z2, ResourceKey<LootTable> lootTable) {
        return this.a((WorldAccess)level, box, random, this.b(x2, y2, z2), lootTable, null);
    }

    public static IBlockData a(IBlockAccess level, BlockPosition pos, IBlockData state) {
        EnumDirection direction = null;
        for (EnumDirection direction1 : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockPos = pos.a(direction1);
            IBlockData blockState = level.a_(blockPos);
            if (blockState.a(Blocks.cS)) {
                return state;
            }
            if (!blockState.s()) continue;
            if (direction != null) {
                direction = null;
                break;
            }
            direction = direction1;
        }
        if (direction != null) {
            return (IBlockData)state.b(BlockFacingHorizontal.f, direction.g());
        }
        EnumDirection direction2 = state.c(BlockFacingHorizontal.f);
        BlockPosition blockPos1 = pos.a(direction2);
        if (level.a_(blockPos1).s()) {
            direction2 = direction2.g();
            blockPos1 = pos.a(direction2);
        }
        if (level.a_(blockPos1).s()) {
            direction2 = direction2.h();
            blockPos1 = pos.a(direction2);
        }
        if (level.a_(blockPos1).s()) {
            direction2 = direction2.g();
            blockPos1 = pos.a(direction2);
        }
        return (IBlockData)state.b(BlockFacingHorizontal.f, direction2);
    }

    protected boolean a(WorldAccess level, StructureBoundingBox box, RandomSource random, BlockPosition pos, ResourceKey<LootTable> lootTable, @Nullable IBlockData state) {
        if (box.b(pos) && !level.a_(pos).a(Blocks.cS)) {
            if (state == null) {
                state = StructurePiece.a(level, pos, Blocks.cS.m());
            }
            CraftChest chestState = (CraftChest)CraftBlockStates.getBlockState((IWorldReader)level, pos, state, null);
            chestState.setLootTable(CraftLootTable.minecraftToBukkit(lootTable));
            chestState.setSeed(random.g());
            this.placeCraftBlockEntity(level, pos, chestState, 2);
            return true;
        }
        return false;
    }

    protected boolean a(GeneratorAccessSeed level, StructureBoundingBox box, RandomSource random, int x2, int y2, int z2, EnumDirection facing, ResourceKey<LootTable> lootTable) {
        BlockPosition.MutableBlockPosition worldPos = this.b(x2, y2, z2);
        if (box.b(worldPos) && !level.a_(worldPos).a(Blocks.bb)) {
            if (!this.a(level, x2, y2, z2, this.f)) {
                return true;
            }
            IBlockData dispenserBlockState = (IBlockData)Blocks.bb.m().b(BlockDispenser.b, facing);
            if (this.b != EnumBlockMirror.a) {
                dispenserBlockState = dispenserBlockState.a(this.b);
            }
            if (this.c != EnumBlockRotation.a) {
                dispenserBlockState = dispenserBlockState.a(this.c);
            }
            CraftDispenser dispenserState = (CraftDispenser)CraftBlockStates.getBlockState((IWorldReader)level, (BlockPosition)worldPos, dispenserBlockState, null);
            dispenserState.setLootTable(CraftLootTable.minecraftToBukkit(lootTable));
            dispenserState.setSeed(random.g());
            this.placeCraftBlockEntity(level, worldPos, dispenserState, 2);
            return true;
        }
        return false;
    }

    public void a(int x2, int y2, int z2) {
        this.f.a(x2, y2, z2);
    }

    public static StructureBoundingBox a(Stream<StructurePiece> pieces) {
        return StructureBoundingBox.b(pieces.map(StructurePiece::f)::iterator).orElseThrow(() -> new IllegalStateException("Unable to calculate boundingbox without pieces"));
    }

    @Nullable
    public static StructurePiece a(List<StructurePiece> pieces, StructureBoundingBox boundingBox) {
        for (StructurePiece structurePiece : pieces) {
            if (!structurePiece.f().a(boundingBox)) continue;
            return structurePiece;
        }
        return null;
    }

    @Nullable
    public EnumDirection i() {
        return this.a;
    }

    public void a(@Nullable EnumDirection orientation) {
        this.a = orientation;
        if (orientation == null) {
            this.c = EnumBlockRotation.a;
            this.b = EnumBlockMirror.a;
        } else {
            switch (orientation) {
                case d: {
                    this.b = EnumBlockMirror.b;
                    this.c = EnumBlockRotation.a;
                    break;
                }
                case e: {
                    this.b = EnumBlockMirror.b;
                    this.c = EnumBlockRotation.b;
                    break;
                }
                case f: {
                    this.b = EnumBlockMirror.a;
                    this.c = EnumBlockRotation.b;
                    break;
                }
                default: {
                    this.b = EnumBlockMirror.a;
                    this.c = EnumBlockRotation.a;
                }
            }
        }
    }

    public EnumBlockRotation a() {
        return this.c;
    }

    public EnumBlockMirror j() {
        return this.b;
    }

    public WorldGenFeatureStructurePieceType k() {
        return this.d;
    }

    public static abstract class StructurePieceBlockSelector {
        protected IBlockData a = Blocks.a.m();

        public abstract void a(RandomSource var1, int var2, int var3, int var4, boolean var5);

        public IBlockData a() {
            return this.a;
        }
    }
}

