/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.SinglePieceStructure;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidPiece;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R6.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBrushableBlock;
import org.bukkit.craftbukkit.v1_21_R6.util.TransformerGeneratorAccess;

public class DesertPyramidStructure
extends SinglePieceStructure {
    public static final MapCodec<DesertPyramidStructure> d = DesertPyramidStructure.a(DesertPyramidStructure::new);

    public DesertPyramidStructure(Structure.c settings) {
        super(DesertPyramidPiece::new, 21, 21, settings);
    }

    @Override
    public void a(GeneratorAccessSeed level, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox boundingBox, ChunkCoordIntPair chunkPos, PiecesContainer pieces) {
        Comparator set = ArraySetSorted.a(BaseBlockPosition::i);
        for (StructurePiece structurePiece : pieces.c()) {
            if (!(structurePiece instanceof DesertPyramidPiece)) continue;
            DesertPyramidPiece desertPyramidPiece = (DesertPyramidPiece)structurePiece;
            set.addAll(desertPyramidPiece.b());
            DesertPyramidStructure.a(boundingBox, level, desertPyramidPiece.c());
        }
        ObjectArrayList list = new ObjectArrayList(set.stream().toList());
        RandomSource randomSource = RandomSource.a(level.H()).e().a(pieces.b().g());
        SystemUtils.c(list, randomSource);
        int min = Math.min(set.size(), randomSource.b(5, 8));
        for (BlockPosition blockPos : list) {
            if (min > 0) {
                --min;
                DesertPyramidStructure.a(boundingBox, level, blockPos);
                continue;
            }
            if (!boundingBox.b(blockPos)) continue;
            level.a(blockPos, Blocks.L.m(), 2);
        }
    }

    private static void a(StructureBoundingBox boundingBox, GeneratorAccessSeed worldGenLevel, BlockPosition pos) {
        if (boundingBox.b(pos)) {
            TransformerGeneratorAccess transformerAccess;
            if (worldGenLevel instanceof TransformerGeneratorAccess && (transformerAccess = (TransformerGeneratorAccess)worldGenLevel).canTransformBlocks()) {
                CraftBrushableBlock brushableState = (CraftBrushableBlock)CraftBlockStates.getBlockState((IWorldReader)worldGenLevel, pos, Blocks.M.m(), null);
                brushableState.setLootTable(CraftLootTable.minecraftToBukkit(LootTables.bk));
                brushableState.setSeed(pos.a());
                transformerAccess.setCraftBlock(pos, brushableState, 2);
                return;
            }
            worldGenLevel.a(pos, Blocks.M.m(), 2);
            worldGenLevel.a(pos, TileEntityTypes.P).ifPresent(brushableBlockEntity -> brushableBlockEntity.a(LootTables.bk, pos.a()));
        }
    }

    @Override
    public StructureType<?> e() {
        return StructureType.b;
    }
}

