/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public final class JigsawStructure
extends Structure {
    public static final DimensionPadding d = DimensionPadding.b;
    public static final LiquidSettings e = LiquidSettings.b;
    public static final int f = 128;
    public static final int g = 0;
    public static final int h = 20;
    public static final MapCodec<JigsawStructure> i = RecordCodecBuilder.mapCodec(instance -> instance.group(JigsawStructure.a(instance), (App)WorldGenFeatureDefinedStructurePoolTemplate.b.fieldOf("start_pool").forGetter(structure -> structure.j), (App)MinecraftKey.a.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.k), (App)Codec.intRange((int)0, (int)20).fieldOf("size").forGetter(structure -> structure.l), (App)HeightProvider.c.fieldOf("start_height").forGetter(structure -> structure.m), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(structure -> structure.n), (App)HeightMap.Type.g.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.o), (App)net.minecraft.world.level.levelgen.structure.structures.JigsawStructure$a.a.fieldOf("max_distance_from_center").forGetter(structure -> structure.p), (App)Codec.list(PoolAliasBinding.b).optionalFieldOf("pool_aliases", List.of()).forGetter(structure -> structure.q), (App)DimensionPadding.a.optionalFieldOf("dimension_padding", (Object)d).forGetter(structure -> structure.r), (App)LiquidSettings.c.optionalFieldOf("liquid_settings", (Object)e).forGetter(structure -> structure.s)).apply((Applicative)instance, JigsawStructure::new)).validate(JigsawStructure::a);
    private final Holder<WorldGenFeatureDefinedStructurePoolTemplate> j;
    private final Optional<MinecraftKey> k;
    private final int l;
    private final HeightProvider m;
    private final boolean n;
    private final Optional<HeightMap.Type> o;
    private final a p;
    private final List<PoolAliasBinding> q;
    private final DimensionPadding r;
    private final LiquidSettings s;

    private static DataResult<JigsawStructure> a(JigsawStructure structure) {
        int i2 = switch (structure.d()) {
            default -> throw new MatchException(null, null);
            case TerrainAdjustment.a -> 0;
            case TerrainAdjustment.b, TerrainAdjustment.c, TerrainAdjustment.d, TerrainAdjustment.e -> 12;
        };
        return structure.p.a() + i2 > 128 ? DataResult.error(() -> "Horizontal structure size including terrain adaptation must not exceed 128") : DataResult.success((Object)structure);
    }

    public JigsawStructure(Structure.c settings, Holder<WorldGenFeatureDefinedStructurePoolTemplate> startPool, Optional<MinecraftKey> startJigsawName, int maxDepth, HeightProvider startHeight, boolean useExpansionHack, Optional<HeightMap.Type> projectStartToHeightmap, a maxDistanceFromCenter, List<PoolAliasBinding> poolAliases, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
        super(settings);
        this.j = startPool;
        this.k = startJigsawName;
        this.l = maxDepth;
        this.m = startHeight;
        this.n = useExpansionHack;
        this.o = projectStartToHeightmap;
        this.p = maxDistanceFromCenter;
        this.q = poolAliases;
        this.r = dimensionPadding;
        this.s = liquidSettings;
    }

    public JigsawStructure(Structure.c settings, Holder<WorldGenFeatureDefinedStructurePoolTemplate> startPool, int maxDepth, HeightProvider startHeight, boolean useExpansionHack, HeightMap.Type projectStartToHeightmap) {
        this(settings, startPool, Optional.empty(), maxDepth, startHeight, useExpansionHack, Optional.of(projectStartToHeightmap), new a(80), List.of(), d, e);
    }

    public JigsawStructure(Structure.c settings, Holder<WorldGenFeatureDefinedStructurePoolTemplate> startPool, int maxDepth, HeightProvider startHeight, boolean useExpansionHack) {
        this(settings, startPool, Optional.empty(), maxDepth, startHeight, useExpansionHack, Optional.empty(), new a(80), List.of(), d, e);
    }

    @Override
    public Optional<Structure.b> a(Structure.a context) {
        ChunkCoordIntPair chunkPos = context.h();
        int i2 = this.m.a(context.f(), new WorldGenerationContext(context.b(), context.i()));
        BlockPosition blockPos = new BlockPosition(chunkPos.d(), i2, chunkPos.e());
        return WorldGenFeatureDefinedStructureJigsawPlacement.a(context, this.j, this.k, this.l, blockPos, this.n, this.o, this.p, PoolAliasLookup.create(this.q, blockPos, context.g()), this.r, this.s);
    }

    @Override
    public StructureType<?> e() {
        return StructureType.f;
    }

    @VisibleForTesting
    public Holder<WorldGenFeatureDefinedStructurePoolTemplate> f() {
        return this.j;
    }

    @VisibleForTesting
    public List<PoolAliasBinding> g() {
        return this.q;
    }

    public static final class a
    extends Record {
        private final int b;
        private final int c;
        private static final Codec<Integer> d = Codec.intRange((int)1, (int)128);
        private static final Codec<a> e = RecordCodecBuilder.create(instance -> instance.group((App)d.fieldOf("horizontal").forGetter(a::a), (App)ExtraCodecs.a(1, 4064).optionalFieldOf("vertical", (Object)4064).forGetter(a::b)).apply((Applicative)instance, a::new));
        public static final Codec<a> a = Codec.either(e, d).xmap(either -> either.map(Function.identity(), a::new), maxDistance -> maxDistance.b == maxDistance.c ? Either.right(maxDistance.b) : Either.left(maxDistance));

        public a(int distance) {
            this(distance, distance);
        }

        public a(int horizontal, int vertical) {
            this.b = horizontal;
            this.c = vertical;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "horizontal;vertical", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "horizontal;vertical", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "horizontal;vertical", "b", "c"}, this, o2);
        }

        public int a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }
    }
}

