/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.structures.OceanRuinStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorPredicates;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R6.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftChest;

public class OceanRuinPieces {
    static final DefinedStructureProcessor a = OceanRuinPieces.a(Blocks.L, Blocks.M, LootTables.bn);
    static final DefinedStructureProcessor b = OceanRuinPieces.a(Blocks.O, Blocks.P, LootTables.bo);
    private static final MinecraftKey[] c = new MinecraftKey[]{MinecraftKey.b("underwater_ruin/warm_1"), MinecraftKey.b("underwater_ruin/warm_2"), MinecraftKey.b("underwater_ruin/warm_3"), MinecraftKey.b("underwater_ruin/warm_4"), MinecraftKey.b("underwater_ruin/warm_5"), MinecraftKey.b("underwater_ruin/warm_6"), MinecraftKey.b("underwater_ruin/warm_7"), MinecraftKey.b("underwater_ruin/warm_8")};
    private static final MinecraftKey[] d = new MinecraftKey[]{MinecraftKey.b("underwater_ruin/brick_1"), MinecraftKey.b("underwater_ruin/brick_2"), MinecraftKey.b("underwater_ruin/brick_3"), MinecraftKey.b("underwater_ruin/brick_4"), MinecraftKey.b("underwater_ruin/brick_5"), MinecraftKey.b("underwater_ruin/brick_6"), MinecraftKey.b("underwater_ruin/brick_7"), MinecraftKey.b("underwater_ruin/brick_8")};
    private static final MinecraftKey[] e = new MinecraftKey[]{MinecraftKey.b("underwater_ruin/cracked_1"), MinecraftKey.b("underwater_ruin/cracked_2"), MinecraftKey.b("underwater_ruin/cracked_3"), MinecraftKey.b("underwater_ruin/cracked_4"), MinecraftKey.b("underwater_ruin/cracked_5"), MinecraftKey.b("underwater_ruin/cracked_6"), MinecraftKey.b("underwater_ruin/cracked_7"), MinecraftKey.b("underwater_ruin/cracked_8")};
    private static final MinecraftKey[] f = new MinecraftKey[]{MinecraftKey.b("underwater_ruin/mossy_1"), MinecraftKey.b("underwater_ruin/mossy_2"), MinecraftKey.b("underwater_ruin/mossy_3"), MinecraftKey.b("underwater_ruin/mossy_4"), MinecraftKey.b("underwater_ruin/mossy_5"), MinecraftKey.b("underwater_ruin/mossy_6"), MinecraftKey.b("underwater_ruin/mossy_7"), MinecraftKey.b("underwater_ruin/mossy_8")};
    private static final MinecraftKey[] g = new MinecraftKey[]{MinecraftKey.b("underwater_ruin/big_brick_1"), MinecraftKey.b("underwater_ruin/big_brick_2"), MinecraftKey.b("underwater_ruin/big_brick_3"), MinecraftKey.b("underwater_ruin/big_brick_8")};
    private static final MinecraftKey[] h = new MinecraftKey[]{MinecraftKey.b("underwater_ruin/big_mossy_1"), MinecraftKey.b("underwater_ruin/big_mossy_2"), MinecraftKey.b("underwater_ruin/big_mossy_3"), MinecraftKey.b("underwater_ruin/big_mossy_8")};
    private static final MinecraftKey[] i = new MinecraftKey[]{MinecraftKey.b("underwater_ruin/big_cracked_1"), MinecraftKey.b("underwater_ruin/big_cracked_2"), MinecraftKey.b("underwater_ruin/big_cracked_3"), MinecraftKey.b("underwater_ruin/big_cracked_8")};
    private static final MinecraftKey[] j = new MinecraftKey[]{MinecraftKey.b("underwater_ruin/big_warm_4"), MinecraftKey.b("underwater_ruin/big_warm_5"), MinecraftKey.b("underwater_ruin/big_warm_6"), MinecraftKey.b("underwater_ruin/big_warm_7")};

    private static DefinedStructureProcessor a(Block block, Block suspiciousBlock, ResourceKey<LootTable> lootTable) {
        return new CappedProcessor(new DefinedStructureProcessorRule(List.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(block), DefinedStructureTestTrue.b, PosRuleTestTrue.b, suspiciousBlock.m(), new AppendLoot(lootTable)))), ConstantInt.a(5));
    }

    private static MinecraftKey a(RandomSource random) {
        return SystemUtils.a(c, random);
    }

    private static MinecraftKey b(RandomSource random) {
        return SystemUtils.a(j, random);
    }

    public static void a(StructureTemplateManager structureTemplateManager, BlockPosition pos, EnumBlockRotation rotation, StructurePieceAccessor structurePieceAccessor, RandomSource random, OceanRuinStructure structure) {
        boolean flag = random.i() <= structure.f;
        float f2 = flag ? 0.9f : 0.8f;
        OceanRuinPieces.a(structureTemplateManager, pos, rotation, structurePieceAccessor, random, structure, flag, f2);
        if (flag && random.i() <= structure.g) {
            OceanRuinPieces.a(structureTemplateManager, random, rotation, pos, structure, structurePieceAccessor);
        }
    }

    private static void a(StructureTemplateManager structureTemplateManager, RandomSource random, EnumBlockRotation rotation, BlockPosition pos, OceanRuinStructure structure, StructurePieceAccessor structurePieceAccessor) {
        BlockPosition blockPos = new BlockPosition(pos.u(), 90, pos.w());
        BlockPosition blockPos1 = DefinedStructure.a(new BlockPosition(15, 0, 15), EnumBlockMirror.a, rotation, BlockPosition.c).a(blockPos);
        StructureBoundingBox boundingBox = StructureBoundingBox.a((BaseBlockPosition)blockPos, (BaseBlockPosition)blockPos1);
        BlockPosition blockPos2 = new BlockPosition(Math.min(blockPos.u(), blockPos1.u()), blockPos.v(), Math.min(blockPos.w(), blockPos1.w()));
        List<BlockPosition> list = OceanRuinPieces.a(random, blockPos2);
        int randomInt = MathHelper.a(random, 4, 8);
        for (int i2 = 0; i2 < randomInt; ++i2) {
            EnumBlockRotation random1;
            BlockPosition blockPos4;
            int randomInt1;
            BlockPosition blockPos3;
            StructureBoundingBox boundingBox1;
            if (list.isEmpty() || (boundingBox1 = StructureBoundingBox.a((BaseBlockPosition)(blockPos3 = list.remove(randomInt1 = random.a(list.size()))), (BaseBlockPosition)(blockPos4 = DefinedStructure.a(new BlockPosition(5, 0, 6), EnumBlockMirror.a, random1 = EnumBlockRotation.a(random), BlockPosition.c).a(blockPos3)))).a(boundingBox)) continue;
            OceanRuinPieces.a(structureTemplateManager, blockPos3, random1, structurePieceAccessor, random, structure, false, 0.8f);
        }
    }

    private static List<BlockPosition> a(RandomSource random, BlockPosition pos) {
        ArrayList list = Lists.newArrayList();
        list.add(pos.b(-16 + MathHelper.a(random, 1, 8), 0, 16 + MathHelper.a(random, 1, 7)));
        list.add(pos.b(-16 + MathHelper.a(random, 1, 8), 0, MathHelper.a(random, 1, 7)));
        list.add(pos.b(-16 + MathHelper.a(random, 1, 8), 0, -16 + MathHelper.a(random, 4, 8)));
        list.add(pos.b(MathHelper.a(random, 1, 7), 0, 16 + MathHelper.a(random, 1, 7)));
        list.add(pos.b(MathHelper.a(random, 1, 7), 0, -16 + MathHelper.a(random, 4, 6)));
        list.add(pos.b(16 + MathHelper.a(random, 1, 7), 0, 16 + MathHelper.a(random, 3, 8)));
        list.add(pos.b(16 + MathHelper.a(random, 1, 7), 0, MathHelper.a(random, 1, 7)));
        list.add(pos.b(16 + MathHelper.a(random, 1, 7), 0, -16 + MathHelper.a(random, 4, 8)));
        return list;
    }

    private static void a(StructureTemplateManager structureTemplateManager, BlockPosition pos, EnumBlockRotation rotation, StructurePieceAccessor structurePieceAccessor, RandomSource random, OceanRuinStructure structure, boolean isLarge, float integrity) {
        switch (structure.e) {
            default: {
                MinecraftKey resourceLocation = isLarge ? OceanRuinPieces.b(random) : OceanRuinPieces.a(random);
                structurePieceAccessor.a(new a(structureTemplateManager, resourceLocation, pos, rotation, integrity, structure.e, isLarge));
                break;
            }
            case b: {
                MinecraftKey[] resourceLocations = isLarge ? g : d;
                MinecraftKey[] resourceLocations1 = isLarge ? i : e;
                MinecraftKey[] resourceLocations2 = isLarge ? h : f;
                int randomInt = random.a(resourceLocations.length);
                structurePieceAccessor.a(new a(structureTemplateManager, resourceLocations[randomInt], pos, rotation, integrity, structure.e, isLarge));
                structurePieceAccessor.a(new a(structureTemplateManager, resourceLocations1[randomInt], pos, rotation, 0.7f, structure.e, isLarge));
                structurePieceAccessor.a(new a(structureTemplateManager, resourceLocations2[randomInt], pos, rotation, 0.5f, structure.e, isLarge));
            }
        }
    }

    public static class a
    extends DefinedStructurePiece {
        private final OceanRuinStructure.a h;
        private final float i;
        private final boolean j;

        public a(StructureTemplateManager structureTemplateManager, MinecraftKey location, BlockPosition pos, EnumBlockRotation rotation, float integrity, OceanRuinStructure.a biomeType, boolean isLarge) {
            super(WorldGenFeatureStructurePieceType.H, 0, structureTemplateManager, location, location.toString(), net.minecraft.world.level.levelgen.structure.structures.OceanRuinPieces$a.a(rotation, integrity, biomeType), pos);
            this.i = integrity;
            this.h = biomeType;
            this.j = isLarge;
        }

        private a(StructureTemplateManager structureTemplateManager, NBTTagCompound genDepth, EnumBlockRotation rotation, float integrity, OceanRuinStructure.a biomeType, boolean isLarge) {
            super(WorldGenFeatureStructurePieceType.H, genDepth, structureTemplateManager, resourceLocation -> net.minecraft.world.level.levelgen.structure.structures.OceanRuinPieces$a.a(rotation, integrity, biomeType));
            this.i = integrity;
            this.h = biomeType;
            this.j = isLarge;
        }

        private static DefinedStructureInfo a(EnumBlockRotation rotation, float integrity, OceanRuinStructure.a structureType) {
            DefinedStructureProcessor structureProcessor = structureType == OceanRuinStructure.a.b ? b : a;
            return new DefinedStructureInfo().a(rotation).a(EnumBlockMirror.a).a(new DefinedStructureProcessorRotation(integrity)).a(DefinedStructureProcessorBlockIgnore.d).a(structureProcessor);
        }

        public static a a(StructureTemplateManager structureTemplateManager, NBTTagCompound tag) {
            EnumBlockRotation rotation = tag.a("Rot", EnumBlockRotation.h).orElseThrow();
            float floatOr = tag.b("Integrity", 0.0f);
            OceanRuinStructure.a type = tag.a("BiomeType", OceanRuinStructure.a.d).orElseThrow();
            boolean booleanOr = tag.b("IsLarge", false);
            return new a(structureTemplateManager, tag, rotation, floatOr, type, booleanOr);
        }

        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound tag) {
            super.a(context, tag);
            tag.a("Rot", EnumBlockRotation.h, this.c.d());
            tag.a("Integrity", this.i);
            tag.a("BiomeType", OceanRuinStructure.a.d, this.h);
            tag.a("IsLarge", this.j);
        }

        @Override
        protected void a(String name, BlockPosition pos, WorldAccess level, RandomSource random, StructureBoundingBox box) {
            EntityDrowned drowned;
            if ("chest".equals(name)) {
                CraftChest craftChest = (CraftChest)CraftBlockStates.getBlockState((IWorldReader)level, pos, (IBlockData)Blocks.cS.m().b(BlockChest.e, level.b_(pos).a(TagsFluid.a)), null);
                craftChest.setSeed(random.g());
                craftChest.setLootTable(CraftLootTable.minecraftToBukkit(this.j ? LootTables.E : LootTables.D));
                this.placeCraftBlockEntity(level, pos, craftChest, 2);
            } else if ("drowned".equals(name) && (drowned = EntityTypes.N.a(level.a(), EntitySpawnReason.d)) != null) {
                drowned.gq();
                drowned.a(pos, 0.0f, 0.0f);
                drowned.a(level, level.d_(pos), EntitySpawnReason.d, null);
                level.a_(drowned);
                if (pos.v() > level.T()) {
                    level.a(pos, Blocks.a.m(), 2);
                } else {
                    level.a(pos, Blocks.J.m(), 2);
                }
            }
        }

        @Override
        public void a(GeneratorAccessSeed level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, StructureBoundingBox box, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            int height = level.a(HeightMap.Type.c, this.d.u(), this.d.w());
            this.d = new BlockPosition(this.d.u(), height, this.d.w());
            BlockPosition blockPos = DefinedStructure.a(new BlockPosition(this.b.a().u() - 1, 0, this.b.a().w() - 1), EnumBlockMirror.a, this.c.d(), BlockPosition.c).a(this.d);
            this.d = new BlockPosition(this.d.u(), this.a(this.d, level, blockPos), this.d.w());
            super.a(level, structureManager, generator, random, box, chunkPos, pos);
        }

        private int a(BlockPosition templatePos, IBlockAccess level, BlockPosition pos) {
            int y2 = templatePos.v();
            int i2 = 512;
            int i1 = y2 - 1;
            int i22 = 0;
            for (BlockPosition blockPos : BlockPosition.c(templatePos, pos)) {
                int x2 = blockPos.u();
                int z2 = blockPos.w();
                int i3 = templatePos.v() - 1;
                BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(x2, i3, z2);
                IBlockData blockState = level.a_(mutableBlockPos);
                Fluid fluidState = level.b_(mutableBlockPos);
                while ((blockState.l() || fluidState.a(TagsFluid.a) || blockState.a(TagsBlock.aC)) && i3 > level.M_() + 1) {
                    mutableBlockPos.d(x2, --i3, z2);
                    blockState = level.a_(mutableBlockPos);
                    fluidState = level.b_(mutableBlockPos);
                }
                i2 = Math.min(i2, i3);
                if (i3 >= i1 - 2) continue;
                ++i22;
            }
            int abs = Math.abs(templatePos.u() - pos.u());
            if (i1 - i2 > 2 && i22 > abs - 2) {
                y2 = i2 + 1;
            }
            return y2;
        }
    }
}

