/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;

public class CappedProcessor
extends DefinedStructureProcessor {
    public static final MapCodec<CappedProcessor> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DefinedStructureStructureProcessorType.a.fieldOf("delegate").forGetter(processor -> processor.b), (App)IntProvider.e.fieldOf("limit").forGetter(processor -> processor.c)).apply((Applicative)instance, CappedProcessor::new));
    private final DefinedStructureProcessor b;
    private final IntProvider c;

    public CappedProcessor(DefinedStructureProcessor delegate, IntProvider limit) {
        this.b = delegate;
        this.c = limit;
    }

    @Override
    protected DefinedStructureStructureProcessorType<?> a() {
        return DefinedStructureStructureProcessorType.o;
    }

    @Override
    public final List<DefinedStructure.BlockInfo> a(WorldAccess level, BlockPosition offset, BlockPosition pos, List<DefinedStructure.BlockInfo> originalBlockInfos, List<DefinedStructure.BlockInfo> processedBlockInfos, DefinedStructureInfo settings) {
        if (this.c.b() != 0 && !processedBlockInfos.isEmpty()) {
            if (originalBlockInfos.size() != processedBlockInfos.size()) {
                SystemUtils.b("Original block info list not in sync with processed list, skipping processing. Original size: " + originalBlockInfos.size() + ", Processed size: " + processedBlockInfos.size());
                return processedBlockInfos;
            }
            RandomSource randomSource = RandomSource.a(level.a().H()).e().a(offset);
            int min = Math.min(this.c.a(randomSource), processedBlockInfos.size());
            if (min < 1) {
                return processedBlockInfos;
            }
            IntArrayList list = SystemUtils.a(IntStream.range(0, processedBlockInfos.size()), randomSource);
            IntIterator intIterator = list.intIterator();
            int i2 = 0;
            while (intIterator.hasNext() && i2 < min) {
                DefinedStructure.BlockInfo structureBlockInfo1;
                int i1 = intIterator.nextInt();
                DefinedStructure.BlockInfo structureBlockInfo = originalBlockInfos.get(i1);
                DefinedStructure.BlockInfo structureBlockInfo2 = this.b.a((IWorldReader)level, offset, pos, structureBlockInfo, structureBlockInfo1 = processedBlockInfos.get(i1), settings);
                if (structureBlockInfo2 == null || structureBlockInfo1.equals(structureBlockInfo2)) continue;
                ++i2;
                processedBlockInfos.set(i1, structureBlockInfo2);
            }
            return processedBlockInfos;
        }
        return processedBlockInfos;
    }
}

