/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorPerlin;

public class NoiseGeneratorOctaves {
    private static final int a = 0x2000000;
    private final NoiseGeneratorPerlin[] b;
    private final int c;
    private final DoubleList d;
    private final double e;
    private final double f;
    private final double g;

    @Deprecated
    public static NoiseGeneratorOctaves a(RandomSource random, IntStream octaves) {
        return new NoiseGeneratorOctaves(random, NoiseGeneratorOctaves.a((IntSortedSet)new IntRBTreeSet((Collection)octaves.boxed().collect(ImmutableList.toImmutableList()))), false);
    }

    @Deprecated
    public static NoiseGeneratorOctaves a(RandomSource random, int firstOctave, DoubleList amplitudes) {
        return new NoiseGeneratorOctaves(random, (Pair<Integer, DoubleList>)Pair.of((Object)firstOctave, (Object)amplitudes), false);
    }

    public static NoiseGeneratorOctaves b(RandomSource random, IntStream octaves) {
        return NoiseGeneratorOctaves.a(random, (List)octaves.boxed().collect(ImmutableList.toImmutableList()));
    }

    public static NoiseGeneratorOctaves a(RandomSource random, List<Integer> octaves) {
        return new NoiseGeneratorOctaves(random, NoiseGeneratorOctaves.a((IntSortedSet)new IntRBTreeSet(octaves)), true);
    }

    public static NoiseGeneratorOctaves a(RandomSource random, int firstOctave, double firstAmplitude, double ... amplitudes) {
        DoubleArrayList list = new DoubleArrayList(amplitudes);
        list.add(0, firstAmplitude);
        return new NoiseGeneratorOctaves(random, (Pair<Integer, DoubleList>)Pair.of((Object)firstOctave, (Object)list), true);
    }

    public static NoiseGeneratorOctaves b(RandomSource random, int firstOctave, DoubleList amplitudes) {
        return new NoiseGeneratorOctaves(random, (Pair<Integer, DoubleList>)Pair.of((Object)firstOctave, (Object)amplitudes), true);
    }

    private static Pair<Integer, DoubleList> a(IntSortedSet octaves) {
        int i1;
        if (octaves.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int i2 = -octaves.firstInt();
        int i22 = i2 + (i1 = octaves.lastInt()) + 1;
        if (i22 < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        DoubleArrayList list = new DoubleArrayList(new double[i22]);
        IntBidirectionalIterator intBidirectionalIterator = octaves.iterator();
        while (intBidirectionalIterator.hasNext()) {
            int i3 = intBidirectionalIterator.nextInt();
            list.set(i3 + i2, 1.0);
        }
        return Pair.of((Object)(-i2), (Object)list);
    }

    protected NoiseGeneratorOctaves(RandomSource random, Pair<Integer, DoubleList> octavesAndAmplitudes, boolean useNewFactory) {
        this.c = (Integer)octavesAndAmplitudes.getFirst();
        this.d = (DoubleList)octavesAndAmplitudes.getSecond();
        int size = this.d.size();
        int i2 = -this.c;
        this.b = new NoiseGeneratorPerlin[size];
        if (useNewFactory) {
            PositionalRandomFactory positionalRandomFactory = random.e();
            for (int i1 = 0; i1 < size; ++i1) {
                if (this.d.getDouble(i1) == 0.0) continue;
                int i22 = this.c + i1;
                this.b[i1] = new NoiseGeneratorPerlin(positionalRandomFactory.a("octave_" + i22));
            }
        } else {
            double _double;
            NoiseGeneratorPerlin improvedNoise = new NoiseGeneratorPerlin(random);
            if (i2 >= 0 && i2 < size && (_double = this.d.getDouble(i2)) != 0.0) {
                this.b[i2] = improvedNoise;
            }
            for (int i1x = i2 - 1; i1x >= 0; --i1x) {
                if (i1x < size) {
                    double _double1 = this.d.getDouble(i1x);
                    if (_double1 != 0.0) {
                        this.b[i1x] = new NoiseGeneratorPerlin(random);
                        continue;
                    }
                    NoiseGeneratorOctaves.a(random);
                    continue;
                }
                NoiseGeneratorOctaves.a(random);
            }
            if (Arrays.stream(this.b).filter(Objects::nonNull).count() != this.d.stream().filter(amplitude -> amplitude != 0.0).count()) {
                throw new IllegalStateException("Failed to create correct number of noise levels for given non-zero amplitudes");
            }
            if (i2 < size - 1) {
                throw new IllegalArgumentException("Positive octaves are temporarily disabled");
            }
        }
        this.f = Math.pow(2.0, -i2);
        this.e = Math.pow(2.0, size - 1) / (Math.pow(2.0, size) - 1.0);
        this.g = this.c(2.0);
    }

    protected double a() {
        return this.g;
    }

    private static void a(RandomSource random) {
        random.b(262);
    }

    public double a(double x2, double y2, double z2) {
        return this.a(x2, y2, z2, 0.0, 0.0, false);
    }

    @Deprecated
    public double a(double x2, double y2, double z2, double yScale, double yMax, boolean useFixedY) {
        double d2 = 0.0;
        double d1 = this.f;
        double d22 = this.e;
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            NoiseGeneratorPerlin improvedNoise = this.b[i2];
            if (improvedNoise != null) {
                double d3 = improvedNoise.a(NoiseGeneratorOctaves.b(x2 * d1), useFixedY ? -improvedNoise.b : NoiseGeneratorOctaves.b(y2 * d1), NoiseGeneratorOctaves.b(z2 * d1), yScale * d1, yMax * d1);
                d2 += this.d.getDouble(i2) * d3 * d22;
            }
            d1 *= 2.0;
            d22 /= 2.0;
        }
        return d2;
    }

    public double a(double yMultiplier) {
        return this.c(yMultiplier + 2.0);
    }

    private double c(double multiplier) {
        double d2 = 0.0;
        double d1 = this.e;
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            NoiseGeneratorPerlin improvedNoise = this.b[i2];
            if (improvedNoise != null) {
                d2 += this.d.getDouble(i2) * multiplier * d1;
            }
            d1 /= 2.0;
        }
        return d2;
    }

    @Nullable
    public NoiseGeneratorPerlin a(int octave) {
        return this.b[this.b.length - 1 - octave];
    }

    public static double b(double value) {
        return value - (double)MathHelper.b(value / 3.3554432E7 + 0.5) * 3.3554432E7;
    }

    protected int b() {
        return this.c;
    }

    protected DoubleList c() {
        return this.d;
    }

    @VisibleForTesting
    public void a(StringBuilder builder) {
        builder.append("PerlinNoise{");
        List<String> list = this.d.stream().map(amplitude -> String.format(Locale.ROOT, "%.2f", amplitude)).toList();
        builder.append("first octave: ").append(this.c).append(", amplitudes: ").append(list).append(", noise levels: [");
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            builder.append(i2).append(": ");
            NoiseGeneratorPerlin improvedNoise = this.b[i2];
            if (improvedNoise == null) {
                builder.append("null");
            } else {
                improvedNoise.a(builder);
            }
            builder.append(", ");
        }
        builder.append("]");
        builder.append("}");
    }
}

