/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.DataBits;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class ChunkSkyLightSources {
    private static final int b = 16;
    public static final int a = Integer.MIN_VALUE;
    private final int c;
    private final DataBits d;
    private final BlockPosition.MutableBlockPosition e = new BlockPosition.MutableBlockPosition();
    private final BlockPosition.MutableBlockPosition f = new BlockPosition.MutableBlockPosition();

    public ChunkSkyLightSources(LevelHeightAccessor level) {
        this.c = level.M_() - 1;
        int i2 = level.ar() + 1;
        int i1 = MathHelper.f(i2 - this.c + 1);
        this.d = new SimpleBitStorage(i1, 256);
    }

    public void a(IChunkAccess chunk) {
        int highestFilledSectionIndex = chunk.a();
        if (highestFilledSectionIndex == -1) {
            this.a(this.c);
        } else {
            for (int i2 = 0; i2 < 16; ++i2) {
                for (int i1 = 0; i1 < 16; ++i1) {
                    int max = Math.max(this.a(chunk, highestFilledSectionIndex, i1, i2), this.c);
                    this.b(ChunkSkyLightSources.c(i1, i2), max);
                }
            }
        }
    }

    private int a(IChunkAccess chunk, int sectionIndex, int x2, int z2) {
        int blockPosCoord = SectionPosition.c(chunk.h(sectionIndex) + 1);
        BlockPosition.MutableBlockPosition mutableBlockPos = this.e.d(x2, blockPosCoord, z2);
        BlockPosition.MutableBlockPosition mutableBlockPos1 = this.f.a((BaseBlockPosition)mutableBlockPos, EnumDirection.a);
        IBlockData blockState = Blocks.a.m();
        for (int i2 = sectionIndex; i2 >= 0; --i2) {
            int sectionYFromSectionIndex;
            ChunkSection section = chunk.b(i2);
            if (section.c()) {
                blockState = Blocks.a.m();
                sectionYFromSectionIndex = chunk.h(i2);
                mutableBlockPos.q(SectionPosition.c(sectionYFromSectionIndex));
                mutableBlockPos1.q(mutableBlockPos.v() - 1);
                continue;
            }
            for (sectionYFromSectionIndex = 15; sectionYFromSectionIndex >= 0; --sectionYFromSectionIndex) {
                IBlockData blockState1 = section.a(x2, sectionYFromSectionIndex, z2);
                if (ChunkSkyLightSources.a(blockState, blockState1)) {
                    return mutableBlockPos.v();
                }
                blockState = blockState1;
                mutableBlockPos.g(mutableBlockPos1);
                mutableBlockPos1.c(EnumDirection.a);
            }
        }
        return this.c;
    }

    public boolean a(IBlockAccess level, int x2, int y2, int z2) {
        IBlockData blockState1;
        BlockPosition.MutableBlockPosition blockPos1;
        IBlockData blockState;
        int i2 = y2 + 1;
        int i1 = ChunkSkyLightSources.c(x2, z2);
        int i22 = this.b(i1);
        if (i2 < i22) {
            return false;
        }
        BlockPosition.MutableBlockPosition blockPos = this.e.d(x2, y2 + 1, z2);
        if (this.a(level, i1, i22, blockPos, blockState = level.a_(blockPos), blockPos1 = this.f.d(x2, y2, z2), blockState1 = level.a_(blockPos1))) {
            return true;
        }
        BlockPosition.MutableBlockPosition blockPos2 = this.e.d(x2, y2 - 1, z2);
        IBlockData blockState2 = level.a_(blockPos2);
        return this.a(level, i1, i22, blockPos1, blockState1, blockPos2, blockState2);
    }

    private boolean a(IBlockAccess level, int index, int minY, BlockPosition pos1, IBlockData state1, BlockPosition pos2, IBlockData state2) {
        int y2 = pos1.v();
        if (ChunkSkyLightSources.a(state1, state2)) {
            if (y2 > minY) {
                this.b(index, y2);
                return true;
            }
        } else if (y2 == minY) {
            this.b(index, this.a(level, pos2, state2));
            return true;
        }
        return false;
    }

    private int a(IBlockAccess level, BlockPosition pos, IBlockData state) {
        BlockPosition.MutableBlockPosition mutableBlockPos = this.e.g(pos);
        BlockPosition.MutableBlockPosition mutableBlockPos1 = this.f.a((BaseBlockPosition)pos, EnumDirection.a);
        IBlockData blockState = state;
        while (mutableBlockPos1.v() >= this.c) {
            IBlockData blockState1 = level.a_(mutableBlockPos1);
            if (ChunkSkyLightSources.a(blockState, blockState1)) {
                return mutableBlockPos.v();
            }
            blockState = blockState1;
            mutableBlockPos.g(mutableBlockPos1);
            mutableBlockPos1.c(EnumDirection.a);
        }
        return this.c;
    }

    private static boolean a(IBlockData state1, IBlockData state2) {
        if (state2.g() != 0) {
            return true;
        }
        VoxelShape occlusionShape = LightEngine.a(state1, EnumDirection.a);
        VoxelShape occlusionShape1 = LightEngine.a(state2, EnumDirection.b);
        return VoxelShapes.b(occlusionShape, occlusionShape1);
    }

    public int a(int x2, int z2) {
        int i2 = this.b(ChunkSkyLightSources.c(x2, z2));
        return this.c(i2);
    }

    public int a() {
        int i2 = Integer.MIN_VALUE;
        for (int i1 = 0; i1 < this.d.b(); ++i1) {
            int i22 = this.d.a(i1);
            if (i22 <= i2) continue;
            i2 = i22;
        }
        return this.c(i2 + this.c);
    }

    private void a(int value) {
        int i2 = value - this.c;
        for (int i1 = 0; i1 < this.d.b(); ++i1) {
            this.d.b(i1, i2);
        }
    }

    private void b(int index, int value) {
        this.d.b(index, value - this.c);
    }

    private int b(int index) {
        return this.d.a(index) + this.c;
    }

    private int c(int y2) {
        return y2 == this.c ? Integer.MIN_VALUE : y2;
    }

    private static int c(int x2, int z2) {
        return x2 + z2 * 16;
    }
}

