/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;

public class PathPoint {
    public final int a;
    public final int b;
    public final int c;
    private final int m;
    public int d = -1;
    public float e;
    public float f;
    public float g;
    @Nullable
    public PathPoint h;
    public boolean i;
    public float j;
    public float k;
    public PathType l = PathType.a;

    public PathPoint(int x2, int y2, int z2) {
        this.a = x2;
        this.b = y2;
        this.c = z2;
        this.m = PathPoint.b(x2, y2, z2);
    }

    public PathPoint a(int x2, int y2, int z2) {
        PathPoint node = new PathPoint(x2, y2, z2);
        node.d = this.d;
        node.e = this.e;
        node.f = this.f;
        node.g = this.g;
        node.h = this.h;
        node.i = this.i;
        node.j = this.j;
        node.k = this.k;
        node.l = this.l;
        return node;
    }

    public static int b(int x2, int y2, int z2) {
        return y2 & 0xFF | (x2 & Short.MAX_VALUE) << 8 | (z2 & Short.MAX_VALUE) << 24 | (x2 < 0 ? Integer.MIN_VALUE : 0) | (z2 < 0 ? 32768 : 0);
    }

    public float a(PathPoint node) {
        float f2 = node.a - this.a;
        float f1 = node.b - this.b;
        float f22 = node.c - this.c;
        return MathHelper.c(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public float b(PathPoint node) {
        float f2 = node.a - this.a;
        float f1 = node.c - this.c;
        return MathHelper.c(f2 * f2 + f1 * f1);
    }

    public float a(BlockPosition pos) {
        float f2 = pos.u() - this.a;
        float f1 = pos.v() - this.b;
        float f22 = pos.w() - this.c;
        return MathHelper.c(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public float c(PathPoint node) {
        float f2 = node.a - this.a;
        float f1 = node.b - this.b;
        float f22 = node.c - this.c;
        return f2 * f2 + f1 * f1 + f22 * f22;
    }

    public float b(BlockPosition pos) {
        float f2 = pos.u() - this.a;
        float f1 = pos.v() - this.b;
        float f22 = pos.w() - this.c;
        return f2 * f2 + f1 * f1 + f22 * f22;
    }

    public float d(PathPoint node) {
        float f2 = Math.abs(node.a - this.a);
        float f1 = Math.abs(node.b - this.b);
        float f22 = Math.abs(node.c - this.c);
        return f2 + f1 + f22;
    }

    public float c(BlockPosition pos) {
        float f2 = Math.abs(pos.u() - this.a);
        float f1 = Math.abs(pos.v() - this.b);
        float f22 = Math.abs(pos.w() - this.c);
        return f2 + f1 + f22;
    }

    public BlockPosition a() {
        return new BlockPosition(this.a, this.b, this.c);
    }

    public Vec3D b() {
        return new Vec3D(this.a, this.b, this.c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof PathPoint)) return false;
        PathPoint node = (PathPoint)other;
        if (this.m != node.m) return false;
        if (this.a != node.a) return false;
        if (this.b != node.b) return false;
        if (this.c != node.c) return false;
        return true;
    }

    public int hashCode() {
        return this.m;
    }

    public boolean c() {
        return this.d >= 0;
    }

    public String toString() {
        return "Node{x=" + this.a + ", y=" + this.b + ", z=" + this.c + "}";
    }

    public void a(PacketDataSerializer buffer) {
        buffer.q(this.a);
        buffer.q(this.b);
        buffer.q(this.c);
        buffer.a(this.j);
        buffer.a(this.k);
        buffer.a(this.i);
        buffer.a(this.l);
        buffer.a(this.g);
    }

    public static PathPoint b(PacketDataSerializer buffer) {
        PathPoint node = new PathPoint(buffer.readInt(), buffer.readInt(), buffer.readInt());
        PathPoint.a(buffer, node);
        return node;
    }

    protected static void a(PacketDataSerializer buffer, PathPoint node) {
        node.j = buffer.readFloat();
        node.k = buffer.readFloat();
        node.i = buffer.readBoolean();
        node.l = buffer.b(PathType.class);
        node.g = buffer.readFloat();
    }
}

