/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.PoiAccess;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.HeightMap;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.util.BlockStateListPopulator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class PortalTravelAgent {
    public static final int a = 3;
    private static final int b = 16;
    private static final int c = 128;
    private static final int d = 5;
    private static final int e = 4;
    private static final int f = 3;
    private static final int g = -1;
    private static final int h = 4;
    private static final int i = -1;
    private static final int j = 3;
    private static final int k = -1;
    private static final int l = 2;
    private static final int m = -1;
    private final WorldServer n;

    public PortalTravelAgent(WorldServer level) {
        this.n = level;
    }

    @Deprecated
    @DoNotUse
    public Optional<BlockPosition> a(BlockPosition exitPos, boolean isNether, WorldBorder worldBorder) {
        return this.findClosestPortalPosition(exitPos, worldBorder, isNether ? 16 : 128);
    }

    public Optional<BlockPosition> findClosestPortalPosition(BlockPosition exitPos, WorldBorder worldBorder, int i2) {
        VillagePlace poiManager = this.n.D();
        ArrayList<VillagePlaceRecord> records = new ArrayList<VillagePlaceRecord>();
        PoiAccess.findClosestPoiDataRecords(poiManager, type -> type.a(PoiTypes.r), pos -> {
            IChunkAccess lowest = this.n.a(pos.u() >> 4, pos.w() >> 4, ChunkStatus.c);
            if (!(lowest.n().a(ChunkStatus.n) || lowest.z() != null && lowest.z().a().a(ChunkStatus.m))) {
                return false;
            }
            if (!worldBorder.a((BlockPosition)pos) || this.n.getTypeKey() == WorldDimension.c && this.n.paperConfig().environment.netherCeilingVoidDamageHeight.test(v2 -> pos.v() >= v2)) {
                return false;
            }
            return lowest.a_((BlockPosition)pos).b(BlockProperties.J);
        }, exitPos, i2, Double.MAX_VALUE, VillagePlace.Occupancy.c, true, records);
        BaseBlockPosition lowestPos = null;
        for (VillagePlaceRecord record : records) {
            if (lowestPos == null) {
                lowestPos = record.g();
                continue;
            }
            if (lowestPos.v() <= record.g().v()) continue;
            lowestPos = record.g();
        }
        return Optional.ofNullable(lowestPos);
    }

    public Optional<BlockUtil.Rectangle> a(BlockPosition pos, EnumDirection.EnumAxis axis) {
        return this.createPortal(pos, axis, null, 16);
    }

    public Optional<BlockUtil.Rectangle> createPortal(BlockPosition pos, EnumDirection.EnumAxis axis, @Nullable net.minecraft.world.entity.Entity entity, int createRadius) {
        int i4;
        EnumDirection direction = EnumDirection.a(EnumDirection.EnumAxisDirection.a, axis);
        double d2 = -1.0;
        BlockPosition blockPos = null;
        double d1 = -1.0;
        BlockPosition blockPos1 = null;
        WorldBorder worldBorder = this.n.u();
        int min = Math.min(this.n.ar(), this.n.M_() + this.n.m() - 1);
        if (this.n.getTypeKey() == WorldDimension.c && this.n.paperConfig().environment.netherCeilingVoidDamageHeight.enabled()) {
            min = Math.min(min, this.n.paperConfig().environment.netherCeilingVoidDamageHeight.intValue() - 1);
        }
        boolean i2 = true;
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        for (BlockPosition.MutableBlockPosition mutableBlockPos1 : BlockPosition.a(pos, createRadius, EnumDirection.f, EnumDirection.d)) {
            int min1 = Math.min(min, this.n.a(HeightMap.Type.e, mutableBlockPos1.u(), mutableBlockPos1.w()));
            if (!worldBorder.a(mutableBlockPos1) || !worldBorder.a(mutableBlockPos1.c(direction, 1))) continue;
            mutableBlockPos1.c(direction.g(), 1);
            for (int i1 = min1; i1 >= this.n.M_(); --i1) {
                int i3;
                mutableBlockPos1.q(i1);
                if (!this.a(mutableBlockPos1)) continue;
                int i22 = i1;
                while (i1 > this.n.M_() && this.a(mutableBlockPos1.c(EnumDirection.a))) {
                    --i1;
                }
                if (i1 + 4 > min || (i3 = i22 - i1) > 0 && i3 < 3) continue;
                mutableBlockPos1.q(i1);
                if (!this.a(mutableBlockPos1, mutableBlockPos, direction, 0)) continue;
                double d22 = pos.j(mutableBlockPos1);
                if (this.a(mutableBlockPos1, mutableBlockPos, direction, -1) && this.a(mutableBlockPos1, mutableBlockPos, direction, 1) && (d2 == -1.0 || d2 > d22)) {
                    d2 = d22;
                    blockPos = mutableBlockPos1.j();
                }
                if (d2 != -1.0 || d1 != -1.0 && !(d1 > d22)) continue;
                d1 = d22;
                blockPos1 = mutableBlockPos1.j();
            }
        }
        if (d2 == -1.0 && d1 != -1.0) {
            blockPos = blockPos1;
            d2 = d1;
        }
        BlockStateListPopulator blockList = new BlockStateListPopulator(this.n);
        if (d2 == -1.0) {
            i4 = min - 9;
            int max = Math.max(this.n.M_() - -1, 70);
            if (i4 < max) {
                return Optional.empty();
            }
            blockPos = new BlockPosition(pos.u() - direction.j() * 1, MathHelper.a(pos.v(), max, i4), pos.w() - direction.l() * 1).j();
            blockPos = worldBorder.b(blockPos);
            EnumDirection clockWise = direction.h();
            for (int i1x = -1; i1x < 2; ++i1x) {
                for (int i23 = 0; i23 < 2; ++i23) {
                    for (int i3 = -1; i3 < 3; ++i3) {
                        IBlockData blockState = i3 < 0 ? Blocks.cK.m() : Blocks.a.m();
                        mutableBlockPos.a(blockPos, i23 * direction.j() + i1x * clockWise.j(), i3, i23 * direction.l() + i1x * clockWise.l());
                        blockList.a((BlockPosition)mutableBlockPos, blockState, 3);
                    }
                }
            }
        }
        for (int max = -1; max < 3; ++max) {
            for (i4 = -1; i4 < 4; ++i4) {
                if (max != -1 && max != 2 && i4 != -1 && i4 != 3) continue;
                mutableBlockPos.a(blockPos, max * direction.j(), i4, max * direction.l());
                blockList.a((BlockPosition)mutableBlockPos, Blocks.cK.m(), 3);
            }
        }
        IBlockData blockState1 = (IBlockData)Blocks.eI.m().b(BlockPortal.b, axis);
        for (int i4x = 0; i4x < 2; ++i4x) {
            for (int min1 = 0; min1 < 3; ++min1) {
                mutableBlockPos.a(blockPos, i4x * direction.j(), min1, i4x * direction.l());
                blockList.a((BlockPosition)mutableBlockPos, blockState1, 18);
            }
        }
        CraftWorld bworld = this.n.getWorld();
        PortalCreateEvent event = new PortalCreateEvent(blockList.getSnapshotBlocks(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.NETHER_PAIR);
        this.n.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return Optional.empty();
        }
        blockList.placeBlocks();
        return Optional.of(new BlockUtil.Rectangle(blockPos.j(), 2, 3));
    }

    private boolean a(BlockPosition.MutableBlockPosition pos) {
        IBlockData blockState = this.n.a_(pos);
        return blockState.v() && blockState.y().c();
    }

    private boolean a(BlockPosition originalPos, BlockPosition.MutableBlockPosition offsetPos, EnumDirection direction, int offsetScale) {
        EnumDirection clockWise = direction.h();
        for (int i2 = -1; i2 < 3; ++i2) {
            for (int i1 = -1; i1 < 4; ++i1) {
                offsetPos.a(originalPos, direction.j() * i2 + clockWise.j() * offsetScale, i1, direction.l() * i2 + clockWise.l() * offsetScale);
                if (!GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits && !this.n.a_(offsetPos).isDestroyable()) {
                    return false;
                }
                if (i1 < 0 && !this.n.a_(offsetPos).e()) {
                    return false;
                }
                if (i1 < 0 || this.a(offsetPos)) continue;
                return false;
            }
        }
        return true;
    }
}

