/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Streams;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueInputContextHelper;

public class TagValueInput
implements ValueInput {
    private final ProblemReporter a;
    private final ValueInputContextHelper b;
    public final NBTTagCompound c;

    private TagValueInput(ProblemReporter problemReporter, ValueInputContextHelper context, NBTTagCompound input) {
        this.a = problemReporter;
        this.b = context;
        this.c = input;
    }

    public static ValueInput createGlobal(ProblemReporter problemReporter, NBTTagCompound compoundTag) {
        return TagValueInput.a(problemReporter, (HolderLookup.a)MinecraftServer.getServer().bg(), compoundTag);
    }

    public static ValueInput a(ProblemReporter problemReporter, HolderLookup.a lookup, NBTTagCompound input) {
        return new TagValueInput(problemReporter, new ValueInputContextHelper(lookup, DynamicOpsNBT.a), input);
    }

    public static ValueInput.b a(ProblemReporter problemReporter, HolderLookup.a lookup, List<NBTTagCompound> input) {
        return new a(problemReporter, new ValueInputContextHelper(lookup, DynamicOpsNBT.a), input);
    }

    @Override
    public <T> Optional<T> a(String key, Codec<T> codec) {
        NBTBase tag = this.c.a(key);
        if (tag == null) {
            return Optional.empty();
        }
        DataResult dataResult = codec.parse(this.b.a(), (Object)tag);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n2)) {
            case 0 -> {
                DataResult.Success success = (DataResult.Success)dataResult2;
                yield Optional.of(success.value());
            }
            case 1 -> {
                DataResult.Error error = (DataResult.Error)dataResult2;
                this.a.a(new b(key, tag, error));
                yield error.partialValue();
            }
            default -> throw new MatchException(null, null);
        };
    }

    @Override
    public <T> Optional<T> a(MapCodec<T> codec) {
        DynamicOps<NBTBase> dynamicOps = this.b.a();
        DataResult dataResult = dynamicOps.getMap((Object)this.c).flatMap(mapLike -> codec.decode(dynamicOps, mapLike));
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n2)) {
            case 0 -> {
                DataResult.Success success = (DataResult.Success)dataResult2;
                yield Optional.of(success.value());
            }
            case 1 -> {
                DataResult.Error error = (DataResult.Error)dataResult2;
                this.a.a(new d(error));
                yield error.partialValue();
            }
            default -> throw new MatchException(null, null);
        };
    }

    @Nullable
    private <T extends NBTBase> T a(String key, NBTTagType<T> type) {
        NBTBase tag = this.c.a(key);
        if (tag == null) {
            return null;
        }
        NBTTagType<?> type1 = tag.c();
        if (type1 != type) {
            this.a.a(new i(key, type, type1));
            return null;
        }
        return (T)tag;
    }

    @Nullable
    private NBTNumber i(String key) {
        NBTBase tag = this.c.a(key);
        if (tag == null) {
            return null;
        }
        if (tag instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)tag;
            return numericTag;
        }
        this.a.a(new h(key, tag.c()));
        return null;
    }

    @Override
    public Optional<ValueInput> a(String key) {
        NBTTagCompound compoundTag = this.a(key, NBTTagCompound.b);
        return compoundTag != null ? Optional.of(this.a(key, compoundTag)) : Optional.empty();
    }

    @Override
    public ValueInput b(String key) {
        NBTTagCompound compoundTag = this.a(key, NBTTagCompound.b);
        return compoundTag != null ? this.a(key, compoundTag) : this.b.c();
    }

    @Override
    public Optional<ValueInput.b> c(String key) {
        NBTTagList listTag = this.a(key, NBTTagList.a);
        return listTag != null ? Optional.of(this.a(key, this.b, listTag)) : Optional.empty();
    }

    @Override
    public ValueInput.b d(String key) {
        NBTTagList listTag = this.a(key, NBTTagList.a);
        return listTag != null ? this.a(key, this.b, listTag) : this.b.d();
    }

    @Override
    public <T> Optional<ValueInput.a<T>> b(String key, Codec<T> elementCodec) {
        NBTTagList listTag = this.a(key, NBTTagList.a);
        return listTag != null ? Optional.of(this.a(key, listTag, elementCodec)) : Optional.empty();
    }

    @Override
    public <T> ValueInput.a<T> c(String key, Codec<T> elementCodec) {
        NBTTagList listTag = this.a(key, NBTTagList.a);
        return listTag != null ? this.a(key, listTag, elementCodec) : this.b.e();
    }

    @Override
    public boolean a(String key, boolean defaultValue) {
        NBTNumber numericTag = this.i(key);
        return numericTag != null ? numericTag.j() != 0 : defaultValue;
    }

    @Override
    public byte a(String key, byte defaultValue) {
        NBTNumber numericTag = this.i(key);
        return numericTag != null ? numericTag.j() : defaultValue;
    }

    @Override
    public int a(String key, short defaultValue) {
        NBTNumber numericTag = this.i(key);
        return numericTag != null ? numericTag.i() : defaultValue;
    }

    @Override
    public Optional<Integer> e(String key) {
        NBTNumber numericTag = this.i(key);
        return numericTag != null ? Optional.of(numericTag.h()) : Optional.empty();
    }

    @Override
    public int a(String key, int defaultValue) {
        NBTNumber numericTag = this.i(key);
        return numericTag != null ? numericTag.h() : defaultValue;
    }

    @Override
    public long a(String key, long defaultValue) {
        NBTNumber numericTag = this.i(key);
        return numericTag != null ? numericTag.g() : defaultValue;
    }

    @Override
    public Optional<Long> f(String key) {
        NBTNumber numericTag = this.i(key);
        return numericTag != null ? Optional.of(numericTag.g()) : Optional.empty();
    }

    @Override
    public float a(String key, float defaultValue) {
        NBTNumber numericTag = this.i(key);
        return numericTag != null ? numericTag.l() : defaultValue;
    }

    @Override
    public double a(String key, double defaultValue) {
        NBTNumber numericTag = this.i(key);
        return numericTag != null ? numericTag.k() : defaultValue;
    }

    @Override
    public Optional<String> g(String key) {
        NBTTagString stringTag = this.a(key, NBTTagString.a);
        return stringTag != null ? Optional.of(stringTag.k()) : Optional.empty();
    }

    @Override
    public String a(String key, String defaultValue) {
        NBTTagString stringTag = this.a(key, NBTTagString.a);
        return stringTag != null ? stringTag.k() : defaultValue;
    }

    @Override
    public Optional<int[]> h(String key) {
        NBTTagIntArray intArrayTag = this.a(key, NBTTagIntArray.a);
        return intArrayTag != null ? Optional.of(intArrayTag.g()) : Optional.empty();
    }

    @Override
    public HolderLookup.a a() {
        return this.b.b();
    }

    private ValueInput a(String key, NBTTagCompound tag) {
        return tag.j() ? this.b.c() : new TagValueInput(this.a.a(new ProblemReporter.c(key)), this.b, tag);
    }

    static ValueInput a(ProblemReporter problemReporter, ValueInputContextHelper context, NBTTagCompound tag) {
        return tag.j() ? context.c() : new TagValueInput(problemReporter, context, tag);
    }

    private ValueInput.b a(String key, ValueInputContextHelper context, NBTTagList tag) {
        return tag.isEmpty() ? context.d() : new e(this.a, key, context, tag);
    }

    private <T> ValueInput.a<T> a(String key, NBTTagList tag, Codec<T> codec) {
        return tag.isEmpty() ? this.b.e() : new f<T>(this.a, key, this.b, codec, tag);
    }

    static class a
    implements ValueInput.b {
        private final ProblemReporter a;
        private final ValueInputContextHelper b;
        private final List<NBTTagCompound> c;

        public a(ProblemReporter problemReporter, ValueInputContextHelper context, List<NBTTagCompound> list) {
            this.a = problemReporter;
            this.b = context;
            this.c = list;
        }

        ValueInput a(int index, NBTTagCompound tag) {
            return TagValueInput.a(this.a.a(new ProblemReporter.e(index)), this.b, tag);
        }

        @Override
        public boolean a() {
            return this.c.isEmpty();
        }

        @Override
        public Stream<ValueInput> b() {
            return Streams.mapWithIndex(this.c.stream(), (compoundTag, l2) -> this.a((int)l2, (NBTTagCompound)compoundTag));
        }

        @Override
        public Iterator<ValueInput> iterator() {
            final ListIterator<NBTTagCompound> listIterator = this.c.listIterator();
            return new AbstractIterator<ValueInput>(){

                @Nullable
                protected ValueInput a() {
                    if (listIterator.hasNext()) {
                        int i2 = listIterator.nextIndex();
                        NBTTagCompound compoundTag = (NBTTagCompound)listIterator.next();
                        return this.a(i2, compoundTag);
                    }
                    return (ValueInput)this.endOfData();
                }
            };
        }
    }

    public record b(String a, NBTBase b, DataResult.Error<?> c) implements ProblemReporter.g
    {
        private final String a;
        private final NBTBase b;
        private final DataResult.Error<?> c;

        @Override
        public String a() {
            return "Failed to decode value '" + String.valueOf(this.b) + "' from field '" + this.a + "': " + this.c.message();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "name;tag;error", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "name;tag;error", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "name;tag;error", "a", "b", "c"}, this, o2);
        }

        public String b() {
            return this.a;
        }

        public NBTBase c() {
            return this.b;
        }

        public DataResult.Error<?> d() {
            return this.c;
        }
    }

    public record d(DataResult.Error<?> a) implements ProblemReporter.g
    {
        private final DataResult.Error<?> a;

        @Override
        public String a() {
            return "Failed to decode from map: " + this.a.message();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "error", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "error", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "error", "a"}, this, o2);
        }

        public DataResult.Error<?> b() {
            return this.a;
        }
    }

    public record i(String a, NBTTagType<?> b, NBTTagType<?> c) implements ProblemReporter.g
    {
        private final String a;
        private final NBTTagType<?> b;
        private final NBTTagType<?> c;

        @Override
        public String a() {
            return "Expected field '" + this.a + "' to contain value of type " + this.b.a() + ", but got " + this.c.a();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{i.class, "name;expected;actual", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{i.class, "name;expected;actual", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{i.class, "name;expected;actual", "a", "b", "c"}, this, o2);
        }

        public String b() {
            return this.a;
        }

        public NBTTagType<?> c() {
            return this.b;
        }

        public NBTTagType<?> d() {
            return this.c;
        }
    }

    public record h(String a, NBTTagType<?> b) implements ProblemReporter.g
    {
        private final String a;
        private final NBTTagType<?> b;

        @Override
        public String a() {
            return "Expected field '" + this.a + "' to contain number, but got " + this.b.a();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "name;actual", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "name;actual", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "name;actual", "a", "b"}, this, o2);
        }

        public String b() {
            return this.a;
        }

        public NBTTagType<?> c() {
            return this.b;
        }
    }

    static class e
    implements ValueInput.b {
        private final ProblemReporter a;
        private final String b;
        final ValueInputContextHelper c;
        private final NBTTagList d;

        e(ProblemReporter problemReporter, String name, ValueInputContextHelper context, NBTTagList list) {
            this.a = problemReporter;
            this.b = name;
            this.c = context;
            this.d = list;
        }

        @Override
        public boolean a() {
            return this.d.isEmpty();
        }

        ProblemReporter a(int index) {
            return this.a.a(new ProblemReporter.d(this.b, index));
        }

        void a(int index, NBTBase tag) {
            this.a.a(new g(this.b, index, NBTTagCompound.b, tag.c()));
        }

        @Override
        public Stream<ValueInput> b() {
            return Streams.mapWithIndex(this.d.stream(), (tag, l2) -> {
                if (tag instanceof NBTTagCompound) {
                    NBTTagCompound compoundTag = (NBTTagCompound)tag;
                    return TagValueInput.a(this.a((int)l2), this.c, compoundTag);
                }
                this.a((int)l2, (NBTBase)tag);
                return null;
            }).filter(Objects::nonNull);
        }

        @Override
        public Iterator<ValueInput> iterator() {
            final Iterator iterator = this.d.iterator();
            return new AbstractIterator<ValueInput>(){
                private int c;

                @Nullable
                protected ValueInput a() {
                    while (iterator.hasNext()) {
                        int i2;
                        NBTBase tag = (NBTBase)iterator.next();
                        ++this.c;
                        if (tag instanceof NBTTagCompound) {
                            NBTTagCompound compoundTag = (NBTTagCompound)tag;
                            return TagValueInput.a(this.a(i2), c, compoundTag);
                        }
                        this.a(i2, tag);
                    }
                    return (ValueInput)this.endOfData();
                }
            };
        }
    }

    static class f<T>
    implements ValueInput.a<T> {
        private final ProblemReporter a;
        private final String b;
        final ValueInputContextHelper c;
        final Codec<T> d;
        private final NBTTagList e;

        f(ProblemReporter problemReporter, String name, ValueInputContextHelper context, Codec<T> codec, NBTTagList list) {
            this.a = problemReporter;
            this.b = name;
            this.c = context;
            this.d = codec;
            this.e = list;
        }

        @Override
        public boolean a() {
            return this.e.isEmpty();
        }

        void a(int index, NBTBase tag, DataResult.Error<?> error) {
            this.a.a(new c(this.b, index, tag, error));
        }

        @Override
        public Stream<T> b() {
            return Streams.mapWithIndex(this.e.stream(), (tag, l2) -> {
                DataResult dataResult = this.d.parse(this.c.a(), tag);
                Objects.requireNonNull(dataResult);
                DataResult selector0$temp = dataResult;
                int index$1 = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)selector0$temp, index$1)) {
                    case 0 -> {
                        DataResult.Success success = (DataResult.Success)selector0$temp;
                        yield success.value();
                    }
                    case 1 -> {
                        DataResult.Error error = (DataResult.Error)selector0$temp;
                        this.a((int)l2, (NBTBase)tag, (DataResult.Error<?>)error);
                        yield error.partialValue().orElse(null);
                    }
                    default -> throw new MatchException(null, null);
                };
            }).filter(Objects::nonNull);
        }

        @Override
        public Iterator<T> iterator() {
            final ListIterator listIterator = this.e.listIterator();
            return new AbstractIterator<T>(){

                @Nullable
                protected T computeNext() {
                    while (listIterator.hasNext()) {
                        DataResult dataResult;
                        int i2 = listIterator.nextIndex();
                        NBTBase tag = (NBTBase)listIterator.next();
                        Objects.requireNonNull(d.parse(c.a(), (Object)tag));
                        int n2 = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult, n2)) {
                            case 0: {
                                DataResult.Success success = (DataResult.Success)dataResult;
                                return success.value();
                            }
                            case 1: {
                                DataResult.Error error = (DataResult.Error)dataResult;
                                this.a(i2, tag, error);
                                if (!error.partialValue().isPresent()) break;
                                return error.partialValue().get();
                            }
                            default: {
                                throw new MatchException(null, null);
                            }
                        }
                    }
                    return this.endOfData();
                }
            };
        }
    }

    public record g(String a, int b, NBTTagType<?> c, NBTTagType<?> d) implements ProblemReporter.g
    {
        private final String a;
        private final int b;
        private final NBTTagType<?> c;
        private final NBTTagType<?> d;

        @Override
        public String a() {
            return "Expected list '" + this.a + "' to contain at index " + this.b + " value of type " + this.c.a() + ", but got " + this.d.a();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{g.class, "name;index;expected;actual", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{g.class, "name;index;expected;actual", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{g.class, "name;index;expected;actual", "a", "b", "c", "d"}, this, o2);
        }

        public String b() {
            return this.a;
        }

        public int c() {
            return this.b;
        }

        public NBTTagType<?> d() {
            return this.c;
        }

        public NBTTagType<?> e() {
            return this.d;
        }
    }

    public record c(String a, int b, NBTBase c, DataResult.Error<?> d) implements ProblemReporter.g
    {
        private final String a;
        private final int b;
        private final NBTBase c;
        private final DataResult.Error<?> d;

        @Override
        public String a() {
            return "Failed to decode value '" + String.valueOf(this.c) + "' from field '" + this.a + "' at index " + this.b + "': " + this.d.message();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "name;index;tag;error", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "name;index;tag;error", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "name;index;tag;error", "a", "b", "c", "d"}, this, o2);
        }

        public String b() {
            return this.a;
        }

        public int c() {
            return this.b;
        }

        public NBTBase d() {
            return this.c;
        }

        public DataResult.Error<?> e() {
            return this.d;
        }
    }
}

