/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.ValueOutput;

public class TagValueOutput
implements ValueOutput {
    private final ProblemReporter a;
    private final DynamicOps<NBTBase> b;
    private final NBTTagCompound c;

    TagValueOutput(ProblemReporter problemReporter, DynamicOps<NBTBase> ops, NBTTagCompound output) {
        this.a = problemReporter;
        this.b = ops;
        this.c = output;
    }

    public static TagValueOutput createWrappingGlobal(ProblemReporter problemReporter, NBTTagCompound output) {
        return new TagValueOutput(problemReporter, DynamicOpsNBT.a, output);
    }

    public static TagValueOutput createWrappingWithContext(ProblemReporter problemReporter, HolderLookup.a lookup, NBTTagCompound output) {
        return new TagValueOutput(problemReporter, lookup.a(DynamicOpsNBT.a), output);
    }

    public static TagValueOutput a(ProblemReporter problemReporter, HolderLookup.a lookup) {
        return new TagValueOutput(problemReporter, lookup.a(DynamicOpsNBT.a), new NBTTagCompound());
    }

    public static TagValueOutput a(ProblemReporter problemReporter) {
        return new TagValueOutput(problemReporter, DynamicOpsNBT.a, new NBTTagCompound());
    }

    @Override
    public <T> void a(String key, Codec<T> codec, T value) {
        DataResult dataResult = codec.encodeStart(this.b, value);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n2)) {
            case 0: {
                DataResult.Success success = (DataResult.Success)dataResult2;
                this.c.a(key, (NBTBase)success.value());
                break;
            }
            case 1: {
                DataResult.Error error = (DataResult.Error)dataResult2;
                this.a.a(new a(key, value, error));
                error.partialValue().ifPresent(tag -> this.c.a(key, (NBTBase)tag));
                break;
            }
            default: {
                throw new MatchException(null, null);
            }
        }
    }

    @Override
    public <T> void b(String key, Codec<T> codec, @Nullable T value) {
        if (value != null) {
            this.a(key, codec, value);
        }
    }

    @Override
    public <T> void a(MapCodec<T> codec, T value) {
        DataResult dataResult = codec.encoder().encodeStart(this.b, value);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n2)) {
            case 0: {
                DataResult.Success success = (DataResult.Success)dataResult2;
                this.c.a((NBTTagCompound)success.value());
                break;
            }
            case 1: {
                DataResult.Error error = (DataResult.Error)dataResult2;
                this.a.a(new c(value, error));
                error.partialValue().ifPresent(tag -> this.c.a((NBTTagCompound)tag));
                break;
            }
            default: {
                throw new MatchException(null, null);
            }
        }
    }

    @Override
    public void a(String key, boolean value) {
        this.c.a(key, value);
    }

    @Override
    public void a(String key, byte value) {
        this.c.a(key, value);
    }

    @Override
    public void a(String key, short value) {
        this.c.a(key, value);
    }

    @Override
    public void a(String key, int value) {
        this.c.a(key, value);
    }

    @Override
    public void a(String key, long value) {
        this.c.a(key, value);
    }

    @Override
    public void a(String key, float value) {
        this.c.a(key, value);
    }

    @Override
    public void a(String key, double value) {
        this.c.a(key, value);
    }

    @Override
    public void a(String key, String value) {
        this.c.a(key, value);
    }

    @Override
    public void a(String key, int[] value) {
        this.c.a(key, value);
    }

    private ProblemReporter d(String name) {
        return this.a.a(new ProblemReporter.c(name));
    }

    @Override
    public ValueOutput a(String key) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        this.c.a(key, compoundTag);
        return new TagValueOutput(this.d(key), this.b, compoundTag);
    }

    @Override
    public ValueOutput.b b(String key) {
        NBTTagList listTag = new NBTTagList();
        this.c.a(key, listTag);
        return new d(key, this.a, this.b, listTag);
    }

    @Override
    public <T> ValueOutput.a<T> a(String key, Codec<T> elementCodec) {
        NBTTagList listTag = new NBTTagList();
        this.c.a(key, listTag);
        return new e<T>(this.a, key, this.b, elementCodec, listTag);
    }

    @Override
    public void c(String key) {
        this.c.r(key);
    }

    @Override
    public boolean a() {
        return this.c.j();
    }

    public NBTTagCompound b() {
        return this.c;
    }

    public record a(String a, Object b, DataResult.Error<?> c) implements ProblemReporter.g
    {
        private final String a;
        private final Object b;
        private final DataResult.Error<?> c;

        @Override
        public String a() {
            return "Failed to encode value '" + String.valueOf(this.b) + "' to field '" + this.a + "': " + this.c.message();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "name;value;error", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "name;value;error", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "name;value;error", "a", "b", "c"}, this, o2);
        }

        public String b() {
            return this.a;
        }

        public Object c() {
            return this.b;
        }

        public DataResult.Error<?> d() {
            return this.c;
        }
    }

    public record c(Object a, DataResult.Error<?> b) implements ProblemReporter.g
    {
        private final Object a;
        private final DataResult.Error<?> b;

        @Override
        public String a() {
            return "Failed to merge value '" + String.valueOf(this.a) + "' to an object: " + this.b.message();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "value;error", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "value;error", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "value;error", "a", "b"}, this, o2);
        }

        public Object b() {
            return this.a;
        }

        public DataResult.Error<?> c() {
            return this.b;
        }
    }

    static class d
    implements ValueOutput.b {
        private final String a;
        private final ProblemReporter b;
        private final DynamicOps<NBTBase> c;
        private final NBTTagList d;

        d(String fieldName, ProblemReporter problemReporter, DynamicOps<NBTBase> ops, NBTTagList output) {
            this.a = fieldName;
            this.b = problemReporter;
            this.c = ops;
            this.d = output;
        }

        @Override
        public ValueOutput a() {
            int size = this.d.size();
            NBTTagCompound compoundTag = new NBTTagCompound();
            this.d.add(compoundTag);
            return new TagValueOutput(this.b.a(new ProblemReporter.d(this.a, size)), this.c, compoundTag);
        }

        @Override
        public void b() {
            this.d.removeLast();
        }

        @Override
        public boolean c() {
            return this.d.isEmpty();
        }
    }

    static class e<T>
    implements ValueOutput.a<T> {
        private final ProblemReporter a;
        private final String b;
        private final DynamicOps<NBTBase> c;
        private final Codec<T> d;
        private final NBTTagList e;

        e(ProblemReporter problemReporter, String name, DynamicOps<NBTBase> ops, Codec<T> codec, NBTTagList output) {
            this.a = problemReporter;
            this.b = name;
            this.c = ops;
            this.d = codec;
            this.e = output;
        }

        @Override
        public void a(T element) {
            DataResult dataResult = this.d.encodeStart(this.c, element);
            Objects.requireNonNull(dataResult);
            DataResult dataResult2 = dataResult;
            int n2 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n2)) {
                case 0: {
                    DataResult.Success success = (DataResult.Success)dataResult2;
                    this.e.add((NBTBase)success.value());
                    break;
                }
                case 1: {
                    DataResult.Error error = (DataResult.Error)dataResult2;
                    this.a.a(new b(this.b, element, error));
                    error.partialValue().ifPresent(this.e::add);
                    break;
                }
                default: {
                    throw new MatchException(null, null);
                }
            }
        }

        @Override
        public boolean a() {
            return this.e.isEmpty();
        }
    }

    public record b(String a, Object b, DataResult.Error<?> c) implements ProblemReporter.g
    {
        private final String a;
        private final Object b;
        private final DataResult.Error<?> c;

        @Override
        public String a() {
            return "Failed to append value '" + String.valueOf(this.b) + "' to list '" + this.a + "': " + this.c.message();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "name;value;error", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "name;value;error", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "name;value;error", "a", "b", "c"}, this, o2);
        }

        public String b() {
            return this.a;
        }

        public Object c() {
            return this.b;
        }

        public DataResult.Error<?> d() {
            return this.c;
        }
    }
}

