/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimers;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.slf4j.Logger;

public class WorldDataServer
implements IWorldDataServer,
SaveData {
    private static final Logger f = LogUtils.getLogger();
    public static final String a = "LevelName";
    protected static final String b = "Player";
    protected static final String c = "WorldGenSettings";
    public WorldSettings g;
    private final WorldOptions h;
    private final a i;
    private final Lifecycle j;
    private WorldData.a k;
    private static final String PAPER_RESPAWN_DIMENSION = "paperSpawnDimension";
    public ResourceKey<World> respawnDimension = World.h;
    private long l;
    private long m;
    @Nullable
    private final NBTTagCompound n;
    private final int o;
    private int p;
    private boolean q;
    private int r;
    private boolean s;
    private int t;
    private boolean u;
    private boolean v;
    @Deprecated
    private Optional<WorldBorder.c> w;
    private EnderDragonBattle.a x;
    @Nullable
    private NBTTagCompound y;
    private int z;
    private int A;
    @Nullable
    private UUID B;
    private final Set<String> C;
    private boolean D;
    private final Set<String> E;
    private final CustomFunctionCallbackTimerQueue<MinecraftServer> F;
    public IRegistry<WorldDimension> customDimensions;
    private WorldServer world;
    protected NBTBase pdc;

    public void setWorld(WorldServer world) {
        if (this.world != null) {
            return;
        }
        this.world = world;
        world.getWorld().readBukkitValues(this.pdc);
        this.pdc = null;
    }

    private WorldDataServer(@Nullable NBTTagCompound loadedPlayerTag, boolean wasModded, WorldData.a respawnData, long gameTime, long dayTime, int version, int clearWeatherTime, int rainTime, boolean raining, int thunderTime, boolean thundering, boolean initialized, boolean difficultyLocked, Optional<WorldBorder.c> legacyWorldBorderSettings, int wanderingTraderSpawnDelay, int wanderingTraderSpawnChance, @Nullable UUID wanderingTraderId, Set<String> knownServerBrands, Set<String> removedFeatureFlags, CustomFunctionCallbackTimerQueue<MinecraftServer> scheduledEvents, @Nullable NBTTagCompound customBossEvents, EnderDragonBattle.a endDragonFightData, WorldSettings settings, WorldOptions worldOptions, a specialWorldProperty, Lifecycle worldGenSettingsLifecycle) {
        this.D = wasModded;
        this.k = respawnData;
        this.l = gameTime;
        this.m = dayTime;
        this.o = version;
        this.p = clearWeatherTime;
        this.r = rainTime;
        this.q = raining;
        this.t = thunderTime;
        this.s = thundering;
        this.u = initialized;
        this.v = difficultyLocked;
        this.w = legacyWorldBorderSettings;
        this.z = wanderingTraderSpawnDelay;
        this.A = wanderingTraderSpawnChance;
        this.B = wanderingTraderId;
        this.C = knownServerBrands;
        this.E = removedFeatureFlags;
        this.n = loadedPlayerTag;
        this.F = scheduledEvents;
        this.y = customBossEvents;
        this.x = endDragonFightData;
        this.g = settings;
        this.h = worldOptions;
        this.i = specialWorldProperty;
        this.j = worldGenSettingsLifecycle;
    }

    public WorldDataServer(WorldSettings settings, WorldOptions worldOptions, a specialWorldProperty, Lifecycle worldGenSettingsLifecycle) {
        this(null, false, WorldData.a.a, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, Optional.empty(), 0, 0, null, Sets.newLinkedHashSet(), new HashSet<String>(), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a), null, EnderDragonBattle.a.b, settings.h(), worldOptions, specialWorldProperty, worldGenSettingsLifecycle);
    }

    public static <T> WorldDataServer a(Dynamic<T> tag, WorldSettings levelSettings, a specialWorldProperty, WorldOptions worldOptions, Lifecycle worldGenSettingsLifecycle) {
        long _long = tag.get("Time").asLong(0L);
        WorldDataServer data = new WorldDataServer(tag.get(b).flatMap(arg_0 -> NBTTagCompound.a.parse(arg_0)).result().orElse(null), tag.get("WasModded").asBoolean(false), tag.get("spawn").read(WorldData.a.c).result().orElse(WorldData.a.a), _long, tag.get("DayTime").asLong(_long), LevelVersion.a(tag).a(), tag.get("clearWeatherTime").asInt(0), tag.get("rainTime").asInt(0), tag.get("raining").asBoolean(false), tag.get("thunderTime").asInt(0), tag.get("thundering").asBoolean(false), tag.get("initialized").asBoolean(true), tag.get("DifficultyLocked").asBoolean(false), WorldBorder.c.b.parse(tag.get("world_border").orElseEmptyMap()).result(), tag.get("WanderingTraderSpawnDelay").asInt(0), tag.get("WanderingTraderSpawnChance").asInt(0), tag.get("WanderingTraderId").read(UUIDUtil.a).result().orElse(null), tag.get("ServerBrands").asStream().flatMap(brandsDynamic -> brandsDynamic.asString().result().stream()).collect(Collectors.toCollection(Sets::newLinkedHashSet)), tag.get("removed_features").asStream().flatMap(removedFeaturesDynamic -> removedFeaturesDynamic.asString().result().stream()).collect(Collectors.toSet()), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a, tag.get("ScheduledEvents").asStream()), (NBTTagCompound)tag.get("CustomBossEvents").orElseEmptyMap().getValue(), tag.get("DragonFight").read(EnderDragonBattle.a.a).resultOrPartial(arg_0 -> ((Logger)f).error(arg_0)).orElse(EnderDragonBattle.a.b), levelSettings, worldOptions, specialWorldProperty, worldGenSettingsLifecycle);
        data.respawnDimension = tag.get(PAPER_RESPAWN_DIMENSION).read(World.g).result().orElse(data.k.a());
        return data;
    }

    @Override
    public NBTTagCompound a(IRegistryCustom registries, @Nullable NBTTagCompound singlePlayerTag) {
        if (singlePlayerTag == null) {
            singlePlayerTag = this.n;
        }
        NBTTagCompound compoundTag = new NBTTagCompound();
        this.a(registries, compoundTag, singlePlayerTag);
        return compoundTag;
    }

    private void a(IRegistryCustom registry, NBTTagCompound tag, @Nullable NBTTagCompound singlePlayerTag) {
        tag.a("ServerBrands", WorldDataServer.a(this.C));
        tag.a("WasModded", this.D);
        if (!this.E.isEmpty()) {
            tag.a("removed_features", WorldDataServer.a(this.E));
        }
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("Name", SharedConstants.b().c());
        compoundTag.a("Id", SharedConstants.b().a().b());
        compoundTag.a("Snapshot", !SharedConstants.b().f());
        compoundTag.a("Series", SharedConstants.b().a().c());
        tag.a("Version", compoundTag);
        GameProfileSerializer.e(tag);
        RegistryOps<NBTBase> dynamicOps = registry.a(DynamicOpsNBT.a);
        GeneratorSettings.a(dynamicOps, this.h, new WorldDimensions(this.customDimensions != null ? this.customDimensions : registry.f(Registries.by))).resultOrPartial(SystemUtils.a("WorldGenSettings: ", arg_0 -> ((Logger)f).error(arg_0))).ifPresent(worldOptionsTag -> tag.a(c, (NBTBase)worldOptionsTag));
        tag.a("GameType", this.g.b().a());
        tag.a("spawn", WorldData.a.c, this.k);
        tag.a(PAPER_RESPAWN_DIMENSION, World.g, this.respawnDimension);
        tag.a("Time", this.l);
        tag.a("DayTime", this.m);
        tag.a("LastPlayed", SystemUtils.e());
        tag.a(a, this.g.a());
        tag.a("version", 19133);
        tag.a("clearWeatherTime", this.p);
        tag.a("rainTime", this.r);
        tag.a("raining", this.q);
        tag.a("thunderTime", this.t);
        tag.a("thundering", this.s);
        tag.a("hardcore", this.g.c());
        tag.a("allowCommands", this.g.e());
        tag.a("initialized", this.u);
        this.w.ifPresent(settings -> tag.a("world_border", WorldBorder.c.b, settings));
        tag.a("Difficulty", (byte)this.g.d().a());
        tag.a("DifficultyLocked", this.v);
        tag.a("GameRules", this.g.f().a());
        tag.a("DragonFight", EnderDragonBattle.a.a, this.x);
        if (singlePlayerTag != null) {
            tag.a(b, singlePlayerTag);
        }
        tag.a(WorldDataConfiguration.b, this.g.g());
        if (this.y != null) {
            tag.a("CustomBossEvents", this.y);
        }
        tag.a("ScheduledEvents", this.F.b());
        tag.a("WanderingTraderSpawnDelay", this.z);
        tag.a("WanderingTraderSpawnChance", this.A);
        tag.b("WanderingTraderId", UUIDUtil.a, this.B);
        tag.a("Bukkit.Version", Bukkit.getName() + "/" + Bukkit.getVersion() + "/" + Bukkit.getBukkitVersion());
        this.world.getWorld().storeBukkitValues(tag);
    }

    private static NBTTagList a(Set<String> stringCollection) {
        NBTTagList listTag = new NBTTagList();
        stringCollection.stream().map(NBTTagString::a).forEach(listTag::add);
        return listTag;
    }

    @Override
    public WorldData.a a() {
        return this.k;
    }

    @Override
    public long b() {
        return this.l;
    }

    @Override
    public long c() {
        return this.m;
    }

    @Override
    @Nullable
    public NBTTagCompound v() {
        return this.n;
    }

    @Override
    public void a(long time) {
        this.l = time;
    }

    @Override
    public void b(long time) {
        this.m = time;
    }

    @Override
    public void a(WorldData.a respawnData) {
        this.k = respawnData;
    }

    @Override
    public String d() {
        return this.g.a();
    }

    @Override
    public int w() {
        return this.o;
    }

    @Override
    public int e() {
        return this.p;
    }

    @Override
    public void a(int time) {
        this.p = time;
    }

    @Override
    public boolean f() {
        return this.s;
    }

    @Override
    public void a(boolean thundering) {
        this.setThundering(thundering, ThunderChangeEvent.Cause.UNKNOWN);
    }

    public void setThundering(boolean thundering, ThunderChangeEvent.Cause cause) {
        if (this.s == thundering) {
            return;
        }
        org.bukkit.World world = Bukkit.getWorld((String)this.d());
        if (world != null) {
            ThunderChangeEvent thunder = new ThunderChangeEvent(world, thundering, cause);
            Bukkit.getServer().getPluginManager().callEvent((Event)thunder);
            if (thunder.isCancelled()) {
                return;
            }
        }
        this.s = thundering;
    }

    @Override
    public int g() {
        return this.t;
    }

    @Override
    public void b(int time) {
        this.t = time;
    }

    @Override
    public boolean h() {
        return this.q;
    }

    @Override
    public void b(boolean isRaining) {
        this.setRaining(isRaining, WeatherChangeEvent.Cause.UNKNOWN);
    }

    public void setRaining(boolean isRaining, WeatherChangeEvent.Cause cause) {
        if (this.q == isRaining) {
            return;
        }
        org.bukkit.World world = Bukkit.getWorld((String)this.d());
        if (world != null) {
            WeatherChangeEvent weather = new WeatherChangeEvent(world, isRaining, cause);
            Bukkit.getServer().getPluginManager().callEvent((Event)weather);
            if (weather.isCancelled()) {
                return;
            }
        }
        this.q = isRaining;
    }

    @Override
    public int i() {
        return this.r;
    }

    @Override
    public void c(int time) {
        this.r = time;
    }

    @Override
    public EnumGamemode j() {
        return this.g.b();
    }

    @Override
    public void a(EnumGamemode type) {
        this.g = this.g.a(type);
    }

    @Override
    public boolean k() {
        return this.g.c();
    }

    @Override
    public boolean l() {
        return this.g.e();
    }

    @Override
    public boolean m() {
        return this.u;
    }

    @Override
    public void c(boolean initialized) {
        this.u = initialized;
    }

    @Override
    public GameRules n() {
        return this.g.f();
    }

    @Override
    public Optional<WorldBorder.c> o() {
        return this.w;
    }

    @Override
    public void a(Optional<WorldBorder.c> settings) {
        this.w = settings;
    }

    @Override
    public EnumDifficulty p() {
        return this.g.d();
    }

    @Override
    public void a(EnumDifficulty difficulty) {
        this.g = this.g.a(difficulty);
        PacketPlayOutServerDifficulty packet = new PacketPlayOutServerDifficulty(this.p(), this.q());
        for (EntityPlayer player : this.world.C()) {
            player.g.b(packet);
        }
    }

    @Override
    public boolean q() {
        return this.v;
    }

    @Override
    public void d(boolean locked) {
        this.v = locked;
    }

    @Override
    public CustomFunctionCallbackTimerQueue<MinecraftServer> r() {
        return this.F;
    }

    @Override
    public void a(CrashReportSystemDetails category, LevelHeightAccessor level) {
        IWorldDataServer.super.a(category, level);
        SaveData.super.a(category);
    }

    @Override
    public WorldOptions x() {
        return this.h;
    }

    @Override
    public boolean y() {
        return this.i == net.minecraft.world.level.storage.WorldDataServer$a.b;
    }

    @Override
    public boolean z() {
        return this.i == net.minecraft.world.level.storage.WorldDataServer$a.c;
    }

    @Override
    public Lifecycle A() {
        return this.j;
    }

    @Override
    public EnderDragonBattle.a B() {
        return this.x;
    }

    @Override
    public void a(EnderDragonBattle.a endDragonFightData) {
        this.x = endDragonFightData;
    }

    @Override
    public WorldDataConfiguration C() {
        return this.g.g();
    }

    @Override
    public void a(WorldDataConfiguration dataConfiguration) {
        this.g = this.g.a(dataConfiguration);
    }

    @Override
    @Nullable
    public NBTTagCompound D() {
        return this.y;
    }

    @Override
    public void a(@Nullable NBTTagCompound tag) {
        this.y = tag;
    }

    @Override
    public int s() {
        return this.z;
    }

    @Override
    public void d(int delay) {
        this.z = delay;
    }

    @Override
    public int t() {
        return this.A;
    }

    @Override
    public void e(int chance) {
        this.A = chance;
    }

    @Override
    @Nullable
    public UUID u() {
        return this.B;
    }

    @Override
    public void a(UUID id) {
        this.B = id;
    }

    @Override
    public void a(String name, boolean isModded) {
        this.C.add(name);
        this.D |= isModded;
    }

    @Override
    public boolean E() {
        return this.D;
    }

    @Override
    public Set<String> F() {
        return ImmutableSet.copyOf(this.C);
    }

    @Override
    public Set<String> G() {
        return Set.copyOf(this.E);
    }

    @Override
    public IWorldDataServer H() {
        return this;
    }

    @Override
    public WorldSettings I() {
        return this.g.h();
    }

    public void checkName(String name) {
        if (!this.g.a.equals(name)) {
            this.g.a = name;
        }
    }

    @Deprecated
    public static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        public static final /* enum */ a c = new a();
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c};
        }

        static {
            d = net.minecraft.world.level.storage.WorldDataServer$a.a();
        }
    }
}

