/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.util.Version;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.TagValueOutput;
import org.bukkit.Bukkit;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class WorldNBTStorage {
    private static final Logger b = LogUtils.getLogger();
    private final File c;
    protected final DataFixer a;
    private static final DateTimeFormatter d = FileNameDateFormatter.a();

    public WorldNBTStorage(Convertable.ConversionSession levelStorageAccess, DataFixer fixerUpper) {
        this.a = fixerUpper;
        this.c = levelStorageAccess.a(SavedFile.c).toFile();
        this.c.mkdirs();
    }

    public void a(EntityHuman player) {
        if (SpigotConfig.disablePlayerDataSaving) {
            return;
        }
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(player.en(), b);){
            TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector, player.ej());
            player.d(tagValueOutput);
            Path path = this.c.toPath();
            Path path1 = Files.createTempFile(path, player.cU() + "-", ".dat", new FileAttribute[0]);
            NBTTagCompound compoundTag = tagValueOutput.b();
            NBTCompressedStreamTools.a(compoundTag, path1);
            Path path2 = path.resolve(player.cU() + ".dat");
            Path path3 = path.resolve(player.cU() + ".dat_old");
            SystemUtils.a(path2, path1, path3);
        }
        catch (Exception var11) {
            b.warn("Failed to save player data for {}", (Object)player.ap(), (Object)var11);
        }
    }

    private void a(NameAndId nameAndId, String suffix) {
        Path path = this.c.toPath();
        String string = nameAndId.a().toString();
        Path path1 = path.resolve(string + suffix);
        Path path2 = path.resolve(string + "_corrupted_" + LocalDateTime.now().format(d) + suffix);
        if (Files.isRegularFile(path1, new LinkOption[0])) {
            try {
                Files.copy(path1, path2, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (Exception var8) {
                b.warn("Failed to copy the player.dat file for {}", (Object)nameAndId.b(), (Object)var8);
            }
        }
    }

    private Optional<NBTTagCompound> b(NameAndId nameAndId, String suffix) {
        File file = new File(this.c, nameAndId.a().toString() + suffix);
        boolean usingWrongFile = false;
        if (Bukkit.getOnlineMode() && !file.exists() && (file = new File(this.c, String.valueOf(UUIDUtil.a(nameAndId.b())) + suffix)).exists()) {
            usingWrongFile = true;
            b.warn("Using offline mode UUID file for player {} as it is the only copy we can find.", (Object)nameAndId.b());
        }
        if (file.exists() && file.isFile()) {
            try {
                Optional<NBTTagCompound> optional = Optional.of(NBTCompressedStreamTools.a(file.toPath(), NBTReadLimiter.a()));
                if (usingWrongFile) {
                    file.renameTo(new File(file.getPath() + ".offline-read"));
                }
                return optional;
            }
            catch (Exception var5) {
                b.warn("Failed to load player data for {}", (Object)nameAndId.b());
            }
        }
        return Optional.empty();
    }

    public Optional<NBTTagCompound> a(NameAndId nameAndId) {
        Optional<NBTTagCompound> optional = this.b(nameAndId, ".dat");
        if (optional.isEmpty()) {
            this.a(nameAndId, ".dat");
        }
        return optional.or(() -> this.b(nameAndId, ".dat_old")).map(compoundTag -> {
            int dataVersion = GameProfileSerializer.b(compoundTag, -1);
            return MCDataConverter.convertTag(MCTypeRegistry.PLAYER, compoundTag, dataVersion, Version.getCurrentVersion());
        });
    }

    public File getPlayerDir() {
        return this.c;
    }
}

