/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.slf4j.Logger;

public class WorldPersistentData
implements AutoCloseable {
    private static final Logger a = LogUtils.getLogger();
    private final PersistentBase.a b;
    public final Map<SavedDataType<?>, Optional<PersistentBase>> c = new HashMap();
    private final DataFixer d;
    private final HolderLookup.a e;
    private final Path f;
    private CompletableFuture<?> g = CompletableFuture.completedFuture(null);

    public WorldPersistentData(PersistentBase.a context, Path dataFolder, DataFixer fixerUpper, HolderLookup.a registries) {
        this.b = context;
        this.d = fixerUpper;
        this.f = dataFolder;
        this.e = registries;
    }

    private Path a(String filename) {
        return this.f.resolve(filename + ".dat");
    }

    public <T extends PersistentBase> T a(SavedDataType<T> type) {
        T savedData = this.b(type);
        if (savedData != null) {
            return savedData;
        }
        PersistentBase savedData1 = (PersistentBase)type.b().apply(this.b);
        this.a(type, savedData1);
        return (T)savedData1;
    }

    @Nullable
    public <T extends PersistentBase> T b(SavedDataType<T> type) {
        Optional<PersistentBase> optional = this.c.get(type);
        if (optional == null) {
            optional = Optional.ofNullable(this.c(type));
            this.c.put(type, optional);
        }
        return (T)((PersistentBase)optional.orElse(null));
    }

    @Nullable
    private <T extends PersistentBase> T c(SavedDataType<T> type) {
        try {
            Path dataFile = this.a(type.a());
            if (Files.exists(dataFile, new LinkOption[0])) {
                NBTTagCompound tagFromDisk = this.a(type.a(), type.d(), SharedConstants.b().a().b());
                RegistryOps<NBTBase> registryOps = this.e.a(DynamicOpsNBT.a);
                return (T)((PersistentBase)type.c().apply(this.b).parse(registryOps, (Object)tagFromDisk.a("data")).resultOrPartial(string -> a.error("Failed to parse saved data for '{}': {}", (Object)type, string)).orElse(null));
            }
        }
        catch (Exception var5) {
            a.error("Error loading saved data: {}", type, (Object)var5);
        }
        return null;
    }

    public <T extends PersistentBase> void a(SavedDataType<T> type, T value) {
        this.c.put(type, Optional.of(value));
        value.t();
    }

    public NBTTagCompound a(String filename, DataFixTypes dataFixType, int version) throws IOException {
        NBTTagCompound var8;
        try (InputStream inputStream = Files.newInputStream(this.a(filename), new OpenOption[0]);
             PushbackInputStream pushbackInputStream = new PushbackInputStream(new FastBufferedInputStream(inputStream), 2);){
            NBTTagCompound compressed;
            if (this.a(pushbackInputStream)) {
                compressed = NBTCompressedStreamTools.a(pushbackInputStream, NBTReadLimiter.a());
            } else {
                try (DataInputStream dataInputStream = new DataInputStream(pushbackInputStream);){
                    compressed = NBTCompressedStreamTools.a(dataInputStream);
                }
            }
            int dataVersion = GameProfileSerializer.b(compressed, 1343);
            var8 = dataFixType.a(this.d, compressed, dataVersion, version);
        }
        return var8;
    }

    private boolean a(PushbackInputStream inputStream) throws IOException {
        int i1;
        byte[] bytes = new byte[2];
        boolean flag = false;
        int i2 = inputStream.read(bytes, 0, 2);
        if (i2 == 2 && (i1 = (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF) == 35615) {
            flag = true;
        }
        if (i2 != 0) {
            inputStream.unread(bytes, 0, i2);
        }
        return flag;
    }

    public CompletableFuture<?> a() {
        Map<SavedDataType<?>, NBTTagCompound> map = this.c();
        if (map.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        int i2 = SystemUtils.g();
        int size = map.size();
        this.g = this.g.thenCompose(object -> CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> CompletableFuture.runAsync(() -> this.a((SavedDataType)entry.getKey(), (NBTTagCompound)entry.getValue()), SystemUtils.DIMENSION_DATA_IO_POOL)).toArray(CompletableFuture[]::new)));
        return this.g;
    }

    private Map<SavedDataType<?>, NBTTagCompound> c() {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        RegistryOps<NBTBase> registryOps = this.e.a(DynamicOpsNBT.a);
        this.c.forEach((arg_0, arg_1) -> this.a((Map)map, registryOps, arg_0, arg_1));
        return map;
    }

    private <T extends PersistentBase> NBTTagCompound a(SavedDataType<T> type, PersistentBase data, RegistryOps<NBTBase> ops) {
        Codec<T> codec = type.c().apply(this.b);
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("data", (NBTBase)codec.encodeStart(ops, (Object)data).getOrThrow());
        GameProfileSerializer.e(compoundTag);
        return compoundTag;
    }

    private void a(SavedDataType<?> type, NBTTagCompound tag) {
        Path dataFile = this.a(type.a());
        try {
            NBTCompressedStreamTools.a(tag, dataFile);
        }
        catch (IOException var5) {
            a.error("Could not save data to {}", (Object)dataFile.getFileName(), (Object)var5);
        }
    }

    public void b() {
        this.a().join();
    }

    @Override
    public void close() {
        this.b();
    }

    private /* synthetic */ void a(Map map, RegistryOps registryOps, SavedDataType savedDataType, Optional optional) {
        optional.filter(PersistentBase::u).ifPresent(savedData -> {
            map.put(savedDataType, this.a(savedDataType, (PersistentBase)savedData, registryOps));
            savedData.a(false);
        });
    }

    private /* synthetic */ CompletionStage a(int i2, int size, Map map, Object object) {
        ArrayList<CompletableFuture<Void>> list = new ArrayList<CompletableFuture<Void>>(i2);
        int i1 = MathHelper.e(size, i2);
        for (List list1 : Iterables.partition(map.entrySet(), (int)i1)) {
            list.add(CompletableFuture.runAsync(() -> {
                for (Map.Entry entry : list1) {
                    this.a((SavedDataType)entry.getKey(), (NBTTagCompound)entry.getValue());
                }
            }, SystemUtils.i()));
        }
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }
}

