/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.SystemUtils;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntry;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionUser;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.apache.commons.lang3.mutable.MutableInt;

public class LootSelector {
    public static final Codec<LootSelector> a = RecordCodecBuilder.create(instance -> instance.group((App)LootEntries.a.listOf().fieldOf("entries").forGetter(lootPool -> lootPool.b), (App)LootItemCondition.e.listOf().optionalFieldOf("conditions", List.of()).forGetter(lootPool -> lootPool.c), (App)LootItemFunctions.c.listOf().optionalFieldOf("functions", List.of()).forGetter(lootPool -> lootPool.e), (App)NumberProviders.a.fieldOf("rolls").forGetter(lootPool -> lootPool.g), (App)NumberProviders.a.fieldOf("bonus_rolls").orElse((Object)ConstantValue.a(0.0f)).forGetter(lootPool -> lootPool.h)).apply((Applicative)instance, LootSelector::new));
    private final List<LootEntryAbstract> b;
    private final List<LootItemCondition> c;
    private final Predicate<LootTableInfo> d;
    private final List<LootItemFunction> e;
    private final BiFunction<ItemStack, LootTableInfo, ItemStack> f;
    private final NumberProvider g;
    private final NumberProvider h;

    LootSelector(List<LootEntryAbstract> entries, List<LootItemCondition> conditions, List<LootItemFunction> functions, NumberProvider rolls, NumberProvider bonusRolls) {
        this.b = entries;
        this.c = conditions;
        this.d = SystemUtils.a(conditions);
        this.e = functions;
        this.f = LootItemFunctions.a(functions);
        this.g = rolls;
        this.h = bonusRolls;
    }

    private void b(Consumer<ItemStack> stackConsumer, LootTableInfo context) {
        RandomSource random = context.b();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableInt = new MutableInt();
        for (LootEntryAbstract lootPoolEntryContainer : this.b) {
            lootPoolEntryContainer.expand(context, lootPoolEntry1 -> {
                int weight = lootPoolEntry1.a(context.c());
                if (weight > 0) {
                    list.add(lootPoolEntry1);
                    mutableInt.add(weight);
                }
            });
        }
        int size = list.size();
        if (mutableInt.intValue() != 0 && size != 0) {
            if (size == 1) {
                ((LootEntry)list.get(0)).a(stackConsumer, context);
            } else {
                int randomInt = random.a(mutableInt.intValue());
                for (LootEntry lootPoolEntry : list) {
                    if ((randomInt -= lootPoolEntry.a(context.c())) >= 0) continue;
                    lootPoolEntry.a(stackConsumer, context);
                    return;
                }
            }
        }
    }

    public void a(Consumer<ItemStack> stackConsumer, LootTableInfo lootContext) {
        if (this.d.test(lootContext)) {
            Consumer<ItemStack> consumer = LootItemFunction.a(this.f, stackConsumer, lootContext);
            int i2 = this.g.a(lootContext) + MathHelper.d(this.h.b(lootContext) * lootContext.c());
            for (int i1 = 0; i1 < i2; ++i1) {
                this.b(consumer, lootContext);
            }
        }
    }

    public void a(LootCollector context) {
        int i2;
        for (i2 = 0; i2 < this.c.size(); ++i2) {
            this.c.get(i2).a(context.a(new ProblemReporter.d("conditions", i2)));
        }
        for (i2 = 0; i2 < this.e.size(); ++i2) {
            this.e.get(i2).a(context.a(new ProblemReporter.d("functions", i2)));
        }
        for (i2 = 0; i2 < this.b.size(); ++i2) {
            this.b.get(i2).a(context.a(new ProblemReporter.d("entries", i2)));
        }
        this.g.a(context.a(new ProblemReporter.c("rolls")));
        this.h.a(context.a(new ProblemReporter.c("bonus_rolls")));
    }

    public static a a() {
        return new a();
    }

    public static class a
    implements LootItemFunctionUser<a>,
    LootItemConditionUser<a> {
        private final ImmutableList.Builder<LootEntryAbstract> a = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemCondition> b = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> c = ImmutableList.builder();
        private NumberProvider d = ConstantValue.a(1.0f);
        private NumberProvider e = ConstantValue.a(0.0f);

        public a a(NumberProvider rolls) {
            this.d = rolls;
            return this;
        }

        public a a() {
            return this;
        }

        public a b(NumberProvider bonusRolls) {
            this.e = bonusRolls;
            return this;
        }

        public a a(LootEntryAbstract.a<?> entriesBuilder) {
            this.a.add((Object)entriesBuilder.b());
            return this;
        }

        public a a(LootItemCondition.a conditionBuilder) {
            this.b.add((Object)conditionBuilder.build());
            return this;
        }

        public a a(LootItemFunction.a functionBuilder) {
            this.c.add((Object)functionBuilder.b());
            return this;
        }

        public LootSelector b() {
            return new LootSelector((List<LootEntryAbstract>)this.a.build(), (List<LootItemCondition>)this.b.build(), (List<LootItemFunction>)this.c.build(), this.d, this.e);
        }
    }
}

