/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.bukkit.craftbukkit.v1_21_R6.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.event.world.LootGenerateEvent;
import org.slf4j.Logger;

public class LootTable {
    private static final Logger g = LogUtils.getLogger();
    public static final Codec<ResourceKey<LootTable>> a = ResourceKey.a(Registries.bz);
    public static final ContextKeySet b = LootContextParameterSets.q;
    public static final long c = 0L;
    public static final Codec<LootTable> d = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)LootContextParameterSets.a.lenientOptionalFieldOf("type", (Object)b).forGetter(lootTable -> lootTable.h), (App)MinecraftKey.a.optionalFieldOf("random_sequence").forGetter(lootTable -> lootTable.i), (App)LootSelector.a.listOf().optionalFieldOf("pools", List.of()).forGetter(lootTable -> lootTable.j), (App)LootItemFunctions.c.listOf().optionalFieldOf("functions", List.of()).forGetter(lootTable -> lootTable.k)).apply((Applicative)instance, LootTable::new)));
    public static final Codec<Holder<LootTable>> e = RegistryFileCodec.a(Registries.bz, d);
    public static final LootTable f = new LootTable(LootContextParameterSets.b, Optional.empty(), List.of(), List.of());
    private final ContextKeySet h;
    private final Optional<MinecraftKey> i;
    private final List<LootSelector> j;
    private final List<LootItemFunction> k;
    private final BiFunction<ItemStack, LootTableInfo, ItemStack> l;
    public CraftLootTable craftLootTable;

    LootTable(ContextKeySet paramSet, Optional<MinecraftKey> randomSequence, List<LootSelector> pools, List<LootItemFunction> functions) {
        this.h = paramSet;
        this.i = randomSequence;
        this.j = pools;
        this.k = functions;
        this.l = LootItemFunctions.a(functions);
    }

    public static Consumer<ItemStack> a(WorldServer level, Consumer<ItemStack> output) {
        boolean skipSplitter = level != null && !level.paperConfig().fixes.splitOverstackedLoot;
        return itemStack -> {
            if (itemStack.a(level.O())) {
                if (skipSplitter || itemStack.M() < itemStack.k()) {
                    output.accept((ItemStack)itemStack);
                } else {
                    ItemStack itemStack1;
                    for (int count = itemStack.M(); count > 0; count -= itemStack1.M()) {
                        itemStack1 = itemStack.c(Math.min(itemStack.k(), count));
                        output.accept(itemStack1);
                    }
                }
            }
        };
    }

    public void a(LootParams params, Consumer<ItemStack> output) {
        this.a(new LootTableInfo.Builder(params).a(this.i), output);
    }

    public void a(LootTableInfo context, Consumer<ItemStack> output) {
        LootTableInfo.e<LootTable> visitedEntry = LootTableInfo.a(this);
        if (context.b(visitedEntry)) {
            Consumer<ItemStack> consumer = LootItemFunction.a(this.l, output, context);
            for (LootSelector lootPool : this.j) {
                lootPool.a(consumer, context);
            }
            context.c(visitedEntry);
        } else {
            g.warn("Detected infinite loop in loot tables");
        }
    }

    public void a(LootParams params, long seed, Consumer<ItemStack> output) {
        this.a(new LootTableInfo.Builder(params).a(seed).a(this.i), LootTable.a(params.a(), output));
    }

    public void b(LootParams params, Consumer<ItemStack> output) {
        this.a(params, LootTable.a(params.a(), output));
    }

    public void b(LootTableInfo contextData, Consumer<ItemStack> output) {
        this.a(contextData, LootTable.a(contextData.d(), output));
    }

    public ObjectArrayList<ItemStack> a(LootParams params, RandomSource random) {
        return this.a(new LootTableInfo.Builder(params).a(random).a(this.i));
    }

    public ObjectArrayList<ItemStack> a(LootParams params, long seed) {
        return this.a(new LootTableInfo.Builder(params).a(seed).a(this.i));
    }

    public ObjectArrayList<ItemStack> a(LootParams params) {
        return this.a(new LootTableInfo.Builder(params).a(this.i));
    }

    private ObjectArrayList<ItemStack> a(LootTableInfo context) {
        ObjectArrayList list = new ObjectArrayList();
        this.b(context, arg_0 -> ((ObjectArrayList)list).add(arg_0));
        return list;
    }

    public ContextKeySet a() {
        return this.h;
    }

    public void a(LootCollector validator) {
        int i2;
        for (i2 = 0; i2 < this.j.size(); ++i2) {
            this.j.get(i2).a(validator.a(new ProblemReporter.d("pools", i2)));
        }
        for (i2 = 0; i2 < this.k.size(); ++i2) {
            this.k.get(i2).a(validator.a(new ProblemReporter.d("functions", i2)));
        }
    }

    public void a(IInventory container, LootParams params, long seed) {
        this.fill(container, params, seed == 0L ? null : RandomSource.a(seed), false);
    }

    public void fill(IInventory container, LootParams params, RandomSource randomSource, boolean plugin) {
        LootTableInfo lootContext = new LootTableInfo.Builder(params).a(randomSource).a(this.i);
        ObjectArrayList randomItems = this.a(lootContext);
        RandomSource random = lootContext.b();
        LootGenerateEvent event = CraftEventFactory.callLootGenerateEvent(container, this, lootContext, randomItems, plugin);
        if (event.isCancelled()) {
            return;
        }
        randomItems = (ObjectArrayList)event.getLoot().stream().map(CraftItemStack::asNMSCopy).collect(ObjectArrayList.toList());
        List<Integer> availableSlots = this.a(container, random);
        this.a((ObjectArrayList<ItemStack>)randomItems, availableSlots.size(), random);
        for (ItemStack itemStack : randomItems) {
            if (availableSlots.isEmpty()) {
                g.warn("Tried to over-fill a container");
                return;
            }
            if (itemStack.f()) {
                container.a((int)availableSlots.remove(availableSlots.size() - 1), ItemStack.l);
                continue;
            }
            container.a((int)availableSlots.remove(availableSlots.size() - 1), itemStack);
        }
    }

    private void a(ObjectArrayList<ItemStack> stacks, int emptySlotsCount, RandomSource random) {
        ArrayList list = Lists.newArrayList();
        ObjectListIterator iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = (ItemStack)iterator.next();
            if (itemStack.f()) {
                iterator.remove();
                continue;
            }
            if (itemStack.M() <= 1) continue;
            list.add(itemStack);
            iterator.remove();
        }
        while (emptySlotsCount - stacks.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemStack1 = (ItemStack)list.remove(MathHelper.a(random, 0, list.size() - 1));
            int randomInt = MathHelper.a(random, 1, itemStack1.M() / 2);
            ItemStack itemStack2 = itemStack1.a(randomInt);
            if (itemStack1.M() > 1 && random.h()) {
                list.add(itemStack1);
            } else {
                stacks.add((Object)itemStack1);
            }
            if (itemStack2.M() > 1 && random.h()) {
                list.add(itemStack2);
                continue;
            }
            stacks.add((Object)itemStack2);
        }
        stacks.addAll((Collection)list);
        SystemUtils.c(stacks, random);
    }

    private List<Integer> a(IInventory inventory, RandomSource random) {
        ObjectArrayList list = new ObjectArrayList();
        for (int i2 = 0; i2 < inventory.b(); ++i2) {
            if (!inventory.a(i2).f()) continue;
            list.add((Object)i2);
        }
        SystemUtils.c(list, random);
        return list;
    }

    public static a b() {
        return new a();
    }

    public static class a
    implements LootItemFunctionUser<a> {
        private final ImmutableList.Builder<LootSelector> a = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> b = ImmutableList.builder();
        private ContextKeySet c = b;
        private Optional<MinecraftKey> d = Optional.empty();

        public a a(LootSelector.a lootPool) {
            this.a.add((Object)lootPool.b());
            return this;
        }

        public a a(ContextKeySet paramSet) {
            this.c = paramSet;
            return this;
        }

        public a a(MinecraftKey randomSequence) {
            this.d = Optional.of(randomSequence);
            return this;
        }

        public a a(LootItemFunction.a functionBuilder) {
            this.b.add((Object)functionBuilder.b());
            return this;
        }

        public a a() {
            return this;
        }

        public LootTable b() {
            return new LootTable(this.c, this.d, (List<LootSelector>)this.a.build(), (List<LootItemFunction>)this.b.build());
        }
    }
}

